/*****************************************************************************
 *  __________________    _________  _____            _____  .__         ._.
 *  \______   \______ \  /   _____/ /     \          /  _  \ |__| ____   | |
 *   |    |  _/|    |  \ \_____  \ /  \ /  \        /  /_\  \|  _/ __ \  | |
 *   |    |   \|    `   \/        /    Y    \      /    |    |  \  ___/   \|
 *   |______  /_______  /_______  \____|__  / /\   \____|__  |__|\___ |   __
 *          \/        \/        \/        \/  )/           \/        \/   \/
 *
 * This file is part of liBDSM. Copyright © 2014-2015 VideoLabs SAS
 *
 * Author: Julien 'Lta' BALLET <contact@lta.io>
 *
 * liBDSM is released under LGPLv2.1 (or later) and is also available
 * under a commercial license.
 *****************************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
 * Copyright (c) 2003-2017
 * Distributed Systems Software.  All rights reserved.
 *
 * $Id: netbios_session.h 2958 2017-05-18 18:56:19Z brachman $
 */

#ifndef _LIBDSM_NETBIOS_SESSION_H_
#define _LIBDSM_NETBIOS_SESSION_H_

#include <stdint.h>
#include <stddef.h>

# include <netinet/in.h>

#include "netbios_defs.h"

enum {
  NETBIOS_SESSION_NEW         =  0,
  NETBIOS_SESSION_CONNECTING  =  1,
  NETBIOS_SESSION_CONNECTED   =  2,
  NETBIOS_SESSION_ERROR       = -1,
  NETBIOS_SESSION_REFUSED     = -2
};

typedef struct netbios_session_s {
  struct sockaddr_in remote_addr; // The address of the remote peer;
  int socket;					  // The socket of the TCP connection to the HOST
  int state;					  // The current session's state
  size_t packet_payload_size;	  // Size of the allocated payload
  size_t packet_cursor; // Offset of write cursor from start of payload
  netbios_session_packet *packet; // Allocated packet, for both send and recv
} netbios_session;

#ifdef __cplusplus
extern "C" {
#endif

// Return NULL if unable to open socket/connect
extern netbios_session *netbios_session_new(size_t buf_size);
extern void netbios_session_destroy(netbios_session *);
extern int netbios_session_connect(uint32_t ip, int port, netbios_session *s,
								   const char *name, int direct_tcp);
extern void netbios_session_packet_init(netbios_session *s);
extern int netbios_session_packet_append(netbios_session *s,
										 const char *data, size_t size);
extern int netbios_session_packet_send(netbios_session *s);
extern ssize_t netbios_session_packet_recv(netbios_session *s, void **data);

#ifdef __cplusplus
}
#endif

#endif
