//
// C++ Implementation: FavouriteHubs
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <QtGui>
#include "favouritehubswidget.h"
#include "backendconnection.h"
#include "createfavouritedialog.h"

FavouriteHubs::CheckBoxDelegate::CheckBoxDelegate( QObject *parent ) : QItemDelegate(parent)
{
}

QWidget * FavouriteHubs::CheckBoxDelegate::createEditor( QWidget * parent, const QStyleOptionViewItem & /*option*/, const QModelIndex & /*index*/ ) const
{
	QCheckBox* editor = new QCheckBox( parent );
	editor->installEventFilter(editor);
	return editor;
}

void FavouriteHubs::CheckBoxDelegate::setEditorData( QWidget * editor, const QModelIndex & index ) const
{	
	QCheckBox *checkBox = dynamic_cast<QCheckBox*>(editor);
	try {
		checkBox->setChecked(dynamic_cast<const FavouriteHubsModel*>(index.model())->getHubData(index).autoConnect);
	}
	catch(...) {
		
	}
}

void FavouriteHubs::CheckBoxDelegate::setModelData( QWidget * editor, QAbstractItemModel * model, const QModelIndex & index ) const
{
	QCheckBox *checkBox = dynamic_cast<QCheckBox*>(editor);
	bool value = checkBox->isChecked();
	model->setData(index, value);
}

void FavouriteHubs::CheckBoxDelegate::updateEditorGeometry( QWidget * editor, const QStyleOptionViewItem & option, const QModelIndex & /*index*/ ) const
{
	editor->setGeometry(option.rect);
}


FavouriteHubs::FavouriteHubs( const BackendConnectionPtr& backendConn,
							  QWidget * parent ) 
: QWidget(parent), 
  model(new FavouriteHubsModel(this)),
  delegate( new CheckBoxDelegate ),
  backendConnection( backendConn )
{
	  // Create the UI
	  ui.setupUi(this);
	  ui.favouriteHubList->setModel(model.get());
	  ui.favouriteHubList->setItemDelegate(delegate.get());
	  connect(model.get(),SIGNAL(layoutChanged()),SLOT(createPersistentEditors()));
}

void FavouriteHubs::on_connectFavouriteButton_clicked( )
{
	backendConnection->createSession( model->getServer( ui.favouriteHubList->selectionModel()->currentIndex().row() ));
	emit close();
}

void FavouriteHubs::on_removeFavouriteButton_clicked( )
{
	QModelIndex i = ui.favouriteHubList->selectionModel()->currentIndex();
	if(i.isValid())
		backendConnection->removeFavouriteHub( model->getServer( i.row()) );
}

void FavouriteHubs::on_addFavouriteButton_clicked( )
{
	CreateFavouriteDialog dlg( backendConnection, this );
	dlg.setModal(true);
	dlg.exec();
}

void FavouriteHubs::on_favouriteHubList_doubleClicked()
{
	on_connectFavouriteButton_clicked();
}

void FavouriteHubs::createPersistentEditors( )
{
	// todo iterate, call openpersistenteditor
	for(int i = 0; i < model->rowCount(QModelIndex());i++) {
		QModelIndex mi = model->index(i,0);
		ui.favouriteHubList->openPersistentEditor(mi);
	}
}

void FavouriteHubs::refresh()
{
	backendConnection->getFavouriteHubs();
}


QVariant FavouriteHubs::FavouriteHubsModel::data( const QModelIndex & index, int role ) const
{
	if(role==Qt::DisplayRole) {
		switch(index.column()) {
//			case 0: return entries[index.row()].autoConnect;
			case 1: return entries[index.row()].name.c_str();
			case 2: return entries[index.row()].server.c_str();
			case 3: return entries[index.row()].description.c_str();
			case 4: return entries[index.row()].password.c_str();
			case 5: return entries[index.row()].nick.c_str();
			case 6: return entries[index.row()].userDescription.c_str();
		}
		
	}
	return QVariant();
}

rpc_types::FavouriteHub FavouriteHubs::FavouriteHubsModel::getHubData( const QModelIndex& index ) const
{
	if( index.isValid() ) {
		return entries[index.row()];
	}
	return rpc_types::FavouriteHub();
}

QVariant FavouriteHubs::FavouriteHubsModel::headerData( int section, Qt::Orientation orientation, int role ) const
{
	if( orientation==Qt::Horizontal && role==Qt::DisplayRole )
	{
		switch(section) {
			case 0: return tr("AutoConnect");
			case 1: return tr("Name");
			case 2: return tr("Server");
			case 3: return tr("Description");
			case 4: return tr("Password");
			case 5: return tr("Nick");
			case 6: return tr("User Description");
				
		}
	}
	return QVariant();
}

void FavouriteHubs::FavouriteHubsModel::setHubs( const QList< rpc_types::FavouriteHub >& hubs)
{
	entries = hubs;
	emit layoutChanged();
}

void FavouriteHubs::FavouriteHubsModel::addHub( const rpc_types::FavouriteHub &e )
{
	entries.append( e );
	emit layoutChanged();
}

void FavouriteHubs::FavouriteHubsModel::removeHub( const string &s )
{
	rpc_types::FavouriteHub tempFav;
	tempFav.server = s;
	entries.removeAll( tempFav );
	emit layoutChanged();
}


bool FavouriteHubs::FavouriteHubsModel::setData ( const QModelIndex& index, const QVariant& value, int role /*= Qt::EditRole*/ )
{
	if(index.column()==0 && role==Qt::EditRole)      // editing autoconnect
	{
		entries[index.row()].autoConnect = value.toBool();
		return true;
	}
	return false;
}

Qt::ItemFlags FavouriteHubs::FavouriteHubsModel::flags ( const QModelIndex& index ) const
{
	switch(index.column()) {
		case 0: return Qt::ItemIsSelectable | 
			Qt::ItemIsEnabled | 
			Qt::ItemIsUserCheckable | 
			Qt::ItemIsEditable;
	}
	return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
}


