# Generated by Django 5.1.5 on 2025-01-24 14:00

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('oauth2_provider', '0012_add_token_checksum'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AlterField(
            model_name='application',
            name='authorization_grant_type',
            field=models.CharField(choices=[('authorization-code', 'Authorization code'), ('urn:ietf:params:oauth:grant-type:device_code', 'Device Code'), ('implicit', 'Implicit'), ('password', 'Resource owner password-based'), ('client-credentials', 'Client credentials'), ('openid-hybrid', 'OpenID connect hybrid')], max_length=44),
        ),
        migrations.CreateModel(
            name='DeviceGrant',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('device_code', models.CharField(max_length=100, unique=True)),
                ('user_code', models.CharField(max_length=100)),
                ('scope', models.CharField(max_length=64, null=True)),
                ('interval', models.IntegerField(default=5)),
                ('expires', models.DateTimeField()),
                ('status', models.CharField(blank=True, choices=[('authorized', 'Authorized'), ('authorization-pending', 'Authorization pending'), ('expired', 'Expired'), ('denied', 'Denied')], default='authorization-pending', max_length=64)),
                ('client_id', models.CharField(db_index=True, max_length=100)),
                ('last_checked', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='%(app_label)s_%(class)s', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
                'swappable': 'OAUTH2_PROVIDER_DEVICE_GRANT_MODEL',
                'constraints': [models.UniqueConstraint(fields=('device_code',), name='oauth2_provider_devicegrant_unique_device_code')],
            },
        ),
    ]
