/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import dumphd.util.ByteSource;
import dumphd.util.CopyResult;
import dumphd.util.MessagePrinter;
import dumphd.util.PrintStreamPrinter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.zip.CRC32;

public final class Utils {
    public static final byte[] buffer = new byte[0x400000];
    public static final char[] hexLut = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static MessagePrinter out = new PrintStreamPrinter(System.out);
    private static CRC32 crc32Calc = new CRC32();

    public static MessagePrinter getMessagePrinter() {
        return out;
    }

    public static void setMessagePrinter(MessagePrinter mp) {
        if (mp == null) {
            throw new IllegalArgumentException("The MessagePrinter must be non null");
        }
        out = mp;
    }

    public static String toHexString(byte[] src, int offset, int length) {
        StringBuffer sb = new StringBuffer(20);
        int endOffset = offset + length;
        int i = offset;
        while (i < endOffset) {
            sb.append(hexLut[src[i] >>> 4 & 0xF]);
            sb.append(hexLut[src[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public static void decodeHexString(String src, byte[] dst, int offset) {
        int halfLength = src.length() / 2;
        int digit0 = 0;
        int digit1 = 0;
        int i = 0;
        while (i < halfLength) {
            int pos = i * 2;
            digit1 = Character.digit(src.charAt(pos), 16);
            digit0 = Character.digit(src.charAt(++pos), 16);
            dst[offset + i] = (byte)((digit1 << 4) + digit0);
            ++i;
        }
    }

    public static void scanForFilenames(File src, String baseDir, Collection<String> dst, boolean recursive, FilenameFilter fnf, boolean silent) {
        LinkedList<DirElement> dirs = new LinkedList<DirElement>();
        class DirElement {
            public String baseDir = null;
            public File dir = null;

            public DirElement(String baseDir, File dir) {
                this.baseDir = baseDir;
                this.dir = dir;
            }
        }
        dirs.add(new DirElement(baseDir, src));
        while (!dirs.isEmpty()) {
            File[] files;
            DirElement dir = (DirElement)dirs.remove();
            if (!silent) {
                out.println("Searching " + dir.dir + " for files...");
            }
            if ((files = dir.dir.listFiles(fnf)) == null) continue;
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    if (recursive) {
                        dirs.add(new DirElement(String.valueOf(dir.baseDir) + File.separator + files[i].getName(), files[i]));
                    }
                } else {
                    if (!silent) {
                        out.println(files[i].toString());
                    }
                    dst.add(String.valueOf(dir.baseDir) + File.separator + files[i].getName());
                }
                ++i;
            }
        }
    }

    public static CopyResult copyBs(ByteSource in, ByteSource out, long length) throws IOException {
        int readResult = 0;
        int writeResult = 0;
        int writeAmount = 0;
        CopyResult returnValue = new CopyResult();
        crc32Calc.reset();
        while (length > 0L) {
            writeAmount = length <= (long)buffer.length ? (int)length : buffer.length;
            readResult = in.read(buffer, 0, writeAmount);
            if (readResult == -1) break;
            if (readResult != writeAmount) {
                writeAmount = readResult;
                length = readResult;
            }
            if ((writeResult = out.write(buffer, 0, writeAmount)) == -1) break;
            if (writeResult != writeAmount) {
                writeAmount = writeResult;
                length = writeResult;
            }
            crc32Calc.update(buffer, 0, writeAmount);
            returnValue.size += (long)writeAmount;
            length -= (long)writeAmount;
        }
        returnValue.crc32 = crc32Calc.getValue();
        return returnValue;
    }

    public static int getClipNumber(String filename) {
        int clipNr = 0;
        int extOffset = filename.lastIndexOf(46);
        try {
            clipNr = Integer.parseInt(filename.substring(0, extOffset));
        }
        catch (IndexOutOfBoundsException ei) {
            clipNr = -1;
        }
        catch (NumberFormatException en) {
            clipNr = 2;
        }
        return clipNr;
    }
}

