#ifndef DUNE_RAVIARTTHOMAS0Q2DLOCALFINITEELEMENT_HH
#define DUNE_RAVIARTTHOMAS0Q2DLOCALFINITEELEMENT_HH

#include <dune/geometry/type.hh>

#include <dune/localfunctions/common/localfiniteelementtraits.hh>
#include "raviartthomas0q2d/raviartthomas0q2dall.hh"

namespace Dune 
{
  template<class D, class R>
  class RT0Q2DLocalFiniteElement 
  {
  public:
	typedef LocalFiniteElementTraits<RT0Q2DLocalBasis<D,R>,RT0Q2DLocalCoefficients,
									 RT0Q2DLocalInterpolation<RT0Q2DLocalBasis<D,R> > > Traits;

	RT0Q2DLocalFiniteElement ()
	{
	  gt.makeQuadrilateral();
	}

	RT0Q2DLocalFiniteElement (int s) : basis(s), interpolation(s)
	{
	  gt.makeQuadrilateral();
	}

	const typename Traits::LocalBasisType& localBasis () const
	{
	  return basis;
	}
	
	const typename Traits::LocalCoefficientsType& localCoefficients () const
	{
	  return coefficients;
	}
	
	const typename Traits::LocalInterpolationType& localInterpolation () const
	{
	  return interpolation;
	}
	
	GeometryType type () const
	{
	  return gt;
	}

  private:
	RT0Q2DLocalBasis<D,R> basis;
	RT0Q2DLocalCoefficients coefficients;
	RT0Q2DLocalInterpolation<RT0Q2DLocalBasis<D,R> > interpolation;
	GeometryType gt;
  };
}
#endif
