/*
 * Copyright © 2021-2023 Dynare Team
 *
 * This file is part of Dynare.
 *
 * Dynare is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dynare is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dynare.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef OBJECTIVE_ABSTRACT_CLASS_HH
#define OBJECTIVE_ABSTRACT_CLASS_HH

#include <vector>

#include "twod_matrix.hh"

class ObjectiveAC
{
protected:
  int ntt; // Size of vector of temporary terms
public:
  ObjectiveAC(int ntt_arg) : ntt {ntt_arg} {};
  virtual ~ObjectiveAC() = default;
  virtual void eval(const Vector& y, const Vector& x, const Vector& params, Vector& residual,
                    std::vector<TwoDMatrix>& md)
      = 0;
};
#endif
