<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.logicexception.php )
 *
 * Exception that represents error in the program logic. This kind of
 * exceptions should directly lead to a fix in your code.
 *
 */
class LogicException extends Exception {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from
 * http://php.net/manual/en/class.badfunctioncallexception.php )
 *
 * Exception thrown if a callback refers to an undefined function or if
 * some arguments are missing.
 *
 */
class BadFunctionCallException extends LogicException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.badmethodcallexception.php
 * )
 *
 * Exception thrown if a callback refers to an undefined method or if some
 * arguments are missing.
 *
 */
class BadMethodCallException extends BadFunctionCallException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.domainexception.php )
 *
 * Exception thrown if a value does not adhere to a defined valid data
 * domain.
 *
 */
class DomainException extends LogicException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from
 * http://php.net/manual/en/class.invalidargumentexception.php )
 *
 * Exception thrown if an argument does not match with the expected value.
 *
 */
class InvalidArgumentException extends LogicException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.lengthexception.php )
 *
 * Exception thrown if a length is invalid.
 *
 */
class LengthException extends LogicException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.outofrangeexception.php )
 *
 * Exception thrown when an illegal index was requested. This represents
 * errors that should be detected at compile time.
 *
 */
class OutOfRangeException extends LogicException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.runtimeexception.php )
 *
 * Exception thrown if an error which can only be found on runtime occurs.
 *
 */
class RuntimeException extends Exception {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.outofboundsexception.php )
 *
 * Exception thrown if a value is not a valid key. This represents errors
 * that cannot be detected at compile time.
 *
 */
class OutOfBoundsException extends RuntimeException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.overflowexception.php )
 *
 * Exception thrown when adding an element to a full container.
 *
 */
class OverflowException extends RuntimeException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.rangeexception.php )
 *
 * Exception thrown to indicate range errors during program execution.
 * Normally this means there was an arithmetic error other than
 * under/overflow. This is the runtime version of DomainException.
 *
 */
class RangeException extends RuntimeException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.underflowexception.php )
 *
 * Exception thrown when performing an invalid operation on an empty
 * container, such as removing an element.
 *
 */
class UnderflowException extends RuntimeException {}

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from
 * http://php.net/manual/en/class.unexpectedvalueexception.php )
 *
 * Exception thrown if a value does not match with a set of values.
 * Typically this happens when a function calls another function and
 * expects the return value to be of a certain type or value not including
 * arithmetic or buffer related errors.
 *
 */
class UnexpectedValueException extends RuntimeException {}
