/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "itensorfieldviewsubject.h"


#include "icommondatadistributors.h"
#include "idata.h"
#include "idatahelper.h"
#include "idatalimits.h"
#include "ierror.h"
#include "ireplicatedactor.h"
#include "itensorfieldpipeline.h"
#include "iviewsubjectparallelpipeline.h"

#include <vtkPolyData.h>

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


using namespace iParameter;


IVIEWSUBJECT_DEFINE_TYPE(iTensorFieldViewSubject,TensorField,t);

IOBJECT_DEFINE_KEY(iTensorFieldViewSubject,Method,m,Int,1);
IOBJECT_DEFINE_KEY(iTensorFieldViewSubject,ScalingOn,so,Bool,1);

//
//  Inherited keys
//
IVIEWSUBJECT_DEFINE_INHERITED_KEYS_COMMON(iTensorFieldViewSubject);
IVIEWSUBJECT_DEFINE_INHERITED_KEYS_REPLICATING(iTensorFieldViewSubject);
IVIEWSUBJECT_DEFINE_INHERITED_KEYS_COLOR(iTensorFieldViewSubject,1);
IVIEWSUBJECT_DEFINE_INHERITED_KEYS_OPACITY(iTensorFieldViewSubject,1);
IVIEWSUBJECT_DEFINE_INHERITED_KEYS_PALETTE(iTensorFieldViewSubject,1);
IVIEWSUBJECT_DEFINE_INHERITED_KEYS_FIELD(iTensorFieldViewSubject);


//
// iTensorFieldViewSubject class
//
iTensorFieldViewSubject::iTensorFieldViewSubject(iViewModule *vm, const iDataType &type, const iDataType &scalarType, const iString &name) : iFieldViewSubject(vm,type,scalarType,name,1,ViewSubject::Flag::AlwaysShaded)
{
	mSubjectId = ViewSubject::Id::TensorField;

	mMethod = 0;
	mScalingOn = true;
}


iTensorFieldViewSubject::~iTensorFieldViewSubject()
{
}


void iTensorFieldViewSubject::ConfigureBody()
{
	//
	//  Create pipeline (must be created after the object is fully created)
	//	
	this->AddMainPipeline(1);
	mActors[0]->SetInput(this->Pipeline()->GetOutput(0));
}


void iTensorFieldViewSubject::ResetPipelineInput(vtkDataSet *input)
{
	this->Pipeline()->SetNthInput(0,input);
}


void iTensorFieldViewSubject::ResetPipeline()
{
}


void iTensorFieldViewSubject::SetScalingOn(bool s)
{
	mScalingOn = s;
	this->Pipeline()->UpdateContents(iTensorFieldPipeline::_ScalingOn);
	this->ClearCache();
}


void iTensorFieldViewSubject::UpdateGlyphSize()
{ 
	this->Pipeline()->UpdateContents(iTensorFieldPipeline::_Size);
}


void iTensorFieldViewSubject::UpdateGlyphSampleRate()
{ 
	this->Pipeline()->UpdateContents(iTensorFieldPipeline::_SampleRate);
}


void iTensorFieldViewSubject::ShowBody(bool show)
{
	if(show)
	{
		mActors[0]->VisibilityOn();
		this->ShowColorBars(true);
	} 
	else 
	{
		this->ShowColorBars(false);
		mActors[0]->VisibilityOff();
	}
}


//
//  Two functions used in saving/restoring the state and in creating new instances with
//
void iTensorFieldViewSubject::FieldViewSubjectPackStateBody(iString &s) const
{
	this->PackValue(s,KeyMethod(),mMethod);
	this->PackValue(s,KeyScalingOn(),mScalingOn);
}


void iTensorFieldViewSubject::FieldViewSubjectUnPackStateBody(const iString &s)
{
	bool b;

//	if(this->UnPackValue(s,KeyMethod(),i)) this->SetMethod(i);
	if(this->UnPackValue(s,KeyScalingOn(),b)) this->SetScalingOn(b);
}


int iTensorFieldViewSubject::GetDataOffset() const
{
	return 0;
}


bool iTensorFieldViewSubject::CanBeShown() const
{
	iDataHelper *h = this->CreateDataHelper(this->GetData());
	bool ret = (h->IsThereTensorData() && this->GetDataOffset()>=0 && this->GetDataOffset()<this->GetLimits()->GetNumVars());
	delete h;
	return ret;
}


void iTensorFieldViewSubject::FieldViewSubjectSyncWithData(const iDataSyncRequest &)
{
}


iViewSubjectPipeline* iTensorFieldViewSubject::CreatePipeline(int)
{
	return new iTensorFieldPipeline(this);
}


void iTensorFieldViewSubject::ConfigureMainPipeline(iViewSubjectPipeline *p, int)
{
	iViewSubjectParallelPipeline *pp = iRequiredCast<iViewSubjectParallelPipeline>(INFO,p);

	iImageDataDistributor *idd = new iImageDataDistributor(pp->GetDataManager());
	pp->GetDataManager()->AddDistributor(idd);
	pp->GetDataManager()->AddCollector(new iPolyDataCollector(pp->GetDataManager(),idd));
}

