/*
 * Copyright (C) 2007, 2008, 2009 Patrick Balleux, Nicolas Cardoso De Castro
 * (nicolas_cardoso@users.sourceforge.net), Daniel Žalar (danizmax@gmail.com).
 * Gabriel Sichardt
 *
 * This file is part of JSymphonic program.
 *
 * JSymphonic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JSymphonic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSymphonic. If not, see <http://www.gnu.org/licenses/>.
 *
 *****
 *
 * M3uReader.java
 *
 * Created on June 15, 2008, 00:07 AM
 *
 */
package org.naurd.media.jsymphonic.playlist;


import java.io.*;
import java.util.ArrayList;
import org.naurd.media.jsymphonic.title.Title;

/**
 * This class reads m3u playlist files from the local filesystem.
 * @author Gabriel Sichardt
 */
public class M3uReader extends Playlist{
/* FIELDS*/

    /* CONSTRUCTOR */
    /**
     * Create a M3uReader object from a file.
     * 
     * @param sourceFile The file to instance the object from.
     */
    public M3uReader(File sourceFile) {
        super(sourceFile.getName().substring(0, sourceFile.getName().length()-4), getTitles(sourceFile.getAbsolutePath()));
        setSourceFile(sourceFile);
    }


/* METHODS */

/* STATIC METHODS */
    /**
     *
     * @param sourcefile
     * @return
     */
    public static ArrayList getTitles(String sourcefile){
             /*@param sourcefile The local playlist filename.
              *@return The titles of the playlist in an ArrayList.
              *
              *This method creates an ArrayList from a source M3U file and returns it.
              *Extended information is skipped and original order will be kept, starting
              *with standard index zero.
              */

  //method variables
  int counter1 = 0;
  int counter2 = 0;
  String line2;   //Line currently read from file
  //end of method varibles
		
  
    try {
            //Reading the sourvefile
            File sourcem3u = new File(sourcefile);
            BufferedReader in2 = new BufferedReader( new FileReader(sourcem3u));
            ArrayList titleList = new ArrayList(counter2);
			
			
            while ((line2 = in2.readLine()) != null) {
                if (!line2.startsWith("#")){	//filtering out lines with extended info

                    if (line2.startsWith(".")) //create absoulute paths from relative paths
                    {
                        line2=line2.substring(1);//removing leading dot
                        line2=sourcem3u.getParent()+line2;//adding the path of the playlist file

                    }


                    // We are processing a line with a file address, that we should instance to a Title object, but to do so, we should create a new file instance
                    // Note that we are instancing a Title object using the "getTitleFromFile" method, which throws an UnknowFileTypeException when the file is not as expected, so this method should be called in a try-catch block
                    try
                    {
                        File titleFile = new File(line2);
                        
                        if(titleFile.getAbsoluteFile().exists())
                            titleList.add(Title.getTitleFromFile(titleFile.getAbsoluteFile()));
                        else
                        {
                            logger.severe("The file "+line2 + " was not found!");
                        }
                       
                    } catch (Exception ex)
                        {
                        // File was not as expected, report the error
                        logger.severe("ERROR while loading a playlist file, the file type is not known. "+ex.getMessage());
                        }

                    counter1++;
                }//end of filter against extended info.
                    
			}//end of reading loop
					
			in2.close();                        
			return titleList;

                }
                catch (IOException except)
                    {
                        except.printStackTrace();
                        return null;
                    }
                
      
     
    }

    /**
     *Obtains the list of the possible file extentions for this format.
     *
     *@return A list of extentions separated with commas.
     */
    public static String getFileExtentionsList() {
        return "m3u";
    }
}
