//---------------------------------------------------------------------------
/**
  * @brief		SHIORI/2.0 AI⥸塼 ݡȥإåե
  *				ΥեPDS(Public Domain Software)Ȥ롣
  *
  * ١פȤϡֻǤѵAI⥸塼뵬ʤ̾ΤǤ롣
  * ٵʤϡHTTP˹ꥯȡ쥹ݥ󥹷å󥰤򼴤Ȥ
  * ·ǥǤꡢAI⥸塼¦٥СסѤ¦
  * ٥饤ȡפȸƤ֡
  *
  * API桢ϤѤΰϡץåȥե¸ΰ
  * ؿǳݤ졢¦롣
  * ΰݡѤؿϰʲ
  * Win32ץåȥե : GlobalAlloc(GMEM_FIXED, len), GlobalFree()
  * POSIXץåȥե : malloc(len), free()
  *	                        (饤ȸͭC饤֥¸)
  */
//
//  2003.02.25                 <suikyo@yk.rim.or.jp>
//
//---------------------------------------------------------------------------
#ifndef SHIORI_H__
#define SHIORI_H__
//-------------------------------------------------------------------------
#if defined(WIN32)||defined(_WIN32)||defined(_Windows)||defined(__CYGWIN__)
// Win32
#	include <windows.h>
#	ifdef __BORLANDC__
// 		Borland C++
#		define SHIORI_EXPORT	extern "C"
#	else
// 		Visual C++ / Cygwin32 / Mingw32
#		define SHIORI_EXPORT	extern "C" __declspec(dllexport)
#	endif
#	define SHIORI_CALL			__cdecl
#	define MEMORY_HANDLE		HGLOBAL
#	define SHIORI_MALLOC(len)	::GlobalAlloc(GMEM_FIXED, len)
#	define SHIORI_FREE(ptr)		::GlobalFree((HGLOBAL)ptr)
#else
// Other Platform
#	define SHIORI_EXPORT		extern "C"
#	define SHIORI_CALL
#	define MEMORY_HANDLE		char *
#	define SHIORI_MALLOC(len)	malloc(len)
#	define SHIORI_FREE(ptr)		free((void *)ptr)
#endif
#ifndef BOOL
#	define BOOL					int
#	define TRUE					1
#	define FALSE				0
#endif
//---------------------------------------------------------------------------
/**
  * @brief		⥸塼ɤ߹ľ˸ƤФ
  *
  * @param h	(I) DLLե뤬¸ߤǥ쥯ȥѥɽʸؤ
  *				ݥ󥿡ΰ٥Ф뤳ȡ
  * @param len	(I) hʸĹ
  * @return		ΤȤTRUEԤΤȤFALSE
  */
SHIORI_EXPORT BOOL SHIORI_CALL load(const MEMORY_HANDLE h,long len);
//---------------------------------------------------------------------------
/**
  * @brief		⥸塼ڤΥľ˸ƤФ
  *
  * @return		ΤȤTRUEԤΤȤFALSE
  */
SHIORI_EXPORT BOOL SHIORI_CALL unload(void);
//---------------------------------------------------------------------------
/**
  * @brief		AIꥯ
  *
  * @param h	(I) ׵ʸؤΥݥ󥿡٥Ф뤳ȡ
  * @param len	(IO) ƤӽФ׵ʸbyteĹǼ졢ʸ
  *				byteĹǼ֤롣
  * @return		ʸؤΥݥ󥿡٥Фݤ٥饤Ȥ
  *				뤳ȡ
  */
SHIORI_EXPORT MEMORY_HANDLE SHIORI_CALL request(const MEMORY_HANDLE h,long *len);
//---------------------------------------------------------------------------
#endif // SHIORI_H__
//---------------------------------------------------------------------------
