/* ***************************************************************************
 *
 *                              KisSplice
 *      de-novo calling alternative splicing events from RNA-seq data.
 *
 * ***************************************************************************
 *
 * Copyright INRIA 
 *  contributors :  Vincent Lacroix
 *                  Pierre Peterlongo
 *                  Gustavo Sacomoto
 *                  Vincent Miele
 *                  Alice Julien-Laferriere
 *                  David Parsons
 *
 * pierre.peterlongo@inria.fr
 * vincent.lacroix@univ-lyon1.fr
 *
 * This software is a computer program whose purpose is to detect alternative
 * splicing events from RNA-seq data.
 *
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software. You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".

 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.

 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 */
 
 
 
 
 
#ifndef EDGE_H
#define EDGE_H


// ===========================================================================
//                               Include Libraries
// ===========================================================================
#include <utility>
#include <algorithm>

// ===========================================================================
//                             Include Project Files
// ===========================================================================

// ===========================================================================
//                              Class declarations
// ===========================================================================

//! Edge class
/*!
 * \brief Class meant to be used by CGraph (compact graph) to represent edges.
 *
 * It encapsulates a pair of int (u -> v edge), each int (u or v) being a node id
 */

class CEdge
{
  public :
    
    // =======================================================================
    //                                 Enums
    // =======================================================================
    
    // =======================================================================
    //                               Constructors
    // =======================================================================
    CEdge() = default;
    CEdge( const CEdge& ) = default;
  
    CEdge( int f, int s ) : m_pair( f, s ) {}

    // =======================================================================
    //                                Destructor
    // =======================================================================

    // =======================================================================
    //                            Accessors: getters
    // =======================================================================
    inline int getFirst() const { return m_pair.first; }
    inline int getSecond() const { return m_pair.second; }

    // =======================================================================
    //                            Accessors: setters
    // =======================================================================

    // =======================================================================
    //                                Operators
    // =======================================================================
    bool operator==( const CEdge& that ) const { return m_pair == that.m_pair; }
    bool operator!=( const CEdge& that ) const { return m_pair != that.m_pair; }
    bool operator<( const CEdge& that ) const { return m_pair < that.m_pair; }

    // =======================================================================
    //                              Public Methods
    // =======================================================================
    CEdge& swap_ends() {
      std::swap(m_pair.first, m_pair.second);
      return *this;
    }

    // =======================================================================
    //                             Public Attributes
    // =======================================================================

  protected :
    std::pair<int, int> m_pair;

    // =======================================================================
    //                            Forbidden Constructors
    // =======================================================================

    // =======================================================================
    //                              Protected Methods
    // =======================================================================

    // =======================================================================
    //                             Protected Attributes
    // =======================================================================
};

#endif // EDGE_H
