/***************************************************************************
                          msndirectconnection.h -  description
                             -------------------
    begin                : Tue 12 27 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSNDIRECTCONNECTION_H
#define MSNDIRECTCONNECTION_H

#include "directconnectionbase.h"

#include <QByteArray>


class MimeMessage;



/**
 * A connection used to transfer MSNP2P data (e.g. files) directly between two end-hosts.
 * This connection can be established during a P2PApplication invitation.
 *
 * @author Diederik van der Boor
 * @ingroup NetworkExtra
 */
class MsnDirectConnection : public DirectConnectionBase
{
  Q_OBJECT

  public:
    // The constructor
                           MsnDirectConnection(const QString &contactHandle);
    // The destructor
    virtual               ~MsnDirectConnection();

    // Send the preamble packet preceeding all other packets
    bool                   initialize();
    // Return the contact handle
    const QString&         getContactHandle() const;
    // Send the message to the contact
    bool                   sendMessage(const QByteArray &message);
    // Mark the remote host as authorized (make it a public method)
    using                  DirectConnectionBase::setAuthorized;

  private slots: // Protected slots
    // This is called when data is received from the socket.
    void                   slotSocketDataReceived();

  private:   // private properties
    // The buffer for the incoming p2p messages.
    QByteArray             buffer_;
    // The offset of the currently received block
    quint64                bufferOffset_;
    // The other contact we're connected with
    QString                contactHandle_;
    // Whether the first message is received
    bool                   firstMessage_;
    // The buffer for the next preamble message.
    QByteArray             preambleBuffer_;
    // The offset in the preamble buffer
    qint64                 preambleOffset_;
    // Set when only partial data was received
    quint64                remainingBlockBytes_;

  signals:
    // Signal that a full message block was received.
    void                   messageReceived(const QByteArray &message);
};


#endif
