<?php
/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: init_admin.php 849 2009-09-22 10:50:52Z lordlamer $
 */

if (!isset ($_SERVER['ORIG_PATH_TRANSLATED'])) { $_SERVER['ORIG_PATH_TRANSLATED'] = ''; }
if (!isset ($_SERVER['ORIG_SCRIPT_FILENAME'])) { $_SERVER['ORIG_SCRIPT_FILENAME'] = ''; }
// get base paths
/*
define('KNOWLEDGEROOT_ADMIN_PATH',str_replace('//','/', str_replace('\\','/', (php_sapi_name()=='cgi' || php_sapi_name()=='isapi' || php_sapi_name()=='cgi-fcgi') && ($_SERVER['ORIG_PATH_TRANSLATED'] ? $_SERVER['ORIG_PATH_TRANSLATED'] : $_SERVER['PATH_TRANSLATED'])? ($_SERVER['ORIG_PATH_TRANSLATED']?$_SERVER['ORIG_PATH_TRANSLATED']:$_SERVER['PATH_TRANSLATED']):($_SERVER['ORIG_SCRIPT_FILENAME']?$_SERVER['ORIG_SCRIPT_FILENAME']:$_SERVER['SCRIPT_FILENAME']))));
define('KNOWLEDGEROOT_PATH',str_replace('/admin','',KNOWLEDGEROOT_ADMIN_PATH));

$base_path = dirname(KNOWLEDGEROOT_PATH) . "/";
*/

// get base url for session name
$baseurl = $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'];
preg_match("/(.*\/).*/", $baseurl, $url_arr);

if($url_arr[1] == "") {
	$url_arr[1] = $_SERVER['HTTP_HOST'];
}

$base_path = realpath(dirname(__FILE__).'/../') . '/';

// load required files
require_once($base_path."include/version.php");
require_once($base_path."include/class-session.php");
require_once($base_path."include/class-runtime.php");
require_once($base_path."include/function.php");
require_once($base_path."include/class-knowledgeroot.php");
require_once($base_path."include/class-knowledgeroot-header.php");
require_once($base_path."include/class-language.php");
require_once($base_path."include/class-knowledgeroot-extension.php");
require_once($base_path."include/class-extension-base.php");
require_once($base_path."include/class-error.php");
require_once($base_path."include/class-hooks.php");
require_once($base_path."include/class-db-result.php");
require_once($base_path."include/class-db-core.php");

// this is the variable where all classes are in
$CLASS = array();

// init session
// init session
$CLASS['session'] = new session();
$CLASS['session']->start($CLASS);
$CLASS['session']->startSession(md5($url_arr[1]));
if(!$CLASS['session']->checkSession()) {
        die("SESSION WAS WRONG!");
}


// define runtimer
$CLASS['runtime'] = new runtime();

// define global variables
$CLASS['vars'] = $CONFIG;
$CLASS['admin_vars'] = $ADMIN_CONFIG;

// init error
$CLASS['error'] = new knowledgeroot_error();
$CLASS['error']->start($CLASS);

// set base paths
//$CLASS['vars']['base_path'] = dirname(KNOWLEDGEROOT_PATH) . "/";
$CLASS['vars']['base_path'] = $base_path;
//$CLASS['vars']['admin_base_path'] = dirname(KNOWLEDGEROOT_ADMIN_PATH) . "/";
$CLASS['vars']['admin_base_path'] = $base_path . "admin/";

// load databaseclass
if($CLASS['vars']['db']['type'] == "mysql") {
	require_once($base_path."include/class-mysql.php");
}

if($CLASS['vars']['db']['type'] == "mysqli") {
	require_once($base_path."include/class-mysqli.php");
}

if($CLASS['vars']['db']['type'] == "pgsql") {
	require_once($base_path."include/class-pgsql.php");
}

if($CLASS['vars']['db']['type'] == "mdb2") {
	require_once($base_path."include/class-mdb2.php");
}

if($CLASS['vars']['db']['type'] == "sqlite") {
	require_once($base_path."include/class-sqlite.php");
}

if($CLASS['vars']['db']['type'] == "oracle") {
	require_once($base_path."include/class-oracle.php");
}

if($KNOWLEDGEROOTDB != "PGSQL" && $KNOWLEDGEROOTDB != "MYSQL" && $KNOWLEDGEROOTDB != "MDB2" && $KNOWLEDGEROOTDB != "SQLITE" && $KNOWLEDGEROOTDB != "OCI") {
	echo "WRONG DBTYPE SELECTED!\n";
	exit();
}

// init hooks
$CLASS['hooks'] = new hooks();
$CLASS['hooks']->start($CLASS);

// init databaseclass
$CLASS['db'] = new db();
$CLASS['db']->start($CLASS);

// connect to database
$CLASS['db']->connect($CLASS['vars']['db']['host'],$CLASS['vars']['db']['user'],$CLASS['vars']['db']['pass'],$CLASS['vars']['db']['database'],$CLASS['vars']['db']['schema'],$CLASS['vars']['db']['encoding']);

// init knowledgerootclass
$CLASS['knowledgeroot'] = new knowledgeroot();
$CLASS['knowledgeroot']->start($CLASS);

// load config from db
$CLASS['vars'] = $CLASS['knowledgeroot']->replace_array($CLASS['vars'], $CLASS['knowledgeroot']->getConfigArr());

/**
 * PHP-Gettext
 */
define('LOCALE_DIR', $base_path.'system/language');
require_once ($base_path."system/php-gettext/gettext.inc.php");

if ($CLASS['vars']['knowledgeroot']['charset'] != '') {
	$encoding = $CLASS['vars']['knowledgeroot']['charset'];
} else {
  $encoding = 'utf-8';
}
if ($CLASS['vars']['knowledgeroot']['language'] != '') {
	define('DEFAULT_LOCALE', $CLASS['vars']['knowledgeroot']['language']);
} else {
	define('DEFAULT_LOCALE', 'en');
}

$locale = (isset($_SESSION['language']))? $_SESSION['language'] : DEFAULT_LOCALE;
//$CLASS['error']->DebugOut($_SESSION['language']);

// gettext setup
putenv('LANG='.$locale);
T_setlocale(LC_ALL, $locale);
// Set the text domain as 'knowledgeroot'
$domain = 'knowledgeroot';
//$domain = $locale;
T_bindtextdomain($domain, LOCALE_DIR);
// bind_textdomain_codeset is supported only in PHP 4.2.0+
if (function_exists('T_bind_textdomain_codeset'))
  T_bind_textdomain_codeset($domain, $encoding);
T_textdomain($domain);
/**
 * PHP-Gettext
 */


// init language
$CLASS['language'] = new language();
$CLASS['language']->start($CLASS,$CLASS['vars']['knowledgeroot']['language']);

// check for opera and konqueror
// this is a short fix beacause the ajaxtree does not work in opera and konqueror
if($CLASS['vars']['menu']['ajax'] == "yes") {
//	if(preg_match("/.*[Kk]onqueror.*/",$_SERVER['HTTP_USER_AGENT']) || preg_match("/.*[Oo]pera.*/",$_SERVER['HTTP_USER_AGENT'])) {
//		$CLASS['vars']['menu']['ajax'] = "no";
//	}
}

// addslashes on GET/POST
$CLASS['knowledgeroot']->addSlashesOnArray($_GET);
$CLASS['knowledgeroot']->addSlashesOnArray($_POST);
$CLASS['knowledgeroot']->addSlashesOnArray($_COOKIE);
$CLASS['knowledgeroot']->addSlashesOnArray($_REQUEST);
$CLASS['knowledgeroot']->addSlashesOnArray($_SERVER);

// init header
$CLASS['kr_header'] = new knowledgeroot_header();
$CLASS['kr_header']->start($CLASS);

// load extensions
$CLASS['kr_extension'] = new knowledgeroot_extension();
$CLASS['kr_extension']->start($CLASS,1);

// add favicon pointer
$CLASS['kr_header']->addheader("<link rel=\"shortcut icon\" href=\"../favicon.ico\" type=\"image/x-icon\" />");

// add generator
$CLASS['kr_header']->addheader("<meta name=\"generator\" content=\"Knowledgeroot - ".$version."\" />");

// set charset
if($CLASS['vars']['knowledgeroot']['charset'] != "") {
	if($CLASS['vars']['knowledgeroot']['charset'] == "utf8") {
		$charset = "utf-8";
	} else {
		$charset = $CLASS['vars']['knowledgeroot']['charset'];
	}

	header("Content-Type: text/html; charset=".$charset."");
	$CLASS['kr_header']->addheader("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" . $charset . "\" />");
}

// add javascript to htmlheader
$CLASS['kr_header']->addjssrc("../system/javascript/prototype.js");
$CLASS['kr_header']->addjssrc("../system/javascript/scriptaculous.js");
$CLASS['kr_header']->addjssrc("../system/javascript/effects.js");
$CLASS['kr_header']->addjssrc("../system/javascript/dragdrop.js");
$CLASS['kr_header']->addjssrc("../system/javascript/showhide.js");
$CLASS['kr_header']->addjssrc("../system/javascript/ajax-tree.js");
$CLASS['kr_header']->addjssrc("../system/javascript/messagebox.js");

// start all extensions
$CLASS['kr_extension']->start_extensions();

// add hook
$CLASS['hooks']->setHook("init_admin","init","end");
?>
