/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "enterpassworddialog.h"

#include <QtGui/QCheckBox>
#include <QtGui/QDialog>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>

#include <klocale.h>
#include <kmessagebox.h>

EnterUsernamePasswordDialog::EnterUsernamePasswordDialog(QWidget *parent, const QString& caption, bool askForGrouppassword, bool askForUsername) : KDialog(parent)
{
    Q_UNUSED(caption);

    QWidget *page = new QWidget(this);
    setMainWidget(page);
    setupUi(page);
    this->askForGrouppassword = askForGrouppassword;
    this->askForUsername = askForUsername;

    if (!askForGrouppassword) {
        PSKLineEdit->hide();
        LabelGroupPassword->hide();
    }

    if (!askForUsername) {
        UsernameEdit->hide();
        LabelUsername->hide();
    }

    if (!askForGrouppassword)
        SavePskCheckBox->hide();
    if (!askForUsername)
        SaveUsernameCheckBox->hide();

    textLabel2->setText(QString("<b><font size=\"+1\">" + i18n("Enter account data:") + "</b></font>"));
}

EnterUsernamePasswordDialog::~ EnterUsernamePasswordDialog()
{
}


void EnterUsernamePasswordDialog::accept()
{
    bool ok = true;

    QString msg = "";
    if (askForGrouppassword) {
        if (PSKLineEdit->text().isEmpty())
            msg += "\n- " + i18n("PSK");
    }

    if (askForUsername) {
        if (UsernameEdit->text().isEmpty())
            msg += "\n- " + i18n("Username");

        if (PasswordEdit->text().isEmpty())
            msg += "\n- " + i18n("Password");
    }
    if (!msg.isEmpty()) {
        KMessageBox::sorry(0, i18n("All fields must be filled in. Please check:\n%1", msg));
        ok = false;
    }

    if (ok)
        QDialog::accept();


}

#include "enterpassworddialog.moc"
