/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef MANAGECISCOCERT_H
#define MANAGECISCOCERT_H

#include <QProcess>
#include <QAction>
#include <QtGui/QMenu>
#include <QtCore/QStringList>

#include <kdialog.h>

#include "ui_manageciscocertbase4.h"
#include "kvpncconfig.h"

class ManageCiscoCert : public KDialog
{
    Q_OBJECT

public:
    ManageCiscoCert(QWidget *parent, const char* caption, KVpncConfig *GlobalConfig);
    ~ManageCiscoCert();

private:
    KVpncConfig *GlobalConfig;
    QProcess *DeleteProcess;
    QProcess *ShowProcess;
    QMenu *ContextMenu;
    QStringList CertDataList;
    QString CertDataName;
    QString CertType;
    bool CertStartFound;
    Ui_ManageCiscoCertBase *ManageCiscoCertWidget;

private slots:
    void deleteCertClicked();
    void importCertClicked();
    void showCertClicked();
    void deleteProcessFinished(int, QProcess::ExitStatus);
    void showProcessFinished(int, QProcess::ExitStatus);
    void checkList();
    void readFromStdout_remove();
    void readFromStderr_remove();
    void readFromStdout_display();
    void readFromStderr_display();
	void customContextMenuRequested(const QPoint &);
	void itemActivated(QTreeWidgetItem *, int);
};

#endif
