/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.internal;

import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnvironmentReader {
    private static final String APPLICATION_RESOURCE_FILE = "jndi.properties";
    private static final String PROVIDER_RESOURCE_FILE = "jndiprovider.properties";

    private EnvironmentReader() {
    }

    public static void mergeEnvironment(Hashtable<?, ?> src, Hashtable<Object, Object> dst, boolean valueAddToList) {
        Object key = null;
        String val = null;
        Enumeration<?> keys = src.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (!dst.containsKey(key)) {
                dst.put(key, src.get(key));
                continue;
            }
            if (!valueAddToList || !"java.naming.factory.control".equals(key) && !"java.naming.factory.object".equals(key) && !"java.naming.factory.state".equals(key) && !"java.naming.factory.url.pkgs".equals(key)) continue;
            val = (String)dst.get(key);
            val = String.valueOf(val) + ":" + src.get(key);
            dst.put(key, val);
        }
    }

    static Hashtable<Object, Object> filterProperties(JNDIPropertiesSource source) {
        Hashtable<Object, Object> filteredProperties = new Hashtable<Object, Object>();
        String propValue = null;
        propValue = source.getProperty("java.naming.factory.initial");
        if (propValue != null) {
            filteredProperties.put("java.naming.factory.initial", propValue);
        }
        if ((propValue = source.getProperty("java.naming.dns.url")) != null) {
            filteredProperties.put("java.naming.dns.url", propValue);
        }
        if ((propValue = source.getProperty("java.naming.provider.url")) != null) {
            filteredProperties.put("java.naming.provider.url", propValue);
        }
        if ((propValue = source.getProperty("java.naming.factory.object")) != null) {
            filteredProperties.put("java.naming.factory.object", propValue);
        }
        if ((propValue = source.getProperty("java.naming.factory.state")) != null) {
            filteredProperties.put("java.naming.factory.state", propValue);
        }
        if ((propValue = source.getProperty("java.naming.factory.url.pkgs")) != null) {
            filteredProperties.put("java.naming.factory.url.pkgs", propValue);
        }
        if ((propValue = source.getProperty("java.naming.factory.control")) != null) {
            filteredProperties.put("java.naming.factory.control", propValue);
        }
        return filteredProperties;
    }

    public static void readSystemProperties(Hashtable<Object, Object> existingProps) {
        Hashtable<Object, Object> systemProperties = AccessController.doPrivileged(new PrivilegedAction<Hashtable<Object, Object>>(){

            @Override
            public Hashtable<Object, Object> run() {
                return EnvironmentReader.filterProperties(new SystemPropertiesSource());
            }
        });
        EnvironmentReader.mergeEnvironment(systemProperties, existingProps, false);
    }

    public static void readAppletParameters(Object applet, Hashtable<Object, Object> existingProps) {
        if (applet != null) {
            Hashtable<Object, Object> appletParameters = EnvironmentReader.filterProperties(new AppletParametersSource((Applet)applet));
            EnvironmentReader.mergeEnvironment(appletParameters, existingProps, false);
        }
    }

    static Hashtable<Object, Object> readMultipleResourceFiles(String name, Hashtable<Object, Object> existingProps, ClassLoader cl) throws NamingException {
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        Enumeration<URL> e = null;
        try {
            e = cl.getResources(name);
        }
        catch (IOException ex) {
            ConfigurationException newEx = new ConfigurationException(Messages.getString("jndi.23"));
            newEx.setRootCause(ex);
            throw newEx;
        }
        URL url = null;
        InputStream is = null;
        Properties p = new Properties();
        while (e.hasMoreElements()) {
            url = e.nextElement();
            try {
                try {
                    is = url.openStream();
                    if (is != null) {
                        p.load(is);
                        EnvironmentReader.mergeEnvironment(p, existingProps, true);
                        p.clear();
                    }
                }
                catch (IOException ex) {
                    ConfigurationException newEx = new ConfigurationException(Messages.getString("jndi.24"));
                    newEx.setRootCause(ex);
                    throw newEx;
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    is = null;
                }
                throw throwable;
            }
            try {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException iOException) {}
            }
            finally {
                is = null;
            }
        }
        return existingProps;
    }

    public static Hashtable<Object, Object> readApplicationResourceFiles(final Hashtable<Object, Object> existingProps) throws NamingException {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws NamingException {
                        EnvironmentReader.readMultipleResourceFiles(EnvironmentReader.APPLICATION_RESOURCE_FILE, existingProps, Thread.currentThread().getContextClassLoader());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception rootCause = e.getException();
                if (rootCause instanceof NamingException) {
                    throw (NamingException)rootCause;
                }
                if (!(rootCause instanceof RuntimeException)) break block3;
                throw (RuntimeException)rootCause;
            }
        }
        return existingProps;
    }

    public static Hashtable<Object, Object> readLibraryResourceFile(Hashtable<Object, Object> existingProps) throws NamingException {
        String sep = System.getProperty("file.separator");
        String resPath = null;
        resPath = System.getProperty("java.home");
        if (!resPath.endsWith(sep)) {
            resPath = String.valueOf(resPath) + sep;
        }
        resPath = String.valueOf(resPath) + "lib" + sep + APPLICATION_RESOURCE_FILE;
        InputStream is = null;
        final File resFile = new File(resPath);
        final Properties p = new Properties();
        boolean resFileExists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return resFile.exists();
            }
        });
        if (resFileExists) {
            try {
                try {
                    is = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                        @Override
                        public FileInputStream run() throws IOException {
                            FileInputStream localInputStream = new FileInputStream(resFile);
                            p.load(localInputStream);
                            return localInputStream;
                        }
                    });
                    EnvironmentReader.mergeEnvironment(p, existingProps, true);
                }
                catch (PrivilegedActionException e) {
                    ConfigurationException newEx = new ConfigurationException(Messages.getString("jndi.25"));
                    newEx.setRootCause(e.getException());
                    throw newEx;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return existingProps;
    }

    public static Hashtable<Object, Object> readProviderResourceFiles(final Context context, final Hashtable<Object, Object> existingProps) throws NamingException {
        String factory = context.getClass().getName();
        String resPath = null;
        int len = factory.lastIndexOf(46);
        if (-1 == len) {
            resPath = PROVIDER_RESOURCE_FILE;
        } else {
            resPath = factory.substring(0, len + 1);
            resPath = resPath.replace('.', '/');
            resPath = String.valueOf(resPath) + PROVIDER_RESOURCE_FILE;
        }
        try {
            final String finalResPath = resPath;
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws NamingException {
                    EnvironmentReader.readMultipleResourceFiles(finalResPath, existingProps, context.getClass().getClassLoader());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception rootCause = e.getException();
            if (rootCause instanceof NamingException) {
                throw (NamingException)rootCause;
            }
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            throw new AssertionError((Object)rootCause);
        }
        return existingProps;
    }

    public static String[] getFactoryNamesFromEnvironmentAndProviderResource(Hashtable<?, ?> envmt, Context ctx, String key) throws NamingException {
        String str;
        ArrayList<String> fnames = new ArrayList<String>();
        if (envmt != null && (str = (String)envmt.get(key)) != null) {
            StringTokenizer st = new StringTokenizer(str, ":");
            while (st.hasMoreTokens()) {
                fnames.add(st.nextToken());
            }
        }
        if (ctx != null) {
            Hashtable<Object, Object> h = new Hashtable<Object, Object>();
            EnvironmentReader.readProviderResourceFiles(ctx, h);
            String str2 = (String)h.get(key);
            if (str2 != null) {
                StringTokenizer st = new StringTokenizer(str2, ":");
                while (st.hasMoreTokens()) {
                    fnames.add(st.nextToken());
                }
            }
        }
        if ("java.naming.factory.url.pkgs".equals(key)) {
            fnames.add("com.sun.jndi.url");
        }
        return fnames.toArray(new String[fnames.size()]);
    }

    private static class AppletParametersSource
    implements JNDIPropertiesSource {
        private Applet applet;

        public AppletParametersSource(Applet applet) {
            this.applet = applet;
        }

        public String getProperty(String propName) {
            return this.applet.getParameter(propName);
        }
    }

    private static interface JNDIPropertiesSource {
        public String getProperty(String var1);
    }

    private static class SystemPropertiesSource
    implements JNDIPropertiesSource {
        public String getProperty(String propName) {
            return System.getProperty(propName);
        }
    }
}

