/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
* This file is part of the libgltf project.
*
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this
* file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/

#ifndef TEXTURE_H
#define TEXTURE_H

#include <epoxy/gl.h>

namespace libgltf
{

enum ETextureFiltering
{
    TEXTURE_FILTER_MAG_NEAREST = 0,
    TEXTURE_FILTER_MAG_BILINEAR,
    TEXTURE_FILTER_MIN_NEAREST,
    TEXTURE_FILTER_MIN_BILINEAR,
    TEXTURE_FILTER_MIN_NEAREST_MIPMAP,
    TEXTURE_FILTER_MIN_BILINEAR_MIPMAP,
    TEXTURE_FILTER_MIN_TRILINEAR
};

class Texture
{
public:

    void createFromData(unsigned char* bData, int a_iWidth, int a_iHeight,
                        GLenum format);

    bool loadTexture2DFromBuffer(unsigned char* buffer, int width, int height);

    void bindTexture(int iTextureUnit);

    void setFiltering(int a_tfMagnification, int a_tfMinification);

    void setTextureParameter(GLenum parameter, GLint value);

    void deleteTexture();

    Texture();
    ~Texture();
private:

    unsigned int mTexture; // Texture name
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
