with GNAT.Strings;
with GNATCOLL.Projects;          use GNATCOLL.Projects;
with GNATCOLL.VFS;               use GNATCOLL.VFS;
with GNATCOLL.Traces;            use GNATCOLL.Traces;
with GNATCOLL.VFS_Utils;         use GNATCOLL.VFS_Utils;

with Ada.Containers.Indefinite_Ordered_Sets;
with Ada.Containers.Indefinite_Vectors;

with Ada.Text_IO;

with GNAT.OS_Lib;             use GNAT.OS_Lib;
with Ada.Characters.Handling; use Ada.Characters.Handling;

procedure Main is
   Env                 : Project_Environment_Access;
   Source_Project_Tree : GNATCOLL.Projects.Project_Tree;

   P : Project_Type;

   package String_Set is new Ada.Containers.Indefinite_Ordered_Sets (String);
   use String_Set;

   Paths         : String_Set.Set;

   procedure Has_Elem (Paths : String_Set.Set; Elem : String; Msg : String);
   procedure Has_Elem (Paths : String_Set.Set; Elem : String; Msg : String) is
   begin
      if Paths.Find (Elem) = String_Set.No_Element then
         Ada.Text_IO.Put_Line (Elem & Msg);
      end if;
   end Has_Elem;

   Cur_Dir : constant Virtual_File := Get_Current_Dir;

   Str : String_Access;
begin
   Parse_Config_File;
   Set_Active (Create ("Projects.Aggregate"), True);
--     Set_Active (Create ("Projects"), True);
   Initialize (Env);
   Env.Register_Default_Language_Extension ("C", ".h", ".c");
   Env.Set_Path_From_Gnatls ("gnatls", Str);
   Free (Str);
   Source_Project_Tree.Load (GNATCOLL.VFS.Create (+"aggr.gpr"), Env);

   if Source_Project_Tree.Root_Project = No_Project then
      Ada.Text_IO.Put_Line ("project not loaded");
   end if;

--     declare
--        Files : File_Array := Object_Path
--          (Source_Project_Tree.Root_Project,
--           Recursive => True,
--           Including_Libraries => True);
--     begin
--        for I in Files'Range loop
--           Ada.Text_IO.Put_Line (Files (I).Display_Full_Name);
--        end loop;
--        Ada.Text_IO.New_Line;
--     end;

   declare
      Files : File_Array_Access;
   begin

      Files :=
        Library_Files
          (Source_Project_Tree.Root_Project,
           Recursive => True,
           Exclude_Overridden => True);
      for I in Files'Range loop
         Paths.Include (+Relative_Path (Files (I), Cur_Dir));
      end loop;

      Has_Elem
        (Paths,
         "obj_p1" & Directory_Separator & "s1.ali",
         " not part of object files (overriden excluded)");
      Has_Elem
        (Paths,
         "obj_p1" & Directory_Separator & "shared_src.ali",
         " not part of object files (overriden excluded)");
      Has_Elem
        (Paths,
         "obj_p2_2" & Directory_Separator & "s1.ali",
         " not part of object files (overriden excluded)");
      Has_Elem
        (Paths,
         "obj_p2_2" & Directory_Separator & "shared_src.ali",
         " not part of object files (overriden excluded)");
      Has_Elem
        (Paths,
         "obj_p2_2" & Directory_Separator & "ext_src.ali",
         " not part of object files (overriden excluded)");

      Paths.Clear;

      Files :=
        Library_Files
          (Source_Project_Tree.Root_Project,
           Recursive => True,
           Exclude_Overridden => False);
      for I in Files'Range loop
         Paths.Include (+Relative_Path (Files (I), Cur_Dir));
      end loop;

      Has_Elem
        (Paths,
         "obj_p1" & Directory_Separator & "s1.ali",
         " not part of object files (overriden included)");
      Has_Elem
        (Paths,
         "obj_p1" & Directory_Separator & "shared_src.ali",
         " not part of object files (overriden included)");
      Has_Elem
        (Paths,
         "obj_p2" & Directory_Separator & "s1.ali",
         " not part of object files (overriden included)");
      Has_Elem
        (Paths,
         "obj_p2" & Directory_Separator & "shared_src.ali",
         " not part of object files (overriden included)");
      Has_Elem
        (Paths,
         "obj_p2" & Directory_Separator & "ext_src.ali",
         " not part of object files (overriden included)");
      Has_Elem
        (Paths,
         "obj_p2_2" & Directory_Separator & "s1.ali",
         " not part of object files (overriden included)");
      Has_Elem
        (Paths,
         "obj_p2_2" & Directory_Separator & "shared_src.ali",
         " not part of object files (overriden included)");
      Has_Elem
        (Paths,
         "obj_p2_2" & Directory_Separator & "ext_src.ali",
         " not part of object files (overriden included)");

      Paths.Clear;
   end;

   Source_Project_Tree.Unload;
   Free (Env);
end Main;
