with Ada.Containers.Hashed_Maps;
with Ada.Text_IO;    use Ada.Text_IO;
with GNATCOLL.VFS;   use GNATCOLL.VFS;

procedure Main is
   package Maps is new Ada.Containers.Hashed_Maps
      (Virtual_File, Integer, Full_Name_Hash, "=");
   use Maps;
   M : Maps.Map;
   C : Maps.Cursor;
   F1, F2 : Virtual_File;
begin
   F1 := Create ("/a/b");
   M.Include (F1, 2);

   F2 := Create ("/a/b/c");
   F2 := F2.Get_Parent;    --  "/a/b/"
   C := M.Find (F2);

   --  call to Has_Element used to raise an exception
   if not Has_Element (C) then
      Put_Line ("Not found");
   end if;
end Main;
