/*
 * @(#)AutoDocJUnitFormatterJDK13UTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.junit;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.AssertionFailedError;


/**
 * Tests the AutoDocJUnitFormatterJDK13UTest class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     April 8, 2002
 * @version   $Date: 2003/02/10 22:52:16 $
 */
public class AutoDocJUnitFormatterJDK13UTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AutoDocJUnitFormatterJDK13UTest.class;
    private static final AutoDoc AD = new AutoDoc(THIS_CLASS);
    
    public AutoDocJUnitFormatterJDK13UTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testConstructor1()
    {
        new AutoDocJUnitFormatter();
    }
    
    public void testStartTestSuite()
    {
        createFormatter().startTestSuite( null );
    }
    
    public void testEndTestSuite()
    {
        createFormatter().endTestSuite( null );
    }
    
    public void testSetOutput()
    {
        createFormatter().setOutput( null );
    }
    
    public void testSetSystemOutput()
    {
        createFormatter().setSystemOutput( null );
    }
    
    public void testSetSystemError()
    {
        createFormatter().setSystemError( null );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected AutoDocJUnitFormatter createFormatter()
    {
        return new AutoDocJUnitFormatter();
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = AutoDocJUnitListenerUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new AutoDocJUnitFormatter();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

