/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "testapp.h"

#include "hud.h"

namespace HUD = Ubuntu::HUD;

TestApp::TestApp(int &argc, char **argv)
    : QApplication(argc, argv)
{
    QTextEdit *text = new QTextEdit();
    text->show();

    HUD::Action *action = new HUD::Action(this);
    action->setIdentifier("MyAction");
    action->setLabel("Hello World");
    action->setDescription("Jada Jada Jada");

    action->setKeywords("Foo;Bar");

    HUD::Context *ctx = new HUD::Context(this);
    ctx->addAction(action);

    HUD::HUD *hud = new HUD::HUD(this);
    hud->addContext(ctx);
}
