#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 106 => 0x69 },
	'about' => { 482 => 'about' },
	'aboutcvterm' => { 474 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 474 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 474 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 474 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 474 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 113 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 488 => 'absPeakAudioFilePath' },
	'academicfield' => { 478 => 'academicField' },
	'acceleration' => { 116 => 0x9404, 469 => 'Acceleration' },
	'accelerationtracking' => { 81 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 376 => 0x3 },
	'accelerometerx' => { 306 => 0x8d },
	'accelerometery' => { 306 => 0x8e },
	'accelerometerz' => { 306 => 0x8c },
	'accessoryserialnumber' => { 306 => 0x54 },
	'accessorytype' => { 306 => 0x53 },
	'actionadvised' => { 128 => 0x2a },
	'activearea' => { 116 => 0xc68d },
	'actived-lighting' => { 219 => 0x22, 257 => 0x24 },
	'actived-lightingmode' => { 257 => 0x25 },
	'adaptervoltage' => { 134 => 0x407 },
	'addaspectratioinfo' => { 81 => 0x80e },
	'addiptcinformation' => { 81 => 0x815 },
	'additionalmodelinformation' => { 474 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 81 => 0x80f, 82 => 0x11, 83 => 0x13, 86 => 0x14 },
	'address' => { 157 => 'Address' },
	'adjustmentmode' => { 383 => 0x15 },
	'adlbracketingstep' => { 238 => 0x883 },
	'adlbracketingtype' => { 238 => 0x884 },
	'adobe' => { 117 => 'Adobe' },
	'adultcontentwarning' => { 293 => 'AdultContentWarning', 481 => 'adultContentWarning' },
	'advancedfilter' => { 124 => 0x1201 },
	'advancedraw' => { 259 => 0x76a43203 },
	'advancedscenetype' => { 306 => 0x3d },
	'advisory' => { 486 => 'Advisory' },
	'ae_iso' => { 314 => 0x2, 315 => 0x4, 316 => 0x12 },
	'aeaperture' => { 314 => 0x1, 315 => 0x3, 316 => 0x11 },
	'aeaperturesteps' => { 314 => 0x8, 315 => 0xb },
	'aebautocancel' => { 81 => 0x104 },
	'aebbracketvalue' => { 74 => 0x11 },
	'aebracketingsteps' => { 237 => 0x174c, 238 => 0x87b, 246 => 0x1756 },
	'aebsequence' => { 81 => 0x105 },
	'aebsequenceautocancel' => { 79 => 0x9, 80 => 0x9, 82 => 0x8, 83 => 0x9, 86 => 0x9, 87 => 0x7 },
	'aebshotcount' => { 81 => 0x106 },
	'aebxv' => { 314 => 0x4, 315 => 0x6 },
	'aeerror' => { 315 => 0x8 },
	'aeexposuretime' => { 314 => 0x0, 315 => 0x2, 316 => 0x10 },
	'aelbutton' => { 179 => 0x45 },
	'aelexposureindicator' => { 179 => 0x51 },
	'aelock' => { 179 => 0x5b, 268 => '4.2', 277 => '4.2', 283 => 0x201, 341 => 0x48, 393 => 0x40, 394 => 0x40, 395 => [0x86,0x286] },
	'aelockbutton' => { 266 => '16.1', 268 => '4.1', 271 => '15.1', 272 => '16.1', 273 => '16.1', 275 => '30.1', 276 => '16.1', 277 => '4.1', 279 => '17.1', 281 => '17.1' },
	'aelockbuttonplusdials' => { 266 => '16.2', 275 => '32.1', 279 => '44.1' },
	'aelockformb-d80' => { 281 => '3.1' },
	'aelockmetermodeafterfocus' => { 81 => 0x114 },
	'aemaxaperture' => { 314 => 0x9, 315 => 0x10, 316 => 0x1c },
	'aemaxaperture2' => { 314 => 0xa, 315 => 0x11, 316 => 0x1d },
	'aemeteringmode' => { 314 => 0xc },
	'aemeteringmode2' => { 314 => '13.1' },
	'aemeteringsegments' => { 182 => 0x628, 341 => 0x209 },
	'aemicroadjustment' => { 81 => 0x110 },
	'aeminaperture' => { 314 => 0xb, 315 => 0x12, 316 => 0x1e },
	'aeminexposuretime' => { 314 => 0x5, 315 => 0x13, 316 => 0x1f },
	'aeprogrammode' => { 314 => 0x6 },
	'aeprojectlink' => { 463 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 463 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 463 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 463 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 463 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 463 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 314 => 0xd },
	'aexv' => { 314 => 0x3, 315 => 0x5 },
	'af-cpriority' => { 125 => '0.2' },
	'af-cpriorityselection' => { 266 => '1.1', 267 => '1.1', 269 => '1.1', 270 => '1.1', 272 => '0.1', 273 => '0.1', 274 => '0.1', 275 => '1.1', 276 => '0.1', 279 => '1.1', 280 => '1.1' },
	'af-csetting' => { 121 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 121 => '0.2' },
	'af-ctrackingsensitivity' => { 121 => '0.1' },
	'af-czoneareaswitching' => { 121 => '0.3' },
	'af-onbutton' => { 269 => '70.1', 270 => '70.1', 280 => '70.1' },
	'af-onformb-d10' => { 266 => '3.3', 275 => '3.2' },
	'af-onformb-d11' => { 276 => '2.2' },
	'af-onformb-d12' => { 279 => '50.1' },
	'af-spriority' => { 125 => '0.1' },
	'af-spriorityselection' => { 266 => '1.2', 267 => '1.2', 269 => '1.2', 270 => '1.2', 274 => '0.2', 275 => '1.2', 276 => '0.2', 279 => '1.2', 280 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 266 => '2.1', 267 => '2.1', 269 => '78.3', 270 => '78.3', 275 => '2.1', 279 => '2.1', 280 => '78.3' },
	'afadjustment' => { 341 => 0x72, 350 => 0x267 },
	'afandmeteringbuttons' => { 81 => 0x701 },
	'afaperture' => { 212 => 0x5, 213 => 0x5, 217 => 0x5 },
	'afareaheight' => { 188 => [0x1a,0x34,0x50] },
	'afareaillumination' => { 179 => 0x4b, 277 => '15.3' },
	'afareamode' => { 123 => '0.2', 175 => 0x33, 179 => 0xe, 187 => 0x0, 188 => 0x5, 306 => 0xf, 373 => 0x1205, 386 => [0xa,0x3a], 393 => 0x11, 394 => 0x10, 395 => 0x24, 406 => 0xb043, 429 => 0x17 },
	'afareamodesetting' => { 268 => '11.1', 271 => '0.1', 277 => '16.1', 281 => '2.1', 406 => 0x201c },
	'afareapointsize' => { 123 => '0.3' },
	'afareas' => { 283 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 81 => 0x51b },
	'afareawidth' => { 188 => [0x18,0x32,0x4e] },
	'afareaxposition' => { 188 => [0x14,0x2e,0x4a], 373 => 0x1203 },
	'afareaxposition1' => { 373 => 0x1201 },
	'afareayposition' => { 188 => [0x16,0x30,0x4c], 373 => 0x1204 },
	'afareayposition1' => { 373 => 0x1202 },
	'afareazonesize' => { 123 => '0.4' },
	'afassist' => { 79 => 0x5, 87 => 0x5, 179 => 0x48, 266 => '2.5', 268 => '0.2', 271 => '0.2', 272 => '1.1', 273 => '1.1', 274 => '1.3', 275 => '2.4', 276 => '1.3', 277 => '0.2', 279 => '2.4', 281 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 81 => 0x50e, 82 => 0x4, 83 => 0x5, 84 => 0x4, 85 => 0x4, 86 => 0x5 },
	'afassistlamp' => { 306 => 0x31 },
	'afbuttonpressed' => { 395 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 317 => 0x6 },
	'afduringliveview' => { 81 => 0x511 },
	'affinea' => { 456 => 'AffineA' },
	'affineb' => { 456 => 'AffineB' },
	'affinec' => { 456 => 'AffineC' },
	'affined' => { 456 => 'AffineD' },
	'affinetune' => { 189 => 0x0, 283 => 0x306 },
	'affinetuneadj' => { 189 => 0x2, 230 => 0x2d1, 231 => 0x2dc, 283 => 0x307 },
	'affinetuneindex' => { 189 => 0x1 },
	'affinex' => { 456 => 'AffineX' },
	'affiney' => { 456 => 'AffineY' },
	'afhold' => { 317 => 0x1fd },
	'afilluminator' => { 393 => 0x29, 406 => 0xb044 },
	'afimageheight' => { 188 => [0x12,0x2c,0x48] },
	'afimagewidth' => { 188 => [0x10,0x2a,0x46] },
	'afintegrationtime' => { 317 => 0x7 },
	'afmicroadj' => { 386 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 390 => 0x131 },
	'afmicroadjregisteredlenses' => { 390 => '305.1' },
	'afmicroadjustment' => { 81 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 390 => 0x130 },
	'afmode' => { 110 => 0x3009, 124 => 0x1022, 175 => 0x16, 383 => 0x5 },
	'afmoderestrictions' => { 267 => '50.3', 269 => '48.3', 270 => '48.3', 279 => '48.3', 280 => '48.3' },
	'afonaelockbuttonswitch' => { 81 => 0x702 },
	'afonbutton' => { 266 => '3.1', 267 => '47.1' },
	'afpoint' => { 34 => 0x13, 109 => 0x18, 175 => 0x15, 187 => 0x1, 286 => 0x308, 383 => 0x1f, 386 => [0x37,0x7], 390 => 0x19, 391 => 0x18, 392 => [0x18,0x20] },
	'afpointactivationarea' => { 80 => 0x11, 86 => 0x11 },
	'afpointareaexpansion' => { 81 => 0x508 },
	'afpointatshutterrelease' => { 386 => [0x39,0x9] },
	'afpointautoselection' => { 81 => 0x50b },
	'afpointbrightness' => { 81 => 0x50d, 266 => '2.4', 267 => '46.5', 269 => '2.2', 270 => '2.2', 279 => '2.3', 280 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 81 => 0x50c },
	'afpointillumination' => { 80 => 0xa, 266 => '2.3', 267 => '46.2', 269 => '47.2', 270 => '47.2', 274 => '1.2', 275 => '2.3', 276 => '1.2', 279 => '47.2', 280 => '47.2', 281 => '2.4' },
	'afpointinfocus' => { 386 => [0x38,0x8] },
	'afpointmode' => { 322 => 0x3 },
	'afpointposition' => { 110 => 0x2021, 306 => 0x4d },
	'afpointregistration' => { 79 => 0x7 },
	'afpoints' => { 178 => 0x10 },
	'afpointselected' => { 179 => 0xd, 283 => 0x305, 341 => 0xe, 390 => 0x15, 391 => 0x14, 392 => [0x14,0x1c], 406 => 0x201e },
	'afpointselected2' => { 322 => 0x4 },
	'afpointselection' => { 80 => 0xb, 266 => '1.3', 267 => '1.3', 275 => '1.3', 279 => '1.3', 280 => '1.3' },
	'afpointselectionmethod' => { 81 => 0x50f, 82 => 0xc, 83 => 0xd, 86 => 0xd },
	'afpointsetting' => { 393 => 0x12, 394 => 0x11 },
	'afpointsinfocus' => { 74 => 0xe, 187 => 0x2, 317 => 0xb, 318 => 0x4, 341 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 80 => 0xd },
	'afpointsselected' => { 318 => '4.1', 437 => 0x4 },
	'afpointsspecial' => { 318 => '4.2' },
	'afpointsunknown1' => { 317 => 0x0 },
	'afpointsunknown2' => { 317 => 0x2 },
	'afpointsused' => { 188 => 0x8, 386 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 317 => 0x4 },
	'afresponse' => { 219 => 0xad },
	'afresult' => { 288 => 0x1038 },
	'afsearch' => { 283 => 0x303 },
	'afsensoractive' => { 175 => 0x1 },
	'afstatus' => { 373 => 0x1200 },
	'afstatus_00_b4' => { 389 => 0x0 },
	'afstatus_01_c4' => { 389 => 0x2 },
	'afstatus_02_d4' => { 389 => 0x4 },
	'afstatus_03_e4' => { 389 => 0x6 },
	'afstatus_04_f4' => { 389 => 0x8 },
	'afstatus_05_g4' => { 389 => 0xa },
	'afstatus_06_h4' => { 389 => 0xc },
	'afstatus_07_b3' => { 389 => 0xe },
	'afstatus_08_c3' => { 389 => 0x10 },
	'afstatus_09_d3' => { 389 => 0x12 },
	'afstatus_10_e3' => { 389 => 0x14 },
	'afstatus_11_f3' => { 389 => 0x16 },
	'afstatus_12_g3' => { 389 => 0x18 },
	'afstatus_13_h3' => { 389 => 0x1a },
	'afstatus_14_b2' => { 389 => 0x1c },
	'afstatus_15_c2' => { 389 => 0x1e },
	'afstatus_16_d2' => { 389 => 0x20 },
	'afstatus_17_e2' => { 389 => 0x22 },
	'afstatus_18_f2' => { 389 => 0x24 },
	'afstatus_19_g2' => { 389 => 0x26 },
	'afstatus_20_h2' => { 389 => 0x28 },
	'afstatus_21_c1' => { 389 => 0x2a },
	'afstatus_22_d1' => { 389 => 0x2c },
	'afstatus_23_e1' => { 389 => 0x2e },
	'afstatus_24_f1' => { 389 => 0x30 },
	'afstatus_25_g1' => { 389 => 0x32 },
	'afstatus_26_a7_vertical' => { 389 => 0x34 },
	'afstatus_27_a6_vertical' => { 389 => 0x36 },
	'afstatus_28_a5_vertical' => { 389 => 0x38 },
	'afstatus_29_c7_vertical' => { 389 => 0x3a },
	'afstatus_30_c6_vertical' => { 389 => 0x3c },
	'afstatus_31_c5_vertical' => { 389 => 0x3e },
	'afstatus_32_e7_vertical' => { 389 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 389 => 0x42 },
	'afstatus_34_e5_vertical' => { 389 => 0x44 },
	'afstatus_35_g7_vertical' => { 389 => 0x46 },
	'afstatus_36_g6_vertical' => { 389 => 0x48 },
	'afstatus_37_g5_vertical' => { 389 => 0x4a },
	'afstatus_38_i7_vertical' => { 389 => 0x4c },
	'afstatus_39_i6_vertical' => { 389 => 0x4e },
	'afstatus_40_i5_vertical' => { 389 => 0x50 },
	'afstatus_41_a7' => { 389 => 0x52 },
	'afstatus_42_b7' => { 389 => 0x54 },
	'afstatus_43_c7' => { 389 => 0x56 },
	'afstatus_44_d7' => { 389 => 0x58 },
	'afstatus_45_e7' => { 389 => 0x5a },
	'afstatus_46_f7' => { 389 => 0x5c },
	'afstatus_47_g7' => { 389 => 0x5e },
	'afstatus_48_h7' => { 389 => 0x60 },
	'afstatus_49_i7' => { 389 => 0x62 },
	'afstatus_50_a6' => { 389 => 0x64 },
	'afstatus_51_b6' => { 389 => 0x66 },
	'afstatus_52_c6' => { 389 => 0x68 },
	'afstatus_53_d6' => { 389 => 0x6a },
	'afstatus_54_e6_center' => { 389 => 0x6c },
	'afstatus_55_f6' => { 389 => 0x6e },
	'afstatus_56_g6' => { 389 => 0x70 },
	'afstatus_57_h6' => { 389 => 0x72 },
	'afstatus_58_i6' => { 389 => 0x74 },
	'afstatus_59_a5' => { 389 => 0x76 },
	'afstatus_60_b5' => { 389 => 0x78 },
	'afstatus_61_c5' => { 389 => 0x7a },
	'afstatus_62_d5' => { 389 => 0x7c },
	'afstatus_63_e5' => { 389 => 0x7e },
	'afstatus_64_f5' => { 389 => 0x80 },
	'afstatus_65_g5' => { 389 => 0x82 },
	'afstatus_66_h5' => { 389 => 0x84 },
	'afstatus_67_i5' => { 389 => 0x86 },
	'afstatus_68_c11' => { 389 => 0x88 },
	'afstatus_69_d11' => { 389 => 0x8a },
	'afstatus_70_e11' => { 389 => 0x8c },
	'afstatus_71_f11' => { 389 => 0x8e },
	'afstatus_72_g11' => { 389 => 0x90 },
	'afstatus_73_b10' => { 389 => 0x92 },
	'afstatus_74_c10' => { 389 => 0x94 },
	'afstatus_75_d10' => { 389 => 0x96 },
	'afstatus_76_e10' => { 389 => 0x98 },
	'afstatus_77_f10' => { 389 => 0x9a },
	'afstatus_78_g10' => { 389 => 0x9c },
	'afstatus_79_h10' => { 389 => 0x9e },
	'afstatus_80_b9' => { 389 => 0xa0 },
	'afstatus_81_c9' => { 389 => 0xa2 },
	'afstatus_82_d9' => { 389 => 0xa4 },
	'afstatus_83_e9' => { 389 => 0xa6 },
	'afstatus_84_f9' => { 389 => 0xa8 },
	'afstatus_85_g9' => { 389 => 0xaa },
	'afstatus_86_h9' => { 389 => 0xac },
	'afstatus_87_b8' => { 389 => 0xae },
	'afstatus_88_c8' => { 389 => 0xb0 },
	'afstatus_89_d8' => { 389 => 0xb2 },
	'afstatus_90_e8' => { 389 => 0xb4 },
	'afstatus_91_f8' => { 389 => 0xb6 },
	'afstatus_92_g8' => { 389 => 0xb8 },
	'afstatus_93_h8' => { 389 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 389 => 0xbc },
	'afstatusactivesensor' => { 175 => 0x2, 386 => [0x4,0x3b], 390 => 0x1e, 391 => 0x1b, 392 => [0x1b,0x21] },
	'afstatusbottom' => { 175 => 0x8, 390 => 0x2a, 391 => 0x21, 392 => 0x21 },
	'afstatusbottom-left' => { 175 => 0x12, 391 => 0x2b, 392 => 0x2b },
	'afstatusbottom-right' => { 175 => 0x6, 391 => 0x1f, 392 => 0x1f },
	'afstatusbottomassist-left' => { 390 => 0x28 },
	'afstatusbottomassist-right' => { 390 => 0x2c },
	'afstatusbottomhorizontal' => { 387 => 0x10, 388 => 0x1c },
	'afstatusbottomvertical' => { 387 => 0x16, 388 => 0x26 },
	'afstatuscenter-10' => { 390 => 0x34 },
	'afstatuscenter-11' => { 390 => 0x36 },
	'afstatuscenter-12' => { 390 => 0x38 },
	'afstatuscenter-14' => { 390 => 0x3c },
	'afstatuscenter-7' => { 390 => 0x2e },
	'afstatuscenter-9' => { 390 => 0x32 },
	'afstatuscenter-horizontal' => { 390 => 0x30 },
	'afstatuscenter-vertical' => { 390 => 0x3a },
	'afstatuscenterf2-8' => { 390 => 0x4c },
	'afstatuscenterhorizontal' => { 175 => 0x2f, 387 => 0xc, 388 => 0x18, 391 => 0x2f, 392 => 0x2f },
	'afstatuscentervertical' => { 175 => 0xc, 387 => 0x14, 388 => 0x22, 391 => 0x25, 392 => 0x25 },
	'afstatusfarleft' => { 387 => 0x6, 390 => 0x26 },
	'afstatusfarlefthorizontal' => { 388 => 0x4 },
	'afstatusfarleftvertical' => { 388 => 0x12 },
	'afstatusfarright' => { 387 => 0x18, 390 => 0x44 },
	'afstatusfarrighthorizontal' => { 388 => 0x2c },
	'afstatusfarrightvertical' => { 388 => 0x34 },
	'afstatusleft' => { 175 => 0x2d, 387 => 0x2, 390 => 0x22, 391 => 0x2d, 392 => 0x2d },
	'afstatuslefthorizontal' => { 388 => 0x6 },
	'afstatusleftvertical' => { 388 => 0xe },
	'afstatuslower-left' => { 387 => 0x4, 390 => 0x24 },
	'afstatuslower-lefthorizontal' => { 388 => 0xa },
	'afstatuslower-leftvertical' => { 388 => 0x10 },
	'afstatuslower-middle' => { 387 => 0x22, 388 => 0x24 },
	'afstatuslower-right' => { 387 => 0x1e, 390 => 0x4a },
	'afstatuslower-righthorizontal' => { 388 => 0x32 },
	'afstatuslower-rightvertical' => { 388 => 0x3a },
	'afstatuslowerfarleft' => { 388 => 0x8 },
	'afstatuslowerfarright' => { 388 => 0x30 },
	'afstatusmiddlehorizontal' => { 175 => 0xa, 391 => 0x23, 392 => 0x23 },
	'afstatusnearleft' => { 387 => 0xe, 388 => 0x1a },
	'afstatusnearright' => { 387 => 0xa, 388 => 0x16 },
	'afstatusright' => { 175 => 0x31, 387 => 0x1c, 390 => 0x48, 391 => 0x31, 392 => 0x31 },
	'afstatusrighthorizontal' => { 388 => 0x2e },
	'afstatusrightvertical' => { 388 => 0x38 },
	'afstatustop' => { 175 => 0xe, 390 => 0x40, 391 => 0x27, 392 => 0x27 },
	'afstatustop-left' => { 175 => 0x10, 391 => 0x29, 392 => 0x29 },
	'afstatustop-right' => { 175 => 0x4, 391 => 0x1d, 392 => 0x1d },
	'afstatustopassist-left' => { 390 => 0x3e },
	'afstatustopassist-right' => { 390 => 0x42 },
	'afstatustophorizontal' => { 387 => 0x8, 388 => 0x14 },
	'afstatustopvertical' => { 387 => 0x12, 388 => 0x1e },
	'afstatusupper-left' => { 387 => 0x0, 390 => 0x20 },
	'afstatusupper-lefthorizontal' => { 388 => 0x2 },
	'afstatusupper-leftvertical' => { 388 => 0xc },
	'afstatusupper-middle' => { 387 => 0x20, 388 => 0x20 },
	'afstatusupper-right' => { 387 => 0x1a, 390 => 0x46 },
	'afstatusupper-righthorizontal' => { 388 => 0x2a },
	'afstatusupper-rightvertical' => { 388 => 0x36 },
	'afstatusupperfarleft' => { 388 => 0x0 },
	'afstatusupperfarright' => { 388 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 406 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 386 => 0x2 },
	'afwithshutter' => { 393 => 0x2a },
	'aggregateissuenumber' => { 478 => 'aggregateIssueNumber' },
	'aggregationtype' => { 478 => 'aggregationType' },
	'agreement' => { 481 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 134 => 0xe4e },
	'aiservocontinuousshooting' => { 80 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 81 => 0x519 },
	'aiservoimagepriority' => { 81 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 81 => 0x51a },
	'aiservotrackingmethod' => { 81 => 0x504 },
	'aiservotrackingsensitivity' => { 80 => 0x14, 81 => 0x502 },
	'album' => { 358 => ['albm',"\xa9alb"], 360 => 'album', 366 => ['albm',"\xa9alb"], 488 => 'album' },
	'albumartist' => { 358 => 'aART', 366 => 'albr' },
	'albumtitleid' => { 358 => 'atID' },
	'alreadyapplied' => { 462 => 'AlreadyApplied', 464 => 'AlreadyApplied' },
	'alternatetitle' => { 478 => 'alternateTitle' },
	'alternatetitlea-lang' => { 478 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 478 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 478 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 190 => 0x6 },
	'alttapename' => { 488 => 'altTapeName' },
	'alttimecode' => { 488 => 'altTimecode' },
	'alttimecodetimeformat' => { 488 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 488 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 488 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 369 => 0x5c },
	'ambientlight' => { 369 => 0x5e },
	'ambienttemperature' => { 116 => 0x9400, 367 => 0x14, 368 => 0x46, 369 => 0x50, 429 => 0x4, 469 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 367 => 0x13, 368 => 0x44, 369 => 0x4e },
	'analogbalance' => { 116 => 0xc627 },
	'analogcaptureiso' => { 134 => 0x89e },
	'analogisotable' => { 134 => 0x89d },
	'androidversion' => { 360 => 'com.android.version' },
	'angleadj' => { 100 => 0x10003, 106 => 0x8b },
	'angleinforoll' => { 458 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 458 => 'AngleInfoYaw' },
	'anti-blur' => { 406 => 0xb04b },
	'antialiasstrength' => { 116 => 0xc632 },
	'aperturelock' => { 267 => '38.2', 269 => '38.2', 270 => '38.2', 279 => '38.2', 280 => '38.2' },
	'aperturemode' => { 366 => 'apmd' },
	'aperturerange' => { 81 => 0x10d },
	'apertureringuse' => { 322 => '1.4' },
	'aperturesetting' => { 179 => 0x7, 393 => 0x30, 394 => 0x29, 395 => 0x1 },
	'aperturevalue' => { 90 => 0x2, 116 => 0x9202, 288 => 0x1002, 350 => 0x401, 468 => 'ApertureValue' },
	'appinfo' => { 442 => 'AppInfo' },
	'appinfoapplication' => { 442 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 442 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 442 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 292 => 'AAPL:Keywords' },
	'applestoreaccount' => { 358 => 'apID' },
	'applestoreaccounttype' => { 358 => 'akID' },
	'applestorecatalogid' => { 358 => 'cnID' },
	'applestorecountry' => { 358 => 'sfID' },
	'applicationkeystring' => { 134 => 0x400 },
	'applicationnotes' => { 116 => 0x2bc, 311 => 0x2bc },
	'applicationrecordversion' => { 128 => 0x0 },
	'applyshootingmeteringmode' => { 81 => 0x10e },
	'approved' => { 470 => 'Approved' },
	'approvedby' => { 470 => 'ApprovedBy' },
	'approximatefnumber' => { 301 => 0x313, 308 => 0x3406 },
	'approximatefocusdistance' => { 459 => 'ApproximateFocusDistance' },
	'appversion' => { 472 => 'AppVersion' },
	'aps-csizecapture' => { 424 => 0x114, 425 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 100 => 0x20914 },
	'armidentifier' => { 129 => 0x78 },
	'armversion' => { 129 => 0x7a },
	'arranger' => { 366 => "\xa9arg" },
	'arrangerkeywords' => { 366 => "\xa9ark" },
	'artfilter' => { 283 => 0x529 },
	'artfiltereffect' => { 283 => 0x52f },
	'artist' => { 116 => 0x13b, 296 => 'Artist', 341 => 0x22e, 358 => "\xa9ART", 360 => 'artist', 366 => "\xa9ART", 484 => 'Artist', 488 => 'artist' },
	'artmode' => { 110 => 0x301b },
	'artmodeparameters' => { 110 => 0x310b },
	'artwork' => { 360 => 'artwork' },
	'artworkcircadatecreated' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 474 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 474 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 287 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 287 => 0x1112, 341 => 0x80, 393 => 0x55, 394 => 0x55, 395 => 0xa },
	'assetid' => { 452 => 'AssetID' },
	'asshoticcprofile' => { 116 => 0xc68f },
	'asshotneutral' => { 116 => 0xc628 },
	'asshotpreprofilematrix' => { 116 => 0xc690 },
	'asshotprofilename' => { 116 => 0xc6f6 },
	'asshotwhitexy' => { 116 => 0xc629 },
	'assignbktbutton' => { 266 => '4.2', 267 => '16.1', 269 => '16.1', 270 => '16.1', 279 => '16.1', 280 => '16.1' },
	'assignfuncbutton' => { 81 => 0x70b },
	'assignmb-d17af-onbutton' => { 270 => '79.1' },
	'assignmb-d17funcbutton' => { 270 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 270 => '68.1' },
	'assignmb-d18af-onbutton' => { 280 => '79.1' },
	'assignmb-d18funcbutton' => { 280 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 280 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 269 => '75.1', 270 => '75.1', 280 => '75.1' },
	'assignmoviefunc2button' => { 269 => '82.1', 270 => '82.1', 280 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 269 => '75.2', 270 => '75.2', 280 => '75.2' },
	'assignmovierecordbutton' => { 267 => '43.2', 279 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 269 => '45.1', 270 => '45.1', 280 => '45.1' },
	'assignmoviesubselector' => { 269 => '74.1', 270 => '74.1', 280 => '74.1' },
	'assignmoviesubselectorplusdials' => { 269 => '76.1', 270 => '76.1', 280 => '76.1' },
	'assignremotefnbutton' => { 267 => '54.1', 279 => '51.1' },
	'assistbuttonfunction' => { 79 => 0xd },
	'atcaptureusercrop' => { 134 => 0x943 },
	'attributionname' => { 460 => 'attributionName' },
	'attributionurl' => { 460 => 'attributionURL' },
	'audio' => { 306 => 0x20 },
	'audiobitrate' => { 64 => 0x6c, 474 => 'audioBitRate' },
	'audiobitratemode' => { 474 => 'audioBitRateMode' },
	'audiobitspersample' => { 474 => 'audioBitsPerSample' },
	'audiochannelcount' => { 474 => 'audioChannelCount' },
	'audiochannels' => { 64 => 0x70 },
	'audiochanneltype' => { 488 => 'audioChannelType' },
	'audiocompression' => { 81 => 0x816, 151 => 'Compression' },
	'audiocompressor' => { 488 => 'audioCompressor' },
	'audiodata' => { 444 => 'Data' },
	'audioduration' => { 128 => 0x99 },
	'audiogain' => { 360 => 'player.movie.audio.gain' },
	'audiomimetype' => { 444 => 'Mime' },
	'audiomoddate' => { 488 => 'audioModDate' },
	'audiooutcue' => { 128 => 0x9a },
	'audiosamplerate' => { 64 => 0x6e, 488 => 'audioSampleRate' },
	'audiosampletype' => { 488 => 'audioSampleType' },
	'audiosamplingrate' => { 128 => 0x97 },
	'audiosamplingresolution' => { 128 => 0x98 },
	'audiotype' => { 128 => 0x96 },
	'author' => { 153 => 'Author', 292 => 'Author', 296 => 'Author', 357 => 'Author', 358 => ['auth',"\xa9aut"], 360 => 'author', 366 => 'auth', 457 => 'author', 475 => 'Author', 486 => 'Author' },
	'authorsposition' => { 476 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 81 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 332 => '0.1' },
	'autobracket' => { 383 => 0x19 },
	'autobracketing' => { 124 => 0x1100, 341 => 0x18, 373 => 0x1007 },
	'autobracketingmode' => { 278 => '12.3' },
	'autobracketingset' => { 278 => '12.1' },
	'autobracketmodem' => { 266 => '21.2', 267 => '13.3', 269 => '13.2', 270 => '13.2', 275 => '26.2', 279 => '13.3', 280 => '13.2' },
	'autobracketorder' => { 179 => 0x43, 266 => '21.3', 267 => '13.2', 269 => '13.1', 270 => '13.1', 275 => '26.3', 276 => '12.2', 277 => '2.2', 278 => '12.2', 279 => '13.2', 280 => '13.1', 281 => '13.2' },
	'autobracketset' => { 266 => '21.1', 267 => '13.1', 271 => '11.1', 272 => '12.1', 273 => '12.1', 275 => '26.1', 276 => '12.1', 277 => '2.1', 279 => '13.1', 281 => '13.1' },
	'autobrightness' => { 462 => 'AutoBrightness', 464 => 'AutoBrightness' },
	'autocontrast' => { 462 => 'AutoContrast', 464 => 'AutoContrast' },
	'autodistortioncontrol' => { 200 => 0x4 },
	'autodynamicrange' => { 124 => 0x140b },
	'autoexposure' => { 462 => 'AutoExposure', 464 => 'AutoExposure' },
	'autoexposurebracketing' => { 74 => 0x10 },
	'autoflashisosensitivity' => { 269 => '38.5', 270 => '38.5', 280 => '38.5' },
	'autofocus' => { 286 => 0x209 },
	'autofp' => { 277 => '7.3', 281 => '31.4' },
	'autoiso' => { 74 => 0x1, 110 => 0x3008, 268 => '1.1', 277 => '1.1' },
	'autoisomax' => { 268 => '1.2', 277 => '1.2' },
	'autoisominshutterspeed' => { 268 => '1.3', 277 => '1.3' },
	'autolateralca' => { 462 => 'AutoLateralCA', 464 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 60 => 0x2, 81 => 0x204, 100 => 0x20500, 106 => 0x6f },
	'autolightingoptimizeron' => { 100 => '0x20500.0', 106 => 0x6e },
	'autoportraitframed' => { 406 => 0x2016 },
	'autoredeye' => { 259 => 0xfe28a44f },
	'autorotate' => { 74 => 0x1b },
	'autoshadows' => { 462 => 'AutoShadows', 464 => 'AutoShadows' },
	'autotone' => { 462 => 'AutoTone', 464 => 'AutoTone' },
	'autowhiteversion' => { 462 => 'AutoWhiteVersion', 464 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 219 => 0x82 },
	'avaperturesetting' => { 322 => 0x13 },
	'averageblacklevel' => { 43 => 0xe7, 45 => 0xfb, 46 => 0x114, 47 => 0x146 },
	'averagelv' => { 182 => 0x38 },
	'avsettingwithoutlens' => { 81 => 0x707 },
	'azimuth' => { 161 => 'Azimuth' },
	'babyage' => { 306 => [0x8010,0x33] },
	'babyname' => { 306 => 0x66 },
	'backgroundalpha' => { 483 => 'bgalpha' },
	'balance' => { 360 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 322 => 0x15 },
	'baseiso' => { 74 => 0x2, 94 => 0x101c, 134 => 0x903, 308 => 0x312a, 435 => 0x6 },
	'baseisodaylight' => { 134 => 0x910 },
	'baseisoflash' => { 134 => 0x913 },
	'baseisofluorescent' => { 134 => 0x912 },
	'baseisotungsten' => { 134 => 0x911 },
	'baselineexposure' => { 116 => 0xc62a },
	'baselineexposureoffset' => { 116 => 0xc7a5 },
	'baselinenoise' => { 116 => 0xc62b },
	'baselinesharpness' => { 116 => 0xc62c },
	'baseurl' => { 486 => 'BaseURL' },
	'bass' => { 360 => 'player.movie.audio.bass' },
	'batterylevel' => { 393 => 0x51, 397 => 0xc, 398 => 0x4, 399 => 0x4, 436 => 0x7 },
	'batterylevelgrip1' => { 436 => 0x6 },
	'batterylevelgrip2' => { 436 => 0x8 },
	'batteryorder' => { 266 => '12.5', 275 => '13.2', 276 => '2.1', 279 => '3.1' },
	'batterystate' => { 179 => 0x60, 393 => 0x50, 399 => 0x14 },
	'batterytemperature' => { 397 => 0x1, 399 => 0x2, 436 => 0x5 },
	'batterytype' => { 61 => 0x38, 369 => 0x66 },
	'batteryunknown' => { 397 => 0x2, 399 => 0x0 },
	'batteryvoltage' => { 134 => 0x408, 367 => 0x2a, 368 => 0x49, 369 => 0x62, 397 => 0x8 },
	'batteryvoltage1' => { 399 => 0x6 },
	'batteryvoltage2' => { 399 => 0x8 },
	'batteryvoltageavg' => { 369 => 0x64 },
	'bayergreensplit' => { 116 => 0xc62d },
	'bayerpattern' => { 133 => 0xf902, 183 => 0x17 },
	'beatsperminute' => { 358 => 'tmpo' },
	'beatspliceparams' => { 488 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 488 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 488 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 488 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 488 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 488 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 266 => '13.1', 267 => '5.4', 268 => '0.1', 271 => '2.1', 272 => '3.1', 273 => '3.1', 275 => '10.1', 277 => '0.1', 279 => '5.5', 281 => '4.1' },
	'beeppitch' => { 276 => '3.1' },
	'beepvolume' => { 276 => '4.5' },
	'bestqualityscale' => { 116 => 0xc65c },
	'bestshotmode' => { 110 => 0x3007 },
	'bitdepth' => { 158 => 'BitDepth', 183 => 0x11, 227 => 0x41 },
	'bitspercomponent' => { 130 => 0x87 },
	'bitspersample' => { 116 => 0x102, 311 => 0xa, 484 => 'BitsPerSample' },
	'blackacquirerows' => { 134 => 0x18ba },
	'blacklevel' => { 116 => 0xc61a, 198 => 0x20, 219 => 0x3d, 288 => [0x401,0x1012], 350 => 0x21d },
	'blacklevel2' => { 287 => 0x600, 291 => 0x600 },
	'blacklevelblue' => { 311 => 0x1e },
	'blacklevelbottom' => { 134 => 0x3f0 },
	'blackleveldata' => { 350 => 0x223 },
	'blackleveldeltah' => { 116 => 0xc61b },
	'blackleveldeltav' => { 116 => 0xc61c },
	'blacklevelgreen' => { 311 => 0x1d },
	'blacklevelred' => { 311 => 0x1c },
	'blacklevelrepeatdim' => { 116 => 0xc619 },
	'blacklevelrough' => { 134 => 0x40e },
	'blacklevelroughafter' => { 134 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 134 => 0x3ef },
	'blackpoint' => { 341 => 0x200 },
	'blacks2012' => { 462 => 'Blacks2012', 464 => 'Blacks2012' },
	'blacksadj' => { 439 => 0x9018 },
	'bleachbypasstoning' => { 341 => 0x7f },
	'blockshotafresponse' => { 269 => '1.5', 270 => '1.5', 280 => '1.5' },
	'blogtitle' => { 478 => 'blogTitle' },
	'blogurl' => { 478 => 'blogURL' },
	'bluebalance' => { 288 => 0x1018, 311 => 0x12, 341 => 0x1b },
	'bluecurvelimits' => { 105 => 0x1fe },
	'bluecurvepoints' => { 104 => 0x79, 105 => 0x1d4 },
	'bluehsl' => { 100 => 0x20915 },
	'bluehue' => { 462 => 'BlueHue', 464 => 'BlueHue' },
	'bluesaturation' => { 462 => 'BlueSaturation', 464 => 'BlueSaturation' },
	'bluratinfinity' => { 448 => 'BlurAtInfinity' },
	'blurcontrol' => { 341 => 0x82 },
	'blurwarning' => { 124 => 0x1300 },
	'bodybatteryadload' => { 320 => 0x3 },
	'bodybatteryadnoload' => { 320 => 0x2 },
	'bodybatterystate' => { 320 => '1.1' },
	'bodybatteryvoltage1' => { 320 => 0x2 },
	'bodybatteryvoltage2' => { 320 => 0x4 },
	'bodybatteryvoltage3' => { 320 => 0x6 },
	'bodybatteryvoltage4' => { 320 => 0x8 },
	'bodyfirmware' => { 374 => 0x0 },
	'bodyfirmwareversion' => { 284 => 0x104, 285 => 0x100, 288 => 0x104 },
	'bodyserialnumber' => { 374 => 0x10 },
	'bookedition' => { 478 => 'bookEdition' },
	'bootloaderversion' => { 368 => 0x26 },
	'bracketmode' => { 55 => 0x3 },
	'bracketsequence' => { 110 => 0x301d },
	'bracketsettings' => { 306 => 0x45 },
	'bracketshotnumber' => { 55 => 0x5, 322 => 0x9, 404 => 0x2b },
	'bracketshotnumber2' => { 404 => 0x2d },
	'bracketstep' => { 176 => 0xe },
	'bracketvalue' => { 55 => 0x4 },
	'brightness' => { 116 => 0xfe53, 152 => 'Brightness', 172 => 'Brightness', 176 => 0x2c, 221 => 0x34, 222 => 0x39, 223 => 0x41, 360 => 'player.movie.visual.brightness', 367 => 0x25, 369 => 0x54, 393 => 0x22, 406 => 0x2007, 462 => 'Brightness', 464 => 'Brightness' },
	'brightnessadj' => { 105 => 0x114, 252 => 0x0, 262 => 0x2d, 439 => 0x8018 },
	'brightnessvalue' => { 116 => 0x9203, 182 => [0x691,0x49c3], 288 => 0x1003, 411 => 0x1e, 414 => 0x1140, 415 => 0x1140, 416 => 0x111c, 417 => 0x1198, 418 => 0x1174, 419 => 0x102c, 420 => 0x224, 421 => 0x224, 422 => 0x219, 468 => 'BrightnessValue' },
	'buildnumber' => { 186 => 0x5500 },
	'bulbduration' => { 74 => 0x18 },
	'burstcount' => { 134 => 0x40d },
	'burstid' => { 445 => 'BurstID' },
	'burstmode' => { 136 => 0xa, 306 => 0x2a },
	'burstmode2' => { 136 => 0x18 },
	'burstprimary' => { 445 => 'BurstPrimary' },
	'burstshot' => { 383 => 0x34 },
	'burstspeed' => { 306 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 81 => 0x70a },
	'bwadjustment' => { 124 => 0x1049 },
	'bwfilter' => { 176 => 0x2a, 184 => 0x39 },
	'bwmode' => { 288 => 0x203 },
	'by-line' => { 128 => 0x50 },
	'by-linetitle' => { 128 => 0x55 },
	'bytecount' => { 478 => 'byteCount' },
	'c14configuration' => { 134 => 0x1964 },
	'cacheversion' => { 116 => 0xc7aa },
	'calibratedfocallength' => { 113 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 113 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 113 => 'CalibratedOpticalCenterY' },
	'calibration' => { 383 => [0x24,0x30] },
	'calibrationhistory' => { 134 => 0x9c9 },
	'calibrationilluminant1' => { 116 => 0xc65a },
	'calibrationilluminant2' => { 116 => 0xc65b },
	'calibrationversion' => { 134 => 0x9c6 },
	'callforimage' => { 452 => 'CallForImage' },
	'camera' => { 442 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 366 => 'angl', 488 => 'cameraAngle' },
	'cameraappinfo' => { 442 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 442 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 442 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 442 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 446 => 'CameraBurstID' },
	'cameracalibration' => { 383 => 0x11f },
	'cameracalibration1' => { 116 => 0xc623 },
	'cameracalibration2' => { 116 => 0xc624 },
	'cameracalibrationsig' => { 116 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 442 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 442 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 442 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 442 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 442 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 442 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 442 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 442 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 442 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 442 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 442 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 442 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 360 => 'direction.facing' },
	'camerae-mountversion' => { 438 => 0xb },
	'cameraelevationangle' => { 116 => 0x9405, 469 => 'CameraElevationAngle' },
	'camerafilename' => { 452 => 'CameraFilename' },
	'cameraid' => { 288 => 0x209, 366 => 'cmid', 382 => 0x209 },
	'cameraidentifier' => { 360 => 'camera.identifier' },
	'cameraimage' => { 442 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 442 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 442 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 442 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 442 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 442 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 442 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 442 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 442 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 442 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 442 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 442 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 442 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 442 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 116 => 0xc7a1, 488 => 'cameraLabel' },
	'cameralightestimate' => { 442 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 442 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 442 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 442 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 442 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 452 => 'CameraMakeModel' },
	'cameramodel' => { 350 => 0x410, 488 => 'cameraModel' },
	'cameramodelid' => { 172 => 'CameraModelID' },
	'cameramotion' => { 360 => 'direction.motion' },
	'cameramove' => { 488 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => 0x36, 24 => 0x7d, 25 => 0x83, 26 => 0x84, 28 => 0x35, 29 => 0x96, 306 => 0x8f, 345 => 0x1, 350 => 0x100, 399 => [0x16,0x18], 426 => 0x28, 427 => 0x24, 428 => 0x29 },
	'cameraowner' => { 137 => 0xc353 },
	'cameraparameters' => { 288 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 112 => 0x9, 366 => "\xa9gpt" },
	'camerapointcloud' => { 442 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 442 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 442 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 442 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 442 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 442 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 442 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 442 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 442 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 442 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 442 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 442 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 442 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 462 => 'CameraProfile', 464 => 'CameraProfile' },
	'cameraprofiledigest' => { 462 => 'CameraProfileDigest', 464 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 106 => 0xe1 },
	'camerarawcontrast' => { 106 => 0xe3 },
	'camerarawhighlightpoint' => { 106 => 0xe6 },
	'camerarawlinear' => { 106 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 106 => 0xe8 },
	'camerarawoutputshadowpoint' => { 106 => 0xe9 },
	'camerarawsaturation' => { 106 => 0xe2 },
	'camerarawshadowpoint' => { 106 => 0xe7 },
	'camerarawsharpness' => { 106 => 0xe5 },
	'cameraroll' => { 112 => 0xb, 366 => "\xa9grl" },
	'cameras' => { 442 => 'Cameras' },
	'cameraserialnumber' => { 116 => 0xc62f, 174 => 'CameraSerialNumber', 452 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 283 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 74 => 0xc, 134 => 0x406, 287 => 0x1306, 301 => 0x320, 308 => 0x3402, 341 => 0x47, 380 => 0x43, 430 => 0x5 },
	'cameratemperature4' => { 346 => 0x14 },
	'cameratemperature5' => { 346 => 0x16 },
	'cameratemperaturerangemax' => { 118 => 0x5 },
	'cameratemperaturerangemin' => { 118 => 0x6 },
	'cameratrait' => { 442 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 74 => 0x1a, 288 => 0x207 },
	'cameratype2' => { 284 => 0x100 },
	'cameravendorinfo' => { 442 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 442 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 442 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 442 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 112 => 0xa, 366 => "\xa9gyw" },
	'camreverse' => { 113 => 'CamReverse' },
	'canondr4' => { 117 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 94 => 0x805 },
	'canonfilelength' => { 61 => 0xe },
	'canonfirmwareversion' => { 61 => 0x7, 94 => 0x80b },
	'canonflashinfo' => { 94 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 61 => 0x6, 94 => 0x815 },
	'canonmodelid' => { 61 => 0x10, 94 => 0x1834 },
	'canonvrd' => { 117 => 'CanonVRD' },
	'caption' => { 457 => 'caption' },
	'caption-abstract' => { 128 => 0x78 },
	'captionsauthornames' => { 467 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 467 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 476 => 'CaptionWriter' },
	'captureframerate' => { 110 => 0x4001 },
	'captureheightnormal' => { 134 => 0x1839 },
	'capturelook' => { 134 => 0xc48 },
	'capturemode' => { 360 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 450 => 'CaptureSoftware' },
	'capturewidthnormal' => { 134 => 0x1838 },
	'capturewidthtest' => { 134 => 0x1842 },
	'cardshutterlock' => { 179 => 0x49 },
	'casioimagesize' => { 110 => 0x9 },
	'catalogsets' => { 128 => 0xff, 443 => 'CatalogSets', 455 => 'CatalogSets' },
	'categories' => { 61 => 0x23, 457 => 'categories' },
	'category' => { 128 => 0xf, 282 => 0x30, 358 => 'catg', 476 => 'Category' },
	'cbcrgain' => { 380 => 0xa036 },
	'cbcrgaindefault' => { 380 => 0xa035 },
	'cbcrmatrix' => { 380 => 0xa034 },
	'cbcrmatrixdefault' => { 380 => 0xa033 },
	'ccdboardversion' => { 301 => 0x331 },
	'ccdscanmode' => { 288 => 0x1039 },
	'ccdsensitivity' => { 249 => 0x6 },
	'ccdversion' => { 301 => 0x330 },
	'cellglobalid' => { 461 => 'cgi' },
	'celllength' => { 116 => 0x109 },
	'cellr' => { 461 => 'r' },
	'celltowerid' => { 461 => 'cellid' },
	'cellwidth' => { 116 => 0x108 },
	'centerafarea' => { 277 => '15.1' },
	'centerfocuspoint' => { 281 => '2.2' },
	'centerpixel' => { 134 => 0x40c },
	'centerweightedareasize' => { 266 => '7.1', 267 => '8.1', 269 => '8.1', 270 => '8.1', 274 => '7.1', 275 => '5.1', 276 => '7.1', 277 => '6.3', 279 => '8.1', 280 => '8.1', 281 => '8.1' },
	'certificate' => { 492 => 'Certificate' },
	'cfainterpolationalgorithm' => { 134 => 0xe60 },
	'cfainterpolationmetric' => { 134 => 0xe61 },
	'cfaoffsetcols' => { 134 => 0xc71 },
	'cfaoffsetrows' => { 134 => 0xc6f },
	'cfapattern' => { 116 => 0xa302, 311 => 0x9, 468 => 'CFAPattern' },
	'cfapattern2' => { 116 => 0x828e },
	'cfapatterncolumns' => { 468 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 468 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 468 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 116 => 0x828d },
	'cfazipperfixthreshold' => { 134 => 0xe62 },
	'channel' => { 478 => 'channel' },
	'channela-lang' => { 478 => [\'channel','channelA-lang'] },
	'channelchannel' => { 478 => [\'channel','channelChannel'] },
	'channels' => { 151 => 'Channels' },
	'channelsubchannel1' => { 478 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 478 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 478 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 478 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 366 => 'chpl' },
	'checkmark' => { 100 => 0x10101, 105 => 0x26a },
	'checkmark2' => { 106 => 0x8e },
	'childfontfiles' => { 493 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 266 => '10.3', 267 => '11.2' },
	'chromablurradius' => { 116 => 0xc631 },
	'chromanoisecolorspace' => { 134 => 0xe6d },
	'chromanoiseedgemapthresh' => { 134 => 0xe6c },
	'chromanoisehighfthresh' => { 134 => 0xe6a },
	'chromanoiselowfthresh' => { 134 => 0xe6b },
	'chromaticaberration' => { 100 => 0x20703, 106 => 0x66, 380 => 0xa051 },
	'chromaticaberrationb' => { 462 => 'ChromaticAberrationB', 464 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 100 => 0x20708, 106 => 0x6b },
	'chromaticaberrationcorr' => { 76 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 116 => 0x7034, 331 => 0x1, 439 => 0x900d },
	'chromaticaberrationcorrparams' => { 116 => 0x7035, 434 => 0x66a, 435 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 100 => '0x20703.0', 106 => 0x62 },
	'chromaticaberrationr' => { 462 => 'ChromaticAberrationR', 464 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 100 => 0x20707, 106 => 0x6a },
	'chromaticaberrationsetting' => { 77 => 0x6 },
	'chrominancenoisereduction' => { 100 => 0x20601, 106 => 0x5e, 383 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 106 => 0x60 },
	'circadatecreated' => { 474 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 462 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 464 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 462 => 'CircularGradientBasedCorrections', 464 => 'CircularGradientBasedCorrections' },
	'city' => { 128 => 0x5a, 157 => 'City', 306 => 0x6d, 476 => 'City' },
	'city2' => { 306 => 0x80 },
	'clarity' => { 222 => 0x35, 223 => 0x3d, 462 => 'Clarity', 464 => 'Clarity' },
	'clarity2012' => { 462 => 'Clarity2012', 464 => 'Clarity2012' },
	'claritycontrol' => { 341 => 0x96 },
	'classifystate' => { 128 => 0xe1 },
	'clearretouch' => { 306 => 0x7c },
	'clearretouchvalue' => { 306 => 0xa3 },
	'client' => { 488 => 'client' },
	'clientname' => { 470 => 'ClientName' },
	'clipfilename' => { 366 => 'clfn' },
	'clipid' => { 366 => 'clid' },
	'clmodeshootingspeed' => { 266 => '10.2', 267 => '11.3', 269 => '11.2', 270 => '11.2', 275 => '11.2', 276 => '10.2', 279 => '11.2', 280 => '11.2', 281 => '11.1' },
	'cmcontrast' => { 291 => 0x2022 },
	'cmexposurecompensation' => { 291 => 0x2000 },
	'cmhue' => { 291 => 0x2021 },
	'cmsaturation' => { 291 => 0x2020 },
	'cmsharpness' => { 291 => 0x2023 },
	'cmwhitebalance' => { 291 => 0x2001 },
	'cmwhitebalancecomp' => { 291 => 0x2002 },
	'cmwhitebalancegraypoint' => { 291 => 0x2010 },
	'codec' => { 165 => 'Codec' },
	'codedcharacterset' => { 129 => 0x5a },
	'codeversion' => { 366 => 'cver' },
	'collection' => { 296 => 'Collection' },
	'collectionname' => { 166 => [\'Collections','CollectionsCollectionName'], 366 => 'coll' },
	'collections' => { 166 => 'Collections', 457 => 'collections' },
	'collectionuri' => { 166 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 360 => 'player.movie.visual.color', 477 => 'color' },
	'coloraberrationcontrol' => { 259 => 0xc89224b },
	'coloradjustment' => { 383 => 0x14 },
	'coloradjustmentmode' => { 382 => 0x210 },
	'coloranta' => { 493 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 493 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 493 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 493 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 493 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 493 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 493 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 493 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 493 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 493 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 493 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 493 => 'Colorants' },
	'colorantswatchname' => { 493 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 493 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 493 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 493 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 152 => 'ColorBalance' },
	'colorbalanceadj' => { 259 => 0x76a43202 },
	'colorbalanceblue' => { 176 => 0x1e },
	'colorbalancegreen' => { 176 => 0x1d },
	'colorbalancered' => { 176 => 0x1c },
	'colorbalanceversion' => { 197 => 0x4, 198 => 0x4, 199 => 0x0 },
	'colorblur' => { 106 => 0x65 },
	'colorbluron' => { 100 => 0x20704 },
	'colorbooster' => { 259 => 0x5f0e7d23 },
	'colorboostlevel' => { 253 => 0x1 },
	'colorboosttype' => { 253 => 0x0 },
	'colorchromeeffect' => { 124 => 0x1048 },
	'colorchromefxblue' => { 124 => 0x104e },
	'colorclass' => { 352 => 0xde, 353 => 'ColorClass' },
	'colorcompensationfilter' => { 179 => [0x3a,0x5f], 181 => 0x111, 406 => 0xb022 },
	'colorcompensationfiltercustom' => { 393 => 0xd, 394 => 0xc },
	'colorcompensationfilterset' => { 393 => 0x8, 394 => 0x7, 395 => 0x18, 411 => 0xf },
	'colorcontrol' => { 288 => 0x102b },
	'colorcorrection' => { 439 => 0x8015 },
	'colorcreatoreffect' => { 283 => 0x532 },
	'colordataversion' => { 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0 },
	'coloreffect' => { 306 => 0x28 },
	'colorfilter' => { 109 => 0x17, 110 => 0x3017, 176 => 0x29, 184 => [0x38,0x4d,0x4f], 348 => 0x17 },
	'colorgain' => { 227 => 0x51 },
	'colorhue' => { 100 => 0x20900, 219 => 0x8d },
	'colorimetricreference' => { 116 => 0xc6bf },
	'colorlabel' => { 467 => 'ColorLabel' },
	'colormatrix' => { 287 => 0x200, 288 => 0x1011, 380 => 0xa030 },
	'colormatrix1' => { 116 => 0xc621, 350 => 0x106 },
	'colormatrix2' => { 116 => 0xc622, 291 => 0x200, 350 => 0x226 },
	'colormatrixa' => { 341 => 0x203 },
	'colormatrixadobergb' => { 380 => 0xa032 },
	'colormatrixb' => { 341 => 0x204 },
	'colormatrixnumber' => { 288 => 0x1019 },
	'colormatrixsrgb' => { 380 => 0xa031 },
	'colormode' => { 110 => 0x3015, 124 => 0x1210, 136 => 0x66, 176 => 0x28, 179 => 0x16, 181 => 0x101, 182 => 0x36, 184 => 0x7, 219 => 0x3, 249 => 0x4, 306 => 0x32, 383 => 0x2c, 406 => 0xb029, 476 => 'ColorMode' },
	'colormoirereduction' => { 100 => 0x20670, 260 => 0x15 },
	'colormoirereductionmode' => { 260 => 0x5 },
	'colormoirereductionon' => { 100 => '0x20670.0' },
	'colornoisereduction' => { 439 => 0x8029, 462 => 'ColorNoiseReduction', 464 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 462 => 'ColorNoiseReductionDetail', 464 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 260 => 0x18 },
	'colornoisereductionsharpness' => { 260 => 0x1c },
	'colornoisereductionsmoothness' => { 462 => 'ColorNoiseReductionSmoothness', 464 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 120 => 0x2 },
	'colorprofile' => { 176 => 0x33 },
	'colorprofilesettings' => { 283 => 0x539 },
	'colorrepresentation' => { 130 => 0x3c },
	'colorsaturationadj' => { 100 => 0x20305 },
	'colorsequence' => { 130 => 0x41 },
	'colorspace' => { 49 => 0x3, 61 => 0xb4, 94 => 0x10b4, 116 => 0xa001, 158 => 'ColorSpace', 177 => 0x2f, 178 => 0x25, 179 => 0x17, 219 => 0x1e, 283 => 0x507, 341 => 0x37, 380 => 0xa011, 383 => 0xb, 393 => 0x1b, 394 => 0x83, 395 => 0xe, 411 => 0x6, 468 => 'ColorSpace' },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x26, 42 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x43, 48 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x1c, 42 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x48, 48 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0x35, 42 => 0x5c, 45 => 0x75, 46 => 0x8e, 47 => 0x93, 48 => 0x96, 341 => 0x55 },
	'colortempcustom' => { 42 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x2b, 42 => 0x52, 45 => 0x6b, 46 => 0x84, 47 => 0x89, 48 => 0x8c, 341 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 61 => 0xae, 71 => 0x9, 94 => 0x10ae, 124 => 0x1005, 134 => 0x846, 152 => 'ColorTemperature', 177 => [0x6e,0x49], 178 => 0x3f, 179 => [0x39,0x5e], 181 => 0x10b, 184 => [0x3c,0x4c,0x4e], 301 => 0x321, 341 => 0x50, 373 => 0x1308, 406 => 0xb021, 462 => 'Temperature', 464 => 'Temperature' },
	'colortemperatureadj' => { 439 => 0x8013 },
	'colortemperatureauto' => { 219 => 0x4f },
	'colortemperaturebg' => { 288 => 0x1013 },
	'colortemperaturecustom' => { 393 => 0xc, 394 => 0xb },
	'colortemperaturerg' => { 288 => 0x1014 },
	'colortemperatureset' => { 393 => 0x7, 394 => 0x6 },
	'colortemperaturesetting' => { 179 => 0x25, 395 => 0x17, 411 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0x49, 42 => 0x70, 45 => 0x89, 46 => 0xa2, 47 => 0xa7, 48 => 0xaa, 341 => 0x5a },
	'colortempflashdata' => { 42 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0x3f, 42 => 0x66, 45 => 0x7f, 46 => 0x98, 47 => 0x9d, 48 => 0xa0 },
	'colortempfluorescentd' => { 341 => 0x57 },
	'colortempfluorescentn' => { 341 => 0x58 },
	'colortempfluorescentw' => { 341 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0x44, 42 => 0x6b, 45 => 0x84, 46 => 0x9d, 47 => 0xa2, 48 => 0xa5, 306 => 0x44, 373 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 42 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x4d, 48 => 0x55 },
	'colortemppc1' => { 41 => 0x94, 42 => 0x75 },
	'colortemppc2' => { 41 => 0x99, 42 => 0x7a },
	'colortemppc3' => { 41 => 0x9e, 42 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x30, 42 => 0x57, 45 => 0x70, 46 => 0x89, 47 => 0x8e, 48 => 0x91, 341 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0x3a, 42 => 0x61, 45 => 0x7a, 46 => 0x93, 47 => 0x98, 48 => 0x9b, 341 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x21, 45 => 0x52, 46 => 0x52, 47 => 0x52, 48 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x76, 45 => 0xa2, 46 => 0x7f, 47 => 0x7f, 48 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0x7b, 45 => 0xa7, 46 => 0xa7, 47 => 0x84, 48 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0x80, 45 => 0xac, 46 => 0xac, 47 => 0xac, 48 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0x85, 45 => 0xb1, 46 => 0xb1, 47 => 0xb1, 48 => 0xb9 },
	'colortempunknown14' => { 41 => 0x8a, 45 => 0xb6, 46 => 0xb6, 47 => 0xb6, 48 => 0xbe },
	'colortempunknown15' => { 41 => 0x8f, 45 => 0xbb, 46 => 0xbb, 47 => 0xbb, 48 => 0xc3 },
	'colortempunknown16' => { 41 => 0xa3, 46 => 0xc0, 47 => 0xc0, 48 => 0xc8 },
	'colortempunknown17' => { 46 => 0xc5, 47 => 0xc5, 48 => 0xcd },
	'colortempunknown18' => { 46 => 0xca, 47 => 0xca, 48 => 0xd2 },
	'colortempunknown19' => { 46 => 0xcf, 47 => 0xcf, 48 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x4e, 45 => 0x57, 46 => 0x57, 47 => 0x57, 48 => 0x5f },
	'colortempunknown20' => { 46 => 0xd4, 47 => 0xd4, 48 => 0xdc },
	'colortempunknown21' => { 47 => 0xd9, 48 => 0xe1 },
	'colortempunknown22' => { 47 => 0xde, 48 => 0xe6 },
	'colortempunknown23' => { 47 => 0xe3, 48 => 0xeb },
	'colortempunknown24' => { 47 => 0xe8, 48 => 0xf0 },
	'colortempunknown25' => { 47 => 0xed, 48 => 0xf5 },
	'colortempunknown26' => { 47 => 0xf2, 48 => 0xfa },
	'colortempunknown27' => { 47 => 0xf7, 48 => 0xff },
	'colortempunknown28' => { 47 => 0xfc, 48 => 0x104 },
	'colortempunknown29' => { 47 => 0x101, 48 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x53, 45 => 0x5c, 46 => 0x5c, 47 => 0x5c, 48 => 0x64 },
	'colortempunknown30' => { 47 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x58, 45 => 0x61, 46 => 0x61, 47 => 0x61, 48 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x5d, 45 => 0x66, 46 => 0x66, 47 => 0x66, 48 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x62, 45 => 0x8e, 46 => 0x6b, 47 => 0x6b, 48 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x67, 45 => 0x93, 46 => 0x70, 47 => 0x70, 48 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x6c, 45 => 0x98, 46 => 0x75, 47 => 0x75, 48 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x71, 45 => 0x9d, 46 => 0x7a, 47 => 0x7a, 48 => 0x82 },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 49 => 0x2 },
	'colortoneadj' => { 100 => 0x20304, 105 => 0x11e },
	'colortoneauto' => { 68 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 67 => 0x6c, 68 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 67 => 0x3c, 68 => 0x3c },
	'colortonemonochrome' => { 67 => 0x84, 68 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 67 => 0x54, 68 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 67 => 0x24, 68 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 67 => 0xc, 68 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 67 => 0x9c, 68 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 67 => 0xb4, 68 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 67 => 0xcc, 68 => 0xe4 },
	'comlenblksize' => { 134 => 0xfde8 },
	'commanddials' => { 277 => '5.1' },
	'commanddialsaperturesetting' => { 266 => '17.3', 267 => '18.3', 269 => '18.3', 270 => '18.3', 275 => '33.3', 276 => '17.3', 279 => '18.3', 280 => '18.3' },
	'commanddialschangemainsub' => { 266 => '17.2', 267 => '18.1', 269 => '18.1', 270 => '18.1', 275 => '33.2', 276 => '17.2', 279 => '18.1', 280 => '18.1' },
	'commanddialsmenuandplayback' => { 266 => '17.4', 267 => '18.2', 269 => '18.2', 270 => '18.2', 275 => '33.4', 276 => '17.4', 279 => '18.2', 280 => '18.2' },
	'commanddialsreverserotation' => { 266 => '17.1', 267 => '6.4', 269 => '6.2', 270 => '6.2', 271 => '16.2', 272 => '17.2', 275 => '33.1', 276 => '17.1', 279 => '6.2', 280 => '6.2', 281 => '18.1' },
	'commanderchannel' => { 277 => '10.2', 278 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 277 => '13.1', 278 => '31.1' },
	'commandergroupa_ttlcomp' => { 281 => '32.1' },
	'commandergroupamanualoutput' => { 277 => '13.2', 278 => '28.2' },
	'commandergroupamode' => { 277 => '11.2', 278 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 277 => '14.1', 278 => '32.1' },
	'commandergroupb_ttlcomp' => { 281 => '33.1' },
	'commandergroupbmanualoutput' => { 277 => '14.2', 278 => '29.2' },
	'commandergroupbmode' => { 277 => '11.3', 278 => '29.1' },
	'commanderinternalflash' => { 277 => '11.1', 278 => '27.1' },
	'commanderinternalmanualoutput' => { 277 => '12.2', 278 => '27.2' },
	'commanderinternalttlchannel' => { 275 => '18.2' },
	'commanderinternalttlcomp' => { 277 => '12.1', 278 => '30.2', 281 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 275 => '20.1', 276 => '26.1' },
	'commanderinternalttlcompgroupa' => { 275 => '21.1', 276 => '27.1' },
	'commanderinternalttlcompgroupb' => { 275 => '22.1', 276 => '28.1' },
	'comment' => { 0 => 0x2, 117 => 'Comment', 153 => 'Comment', 296 => 'Comment', 358 => "\xa9cmt", 360 => 'comment', 366 => "\xa9cmt" },
	'compass' => { 376 => 0x4 },
	'compilation' => { 358 => 'cpil' },
	'complianceprofile' => { 478 => 'complianceProfile' },
	'componentsconfiguration' => { 116 => 0x9101, 158 => 'Components', 468 => 'ComponentsConfiguration' },
	'componentversion' => { 94 => 0x80c },
	'composer' => { 358 => ["\xa9com","\xa9wrt"], 366 => ["\xa9com","\xa9wrt"], 488 => 'composer' },
	'composerkeywords' => { 366 => "\xa9cok" },
	'compositeimage' => { 116 => 0xa460 },
	'compositeimagecount' => { 116 => 0xa461 },
	'compositeimageexposuretimes' => { 116 => 0xa462 },
	'composition' => { 452 => 'Composition' },
	'compositionadjust' => { 340 => '0.1' },
	'compositionadjustrotation' => { 340 => 0x7 },
	'compositionadjustx' => { 340 => 0x5 },
	'compositionadjusty' => { 340 => 0x6 },
	'compressedbitsperpixel' => { 116 => 0x9102, 468 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 181 => 0x40, 288 => 0x40 },
	'compression' => { 116 => 0x103, 311 => 0xb, 484 => 'Compression' },
	'compressionfactor' => { 283 => 0x50d },
	'compressionratio' => { 158 => 'Compression', 288 => 0x1034 },
	'compressorversion' => { 366 => 'CNCV' },
	'condadobvfactor' => { 134 => 0xf3e },
	'condadodaybvthresh' => { 134 => 0xf3c },
	'condadodayoffsets' => { 134 => 0xf42 },
	'condadofluoffsets' => { 134 => 0xf44 },
	'condadofluthresh' => { 134 => 0xf41 },
	'condadoillfactor' => { 134 => 0xf3f },
	'condadoneurange' => { 134 => 0xf3d },
	'condadotunoffsets' => { 134 => 0xf43 },
	'condadotunthresh' => { 134 => 0xf40 },
	'confidence' => { 447 => 'Confidence' },
	'confidencelevel' => { 458 => 'ConfidenceLevel' },
	'confidencemime' => { 447 => 'ConfidenceMime' },
	'constrainedcropheight' => { 105 => 0x266, 352 => 0xd6 },
	'constrainedcropwidth' => { 105 => 0x262, 352 => 0xd5 },
	'contact' => { 128 => 0x76 },
	'contactinfo' => { 477 => 'contactInfo' },
	'container' => { 442 => 'Container' },
	'containerdirectory' => { 442 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 442 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 442 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 442 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 442 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 442 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 474 => 'ContainerFormat' },
	'containerformatidentifier' => { 474 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 474 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 358 => "\xa9day", 366 => "\xa9day" },
	'contentdistributorid' => { 366 => 'cdis' },
	'contentid' => { 366 => 'ccid' },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 128 => 0x1a },
	'contentlocationname' => { 128 => 0x1b },
	'contenttype' => { 478 => 'contentType' },
	'continuousbracketing' => { 179 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodeliveview' => { 280 => '77.2' },
	'continuousshootingspeed' => { 81 => 0x610 },
	'continuousshotlimit' => { 81 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 109 => 0xc, 110 => [0x3012,0x20], 116 => [0xa408,0xfe54], 124 => [0x1004,0x1006], 152 => 'Contrast', 172 => 'Contrast', 176 => 0x20, 177 => 0x31, 178 => 0x27, 179 => 0x19, 184 => 0x2, 221 => 0x33, 222 => 0x37, 223 => 0x3f, 288 => 0x1029, 306 => 0x39, 308 => 0x300a, 341 => 0x20, 348 => 0xc, 360 => 'player.movie.visual.contrast', 367 => 0x24, 369 => 0x52, 373 => 0x1012, 383 => 0xd, 393 => 0x1d, 394 => 0x1a, 406 => 0x2004, 462 => 'Contrast', 464 => 'Contrast', 468 => 'Contrast' },
	'contrast2012' => { 462 => 'Contrast2012', 464 => 'Contrast2012' },
	'contrastadj' => { 100 => 0x20303, 105 => 0x115, 262 => 0x2c, 439 => 0x8017 },
	'contrastauto' => { 68 => 0x90 },
	'contrastcurve' => { 219 => 0x8c },
	'contrastdetectaf' => { 188 => 0x4 },
	'contrastdetectafarea' => { 341 => 0x231 },
	'contrastdetectafinfocus' => { 188 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 67 => 0x60, 68 => 0x60 },
	'contrasthighlight' => { 341 => 0x6d },
	'contrasthighlightshadowadj' => { 341 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 67 => 0x30, 68 => 0x30 },
	'contrastmode' => { 306 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 67 => 0x78, 68 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 67 => 0x48, 68 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 67 => 0x18, 68 => 0x18 },
	'contrastsetting' => { 283 => 0x505, 291 => 0x1012, 395 => 0x10, 411 => 0x8 },
	'contrastshadow' => { 341 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 67 => 0x0, 68 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 67 => 0x90, 68 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 67 => 0xa8, 68 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 67 => 0xc0, 68 => 0xd8 },
	'contributedmedia' => { 488 => 'contributedMedia' },
	'contributedmediaduration' => { 488 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 488 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 488 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 488 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 488 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 488 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 488 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 488 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 488 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 488 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 465 => 'contributor', 474 => 'Contributor' },
	'contributoridentifier' => { 474 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 474 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 474 => [\'Contributor','ContributorRole'] },
	'contributors' => { 153 => 'Contributors' },
	'controldialset' => { 179 => 0x46 },
	'controlledvocabularyterm' => { 474 => 'CVterm' },
	'controllerboardversion' => { 301 => 0x332 },
	'controlmode' => { 74 => 0x12 },
	'controlringrotation' => { 81 => 0x712 },
	'conversionlens' => { 284 => 0x403, 306 => 0x35 },
	'converter' => { 116 => 0xfe4d, 249 => 0xb, 462 => 'Converter', 464 => 'Converter' },
	'converttograyscale' => { 462 => 'ConvertToGrayscale', 464 => 'ConvertToGrayscale' },
	'cookingequipment' => { 480 => 'cookingEquipment' },
	'cookingmethod' => { 480 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 116 => 0x8298, 153 => 'Copyright', 296 => 'Copyright', 341 => 0x22f, 357 => 'Copyright', 358 => ['cprt',"\xa9cpy"], 360 => 'copyright', 366 => ['cprt',"\xa9cpy"], 475 => 'Copyright', 481 => 'copyright', 484 => 'Copyright', 488 => 'copyright' },
	'copyrightflag' => { 355 => 0x40a },
	'copyrightnotice' => { 128 => 0x74 },
	'copyrightowner' => { 293 => 'CopyrightOwner' },
	'copyrightownerid' => { 293 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 293 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 293 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 293 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 293 => 'CopyrightStatus' },
	'copyrightyear' => { 474 => 'CopyrightYear', 478 => 'copyrightYear' },
	'coringfilter' => { 287 => 0x310, 288 => 0x102d, 291 => 0x310 },
	'coringvalues' => { 287 => 0x311, 291 => 0x311 },
	'corporateentity' => { 478 => 'corporateEntity' },
	'country' => { 157 => 'Country', 306 => 0x69, 476 => 'Country' },
	'country-primarylocationcode' => { 128 => 0x64 },
	'country-primarylocationname' => { 128 => 0x65 },
	'countrycode' => { 218 => 0x5, 353 => 'CountryCode', 473 => 'CountryCode' },
	'course' => { 480 => 'course' },
	'coverage' => { 465 => 'coverage' },
	'coverart' => { 358 => 'covr' },
	'coverdate' => { 478 => 'coverDate' },
	'coverdisplaydate' => { 478 => 'coverDisplayDate' },
	'coveruri' => { 366 => 'cvru' },
	'cpufirmwareversion' => { 341 => 0x28 },
	'crc32' => { 466 => 'crc32' },
	'createdate' => { 116 => 0x9004, 153 => 'CreateDate', 292 => 'CreationDate', 296 => 'create-date', 357 => 'CreationDate', 363 => 0x1, 486 => 'CreateDate' },
	'creationdate' => { 360 => 'creationdate', 475 => 'CreationDate', 478 => 'creationDate' },
	'creationtime' => { 296 => 'Creation Time' },
	'creativestyle' => { 393 => 0x1a, 394 => 0x18, 404 => 0x41, 406 => 0xb020, 435 => 0x4a },
	'creativestylesetting' => { 395 => 0xf, 411 => 0x7 },
	'creativestylewaschanged' => { 439 => 0x8001 },
	'creator' => { 292 => 'Creator', 357 => 'Creator', 465 => 'creator', 474 => 'Creator', 475 => 'Creator' },
	'creatoraddress' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 174 => 'CreatorAppId' },
	'creatorcity' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 473 => 'CreatorContactInfo' },
	'creatorcountry' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 474 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 474 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 174 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 474 => [\'Creator','CreatorRole'] },
	'creatortool' => { 486 => 'CreatorTool' },
	'creatorworkemail' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 473 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 128 => 0x6e, 476 => 'Credit' },
	'creditline' => { 481 => 'creditLine' },
	'creditlinereq' => { 491 => 'CreditLineReq' },
	'creditlinerequired' => { 293 => 'CreditLineRequired' },
	'cropactive' => { 98 => 0x0, 105 => 0x244 },
	'cropangle' => { 462 => 'CropAngle', 464 => 'CropAngle' },
	'croparea' => { 219 => 0x45, 439 => 0x9011 },
	'cropaspectratio' => { 100 => 0x30101, 105 => 0x260 },
	'cropaspectratiocustom' => { 100 => 0x30102 },
	'cropbottom' => { 120 => 0x9, 254 => 0x36, 311 => 0x31, 352 => 0xdc, 462 => 'CropBottom', 464 => 'CropBottom' },
	'cropbottommargin' => { 51 => 0x3 },
	'cropcircleactive' => { 106 => 0xd6 },
	'cropcircleradius' => { 106 => 0xd9 },
	'cropcirclex' => { 106 => 0xd7 },
	'cropcircley' => { 106 => 0xd8 },
	'cropconstraintowarp' => { 462 => 'CropConstrainToWarp', 464 => 'CropConstrainToWarp' },
	'croph' => { 456 => 'CropH' },
	'cropheight' => { 98 => 0x6, 105 => 0x24c, 287 => 0x615, 291 => 0x615, 462 => 'CropHeight', 464 => 'CropHeight' },
	'crophispeed' => { 219 => 0x1b },
	'cropleft' => { 105 => 0x246, 120 => 0x6, 254 => 0x1e, 287 => 0x612, 291 => 0x612, 311 => 0x30, 352 => 0xd9, 462 => 'CropLeft', 464 => 'CropLeft' },
	'cropleftmargin' => { 51 => 0x0 },
	'cropmode' => { 124 => 0x104d, 373 => 0x1018 },
	'croporiginalheight' => { 98 => 0xb },
	'croporiginalwidth' => { 98 => 0xa },
	'cropoutputheight' => { 254 => 0xce },
	'cropoutputheightinches' => { 254 => 0x96 },
	'cropoutputpixels' => { 254 => 0xd6 },
	'cropoutputresolution' => { 254 => 0xb6 },
	'cropoutputscale' => { 254 => 0xbe },
	'cropoutputwidth' => { 254 => 0xc6 },
	'cropoutputwidthinches' => { 254 => 0x8e },
	'croppedareaimageheightpixels' => { 450 => 'CroppedAreaImageHeightPixels', 451 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 450 => 'CroppedAreaImageWidthPixels', 451 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 450 => 'CroppedAreaLeftPixels', 451 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 450 => 'CroppedAreaTopPixels', 451 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 373 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 373 => 0x1603 },
	'cropping' => { 439 => 0x9010 },
	'cropright' => { 120 => 0x8, 254 => 0x2e, 311 => 0x32, 352 => 0xdb, 462 => 'CropRight', 464 => 'CropRight' },
	'croprightmargin' => { 51 => 0x1 },
	'croprotatedoriginalheight' => { 98 => 0x2 },
	'croprotatedoriginalwidth' => { 98 => 0x1 },
	'croprotation' => { 98 => 0x8, 120 => 0xb },
	'cropscaledresolution' => { 254 => 0x9e },
	'cropsourceresolution' => { 254 => 0xae },
	'croptop' => { 105 => 0x248, 120 => 0x7, 254 => 0x26, 287 => 0x613, 291 => 0x613, 311 => 0x2f, 352 => 0xda, 462 => 'CropTop', 464 => 'CropTop' },
	'croptopmargin' => { 51 => 0x2 },
	'cropunit' => { 462 => 'CropUnit', 464 => 'CropUnit' },
	'cropunits' => { 462 => 'CropUnits', 464 => 'CropUnits' },
	'cropw' => { 456 => 'CropW' },
	'cropwidth' => { 98 => 0x5, 105 => 0x24a, 287 => 0x614, 291 => 0x614, 462 => 'CropWidth', 464 => 'CropWidth' },
	'cropx' => { 98 => 0x3, 456 => 'CropX' },
	'cropy' => { 98 => 0x4, 456 => 'CropY' },
	'crossprocess' => { 341 => 0x7b },
	'crossprocessparams' => { 341 => 0x235 },
	'cuisine' => { 480 => 'cuisine' },
	'currenticcprofile' => { 116 => 0xc691 },
	'currentpreprofilematrix' => { 116 => 0xc692 },
	'currentversion' => { 439 => 0xd000 },
	'curve0x' => { 456 => 'Curve0x' },
	'curve0y' => { 456 => 'Curve0y' },
	'curve1x' => { 456 => 'Curve1x' },
	'curve1y' => { 456 => 'Curve1y' },
	'curve2x' => { 456 => 'Curve2x' },
	'curve2y' => { 456 => 'Curve2y' },
	'curve3x' => { 456 => 'Curve3x' },
	'curve3y' => { 456 => 'Curve3y' },
	'curve4x' => { 456 => 'Curve4x' },
	'curve4y' => { 456 => 'Curve4y' },
	'curves' => { 259 => 0x76a43201 },
	'custom1' => { 293 => 'Custom1' },
	'custom10' => { 293 => 'Custom10' },
	'custom2' => { 293 => 'Custom2' },
	'custom3' => { 293 => 'Custom3' },
	'custom4' => { 293 => 'Custom4' },
	'custom5' => { 293 => 'Custom5' },
	'custom6' => { 293 => 'Custom6' },
	'custom7' => { 293 => 'Custom7' },
	'custom8' => { 293 => 'Custom8' },
	'custom9' => { 293 => 'Custom9' },
	'customcolortone' => { 106 => 0x4c },
	'customcontrast' => { 106 => 0x4e },
	'customcontrols' => { 81 => 0x70c },
	'customdefaultunsharpfineness' => { 106 => 0xbe },
	'customdefaultunsharpstrength' => { 106 => 0xbc },
	'customdefaultunsharpthreshold' => { 106 => 0xc0 },
	'customilluminant' => { 134 => 0x405 },
	'customizedials' => { 81 => 0x715 },
	'customlinear' => { 106 => 0x4f },
	'customoutputhighlightpoint' => { 106 => 0x53 },
	'customoutputshadowpoint' => { 106 => 0x54 },
	'custompicturestyle' => { 100 => 0x10021 },
	'custompicturestyledata' => { 100 => 0xf0500 },
	'custompicturestylefilename' => { 61 => 0x4010 },
	'customrawhighlight' => { 106 => 0x7c },
	'customrawhighlightpoint' => { 106 => 0x51 },
	'customrawshadow' => { 106 => 0x85 },
	'customrawshadowpoint' => { 106 => 0x52 },
	'customrendered' => { 116 => 0xa401, 468 => 'CustomRendered' },
	'customsaturation' => { 106 => 0x4d, 283 => 0x503 },
	'customsettingsalldefault' => { 266 => '0.2', 275 => '0.2' },
	'customsettingsbank' => { 266 => '0.1', 267 => '0.1', 269 => '0.1', 270 => '0.1', 275 => '0.1', 279 => '0.2', 280 => '0.2' },
	'customsharpness' => { 106 => 0x50 },
	'customunsharpmaskfineness' => { 106 => 0xb8 },
	'customunsharpmaskstrength' => { 106 => 0xb6 },
	'customunsharpmaskthreshold' => { 106 => 0xba },
	'customwb_rblevels' => { 411 => 0x1a },
	'customwb_rgblevels' => { 394 => 0x8, 395 => 0x19 },
	'customwbbluelevel' => { 179 => 0x36 },
	'customwberror' => { 179 => 0x37 },
	'customwbgreenlevel' => { 179 => 0x35 },
	'customwbredlevel' => { 179 => 0x34 },
	'customwbsetting' => { 179 => 0x26 },
	'cx' => { 366 => '_cx_' },
	'cy' => { 366 => '_cy_' },
	'd-lightinghq' => { 259 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 255 => 0x2 },
	'd-lightinghqhighlight' => { 255 => 0x1 },
	'd-lightinghqselected' => { 259 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 255 => 0x0 },
	'd-lightinghs' => { 259 => 0xce5554aa },
	'd-lightinghsadjustment' => { 256 => 0x0 },
	'd-lightinghscolorboost' => { 256 => 0x1 },
	'd-rangeoptimizerhighlight' => { 439 => 0x8024 },
	'd-rangeoptimizermode' => { 439 => 0x8022 },
	'd-rangeoptimizershadow' => { 439 => 0x802d },
	'd-rangeoptimizervalue' => { 439 => 0x8023 },
	'darkblacksegrows' => { 134 => 0x18d8 },
	'darkfocusenvironment' => { 306 => 0x8003 },
	'darkframecountfactor' => { 134 => 0xc85 },
	'darkframelongexposure' => { 134 => 0xc84 },
	'darkframeshortexposure' => { 134 => 0xc83 },
	'darkpedestal' => { 134 => 0xc7f },
	'datacompressionmethod' => { 130 => 0x6e },
	'dataimprint' => { 176 => 0x34 },
	'dataonscreen' => { 474 => 'DataOnScreen' },
	'dataonscreenregion' => { 474 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 474 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 474 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 474 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 474 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 474 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 474 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 474 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 341 => 0x3d },
	'date' => { 341 => 0x6, 465 => 'date' },
	'dateacquired' => { 174 => 'DateAcquired' },
	'datecreated' => { 128 => 0x37, 476 => 'DateCreated' },
	'datedisplayformat' => { 251 => 0x3 },
	'dateidentified' => { 115 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 271 => '4.2' },
	'daterecieved' => { 478 => 'dateRecieved' },
	'datesent' => { 129 => 0x46 },
	'datestampmode' => { 61 => 0x1c, 219 => 0x9d },
	'datetime' => { 457 => 'datetime', 484 => 'DateTime' },
	'datetimedigitized' => { 468 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 97 => 0x0, 116 => 0x9003, 150 => 0x14, 153 => 'OriginalDate', 361 => 'IDIT', 366 => 'date', 367 => 0xb, 368 => 0x3b, 369 => 0x3e, 468 => 'DateTimeOriginal' },
	'datetimestamp' => { 136 => 0x64 },
	'datetimeutc' => { 283 => 0x908 },
	'daylightsavings' => { 75 => 0x3, 251 => 0x2 },
	'dayofweek' => { 368 => 0x42, 369 => 0x4a },
	'dccontinent' => { 115 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 115 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 115 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 115 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 115 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 115 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 115 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 115 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 115 => 'Event' },
	'dcfootprintspatialfit' => { 115 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 115 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 115 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 115 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 115 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 115 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 115 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 115 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 115 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 115 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 115 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 115 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 115 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 115 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 115 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 115 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 115 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 115 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 115 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 115 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 115 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 115 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 115 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 115 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 115 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 115 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 115 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 115 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 115 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 115 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 161 => 'Declination' },
	'decposition' => { 176 => 0x32 },
	'defaultautogray' => { 462 => 'DefaultAutoGray', 464 => 'DefaultAutoGray' },
	'defaultautotone' => { 462 => 'DefaultAutoTone', 464 => 'DefaultAutoTone' },
	'defaultblackrender' => { 116 => 0xc7a6 },
	'defaultcroporigin' => { 116 => 0xc61f },
	'defaultcropsize' => { 116 => 0xc620 },
	'defaulteraseoption' => { 81 => 0x813 },
	'defaultscale' => { 116 => 0xc61e },
	'defaultsspecifictoiso' => { 462 => 'DefaultsSpecificToISO', 464 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 462 => 'DefaultsSpecificToSerial', 464 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 116 => 0xc7b5 },
	'defectisocode' => { 134 => 0x90f },
	'defringe' => { 462 => 'Defringe', 464 => 'Defringe' },
	'defringegreenamount' => { 462 => 'DefringeGreenAmount', 464 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 462 => 'DefringeGreenHueHi', 464 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 462 => 'DefringeGreenHueLo', 464 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 462 => 'DefringePurpleAmount', 464 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 462 => 'DefringePurpleHueHi', 464 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 462 => 'DefringePurpleHueLo', 464 => 'DefringePurpleHueLo' },
	'dehaze' => { 462 => 'Dehaze', 464 => 'Dehaze' },
	'deletedimagecount' => { 219 => 0xa6, 228 => 0x6e },
	'deprecatedon' => { 460 => 'deprecatedOn' },
	'depthfar' => { 116 => 0xc7eb },
	'depthformat' => { 116 => 0xc7e9 },
	'depthimage' => { 447 => 'Data' },
	'depthmeasuretype' => { 116 => 0xc7ed },
	'depthnear' => { 116 => 0xc7ea },
	'depthunits' => { 116 => 0xc7ec },
	'derivedfrom' => { 489 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 489 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 489 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 489 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 489 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 489 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 489 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 489 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 489 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 489 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 489 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 489 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 489 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 489 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 489 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 489 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 489 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 489 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 489 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 489 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 489 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 489 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 489 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 489 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 296 => 'Description', 358 => ['desc','dscp',"\xa9des"], 360 => 'description', 366 => 'dscp', 465 => 'description', 486 => 'Description' },
	'destination' => { 129 => 0x5 },
	'destinationcity' => { 341 => 0x24, 347 => 0x3 },
	'destinationcitycode' => { 348 => 0x1001 },
	'destinationdst' => { 341 => 0x26, 347 => '0.3' },
	'developmentdynamicrange' => { 124 => 0x1403 },
	'deviantmatrixcustom' => { 134 => 0x7de },
	'deviantmatrixdaylight' => { 134 => 0x7da },
	'deviantmatrixflash' => { 134 => 0x7dd },
	'deviantmatrixfluorescent' => { 134 => 0x7dc },
	'deviantmatrixtungsten' => { 134 => 0x7db },
	'deviantwhitecustom' => { 134 => 0x842 },
	'deviantwhitedaylight' => { 134 => 0x83e },
	'deviantwhiteflash' => { 134 => 0x841 },
	'deviantwhitefluorescent' => { 134 => 0x840 },
	'deviantwhitetungsten' => { 134 => 0x83f },
	'device' => { 478 => 'device' },
	'devicesettingdescription' => { 468 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 468 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 468 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 468 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 380 => 0x2 },
	'dewarpdata' => { 113 => 'DewarpData' },
	'dewarpflag' => { 113 => 'DewarpFlag' },
	'dialdirectiontvav' => { 81 => 0x706 },
	'dietaryneeds' => { 480 => 'dietaryNeeds' },
	'diffractioncorrection' => { 306 => 0xbc, 331 => 0x3 },
	'diffractioncorrectionon' => { 100 => 0x2070b },
	'digitalcreationdate' => { 128 => 0x3e },
	'digitalcreationtime' => { 128 => 0x3f },
	'digitaldeehighlightadj' => { 227 => 0x202 },
	'digitaldeeshadowadj' => { 227 => 0x200 },
	'digitaldeethreshold' => { 227 => 0x201 },
	'digitalfilter' => { 383 => 0x59 },
	'digitalfilter01' => { 328 => 0x5 },
	'digitalfilter02' => { 328 => 0x16 },
	'digitalfilter03' => { 328 => 0x27 },
	'digitalfilter04' => { 328 => 0x38 },
	'digitalfilter05' => { 328 => 0x49 },
	'digitalfilter06' => { 328 => 0x5a },
	'digitalfilter07' => { 328 => 0x6b },
	'digitalfilter08' => { 328 => 0x7c },
	'digitalfilter09' => { 328 => 0x8d },
	'digitalfilter10' => { 328 => 0x9e },
	'digitalfilter11' => { 328 => 0xaf },
	'digitalfilter12' => { 328 => 0xc0 },
	'digitalfilter13' => { 328 => 0xd1 },
	'digitalfilter14' => { 328 => 0xe2 },
	'digitalfilter15' => { 328 => 0xf3 },
	'digitalfilter16' => { 328 => 0x104 },
	'digitalfilter17' => { 328 => 0x115 },
	'digitalfilter18' => { 328 => 0x126 },
	'digitalfilter19' => { 328 => 0x137 },
	'digitalfilter20' => { 328 => 0x148 },
	'digitalgain' => { 71 => 0xb },
	'digitalgem' => { 208 => 0x0 },
	'digitalice' => { 227 => 0x100 },
	'digitalimageguid' => { 474 => 'DigImageGUID' },
	'digitalroc' => { 225 => 0x0 },
	'digitalsourcefiletype' => { 474 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 474 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 109 => 0xa, 124 => 0x1044, 136 => 0x68, 147 => 0x22, 148 => 0x1e, 152 => 'DigitalZoom', 176 => 0xc, 219 => 0x86, 249 => 0xa, 288 => 0x204, 341 => 0x1e, 348 => 0xa, 382 => 0x204, 426 => 0x12, 427 => 0x12 },
	'digitalzoomon' => { 382 => 0x21b },
	'digitalzoomratio' => { 116 => 0xa404, 416 => 0x200, 418 => 0x21c, 468 => 'DigitalZoomRatio' },
	'director' => { 360 => 'director', 366 => "\xa9dir", 488 => 'director' },
	'directorphotography' => { 488 => 'directorPhotography' },
	'directory' => { 117 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 202 => 0x3, 369 => 0x12 },
	'disableautocreation' => { 445 => 'DisableAutoCreation' },
	'disclaimer' => { 296 => 'Disclaimer' },
	'discnumber' => { 488 => 'discNumber' },
	'dishtype' => { 480 => 'dishType' },
	'disknumber' => { 358 => 'disk' },
	'displayallafpoints' => { 81 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 356 => 0x2 },
	'displayedunitsy' => { 356 => 0x6 },
	'displayname' => { 360 => 'displayname', 477 => 'displayName' },
	'distance1' => { 136 => 0x28 },
	'distance2' => { 136 => 0x2c },
	'distance3' => { 136 => 0x30 },
	'distance4' => { 136 => 0x34 },
	'distortion' => { 380 => 0xa050 },
	'distortioncompensation' => { 439 => 0x8040 },
	'distortioncontrol' => { 228 => 0x10 },
	'distortioncorrection' => { 76 => 0x3, 100 => 0x20705, 106 => 0x67, 116 => 0x7036, 283 => 0x50b, 310 => '7.1', 331 => 0x0, 434 => 0x601, 435 => 0x5b },
	'distortioncorrection2' => { 287 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 459 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 100 => '0x20705.0', 106 => 0x63 },
	'distortioncorrectionsetting' => { 77 => 0x7, 406 => 0x2013 },
	'distortioncorrectionvalue' => { 76 => 0x9 },
	'distortioncorrparams' => { 116 => 0x7037, 415 => 0x1a23, 418 => 0x1870, 420 => 0x189c, 421 => 0x18cc, 422 => 0x17d0, 434 => 0x6ca, 435 => 0x64 },
	'distortioncorrparamsnumber' => { 418 => 0x1899, 420 => 0x18c5, 421 => 0x18f5, 422 => 0x17f9 },
	'distortioncorrparamspresent' => { 418 => 0x1898, 420 => 0x18c4, 421 => 0x18f4, 422 => 0x17f8, 424 => 0x10b, 425 => 0x10b, 434 => 0x600, 435 => 0x5a },
	'distortioneffect' => { 100 => 0x20709 },
	'distortionn' => { 310 => 0xc },
	'distortionparam02' => { 310 => 0x2 },
	'distortionparam04' => { 310 => 0x4 },
	'distortionparam08' => { 310 => 0x8 },
	'distortionparam09' => { 310 => 0x9 },
	'distortionparam11' => { 310 => 0xb },
	'distortionscale' => { 310 => 0x5 },
	'distributor' => { 478 => 'distributor' },
	'distributorproductid' => { 477 => 'distributorProductID' },
	'dloon' => { 100 => '0x20706.0', 106 => 0xdc },
	'dlosetting' => { 100 => 0x20706, 106 => 0xdd },
	'dlosettingapplied' => { 99 => 0x4 },
	'dloshootingdistance' => { 106 => 0xde },
	'dloversion' => { 99 => 0x5 },
	'dmcomment' => { 488 => 'comment' },
	'dmdithermatrix' => { 134 => 0xc7a },
	'dmdithermatrixheight' => { 134 => 0xc7c },
	'dmdithermatrixwidth' => { 134 => 0xc7b },
	'dngadobedata' => { 116 => 0xc634 },
	'dngbackwardversion' => { 116 => 0xc613 },
	'dngignoresidecars' => { 462 => 'DNGIgnoreSidecars', 464 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 116 => 0xc630 },
	'dngprivatedata' => { 116 => 0xc634 },
	'dngversion' => { 116 => 0xc612 },
	'document' => { 296 => 'Document' },
	'documentancestors' => { 476 => 'DocumentAncestors' },
	'documenthistory' => { 128 => 0xe7 },
	'documentid' => { 489 => 'DocumentID' },
	'documentname' => { 116 => 0x10d },
	'documentnotes' => { 128 => 0xe6 },
	'doi' => { 478 => 'doi' },
	'dopesheet' => { 474 => 'Dopesheet' },
	'dopesheetlink' => { 474 => 'DopesheetLink' },
	'dopesheetlinklink' => { 474 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 474 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 134 => 0xc82 },
	'dpp' => { 457 => 'dpp' },
	'dr4cameramodel' => { 101 => 0x3 },
	'drangepriority' => { 124 => 0x1443 },
	'drangepriorityauto' => { 124 => 0x1444 },
	'drangepriorityfixed' => { 124 => 0x1445 },
	'drivemode' => { 110 => 0x3103, 122 => '0.1', 176 => 0x6, 179 => 0x1e, 182 => 0xe, 283 => 0x600, 341 => 0x34, 373 => 0x1002, 383 => 0x3, 393 => 0x4, 394 => 0x7e, 395 => 0x34 },
	'drivemode2' => { 179 => 0xa, 322 => 0x7, 404 => 0xe, 411 => 0x1 },
	'drivemodesetting' => { 395 => 0x4 },
	'drivespeed' => { 122 => '0.2' },
	'dspfirmwareversion' => { 341 => 0x27 },
	'duration' => { 64 => 0x6a, 151 => 'Duration', 165 => 'Duration', 480 => 'duration', 488 => 'duration' },
	'durationscale' => { 488 => [\'duration','durationScale'] },
	'durationvalue' => { 488 => [\'duration','durationValue'] },
	'dustremovaldata' => { 61 => 0x97 },
	'dynamicafarea' => { 266 => '1.4', 275 => '1.4' },
	'dynamicareaafdisplay' => { 267 => '46.1', 269 => '47.1', 270 => '47.1', 279 => '47.1', 280 => '47.1' },
	'dynamicrange' => { 124 => 0x1400 },
	'dynamicrangeexpansion' => { 341 => 0x69, 373 => 0x100e },
	'dynamicrangemax' => { 105 => 0x7c },
	'dynamicrangemin' => { 105 => 0x7a },
	'dynamicrangeoptimizer' => { 179 => 0x15, 406 => [0xb025,0xb04f], 414 => 0x1144, 415 => [0x1144,0x324], 416 => [0x1120,0x300], 417 => [0x119c,0x37c], 418 => [0x1178,0x328], 419 => [0x1030,0x50], 420 => [0x228,0x50], 421 => [0x228,0x50], 422 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 404 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 393 => 0x19, 394 => 0x17, 395 => 0xd, 404 => 0x79, 411 => 0x5 },
	'dynamicrangeoptimizermode' => { 182 => 0x15, 393 => 0x18, 394 => 0x16, 404 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 179 => 0x27, 395 => 0xc, 411 => 0x4 },
	'dynamicrangesetting' => { 124 => 0x1402 },
	'e-dialinprogram' => { 322 => '1.3' },
	'earliestageorloweststage' => { 115 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 115 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 115 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 115 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 115 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 442 => 'EarthPos' },
	'earthposaltitude' => { 442 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 442 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 442 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 442 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 442 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 442 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 442 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 442 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 281 => '6.1' },
	'easyexposurecompensation' => { 266 => '6.4', 267 => '6.5', 269 => '6.3', 270 => '6.3', 274 => '5.1', 275 => '4.4', 276 => '5.2', 279 => '6.3', 280 => '6.3' },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 134 => 0x930 },
	'edgemapx1' => { 134 => 0x931 },
	'edgemapx2' => { 134 => 0x932 },
	'edgemapx3' => { 134 => 0x934 },
	'edgemapx4' => { 134 => 0x935 },
	'edgenoisereduction' => { 260 => 0x4, 439 => 0x8028 },
	'edit1' => { 366 => "\xa9ed1" },
	'edit2' => { 366 => "\xa9ed2" },
	'edit3' => { 366 => "\xa9ed3" },
	'edit4' => { 366 => "\xa9ed4" },
	'edit5' => { 366 => "\xa9ed5" },
	'edit6' => { 366 => "\xa9ed6" },
	'edit7' => { 366 => "\xa9ed7" },
	'edit8' => { 366 => "\xa9ed8" },
	'edit9' => { 366 => "\xa9ed9" },
	'edition' => { 478 => 'edition' },
	'editorialupdate' => { 128 => 0x8 },
	'editstatus' => { 128 => 0x7, 353 => 'EditStatus', 457 => 'EditStatus' },
	'editversionname' => { 259 => 0x3d136244 },
	'effectivelv' => { 341 => 0x2d },
	'effectivemaxaperture' => { 212 => 0x12, 213 => 0x13, 217 => 0x14 },
	'eissn' => { 478 => 'eIssn' },
	'electricalblackcolumns' => { 134 => 0x1810 },
	'electronicfront-curtainshutter' => { 269 => '5.2', 270 => '5.2', 279 => '5.3', 280 => '5.2' },
	'electronicfrontcurtainshutter' => { 406 => 0x201a },
	'elevation' => { 161 => 'Elevation' },
	'email' => { 153 => 'EMail' },
	'embargodate' => { 481 => 'embargoDate' },
	'embdencrightsexpr' => { 474 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 474 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 474 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 474 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 476 => 'EmbeddedXMPDigest' },
	'emissivity' => { 118 => 0x3 },
	'enablechromanoisereduction' => { 134 => 0xe6e },
	'enablesharpening' => { 134 => 0x92e },
	'encodedby' => { 358 => "\xa9enc" },
	'encodedwith' => { 360 => 'Encoded_With' },
	'encoder' => { 358 => "\xa9too", 366 => "\xa9too" },
	'encoderid' => { 366 => "\xa9enc" },
	'encryptionkey' => { 380 => 0xa020 },
	'endingpage' => { 478 => 'endingPage' },
	'enduser' => { 293 => 'EndUser' },
	'enduserid' => { 293 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 293 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 488 => 'engineer' },
	'enhancedarktones' => { 252 => 0x8 },
	'enhancement' => { 109 => 0x16, 110 => 0x3016 },
	'enhanceparams' => { 116 => 0xc7ee },
	'enhancer' => { 287 => 0x300 },
	'enhancervalues' => { 287 => 0x301 },
	'envelopenumber' => { 129 => 0x28 },
	'envelopepriority' => { 129 => 0x3c },
	'enveloperecordversion' => { 129 => 0x0 },
	'episode' => { 474 => 'Episode' },
	'episodeglobaluniqueid' => { 358 => 'egid' },
	'episodeidentifier' => { 474 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 474 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 474 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 288 => 0x20c },
	'epsonimagewidth' => { 288 => 0x20b },
	'epsonsoftware' => { 288 => 0x20d },
	'equipmentinstitution' => { 441 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 441 => 'EquipmentManufacturer' },
	'equipmentversion' => { 284 => 0x0 },
	'ettlii' => { 81 => 0x304, 82 => 0xd, 83 => 0xe, 84 => 0x7, 85 => 0x7, 86 => 0xe },
	'event' => { 443 => 'Event', 455 => 'Event', 474 => 'Event', 478 => 'event' },
	'eventalias' => { 477 => 'eventAlias' },
	'eventdate' => { 115 => [\'Event','EventEventDate'] },
	'eventday' => { 115 => [\'Event','EventDay'] },
	'eventearliestdate' => { 115 => [\'Event','EventEarliestDate'] },
	'eventend' => { 477 => 'eventEnd' },
	'eventenddayofyear' => { 115 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 115 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 115 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 115 => [\'Event','EventHabitat'] },
	'eventid' => { 115 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 115 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 115 => [\'Event','EventMonth'] },
	'eventnumber' => { 367 => 0x9, 368 => 0x37, 369 => 0x3a },
	'eventparenteventid' => { 115 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 115 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 115 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 115 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 115 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 115 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 477 => 'eventStart' },
	'eventstartdayofyear' => { 115 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 477 => 'eventSubtype' },
	'eventtime' => { 115 => [\'Event','EventEventTime'] },
	'eventtype' => { 477 => 'eventType' },
	'eventverbatimeventdate' => { 115 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 115 => [\'Event','EventYear'] },
	'evsteps' => { 322 => '1.2', 324 => 0x0 },
	'evstepsize' => { 271 => '5.1', 272 => '6.1', 273 => '6.1', 277 => '0.7' },
	'exclusivecoverage' => { 452 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 481 => 'exclusivityEndDate' },
	'excursiontolerance' => { 130 => 0x82 },
	'exif' => { 117 => 'EXIF' },
	'exifbyteorder' => { 117 => 'ExifByteOrder' },
	'exifcamerainfo' => { 128 => 0xe8 },
	'exifimageheight' => { 116 => 0xa003, 468 => 'PixelYDimension' },
	'exifimagewidth' => { 116 => 0xa002, 468 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 117 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 116 => 0x9000, 468 => 'ExifVersion' },
	'exitpupilposition' => { 212 => 0x4, 213 => 0x4, 217 => 0x4 },
	'expirationdate' => { 128 => 0x25, 481 => 'expirationDate' },
	'expirationtime' => { 128 => 0x26 },
	'exposure' => { 116 => 0xfe51, 462 => 'Exposure', 464 => 'Exposure' },
	'exposure2012' => { 462 => 'Exposure2012', 464 => 'Exposure2012' },
	'exposureadj' => { 257 => 0x0 },
	'exposureadj2' => { 257 => 0x12 },
	'exposureadjust' => { 383 => 0xc },
	'exposurebracketingindicatorlast' => { 179 => 0x52 },
	'exposurebracketshotnumber' => { 182 => 0x2d, 404 => 0x2f },
	'exposurebracketstepsize' => { 322 => 0x8 },
	'exposurebracketvalue' => { 219 => 0x19 },
	'exposurecompautocancel' => { 81 => 0x113 },
	'exposurecompensation' => { 74 => 0x6, 90 => 0x0, 116 => 0x9204, 136 => 0x24, 152 => 'ExposureComp', 172 => 'ExposureCompensation', 176 => 0xd, 177 => 0x53, 178 => 0x1e, 182 => 0x49c0, 288 => 0x1006, 341 => 0x16, 350 => 0x402, 380 => 0xa013, 383 => [0xc,0x35,0x4d], 414 => 0x114c, 415 => 0x114c, 416 => 0x1128, 418 => 0x1180, 419 => 0x1038, 420 => 0x230, 421 => 0x230, 422 => 0x223, 468 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 411 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 179 => 0x47, 182 => 0x2a },
	'exposurecompensationset' => { 393 => 0x3, 394 => 0x3, 395 => 0x3, 411 => 0x1e },
	'exposurecompensationsetting' => { 179 => 0x1 },
	'exposurecompstepsize' => { 266 => '6.3', 267 => '7.3', 269 => '7.3', 270 => '7.3', 275 => '4.3', 279 => '7.3', 280 => '7.3' },
	'exposurecontrolstep' => { 274 => '6.1', 276 => '6.1' },
	'exposurecontrolstepsize' => { 266 => '6.2', 267 => '7.1', 269 => '7.1', 270 => '7.1', 275 => '4.2', 279 => '7.1', 280 => '7.1', 281 => '7.1' },
	'exposurecount' => { 124 => 0x1032 },
	'exposuredelaymode' => { 266 => '10.1', 267 => '11.1', 269 => '11.1', 270 => '11.1', 271 => '9.1', 272 => '10.1', 273 => '10.1', 275 => '10.4', 276 => '10.1', 277 => '6.4', 279 => '11.1', 280 => '11.1', 281 => '11.2' },
	'exposuredifference' => { 219 => 0xe },
	'exposuregaincustom' => { 134 => 0x89c },
	'exposuregaindaylight' => { 134 => 0x898 },
	'exposuregainflash' => { 134 => 0x89b },
	'exposuregainfluorescent' => { 134 => 0x89a },
	'exposuregaintungsten' => { 134 => 0x899 },
	'exposureindex' => { 116 => 0xa215, 468 => 'ExposureIndex' },
	'exposureindicator' => { 179 => 0x50 },
	'exposurelevelincrements' => { 79 => 0x6, 80 => 0x6, 81 => 0x101, 82 => 0x5, 83 => 0x6, 84 => 0x5, 85 => 0x5, 86 => 0x6, 87 => 0x4, 393 => 0x58, 394 => 0x58 },
	'exposurelockused' => { 450 => 'ExposureLockUsed' },
	'exposuremode' => { 116 => 0xa402, 152 => 'ExposureMode', 176 => 0x1, 177 => 0xa, 178 => 0x0, 179 => 0x0, 182 => 0x34, 283 => 0x200, 303 => 0x40d, 383 => 0x8, 406 => 0xb041, 468 => 'ExposureMode' },
	'exposuremodeinmanual' => { 81 => 0x10b },
	'exposureprogram' => { 116 => 0x8822, 373 => 0x1001, 386 => [0x17e,0x43], 393 => 0x3c, 394 => 0x3c, 395 => 0x5, 399 => 0x14, 404 => 0x3f, 411 => 0x2, 414 => 0x1175, 415 => 0x1179, 416 => 0x1155, 417 => 0x11d1, 418 => 0x11ad, 419 => 0x1065, 420 => 0x25d, 421 => 0x25d, 422 => 0x24c, 431 => 0xb, 432 => 0xc, 433 => 0xb, 435 => 0x48, 468 => 'ExposureProgram' },
	'exposureshift' => { 283 => 0x203 },
	'exposurestandardadjustment' => { 406 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 74 => 0x16, 116 => 0x829a, 133 => 0xfd05, 136 => 0x20, 138 => 0xfa24, 140 => 0xf104, 143 => 0x12, 145 => 0x38, 147 => 0x14, 148 => 0x10, 150 => 0x10, 152 => 'ExposureTime', 176 => 0x9, 177 => 0x35, 178 => 0x48, 179 => 0x8, 182 => 0x49b8, 341 => 0x12, 380 => 0xa018, 383 => [0x32,0x4a], 393 => 0x0, 394 => 0x0, 411 => [0x21,0x23,0x27], 435 => 0x10, 468 => 'ExposureTime' },
	'exposuretime2' => { 383 => [0x33,0x4b] },
	'exposuretuning' => { 219 => 0x1c },
	'exposurevalue' => { 134 => 0x3 },
	'exposurewarning' => { 124 => 0x1302 },
	'exrauto' => { 124 => 0x1033 },
	'exrmode' => { 124 => 0x1034 },
	'extendedwbdetect' => { 283 => 0x902 },
	'extender' => { 284 => 0x301 },
	'extenderfirmwareversion' => { 284 => 0x304 },
	'extendermagnification' => { 154 => 'Magnification' },
	'extendermake' => { 154 => 'Make' },
	'extendermodel' => { 154 => 'Model', 284 => 0x303 },
	'extenderserialnumber' => { 154 => 'SerialNumber', 284 => 0x302 },
	'extenderstatus' => { 339 => 0x3 },
	'externalflash' => { 286 => 0x1201 },
	'externalflashae1' => { 288 => 0x101f },
	'externalflashae1_0' => { 288 => 0x101b },
	'externalflashae2' => { 288 => 0x1020 },
	'externalflashae2_0' => { 288 => 0x101c },
	'externalflashbounce' => { 286 => 0x1204, 288 => 0x1026, 329 => 0x1a },
	'externalflashcompensation' => { 205 => 0x1b },
	'externalflashexposurecomp' => { 219 => 0x17, 329 => 0x19 },
	'externalflashfirmware' => { 203 => 0x6, 204 => 0x6, 205 => 0x6, 206 => 0x6, 207 => 0x6 },
	'externalflashflags' => { 203 => 0x8, 204 => 0x8, 205 => 0x8, 206 => 0x8 },
	'externalflashguidenumber' => { 286 => 0x1203, 329 => '24.1' },
	'externalflashgvalue' => { 288 => 0x1025 },
	'externalflashmode' => { 288 => 0x1028, 329 => 0x2 },
	'externalflashreadystate' => { 207 => '9.1' },
	'externalflashstatus' => { 207 => '8.2' },
	'externalflashzoom' => { 286 => 0x1205, 288 => 0x1027 },
	'externalflashzoomoverride' => { 207 => '8.1' },
	'externalmetadatalink' => { 474 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 301 => 0x311, 304 => 0x311, 305 => 0x311, 308 => 0x3408 },
	'extrainfoversion' => { 397 => 0x1a },
	'eyestartaf' => { 179 => 0x40 },
	'fac100per' => { 134 => 0xe94 },
	'fac170per' => { 134 => 0xe93 },
	'fac18per' => { 134 => 0xe92 },
	'face10position' => { 107 => 0x3f4, 108 => 0x1ec, 201 => 0x28, 326 => 0x12 },
	'face10size' => { 327 => 0x12 },
	'face11position' => { 201 => 0x2c, 326 => 0x14 },
	'face11size' => { 327 => 0x14 },
	'face12position' => { 201 => 0x30, 326 => 0x16 },
	'face12size' => { 327 => 0x16 },
	'face13position' => { 326 => 0x18 },
	'face13size' => { 327 => 0x18 },
	'face14position' => { 326 => 0x1a },
	'face14size' => { 327 => 0x1a },
	'face15position' => { 326 => 0x1c },
	'face15size' => { 327 => 0x1c },
	'face16position' => { 326 => 0x1e },
	'face16size' => { 327 => 0x1e },
	'face17position' => { 326 => 0x20 },
	'face17size' => { 327 => 0x20 },
	'face18position' => { 326 => 0x22 },
	'face18size' => { 327 => 0x22 },
	'face19position' => { 326 => 0x24 },
	'face19size' => { 327 => 0x24 },
	'face1position' => { 52 => 0x8, 107 => 0xd, 108 => 0x18, 201 => 0x4, 298 => 0x1, 326 => 0x0, 370 => 0xbc, 400 => 0x1, 401 => 0x0, 402 => 0x0, 403 => 0x5b },
	'face1size' => { 327 => 0x0 },
	'face20position' => { 326 => 0x26 },
	'face20size' => { 327 => 0x26 },
	'face21position' => { 326 => 0x28 },
	'face21size' => { 327 => 0x28 },
	'face22position' => { 326 => 0x2a },
	'face22size' => { 327 => 0x2a },
	'face23position' => { 326 => 0x2c },
	'face23size' => { 327 => 0x2c },
	'face24position' => { 326 => 0x2e },
	'face24size' => { 327 => 0x2e },
	'face25position' => { 326 => 0x30 },
	'face25size' => { 327 => 0x30 },
	'face26position' => { 326 => 0x32 },
	'face26size' => { 327 => 0x32 },
	'face27position' => { 326 => 0x34 },
	'face27size' => { 327 => 0x34 },
	'face28position' => { 326 => 0x36 },
	'face28size' => { 327 => 0x36 },
	'face29position' => { 326 => 0x38 },
	'face29size' => { 327 => 0x38 },
	'face2position' => { 52 => 0xa, 107 => 0x7c, 108 => 0x4c, 201 => 0x8, 298 => 0x5, 326 => 0x2, 370 => 0xc8, 400 => 0x6, 401 => 0x20, 402 => 0x25, 403 => 0x65 },
	'face2size' => { 327 => 0x2 },
	'face30position' => { 326 => 0x3a },
	'face30size' => { 327 => 0x3a },
	'face31position' => { 326 => 0x3c },
	'face31size' => { 327 => 0x3c },
	'face32position' => { 326 => 0x3e },
	'face32size' => { 327 => 0x3e },
	'face3position' => { 52 => 0xc, 107 => 0xeb, 108 => 0x80, 201 => 0xc, 298 => 0x9, 326 => 0x4, 370 => 0xd4, 400 => 0xb, 401 => 0x40, 402 => 0x4a, 403 => 0x6f },
	'face3size' => { 327 => 0x4 },
	'face4position' => { 52 => 0xe, 107 => 0x15a, 108 => 0xb4, 201 => 0x10, 298 => 0xd, 326 => 0x6, 370 => 0xe0, 400 => 0x10, 401 => 0x60, 402 => 0x6f, 403 => 0x79 },
	'face4size' => { 327 => 0x6 },
	'face5position' => { 52 => 0x10, 107 => 0x1c9, 108 => 0xe8, 201 => 0x14, 298 => 0x11, 326 => 0x8, 370 => 0xec, 400 => 0x15, 401 => 0x80, 402 => 0x94 },
	'face5size' => { 327 => 0x8 },
	'face6position' => { 52 => 0x12, 107 => 0x238, 108 => 0x11c, 201 => 0x18, 326 => 0xa, 370 => 0xf8, 400 => 0x1a, 401 => 0xa0, 402 => 0xb9 },
	'face6size' => { 327 => 0xa },
	'face7position' => { 52 => 0x14, 107 => 0x2a7, 108 => 0x150, 201 => 0x1c, 326 => 0xc, 370 => 0x104, 400 => 0x1f, 401 => 0xc0, 402 => 0xde },
	'face7size' => { 327 => 0xc },
	'face8position' => { 52 => 0x16, 107 => 0x316, 108 => 0x184, 201 => 0x20, 326 => 0xe, 370 => 0x110, 400 => 0x24, 401 => 0xe0, 402 => 0x103 },
	'face8size' => { 327 => 0xe },
	'face9position' => { 52 => 0x18, 107 => 0x385, 108 => 0x1b8, 201 => 0x24, 326 => 0x10 },
	'face9size' => { 327 => 0x10 },
	'facebalanceorigi' => { 456 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 456 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 456 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 456 => 'FaceBalanceWarmth' },
	'facedetect' => { 341 => 0x76, 380 => 0x100 },
	'facedetectarea' => { 287 => 0x1201 },
	'facedetectframecrop' => { 287 => 0x1207 },
	'facedetectframesize' => { 52 => 0x3, 107 => 0x1, 108 => 0x4, 201 => 0x1, 287 => 0x1203, 341 => 0x77, 370 => 0xb6 },
	'facedetection' => { 395 => 0x30, 411 => 0x19 },
	'faceelementpositions' => { 124 => 0x4203 },
	'faceelementselected' => { 124 => 0x4005 },
	'faceelementtypes' => { 124 => 0x4201 },
	'faceid' => { 458 => 'FaceID' },
	'faceinfounknown' => { 110 => 0x2089 },
	'facename' => { 380 => 0x123 },
	'faceorientation' => { 108 => 0x8 },
	'faceposition' => { 325 => 0x2, 381 => 0x4 },
	'facepositions' => { 124 => 0x4103 },
	'facerecognition' => { 380 => 0x120 },
	'facesdetected' => { 52 => 0x2, 53 => 0x2, 54 => 0x3, 107 => 0x0, 108 => 0x2, 110 => 0x211c, 124 => 0x4100, 201 => 0x3, 287 => 0x1200, 306 => 0x3f, 325 => 0x0, 370 => 0xb5, 381 => 0x0, 400 => 0x0, 403 => 0x3, 413 => 0x30 },
	'facesrecognized' => { 299 => 0x0 },
	'facewidth' => { 53 => 0x1 },
	'faithfuloutputhighlightpoint' => { 106 => 0x38 },
	'faithfuloutputshadowpoint' => { 106 => 0x39 },
	'faithfulrawcolortone' => { 106 => 0x31 },
	'faithfulrawcontrast' => { 106 => 0x33 },
	'faithfulrawhighlight' => { 106 => 0x79 },
	'faithfulrawhighlightpoint' => { 106 => 0x36 },
	'faithfulrawlinear' => { 106 => 0x34 },
	'faithfulrawsaturation' => { 106 => 0x32 },
	'faithfulrawshadow' => { 106 => 0x82 },
	'faithfulrawshadowpoint' => { 106 => 0x37 },
	'faithfulrawsharpness' => { 106 => 0x35 },
	'faithfulunsharpmaskfineness' => { 106 => 0xac },
	'faithfulunsharpmaskstrength' => { 106 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 106 => 0xae },
	'far' => { 447 => 'Far' },
	'fastresetlinetime' => { 134 => 0x1860 },
	'feedidentifier' => { 474 => 'FeedIdentifier' },
	'femicroadjustment' => { 81 => 0x111 },
	'ffid' => { 466 => 'ffid' },
	'field' => { 477 => 'field' },
	'fieldcount' => { 288 => 0x103f },
	'fieldofview' => { 366 => "FOV\x00" },
	'fifoenonepixeldelay' => { 134 => 0x1901 },
	'filecreatedate' => { 117 => 'FileCreateDate' },
	'filedatarate' => { 488 => 'fileDataRate' },
	'fileformat' => { 92 => 0x0, 129 => 0x14, 383 => [0x22,0x26], 406 => 0xb000 },
	'filegroupid' => { 117 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 307 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 117 => 'FileModifyDate' },
	'filename' => { 117 => 'FileName' },
	'filenameasdelivered' => { 293 => 'FileNameAsDelivered' },
	'filenumber' => { 55 => 0x1, 61 => 0x8, 94 => 0x1817, 111 => 'Canon::FileNumber', 202 => 0x4, 369 => 0x10 },
	'filenumbermemory' => { 176 => 0x1a },
	'filenumbersequence' => { 266 => '12.2', 271 => '3.1', 272 => '4.1', 273 => '4.1', 275 => '11.1', 276 => '4.3', 281 => '5.2' },
	'filepermissions' => { 117 => 'FilePermissions' },
	'filesource' => { 116 => 0xa300, 124 => 0x8000, 468 => 'FileSource' },
	'fileuserid' => { 117 => 'FileUserID' },
	'fileversion' => { 129 => 0x16 },
	'fillflashautoreduction' => { 79 => 0xe, 80 => 0xe, 87 => 0xa },
	'filllight' => { 462 => 'FillLight', 464 => 'FillLight' },
	'fillorder' => { 116 => 0x10a },
	'filmgraineffect' => { 283 => 0x538 },
	'filmmode' => { 124 => 0x1401, 303 => 0x412, 306 => 0x42 },
	'filmtype' => { 227 => 0x2 },
	'filtereffect' => { 55 => 0xe, 221 => 0x37, 222 => 0x3f, 223 => 0x47 },
	'filtereffectauto' => { 68 => 0xa0 },
	'filtereffectfaithful' => { 67 => 0x70, 68 => 0x70 },
	'filtereffectlandscape' => { 67 => 0x40, 68 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 67 => 0x88, 68 => 0x88 },
	'filtereffectneutral' => { 67 => 0x58, 68 => 0x58 },
	'filtereffectportrait' => { 67 => 0x28, 68 => 0x28 },
	'filtereffectstandard' => { 67 => 0x10, 68 => 0x10 },
	'filtereffectuserdef1' => { 67 => 0xa0, 68 => 0xb8 },
	'filtereffectuserdef2' => { 67 => 0xb8, 68 => 0xd0 },
	'filtereffectuserdef3' => { 67 => 0xd0, 68 => 0xe8 },
	'finderdisplayduringexposure' => { 80 => 0x1 },
	'finesharpness' => { 341 => 0x70 },
	'finetuneoptcenterweighted' => { 266 => '7.2', 267 => '9.1', 269 => '9.1', 270 => '9.1', 274 => '8.1', 279 => '9.1', 280 => '9.1', 281 => '9.1' },
	'finetuneopthighlightweighted' => { 269 => '46.1', 270 => '46.1', 279 => '46.1', 280 => '46.1' },
	'finetuneoptmatrixmetering' => { 266 => '8.1', 267 => '8.2', 269 => '8.2', 270 => '8.2', 274 => '7.2', 275 => '6.1', 279 => '8.2', 280 => '8.2', 281 => '8.2' },
	'finetuneoptspotmetering' => { 266 => '8.2', 267 => '9.2', 269 => '9.2', 270 => '9.2', 274 => '8.2', 275 => '6.2', 279 => '9.2', 280 => '9.2', 281 => '9.2' },
	'finishexposure' => { 134 => 0xdbd },
	'finishfiletype' => { 134 => 0xdb8 },
	'finishlook' => { 134 => 0xdbc },
	'finishnoise' => { 134 => 0xdba },
	'finishresolution' => { 134 => 0xdb9 },
	'finishsharpening' => { 134 => 0xdbb },
	'firmware' => { 288 => 0x405, 383 => [0x8c,0x17,0x3b], 459 => 'Firmware' },
	'firmware2' => { 383 => 0x57 },
	'firmwaredate' => { 109 => 0x15, 110 => 0x2001, 367 => 0x4, 369 => 0x30 },
	'firmwareid' => { 183 => 0x0 },
	'firmwarename' => { 380 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 61 => 0x1e, 371 => 0x0 },
	'firmwarerevision2' => { 371 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 134 => [0x415,0xce5], 150 => 0x57, 152 => 'FirmwareVersion', 304 => 0x320, 306 => 0x2, 308 => 0x3109, 341 => 0x230, 366 => ['CNFV','FIRM'], 368 => 0x18, 369 => 0x2a, 373 => 0x2 },
	'firmwareversions' => { 350 => 0x301 },
	'firstphotodate' => { 450 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 293 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 128 => 0x16, 457 => 'FixtureIdentifier' },
	'flash' => { 111 => 'XMP::Flash', 116 => 0x9209, 148 => 0x22, 177 => 0x1f, 178 => 0x15, 369 => 0x5a, 468 => 'Flash' },
	'flashaction' => { 393 => 0x3e, 394 => 0x3e, 406 => 0x2017, 411 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 393 => 0x4c, 394 => 0x4c, 411 => 0x77 },
	'flashactionexternal' => { 411 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 42 => 0x249 },
	'flashbias' => { 306 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashbuttonfunction' => { 81 => 0x70e },
	'flashchargelevel' => { 288 => 0x1010 },
	'flashcolorfilter' => { 205 => 0x10, 206 => 0x10 },
	'flashcommandermode' => { 203 => '9.1', 204 => '9.1', 205 => '9.1', 206 => '9.1' },
	'flashcompensation' => { 134 => 0x3f3, 203 => 0xa, 204 => 0xa, 205 => 0xa, 206 => 0x27, 207 => 0xa, 459 => 'FlashCompensation' },
	'flashcontrol' => { 393 => 0x23, 394 => 0x1f, 395 => 0x21 },
	'flashcontrolbuilt-in' => { 275 => '16.1', 276 => '23.1', 278 => '23.1', 279 => '24.1' },
	'flashcontrolmode' => { 203 => '9.2', 204 => '9.2', 205 => '9.2', 206 => '9.2', 283 => 0x404 },
	'flashcurtain' => { 306 => 0x48 },
	'flashdefault' => { 179 => 0x42 },
	'flashdevice' => { 288 => 0x1005 },
	'flashdistance' => { 110 => 0x2034 },
	'flashenergy' => { 116 => 0xa20b, 468 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 219 => 0x18 },
	'flashexposurecomp' => { 74 => 0xf, 124 => 0x1011, 155 => 'ExposureComp', 176 => 0x23, 181 => 0x104, 182 => 0x49c1, 219 => 0x12, 283 => 0x401, 288 => 0x1023, 341 => 0x4d, 373 => 0x100b, 383 => [0x3a,0x56], 406 => 0x104 },
	'flashexposurecomp2' => { 245 => 0x4d2 },
	'flashexposurecomp3' => { 205 => 0x1d },
	'flashexposurecomp4' => { 205 => 0x27 },
	'flashexposurecomparea' => { 267 => '38.4', 269 => '38.4', 270 => '38.4', 279 => '38.4', 280 => '38.4' },
	'flashexposurecompset' => { 179 => 0x10, 314 => 0xe, 393 => 0x14, 394 => 0x12, 395 => 0x23, 411 => 0x1f },
	'flashexposurecompset2' => { 411 => [0x26,0x2c] },
	'flashexposureindicator' => { 179 => 0x54 },
	'flashexposureindicatorlast' => { 179 => 0x56 },
	'flashexposureindicatornext' => { 179 => 0x55 },
	'flashexposurelock' => { 55 => 0x19 },
	'flashfired' => { 136 => 0x5d, 155 => 'Fired', 176 => 0x14, 244 => '590.3', 468 => [\'Flash','FlashFired'] },
	'flashfiring' => { 81 => 0x306, 82 => 0x6, 83 => 0x7, 86 => 0x7 },
	'flashfirmwareversion' => { 284 => 0x1002 },
	'flashfocallength' => { 203 => 0xb, 204 => 0xc, 205 => 0xc, 206 => 0xc, 207 => 0xc },
	'flashfunction' => { 182 => 0x31, 468 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 203 => 0xe, 204 => 0xf, 205 => 0xf, 206 => 0xf, 207 => 0xf },
	'flashgroupacompensation' => { 203 => 0x11, 204 => 0x12, 205 => 0x13, 206 => 0x28, 207 => 0x28 },
	'flashgroupacontrolmode' => { 203 => 0xf, 204 => '16.1', 205 => '17.1', 206 => '17.1', 207 => '17.1' },
	'flashgroupaoutput' => { 203 => 0x11, 204 => 0x12, 205 => 0x13, 206 => 0x28, 207 => 0x28 },
	'flashgroupbcompensation' => { 203 => 0x12, 204 => 0x13, 205 => 0x14, 206 => 0x29, 207 => 0x29 },
	'flashgroupbcontrolmode' => { 203 => 0x10, 204 => '17.1', 205 => '18.1', 206 => '18.1', 207 => '18.1' },
	'flashgroupboutput' => { 203 => 0x12, 204 => 0x13, 205 => 0x14, 206 => 0x29, 207 => 0x29 },
	'flashgroupccompensation' => { 204 => 0x14, 205 => 0x15, 206 => 0x2a, 207 => 0x2a },
	'flashgroupccontrolmode' => { 204 => '17.2', 205 => '18.2', 206 => '18.2', 207 => '18.2' },
	'flashgroupcoutput' => { 204 => 0x14, 205 => 0x15, 206 => 0x2a, 207 => 0x2a },
	'flashguidenumber' => { 74 => 0xd, 91 => 0x0, 155 => 'GuideNumber' },
	'flashintensity' => { 109 => [0x19,0x5], 283 => 0x405 },
	'flashlevel' => { 268 => 0x9, 406 => 0xb048 },
	'flashmake' => { 155 => 'Make' },
	'flashmanufacturer' => { 174 => 'FlashManufacturer' },
	'flashmetering' => { 176 => 0x3f, 179 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 341 => 0x20a },
	'flashmode' => { 109 => 0x4, 134 => 0x3f2, 136 => 0x5c, 147 => 0x27, 155 => 'Mode', 176 => 0x2, 177 => 0x20, 178 => 0x16, 179 => 0xf, 219 => 0x87, 283 => 0x400, 288 => 0x1004, 341 => 0xc, 348 => 0x4, 372 => 0x20, 373 => 0x100a, 382 => 0x225, 393 => 0x13, 394 => 0x7f, 395 => 0x20, 411 => 0x10, 414 => 0x1138, 415 => 0x1138, 416 => 0x1114, 417 => 0x1190, 418 => 0x116c, 419 => 0x1024, 420 => 0x21c, 421 => 0x21c, 422 => 0x211, 468 => [\'Flash','FlashMode'] },
	'flashmodel' => { 155 => 'Model', 174 => 'FlashModel', 284 => 0x1001 },
	'flashoptions' => { 322 => 0x2 },
	'flashoptions2' => { 322 => 0x10 },
	'flashoutput' => { 42 => 0x248, 74 => 0x21, 203 => 0xa, 204 => 0xa, 205 => 0xa, 206 => 0x27 },
	'flashpixversion' => { 116 => 0xa000, 468 => 'FlashpixVersion' },
	'flashredeyemode' => { 468 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 283 => 0x403 },
	'flashreturn' => { 468 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 155 => 'SerialNumber', 284 => 0x1003 },
	'flashsetting' => { 219 => 0x8 },
	'flashshutterspeed' => { 266 => '20.2', 267 => '23.2', 269 => '23.2', 270 => '23.2', 275 => '15.2', 276 => '22.2', 277 => '7.2', 278 => '22.2', 279 => '23.2', 280 => '23.2', 281 => '23.1' },
	'flashsource' => { 203 => 0x4, 204 => 0x4, 205 => 0x4, 206 => 0x4, 207 => 0x4 },
	'flashstatus' => { 329 => 0x0, 411 => [0x82,0x86], 424 => 0x31, 425 => 0x39 },
	'flashstatusbuilt-in' => { 395 => [0x87,0x287] },
	'flashstatusexternal' => { 395 => [0x88,0x288] },
	'flashsyncspeed' => { 266 => '20.1', 267 => '23.1', 269 => '23.1', 270 => '23.1', 275 => '15.1', 276 => '22.1', 278 => '22.1', 279 => '23.1', 280 => '23.1' },
	'flashsyncspeedav' => { 79 => 0x3, 81 => 0x10f, 82 => 0x2, 83 => 0x3, 84 => 0x2, 85 => 0x2, 86 => 0x3, 87 => 0x6 },
	'flashthreshold' => { 91 => 0x1 },
	'flashtype' => { 155 => 'Type', 179 => 0x59, 219 => 0x9, 284 => 0x1000 },
	'flashwarning' => { 276 => '30.1', 277 => '7.1', 281 => '31.1', 306 => 0x62 },
	'flexiblespotposition' => { 406 => 0x201d },
	'flickerreduce' => { 382 => 0x218 },
	'flickerreduction' => { 124 => 0x1446, 238 => 0xe84 },
	'flickerreductionindicator' => { 238 => 0x5e2 },
	'flightpitchdegree' => { 113 => 'FlightPitchDegree' },
	'flightrolldegree' => { 113 => 'FlightRollDegree' },
	'flightxspeed' => { 113 => 'FlightXSpeed' },
	'flightyawdegree' => { 113 => 'FlightYawDegree' },
	'flightyspeed' => { 113 => 'FlightYSpeed' },
	'flightzspeed' => { 113 => 'FlightZSpeed' },
	'fliphorizontal' => { 259 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 74 => 0x15, 116 => 0x829d, 133 => 0xfd04, 136 => 0x1e, 138 => 0xfa23, 140 => 0xf103, 143 => 0x13, 145 => 0x3c, 147 => 0x1c, 148 => 0x18, 150 => 0xc, 159 => 'FNumber', 176 => 0xa, 177 => 0x36, 178 => 0x47, 179 => 0x9, 182 => 0x49c7, 217 => 0x38, 341 => 0x13, 380 => 0xa019, 383 => [0x31,0x49], 393 => 0x1, 394 => 0x1, 411 => [0x20,0x22,0x26], 468 => 'FNumber' },
	'focaldistance' => { 448 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 57 => 0x1, 110 => 0x1d, 116 => 0x920a, 143 => 0x1d, 159 => 'FocalLength', 176 => 0x12, 212 => 0xa, 213 => 0xb, 217 => [0xc,0x3c], 300 => 0x1, 341 => 0x1d, 350 => 0x403, 373 => 0x1500, 392 => 0xe, 418 => 0x1278, 419 => 0x1134, 420 => 0x32c, 421 => 0x32c, 422 => 0x30a, 468 => 'FocalLength' },
	'focallength2' => { 411 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 116 => 0xa405, 380 => 0xa01a, 468 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 392 => 0x10 },
	'focalplaneafpointarea' => { 423 => 0x2 },
	'focalplaneafpointlocation1' => { 423 => 0x6 },
	'focalplaneafpointlocation10' => { 423 => 0x2a },
	'focalplaneafpointlocation11' => { 423 => 0x2e },
	'focalplaneafpointlocation12' => { 423 => 0x32 },
	'focalplaneafpointlocation13' => { 423 => 0x36 },
	'focalplaneafpointlocation14' => { 423 => 0x3a },
	'focalplaneafpointlocation15' => { 423 => 0x3e },
	'focalplaneafpointlocation2' => { 423 => 0xa },
	'focalplaneafpointlocation3' => { 423 => 0xe },
	'focalplaneafpointlocation4' => { 423 => 0x12 },
	'focalplaneafpointlocation5' => { 423 => 0x16 },
	'focalplaneafpointlocation6' => { 423 => 0x1a },
	'focalplaneafpointlocation7' => { 423 => 0x1e },
	'focalplaneafpointlocation8' => { 423 => 0x22 },
	'focalplaneafpointlocation9' => { 423 => 0x26 },
	'focalplaneafpointsused' => { 423 => 0x1 },
	'focalplanediagonal' => { 284 => 0x103, 288 => 0x205 },
	'focalplaneresolutionunit' => { 116 => 0xa210, 468 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 116 => 0xa20e, 468 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 57 => 0x2 },
	'focalplanexunknown' => { 57 => 0x2 },
	'focalplaneyresolution' => { 116 => 0xa20f, 468 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 57 => 0x3 },
	'focalplaneyunknown' => { 57 => 0x3 },
	'focalpointx' => { 448 => 'FocalPointX' },
	'focalpointy' => { 448 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 57 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 249 => 0x8 },
	'focusarea' => { 176 => 0x31 },
	'focusareaselection' => { 277 => '15.2' },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 81 => 0x515 },
	'focusdistance' => { 159 => 'FocusDistance', 176 => 0x13, 182 => 0x49bb, 212 => 0x9, 213 => 0xa, 217 => [0xb,0x4f], 286 => 0x305, 300 => 0x0, 304 => 0x304, 305 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 55 => 0x15, 74 => 0x14 },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 55 => 0x14, 74 => 0x13 },
	'focusholdbutton' => { 179 => 0x44 },
	'focusinfoversion' => { 286 => 0x0 },
	'focusingscreen' => { 80 => 0x0, 81 => 0x80b, 86 => 0x0 },
	'focuslocation' => { 406 => 0x2027 },
	'focuslocked' => { 175 => 0x14 },
	'focusmode' => { 34 => 0x7, 109 => 0x3, 110 => [0x3003,0xd], 124 => 0x1021, 134 => 0x3f5, 136 => 0x38, 152 => 'FocusMode', 176 => 0x30, 178 => 0xe, 179 => 0xc, 219 => 0x7, 283 => 0x301, 288 => 0x100b, 306 => 0x7, 341 => 0xd, 348 => 0x3, 373 => 0x1006, 386 => [0xb,0x5], 392 => [0x15,0x1d], 393 => 0x4d, 394 => 0x4d, 406 => [0xb042,0xb04e,0x201b], 411 => 0x13, 429 => 0x16 },
	'focusmode2' => { 123 => '0.1', 322 => '3.1', 411 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 268 => '10.1', 390 => 0x14, 391 => 0x15, 393 => 0x10, 394 => 0xf, 395 => 0x6 },
	'focusmodeswitch' => { 179 => 0x58, 393 => 0x2e },
	'focuspixel' => { 124 => 0x1023 },
	'focuspointwrap' => { 266 => '2.2', 267 => '2.2', 269 => '2.1', 270 => '2.1', 274 => '1.1', 275 => '2.2', 276 => '1.1', 279 => '2.2', 280 => '2.1', 281 => '2.5' },
	'focusposition' => { 212 => 0x8, 213 => 0x8, 217 => 0x9, 341 => 0x10, 404 => 0x9bb },
	'focusposition2' => { 411 => [0x29,0x2b,0x2f], 429 => 0x2d, 432 => 0x20 },
	'focusprocess' => { 283 => 0x302 },
	'focusrange' => { 34 => 0x12, 288 => 0x100a },
	'focusrangeindex' => { 332 => '3.1' },
	'focusringrotation' => { 81 => 0x713 },
	'focussetting' => { 383 => 0x6 },
	'focusstatus' => { 392 => 0x19, 393 => 0x53, 394 => 0x53 },
	'focusstepcount' => { 286 => 0x301, 288 => 0x100e },
	'focusstepinfinity' => { 286 => 0x303, 288 => 0x103b },
	'focusstepnear' => { 286 => 0x304, 288 => 0x103c },
	'focustrackinglockon' => { 266 => ['1.5','4.1'], 267 => '1.4', 274 => '0.4', 275 => '3.1', 276 => '0.4', 279 => '1.4' },
	'focuswarning' => { 124 => 0x1301 },
	'foldername' => { 176 => 0x27 },
	'foldernumber' => { 393 => 0x9a, 395 => [0x402,0x114,0x316] },
	'fontcomposite' => { 493 => [\'Fonts','FontsComposite'] },
	'fontface' => { 493 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 493 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 493 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 493 => [\'Fonts','FontsFontName'] },
	'fonts' => { 493 => 'Fonts' },
	'fonttype' => { 493 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 493 => [\'Fonts','FontsVersionString'] },
	'for' => { 357 => 'For' },
	'forcewrite' => { 117 => 'ForceWrite' },
	'format' => { 366 => "\xa9fmt", 447 => 'Format', 465 => 'format', 486 => 'Format' },
	'forwardlock' => { 483 => 'forwardlock' },
	'forwardmatrix1' => { 116 => 0xc714 },
	'forwardmatrix2' => { 116 => 0xc715 },
	'fossilspecimen' => { 115 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 115 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 64 => [0x2,0x4] },
	'frameheight' => { 124 => 0x3822 },
	'framenum' => { 352 => 0xd7 },
	'framenumber' => { 124 => 0x8003, 182 => 0x3c, 341 => 0x29 },
	'framerate' => { 64 => [0x1,0x6], 116 => 0xc764, 124 => 0x3820 },
	'framereadouttime' => { 360 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 124 => 0x3821 },
	'framing' => { 477 => 'framing' },
	'freebytes' => { 94 => 0x1 },
	'freememorycardimages' => { 177 => [0x37,0x54], 178 => [0x2d,0x4a], 179 => 0x32 },
	'fujiflashmode' => { 124 => 0x1010 },
	'fullhdhighspeedrec' => { 124 => 0x3824 },
	'fullimagesize' => { 406 => 0xb02b },
	'fullpanoheightpixels' => { 450 => 'FullPanoHeightPixels', 451 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 450 => 'FullPanoWidthPixels', 451 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 373 => 0x100d },
	'fullsizeimage' => { 158 => 'data' },
	'fullsizeimagename' => { 158 => '1Name' },
	'fullsizeimagetype' => { 158 => '0Type' },
	'func1button' => { 269 => '14.1', 270 => '14.1', 280 => '14.1' },
	'func1buttonplusdials' => { 269 => '42.1', 270 => '42.1', 280 => '42.1' },
	'func2button' => { 269 => '80.1', 270 => '80.1', 280 => '80.1' },
	'func2buttonplusdials' => { 269 => '81.1' },
	'func3button' => { 269 => '83.1' },
	'funcbutton' => { 266 => ['14.1','15.1'], 267 => '14.1', 275 => '28.1', 276 => '13.1', 279 => '14.1', 281 => '14.1' },
	'funcbuttonplusdials' => { 266 => ['14.2','15.2'], 267 => '14.2', 275 => '31.1', 279 => '42.1' },
	'functionbutton' => { 273 => '13.1', 277 => '5.2' },
	'gainbase' => { 287 => 0x610 },
	'gaincontrol' => { 116 => 0xa407, 468 => 'GainControl' },
	'gamma' => { 116 => 0xa500, 134 => 0x8fe, 311 => 0x11c, 469 => 'Gamma' },
	'gammablackpoint' => { 102 => 0xc },
	'gammacolortone' => { 102 => 0x3 },
	'gammacompensatedvalue' => { 130 => 0x91 },
	'gammacontrast' => { 102 => 0x2 },
	'gammacurveoutputrange' => { 102 => 0xf },
	'gammahighlight' => { 102 => 0xa },
	'gammalinear' => { 100 => 0x20200 },
	'gammamidpoint' => { 102 => 0xe },
	'gammasaturation' => { 102 => 0x4 },
	'gammashadow' => { 102 => 0x9 },
	'gammasharpnessstrength' => { 102 => 0x8 },
	'gammaunsharpmaskfineness' => { 102 => 0x6 },
	'gammaunsharpmaskstrength' => { 102 => 0x5 },
	'gammaunsharpmaskthreshold' => { 102 => 0x7 },
	'gammawhitepoint' => { 102 => 0xd },
	'gdalmetadata' => { 116 => 0xa480 },
	'gdalnodata' => { 116 => 0xa481 },
	'geimagesize' => { 124 => 0x1304 },
	'gemake' => { 126 => 0x300 },
	'gemodel' => { 126 => 0x207 },
	'genre' => { 358 => ['gnre',"\xa9gen"], 360 => 'genre', 366 => ['gnre',"\xa9gen"], 474 => 'Genre', 478 => 'genre', 488 => 'genre' },
	'genrecvid' => { 474 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 474 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 474 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 474 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 358 => 'geID' },
	'geography' => { 479 => 'geography' },
	'geologicalcontext' => { 115 => 'GeologicalContext' },
	'geologicalcontextbed' => { 115 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 115 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 115 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 115 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 115 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 117 => 'Geosync' },
	'geotag' => { 117 => 'Geotag' },
	'geotiffasciiparams' => { 116 => 0x87b1 },
	'geotiffdirectory' => { 116 => 0x87af },
	'geotiffdoubleparams' => { 116 => 0x87b0 },
	'geotime' => { 117 => 'Geotime' },
	'giftftppriority' => { 452 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 113 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 113 => 'GimbalReverse' },
	'gimbalrolldegree' => { 113 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 113 => 'GimbalYawDegree' },
	'globalaltitude' => { 355 => 0x419 },
	'globalangle' => { 355 => 0x40d },
	'good' => { 488 => 'good' },
	'googlehostheader' => { 358 => 'gshh' },
	'googlepingmessage' => { 358 => 'gspm' },
	'googlepingurl' => { 358 => 'gspu' },
	'googleplusuploadcode' => { 116 => 0x9009 },
	'googlesourcedata' => { 358 => 'gssd' },
	'googlestarttime' => { 358 => 'gsst' },
	'googletrackduration' => { 358 => 'gstd' },
	'goprotype' => { 366 => 'GoPr' },
	'gpsaltitude' => { 127 => 0x6, 156 => 'Altitude', 468 => 'GPSAltitude' },
	'gpsaltituderef' => { 127 => 0x5, 468 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 127 => 0x1c, 468 => 'GPSAreaInformation' },
	'gpscoordinates' => { 360 => 'location.ISO6709', 366 => "\xa9xyz" },
	'gpsdatestamp' => { 127 => 0x1d },
	'gpsdatetime' => { 156 => 'DateTime', 468 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 127 => 0x18, 156 => 'Bearing', 468 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 127 => 0x17, 468 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 127 => 0x1a, 156 => 'Distance', 468 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 127 => 0x19, 468 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 127 => 0x14, 468 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 127 => 0x13 },
	'gpsdestlongitude' => { 127 => 0x16, 468 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 127 => 0x15 },
	'gpsdifferential' => { 127 => 0x1e, 156 => 'Differential', 468 => 'GPSDifferential' },
	'gpsdop' => { 127 => 0xb, 468 => 'GPSDOP' },
	'gpshpositioningerror' => { 127 => 0x1f, 468 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 127 => 0x11, 468 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 127 => 0x10, 468 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 113 => 'GpsLatitude', 127 => 0x2, 156 => 'Latitude', 468 => 'GPSLatitude' },
	'gpslatituderef' => { 127 => 0x1 },
	'gpslongitude' => { 113 => 'GpsLongitude', 127 => 0x4, 156 => 'Longitude', 468 => 'GPSLongitude' },
	'gpslongituderef' => { 127 => 0x3 },
	'gpslongtitude' => { 113 => 'GpsLongtitude' },
	'gpsmapdatum' => { 127 => 0x12, 156 => 'Datum', 468 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 127 => 0xa, 156 => 'MeasureMode', 468 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 127 => 0x1b, 468 => 'GPSProcessingMethod' },
	'gpssatellites' => { 127 => 0x8, 156 => 'Satellites', 468 => 'GPSSatellites' },
	'gpsspeed' => { 127 => 0xd, 156 => 'Speed', 468 => 'GPSSpeed' },
	'gpsspeedref' => { 127 => 0xc, 468 => 'GPSSpeedRef' },
	'gpsstatus' => { 127 => 0x9, 468 => 'GPSStatus' },
	'gpsstring' => { 134 => 0x402 },
	'gpstimestamp' => { 127 => 0x7 },
	'gpstrack' => { 127 => 0xf, 156 => 'Heading', 468 => 'GPSTrack' },
	'gpstrackref' => { 127 => 0xe, 468 => 'GPSTrackRef' },
	'gpsversionid' => { 127 => 0x0, 468 => 'GPSVersionID' },
	'gradation' => { 283 => 0x50f },
	'gradientbasedcorractive' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 462 => 'GradientBasedCorrections', 464 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 462 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 464 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 462 => 'GrainAmount', 464 => 'GrainAmount' },
	'graineffect' => { 124 => 0x1047 },
	'grainfrequency' => { 462 => 'GrainFrequency', 464 => 'GrainFrequency' },
	'grainsize' => { 462 => 'GrainSize', 464 => 'GrainSize' },
	'graymixeraqua' => { 462 => 'GrayMixerAqua', 464 => 'GrayMixerAqua' },
	'graymixerblue' => { 462 => 'GrayMixerBlue', 464 => 'GrayMixerBlue' },
	'graymixergreen' => { 462 => 'GrayMixerGreen', 464 => 'GrayMixerGreen' },
	'graymixermagenta' => { 462 => 'GrayMixerMagenta', 464 => 'GrayMixerMagenta' },
	'graymixerorange' => { 462 => 'GrayMixerOrange', 464 => 'GrayMixerOrange' },
	'graymixerpurple' => { 462 => 'GrayMixerPurple', 464 => 'GrayMixerPurple' },
	'graymixerred' => { 462 => 'GrayMixerRed', 464 => 'GrayMixerRed' },
	'graymixeryellow' => { 462 => 'GrayMixerYellow', 464 => 'GrayMixerYellow' },
	'graypoint' => { 439 => 0x8021 },
	'grayresponseunit' => { 116 => 0x122 },
	'greencurvelimits' => { 105 => 0x1c4 },
	'greencurvepoints' => { 104 => 0x53, 105 => 0x19a },
	'greenhsl' => { 100 => 0x20913 },
	'greenhue' => { 462 => 'GreenHue', 464 => 'GreenHue' },
	'greensaturation' => { 462 => 'GreenSaturation', 464 => 'GreenSaturation' },
	'griddisplay' => { 266 => '13.3', 267 => '4.3', 269 => '4.2', 270 => '4.2', 271 => '2.2', 275 => '10.5', 276 => '3.4', 277 => '6.1', 279 => '4.4', 280 => '4.2', 281 => '4.2' },
	'gripbatteryadload' => { 320 => 0x5 },
	'gripbatteryadnoload' => { 320 => 0x4 },
	'gripbatterystate' => { 320 => '1.2' },
	'groupareaafillumination' => { 267 => '46.4', 270 => '47.4', 279 => '47.4' },
	'grouping' => { 358 => ['grup',"\xa9grp"], 366 => "\xa9grp" },
	'guid' => { 358 => 'GUID' },
	'h2resetblackpixels' => { 134 => 0x18a6 },
	'h3resetblackcolumns' => { 134 => 0x18ce },
	'h3resetblackpixels' => { 134 => 0x18b0 },
	'halftonehints' => { 116 => 0x141 },
	'hardlink' => { 117 => 'HardLink' },
	'hasalternative' => { 478 => 'hasAlternative' },
	'hascorrection' => { 478 => 'hasCorrection' },
	'hascorrectiona-lang' => { 478 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 478 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 478 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 462 => 'HasCrop', 464 => 'HasCrop' },
	'hasextendedxmp' => { 490 => 'HasExtendedXMP' },
	'hassettings' => { 462 => 'HasSettings', 464 => 'HasSettings' },
	'hastranslation' => { 478 => 'hasTranslation' },
	'hasvisibleoverprint' => { 493 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 493 => 'HasVisibleTransparency' },
	'hdr' => { 58 => 0x1, 209 => 0x4, 306 => 0x9e, 341 => 0x85, 406 => 0x200a },
	'hdreffect' => { 58 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 209 => 0x0 },
	'hdrlevel' => { 209 => 0x5, 395 => 0x2e, 411 => 0x17 },
	'hdrlevel2' => { 209 => 0x7 },
	'hdrpmakernote' => { 445 => 'hdrp_makernote' },
	'hdrsetting' => { 395 => 0x2d, 411 => 0x16, 414 => 0x1148, 415 => 0x1148, 416 => 0x1124, 417 => 0x11a0, 418 => 0x117c, 419 => 0x1034, 420 => 0x22c, 421 => 0x22c, 422 => 0x21f },
	'hdrshot' => { 306 => 0x76 },
	'hdrsmoothing' => { 209 => 0x6 },
	'hdvideo' => { 358 => 'hdvd' },
	'headline' => { 128 => 0x69, 474 => 'Headline', 476 => 'Headline' },
	'hierarchicalkeywords' => { 167 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 167 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 167 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 167 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 167 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 167 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 167 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 454 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 115 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 311 => 0x1a },
	'highisomultipliergreen' => { 311 => 0x19 },
	'highisomultiplierred' => { 311 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 60 => 0x5, 81 => 0x202, 219 => 0xb1, 341 => 0x71, 393 => 0x2c, 394 => 0x26, 395 => 0x26, 406 => 0x2009, 411 => 0x12, 435 => 0x42 },
	'highisonoisereduction2' => { 406 => 0xb050 },
	'highlight' => { 383 => 0xf },
	'highlight2012' => { 462 => 'Highlight2012', 464 => 'Highlight2012' },
	'highlightadj' => { 100 => 0x2030c },
	'highlightcolordistortreduct' => { 439 => 0x8026 },
	'highlightlinearitylimit' => { 380 => 0xa025 },
	'highlightprotection' => { 258 => 0x6 },
	'highlightrecovery' => { 462 => 'HighlightRecovery', 464 => 'HighlightRecovery' },
	'highlights' => { 456 => 'Highlights' },
	'highlights2012' => { 462 => 'Highlights2012', 464 => 'Highlights2012' },
	'highlightsadj' => { 439 => 0x9019 },
	'highlightshadow' => { 306 => 0xad },
	'highlighttone' => { 124 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 60 => 0x3, 81 => 0x203 },
	'highlightwarning' => { 306 => 0x8002 },
	'highlowkeyadj' => { 341 => 0x6c },
	'highspeedsync' => { 179 => 0x5, 393 => 0x2, 394 => 0x2 },
	'hintversion' => { 366 => 'hinv' },
	'histogramxml' => { 259 => 0x83a1a25 },
	'history' => { 476 => 'History', 489 => 'History' },
	'historyaction' => { 489 => [\'History','HistoryAction'] },
	'historychanged' => { 489 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 489 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 489 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 489 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 489 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 134 => 0xc88 },
	'holefilldeltathreshold' => { 134 => 0xc7e },
	'hometowncity' => { 110 => 0x3006, 341 => 0x23, 347 => 0x2 },
	'hometowncitycode' => { 348 => 0x1000 },
	'hometowndst' => { 341 => 0x25, 347 => '0.2' },
	'hostcomputer' => { 116 => 0x13c },
	'hostsoftwarerendering' => { 134 => 0xce7 },
	'hue' => { 184 => 0x3b, 222 => 0x3d, 223 => 0x45, 341 => 0x67 },
	'hueadj' => { 262 => 0x2f, 439 => 0x8019 },
	'hueadjust' => { 373 => 0x1016 },
	'hueadjustment' => { 177 => 0x4a, 178 => 0x40, 219 => 0x92, 221 => 0x36 },
	'hueadjustmentaqua' => { 462 => 'HueAdjustmentAqua', 464 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 462 => 'HueAdjustmentBlue', 464 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 462 => 'HueAdjustmentGreen', 464 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 462 => 'HueAdjustmentMagenta', 464 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 462 => 'HueAdjustmentOrange', 464 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 462 => 'HueAdjustmentPurple', 464 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 462 => 'HueAdjustmentRed', 464 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 462 => 'HueAdjustmentYellow', 464 => 'HueAdjustmentYellow' },
	'huesetting' => { 291 => 0x1011 },
	'humanobservation' => { 115 => 'HumanObservation' },
	'humanobservationday' => { 115 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 115 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 115 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 115 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 115 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 115 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 115 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 115 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 115 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 115 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 115 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 115 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 115 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 115 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 115 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 115 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 115 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 115 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 115 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 115 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 116 => 0x9401, 469 => 'Humidity' },
	'icc_profile' => { 117 => 'ICC_Profile' },
	'iccprofilename' => { 476 => 'ICCProfile' },
	'iconuri' => { 366 => 'icnu' },
	'idccreativestyle' => { 439 => 0x8000 },
	'idcpreviewlength' => { 439 => 0x202 },
	'idcpreviewstart' => { 439 => 0x201 },
	'identification' => { 115 => 'Identification' },
	'identificationid' => { 115 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 115 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 115 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 115 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 115 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 115 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 465 => 'identifier', 486 => 'Identifier' },
	'ifcameramodel' => { 134 => 0x9c8 },
	'illumination' => { 277 => '0.5', 368 => 0x48 },
	'imageabsolutex' => { 134 => 0x3fe },
	'imageabsolutey' => { 134 => 0x3ff },
	'imageadjustment' => { 219 => 0x80, 249 => 0x5 },
	'imagealterationconstraints' => { 293 => 'ImageAlterationConstraints' },
	'imagearea' => { 232 => 0x10, 235 => 0x10 },
	'imageareaoffset' => { 341 => 0x38 },
	'imageauthentication' => { 219 => 0x20 },
	'imageboundary' => { 219 => 0x16 },
	'imagecount' => { 124 => 0x1438, 219 => 0xa5, 409 => 0x11b },
	'imagecreator' => { 293 => 'ImageCreator' },
	'imagecreatorid' => { 293 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 293 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 293 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 134 => 0x41f },
	'imagecropy' => { 134 => 0x420 },
	'imagedata' => { 449 => 'Data' },
	'imagedatasize' => { 219 => 0xa2 },
	'imagedescription' => { 116 => 0x10e, 484 => 'ImageDescription' },
	'imageduplicationconstraints' => { 293 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 259 => 0xfe443a45 },
	'imageeditcount' => { 341 => 0x41 },
	'imageediting' => { 341 => 0x32 },
	'imageeffects' => { 373 => 0x1010 },
	'imagefileconstraints' => { 293 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 293 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 293 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 124 => 0x1436 },
	'imageheight' => { 116 => 0x101, 183 => 0xc, 350 => 0x10d, 447 => 'ImageHeight', 484 => 'ImageLength' },
	'imagehistory' => { 116 => 0x9213, 467 => 'ImageHistory' },
	'imageidnumber' => { 301 => 0x340 },
	'imagemimetype' => { 449 => 'Mime' },
	'imagenumber' => { 116 => 0x9211, 152 => 'ImageNumber', 177 => 0xae, 178 => 0x5e, 350 => 0x113, 393 => 0x9b, 395 => [0x400,'276.1',0x314], 459 => 'ImageNumber' },
	'imagenumber2' => { 178 => 0x62 },
	'imageoptimization' => { 219 => 0xa9 },
	'imageorientation' => { 128 => 0x83 },
	'imageprocessing' => { 219 => 0x1a },
	'imageprocessingfiledatecreated' => { 134 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 134 => 0xc80 },
	'imageprocessingversion' => { 287 => 0x0 },
	'imagequality' => { 152 => 'ImageQuality', 234 => '723.2', 235 => '732.2', 244 => '708.1', 306 => 0x1 },
	'imagequality2' => { 283 => 0x603 },
	'imagerank' => { 452 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 134 => 0x600 },
	'imagerboardversion' => { 134 => 0x439 },
	'imagercols' => { 134 => 0x17d4 },
	'imageref' => { 472 => 'ImageRef' },
	'imageregion' => { 474 => 'ImageRegion' },
	'imageregionboundary' => { 474 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 474 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 474 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 474 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 474 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 474 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 474 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 474 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 474 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 474 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 134 => 0x944 },
	'imageresolutionjpg' => { 134 => 0x945 },
	'imagereview' => { 268 => '0.4', 277 => '0.4' },
	'imagereviewmonitorofftime' => { 267 => '21.1', 269 => '21.1', 270 => '21.1', 274 => '20.1', 279 => '21.1', 280 => '21.1' },
	'imagereviewtime' => { 266 => '25.1', 268 => '2.1', 271 => '19.1', 272 => '20.1', 273 => '20.1', 275 => '9.2', 276 => '20.1', 281 => '21.2' },
	'imagerfiledatecreated' => { 134 => 0x9c5 },
	'imagerfileproductionlevel' => { 134 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 134 => 0x9c7 },
	'imagerotated' => { 147 => 0x2a },
	'imagerpowerondelaymsec' => { 134 => 0x5fd },
	'imagerrows' => { 134 => 0x17de },
	'imagesegmentlines' => { 134 => 0x184d },
	'imagesegmentstartline' => { 134 => 0x184c },
	'imagesize' => { 158 => 'ImageSize' },
	'imagesizerestriction' => { 481 => 'imageSizeRestriction' },
	'imagesourcedata' => { 116 => 0x935c },
	'imagespace' => { 134 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 110 => 0x3020, 124 => 0x1422, 152 => 'ImageStabilization', 177 => 0xbd, 178 => 0x71, 179 => 0x57, 180 => 0x0, 181 => [0x18,0x107,0x113], 182 => 0x49c2, 219 => 0xac, 283 => 0x604, 286 => 0x1600, 306 => 0x1a, 398 => 0x12, 399 => 0x11, 406 => 0xb026 },
	'imagestabilization2' => { 397 => 0xa },
	'imagestabilizationsetting' => { 182 => 0x14, 393 => 0x3d, 394 => 0x3d, 404 => 0x14 },
	'imagestyle' => { 393 => 0x2d, 394 => 0x27 },
	'imagesupplier' => { 293 => 'ImageSupplier' },
	'imagesupplierid' => { 293 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 293 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 293 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 118 => 0x1 },
	'imagetemperaturemin' => { 118 => 0x2 },
	'imagetone' => { 341 => 0x4f },
	'imagetype' => { 128 => 0x82, 293 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 61 => 0x28, 116 => 0xa420, 467 => 'ImageUniqueID', 468 => 'ImageUniqueID' },
	'imagewidth' => { 116 => 0x100, 183 => 0xe, 350 => 0x10c, 447 => 'ImageWidth', 484 => 'ImageWidth' },
	'inclinationangle' => { 439 => 0x900f },
	'inclinationcorrection' => { 439 => 0x900e },
	'incrementaltemperature' => { 462 => 'IncrementalTemperature', 464 => 'IncrementalTemperature' },
	'incrementaltint' => { 462 => 'IncrementalTint', 464 => 'IncrementalTint' },
	'industry' => { 478 => 'industry', 479 => 'industry' },
	'infobuttonwhenshooting' => { 81 => 0x409 },
	'information' => { 360 => 'information', 366 => "\xa9inf" },
	'infourl' => { 366 => 'infu' },
	'infraredilluminator' => { 367 => 0x28 },
	'ingredientexclusion' => { 480 => 'ingredientExclusion' },
	'ingredients' => { 489 => 'Ingredients' },
	'ingredientsalternatepaths' => { 489 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 489 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 489 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 489 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 489 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 489 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 489 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 489 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 489 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 489 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 489 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 489 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 489 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 489 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 489 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 489 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 489 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 489 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 489 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 489 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 489 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 489 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 489 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 81 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 450 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 450 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 450 => 'InitialViewHeadingDegrees', 451 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 450 => 'InitialViewPitchDegrees', 451 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 450 => 'InitialViewRollDegrees', 451 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 266 => '4.4' },
	'initialzoomsetting' => { 266 => '9.3', 275 => '27.3' },
	'inkset' => { 116 => 0x14c },
	'inputprofile' => { 134 => 0x1389 },
	'instanceid' => { 489 => 'InstanceID' },
	'instantplaybacksetup' => { 179 => 0x3e },
	'instantplaybacktime' => { 179 => 0x3d },
	'instructions' => { 476 => 'Instructions' },
	'instrument' => { 488 => 'instrument' },
	'integrationtime' => { 134 => 0x423 },
	'intellectualgenre' => { 473 => 'IntellectualGenre' },
	'intelligentauto' => { 406 => 0xb052, 431 => 0xd, 432 => 0xe, 433 => 0xd },
	'intelligentcontrast' => { 50 => 0x4 },
	'intelligentd-range' => { 306 => 0x79 },
	'intelligentexposure' => { 306 => 0x5d },
	'intelligentresolution' => { 306 => 0x70 },
	'interchangecolorspace' => { 130 => 0x40 },
	'intergraphmatrix' => { 116 => 0x8480 },
	'internalflash' => { 176 => 0x2b, 266 => '23.1', 268 => '8.1', 271 => '22.1', 273 => '23.1', 277 => '8.1', 281 => '24.1', 286 => 0x1208 },
	'internalflashae1' => { 288 => 0x1021 },
	'internalflashae1_0' => { 288 => 0x101d },
	'internalflashae2' => { 288 => 0x1022 },
	'internalflashae2_0' => { 288 => 0x101e },
	'internalflashmode' => { 329 => 0x1 },
	'internalflashstrength' => { 329 => 0x3 },
	'internalflashtable' => { 288 => 0x1024 },
	'internallensserialnumber' => { 380 => 0xa005 },
	'internalndfilter' => { 306 => 0x9d },
	'internalserialnumber' => { 61 => 0x96, 73 => 0x9, 124 => 0x10, 182 => 0x49dc, 282 => 0x18, 284 => 0x102, 303 => 0x500, 306 => 0x25, 321 => 0x4, 373 => 0x5, 424 => [0x7c,0xf0], 425 => 0x88 },
	'interopindex' => { 116 => 0x1, 469 => 'InteroperabilityIndex' },
	'interopversion' => { 116 => 0x2 },
	'intervallength' => { 176 => 0x10 },
	'intervalmode' => { 176 => 0x26 },
	'intervalnumber' => { 176 => 0x11 },
	'intervalshooting' => { 341 => 0x92 },
	'introtime' => { 488 => 'introTime' },
	'introtimescale' => { 488 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 488 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 134 => 0xdae },
	'ipfcameramodel' => { 134 => 0xe4d },
	'iptc' => { 117 => 'IPTC' },
	'iptc-naa' => { 116 => 0x83bb, 311 => 0x83bb },
	'iptcbitspersample' => { 130 => 0x56 },
	'iptcdigest' => { 355 => 0x425 },
	'iptcimageheight' => { 130 => 0x1e },
	'iptcimagerotation' => { 130 => 0x66 },
	'iptcimagewidth' => { 130 => 0x14 },
	'iptclastedited' => { 474 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 130 => 0xa },
	'iptcpixelheight' => { 130 => 0x32 },
	'iptcpixelwidth' => { 130 => 0x28 },
	'isalternativeof' => { 478 => 'isAlternativeOf' },
	'isbn' => { 478 => 'isbn' },
	'iscorrectionof' => { 478 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 106 => 0x3 },
	'ismergedhdr' => { 459 => 'IsMergedHDR' },
	'ismergedpanorama' => { 459 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 109 => 0x14, 110 => [0x3014,0x14], 116 => 0x8827, 133 => 0xfd06, 134 => 0x1784, 136 => 0x60, 138 => [0xfa2e,0xfa46], 139 => [0x27,0x28], 140 => 0xf105, 143 => 0x14, 145 => 0x4e, 147 => 0x1e, 148 => 0x1a, 150 => 0x34, 152 => 'ISO', 176 => 0x8, 182 => 0x49ba, 210 => 0x0, 219 => 0x2, 306 => 0xd1, 311 => 0x17, 341 => [0x8b,0x14], 348 => 0x14, 350 => 0x105, 380 => 0xa014, 383 => 0x86, 404 => 0x6f, 411 => [0x1f,0x21,0x25], 468 => 'ISOSpeedRatings' },
	'iso2' => { 210 => 0x6, 229 => 0x265, 230 => 0x25c, 231 => 0x265, 232 => 0x221, 233 => 0x25d, 234 => 0x256, 235 => 0x25d, 239 => 0x2b5, 242 => 0x265, 248 => 0x2b5 },
	'isoauto' => { 322 => '14.4' },
	'isoautohilimit' => { 237 => 0x18eb, 238 => 0xe82, 246 => 0x185d },
	'isoautomax' => { 405 => 0x4 },
	'isoautomin' => { 405 => 0x2 },
	'isoautoparameters' => { 341 => 0x7a },
	'isoautoshuttertime' => { 237 => 0x18ea, 238 => 0xe81, 246 => 0x185c },
	'isocalibrationgain' => { 134 => 0x89f },
	'isodisplay' => { 269 => '4.1', 270 => '4.1', 271 => '2.3', 272 => '3.3', 273 => '3.3', 276 => '3.3', 279 => '4.3', 280 => '4.1', 281 => '4.3' },
	'isoexpansion' => { 81 => 0x103, 82 => 0x7, 83 => 0x8, 86 => 0x8, 210 => 0x4 },
	'isoexpansion2' => { 210 => 0xa },
	'isofloor' => { 322 => 0x6 },
	'isoselection' => { 219 => 0xf },
	'isosensitivitystep' => { 274 => '6.2', 276 => '6.2' },
	'isosetting' => { 136 => 0x5e, 148 => 0x14, 152 => 'ISOSetting', 176 => 0x24, 177 => 0x26, 178 => 0x1c, 179 => 0x13, 184 => 0x6, 219 => 0x13, 322 => '17.3', 372 => 0x27, 393 => 0x16, 394 => 0x14, 395 => 0x2, 404 => 0x6d, 405 => 0x0 },
	'isospeed' => { 116 => 0x8833, 469 => 'ISOSpeed' },
	'isospeedexpansion' => { 80 => 0x3 },
	'isospeedincrements' => { 81 => 0x102 },
	'isospeedlatitudeyyy' => { 116 => 0x8834, 469 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 116 => 0x8835, 469 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 81 => 0x103 },
	'isostepsize' => { 266 => '6.1', 267 => '7.2', 269 => '7.2', 270 => '7.2', 275 => '4.1', 279 => '7.2', 280 => '7.2' },
	'isovalue' => { 288 => 0x1001 },
	'isrccode' => { 366 => "\xa9isr" },
	'issn' => { 478 => 'issn' },
	'issueidentifier' => { 478 => 'issueIdentifier' },
	'issuename' => { 478 => 'issueName' },
	'issueteaser' => { 478 => 'issueTeaser' },
	'issuetype' => { 478 => 'issueType' },
	'istranslationof' => { 478 => 'isTranslationOf' },
	'itemsubtype' => { 174 => 'ItemSubType' },
	'itunesu' => { 358 => 'itnu' },
	'jobid' => { 128 => 0xb8 },
	'jobname' => { 470 => 'JobName' },
	'jobref' => { 487 => 'JobRef' },
	'jobrefid' => { 487 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 487 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 487 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 470 => 'JobStatus' },
	'jpeghandling' => { 462 => 'JPEGHandling', 464 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 306 => 0x43, 308 => 0x3034, 406 => 0xb047 },
	'jpegsize' => { 308 => 0x303a },
	'jpgcompression' => { 238 => 0x7d4 },
	'jpgfromraw' => { 94 => 0x2007, 111 => 'Exif::JpgFromRaw', 311 => 0x2e },
	'jpgfromrawlength' => { 116 => [0x117,0x202] },
	'jpgfromrawstart' => { 116 => [0x111,0x201] },
	'jpgrecordedpixels' => { 322 => '14.1' },
	'jurisdiction' => { 460 => 'jurisdiction' },
	'kelvinwb_01' => { 330 => 0x5 },
	'kelvinwb_02' => { 330 => 0x9 },
	'kelvinwb_03' => { 330 => 0xd },
	'kelvinwb_04' => { 330 => 0x11 },
	'kelvinwb_05' => { 330 => 0x15 },
	'kelvinwb_06' => { 330 => 0x19 },
	'kelvinwb_07' => { 330 => 0x1d },
	'kelvinwb_08' => { 330 => 0x21 },
	'kelvinwb_09' => { 330 => 0x25 },
	'kelvinwb_10' => { 330 => 0x29 },
	'kelvinwb_11' => { 330 => 0x2d },
	'kelvinwb_12' => { 330 => 0x31 },
	'kelvinwb_13' => { 330 => 0x35 },
	'kelvinwb_14' => { 330 => 0x39 },
	'kelvinwb_15' => { 330 => 0x3d },
	'kelvinwb_16' => { 330 => 0x41 },
	'kelvinwb_daylight' => { 330 => 0x1 },
	'kerneldenominators' => { 134 => 0x933 },
	'key' => { 488 => 'key' },
	'keystonecompensation' => { 287 => 0x1900 },
	'keystonedirection' => { 287 => 0x1901 },
	'keystonevalue' => { 287 => 0x1906 },
	'keyword' => { 358 => 'keyw', 478 => 'keyword' },
	'keywordinfo' => { 167 => 'Keywords' },
	'keywords' => { 128 => 0x19, 153 => 'Keywords', 292 => 'Keywords', 357 => 'Keywords', 360 => 'keywords', 457 => 'keywords', 475 => 'Keywords', 486 => 'Keywords' },
	'killdate' => { 478 => 'killDate' },
	'killdatea-platform' => { 478 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 478 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 133 => 0xf908, 136 => 0xe, 138 => [0xfa1e,0xfa52], 144 => 0x70 },
	'kodakimagewidth' => { 133 => 0xf907, 136 => 0xc, 138 => [0xfa1d,0xfa51], 144 => 0x6c },
	'kodakinfotype' => { 133 => 0xfa00 },
	'kodaklook' => { 134 => 0xe4c },
	'kodaklookprofile' => { 134 => 0x138a },
	'kodakmaker' => { 144 => 0x8 },
	'kodakmodel' => { 136 => 0x0, 144 => 0x28 },
	'kodaktag' => { 134 => 0x3ea },
	'kodakversion' => { 134 => 0x0 },
	'label' => { 296 => 'Label', 486 => 'Label' },
	'labelname1' => { 472 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 472 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 306 => 0x6f },
	'landscapeoutputhighlightpoint' => { 106 => 0x26 },
	'landscapeoutputshadowpoint' => { 106 => 0x27 },
	'landscaperawcolortone' => { 106 => 0x1f },
	'landscaperawcontrast' => { 106 => 0x21 },
	'landscaperawhighlight' => { 106 => 0x77 },
	'landscaperawhighlightpoint' => { 106 => 0x24 },
	'landscaperawlinear' => { 106 => 0x22 },
	'landscaperawsaturation' => { 106 => 0x20 },
	'landscaperawshadow' => { 106 => 0x80 },
	'landscaperawshadowpoint' => { 106 => 0x25 },
	'landscaperawsharpness' => { 106 => 0x23 },
	'landscapeunsharpmaskfineness' => { 106 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 106 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 106 => 0xa2 },
	'language' => { 465 => 'language' },
	'languageidentifier' => { 128 => 0x87 },
	'largestvalidinteriorrectheight' => { 450 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 450 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 450 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 450 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 176 => 0x1b },
	'lastkeywordiptc' => { 174 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 174 => 'LastKeywordXMP' },
	'lastphotodate' => { 450 => 'LastPhotoDate' },
	'lasturl' => { 489 => 'LastURL' },
	'lateralchromaticaberration' => { 406 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 459 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 115 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 115 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 115 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 115 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 115 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 113 => 'Latitude' },
	'lc1' => { 332 => 0x2 },
	'lc10' => { 332 => 0xb },
	'lc11' => { 332 => 0xc },
	'lc12' => { 332 => 0xd },
	'lc14' => { 332 => 0xf },
	'lc15' => { 332 => 0x10 },
	'lc3' => { 332 => 0x4 },
	'lc4' => { 332 => 0x5 },
	'lc5' => { 332 => 0x6 },
	'lc6' => { 332 => 0x7 },
	'lc7' => { 332 => 0x8 },
	'lc8' => { 332 => 0x9 },
	'lcddisplayatpoweron' => { 81 => 0x811, 85 => 0xa },
	'lcddisplayreturntoshoot' => { 86 => 0x12 },
	'lcdillumination' => { 266 => '17.5', 267 => '5.2', 269 => '5.1', 270 => '5.1', 275 => '10.3', 276 => '4.2', 279 => '5.2', 280 => '5.1', 281 => '5.4' },
	'lcdilluminationduringbulb' => { 81 => 0x408 },
	'lcdmatrix' => { 134 => 0xe74 },
	'lcdmatrixchickfix' => { 134 => 0xe75 },
	'lcdmatrixmarvin' => { 134 => 0xe76 },
	'lcdpanels' => { 80 => 0x8 },
	'lcheditor' => { 259 => 0x8ae85e },
	'legacyiptcdigest' => { 476 => 'LegacyIPTCDigest' },
	'legalcode' => { 460 => 'legalcode' },
	'lens' => { 116 => 0xfdea, 219 => 0x84, 459 => 'Lens' },
	'lensafstopbutton' => { 79 => 0x11, 80 => 0x13, 81 => 0x506, 82 => 0x10, 83 => 0x12, 86 => 0x13, 87 => 0x9 },
	'lensaperturerange' => { 383 => [0x30,0x48] },
	'lenscorrectionsettings' => { 467 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 459 => 'LensDistortInfo' },
	'lensdistortionparams' => { 288 => 0x206 },
	'lensdrivenoaf' => { 81 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 395 => 0x3f0, 438 => 0xd },
	'lensfirmware' => { 374 => 0x20, 380 => 0xa004 },
	'lensfirmwareversion' => { 284 => 0x204, 306 => 0x60, 395 => 0x3f3, 438 => 0x14 },
	'lensfocallength' => { 100 => 0xf0512, 332 => 0x9 },
	'lensfocalrange' => { 383 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 267 => '55.1', 269 => '52.1', 270 => '52.1', 279 => '52.1', 280 => '52.1' },
	'lensformat' => { 418 => 0x1891, 420 => 0x18bd, 421 => 0x18ed, 422 => 0x17f1, 424 => 0x106, 425 => 0x106, 434 => 0x603, 435 => 0x5d },
	'lensfstops' => { 211 => 0x7, 212 => 0xc, 213 => 0xd, 217 => 0xe, 219 => 0x8b, 332 => '0.3' },
	'lensid' => { 217 => 0x30, 459 => 'LensID' },
	'lensidnumber' => { 211 => 0x6, 212 => 0xb, 213 => 0xc, 217 => 0xd },
	'lensinfo' => { 116 => 0xa432, 338 => 0x2a, 459 => 'LensInfo', 469 => 'LensSpecification' },
	'lenskind' => { 332 => 0x1 },
	'lensmake' => { 116 => 0xa433, 159 => 'Make', 469 => 'LensMake' },
	'lensmanualdistortionamount' => { 462 => 'LensManualDistortionAmount', 464 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 174 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 383 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 61 => 0x95, 116 => 0xa434, 159 => 'Model', 174 => 'LensModel', 214 => 0x18a, 215 => 0x18b, 216 => 0x2ac, 284 => 0x203, 338 => 0xc, 350 => 0x412, 469 => 'LensModel' },
	'lensmodulationoptimizer' => { 124 => 0x1045 },
	'lensmount' => { 395 => 0x99, 418 => 0x1892, 420 => 0x18be, 421 => 0x18ee, 422 => 0x17f2, 424 => 0x105, 425 => 0x105, 434 => 0x604, 435 => 0x5e },
	'lensmount2' => { 438 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 462 => 'LensProfileChromaticAberrationScale', 464 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 462 => 'LensProfileDigest', 464 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 462 => 'LensProfileDistortionScale', 464 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 462 => 'LensProfileEnable', 464 => 'LensProfileEnable' },
	'lensprofilefilename' => { 462 => 'LensProfileFilename', 464 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 462 => 'LensProfileMatchKeyCameraModelName', 464 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 462 => 'LensProfileMatchKeyExifMake', 464 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 462 => 'LensProfileMatchKeyExifModel', 464 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 462 => 'LensProfileMatchKeyIsRaw', 464 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 462 => 'LensProfileMatchKeyLensID', 464 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 462 => 'LensProfileMatchKeyLensInfo', 464 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 462 => 'LensProfileMatchKeyLensName', 464 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 462 => 'LensProfileMatchKeySensorFormatFactor', 464 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 462 => 'LensProfileName', 464 => 'LensProfileName' },
	'lensprofilesetup' => { 462 => 'LensProfileSetup', 464 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 462 => 'LensProfileVignettingScale', 464 => 'LensProfileVignettingScale' },
	'lensproperties' => { 284 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 59 => 0x0, 116 => 0xa435, 159 => 'SerialNumber', 284 => 0x202, 304 => 0x321, 306 => 0x52, 366 => 'LENS', 374 => 0x30, 459 => 'LensSerialNumber', 469 => 'LensSerialNumber' },
	'lensshutterlock' => { 179 => 0x4a },
	'lensspec' => { 390 => 0x0, 391 => 0x0, 392 => 0x0, 406 => 0xb02a },
	'lensspecfeatures' => { 424 => [0x115,0x116], 425 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 288 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 181 => 0x10c, 182 => 0x49bd, 219 => 0x83, 284 => 0x201, 297 => 0x16, 301 => 0x310, 303 => 0x303, 304 => 0x303, 306 => 0x51, 308 => 0x3405, 333 => 0x0, 334 => 0x0, 335 => 0x1, 336 => 0x1, 337 => 0x1, 339 => 0x0, 380 => 0xa003, 383 => 0x27, 406 => 0xb027, 418 => 0x1896, 420 => 0x18c2, 421 => 0x18f2, 422 => 0x17f6, 424 => 0x109, 425 => 0x109, 434 => 0x608, 435 => 0x62 },
	'lenstype2' => { 395 => 0x3f7, 418 => 0x1893, 420 => 0x18bf, 421 => 0x18ef, 422 => 0x17f3, 424 => 0x107, 425 => 0x107, 434 => 0x605, 435 => 0x60 },
	'lenstype3' => { 438 => 0x9 },
	'lenszoomposition' => { 431 => 0x19, 432 => 0x1e, 435 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 314 => 0x15 },
	'levelmeter' => { 366 => ['Lvlm','lvlm'] },
	'levelorientation' => { 340 => 0x0 },
	'license' => { 460 => 'license' },
	'licensee' => { 293 => 'Licensee' },
	'licenseeid' => { 293 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 293 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 293 => 'LicenseeImageNotes' },
	'licenseename' => { 293 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 293 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 293 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 293 => 'LicenseeTransactionID' },
	'licenseid' => { 293 => 'LicenseID' },
	'licensestartdate' => { 293 => 'LicenseStartDate' },
	'licensetransactiondate' => { 293 => 'LicenseTransactionDate' },
	'licensetype' => { 466 => 'licensetype' },
	'licensor' => { 293 => 'Licensor' },
	'licensorcity' => { 293 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 293 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 293 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 293 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 293 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 293 => 'LicensorImageID' },
	'licensorname' => { 293 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 293 => 'LicensorNotes' },
	'licensorpostalcode' => { 293 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 293 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 293 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 293 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 293 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 293 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 293 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 293 => 'LicensorTransactionID' },
	'licensorurl' => { 293 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 288 => 0x1009 },
	'lightingmode' => { 110 => 0x302a },
	'lightreading' => { 341 => 0x15 },
	'lightsource' => { 116 => 0x9208, 219 => 0x90, 291 => 0x1000, 468 => 'LightSource' },
	'lightsourcespecial' => { 382 => 0x21d },
	'lightswitch' => { 279 => '0.1', 281 => '0.1' },
	'lightvaluecenter' => { 288 => 0x103d },
	'lightvalueperiphery' => { 288 => 0x103e },
	'limitafareamodeselection' => { 267 => '51.1', 269 => '49.1', 270 => '49.1', 279 => '49.1', 280 => '49.1' },
	'linearitylimitblue' => { 311 => 0x10 },
	'linearitylimitgreen' => { 311 => 0xf },
	'linearitylimitred' => { 311 => 0xe },
	'linearityuppermargin' => { 43 => [0x2ba,0x2d1,0x2d5], 45 => 0x1e5, 46 => [0x1fe,0x2de], 47 => [0x232,0x310], 48 => 0x31e },
	'linearizationtable' => { 116 => 0xc618 },
	'linearresponselimit' => { 116 => 0xc62e },
	'link' => { 478 => 'link' },
	'linkaetoafpoint' => { 322 => '14.2' },
	'linkedencodedrightsexpr' => { 474 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 474 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 474 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 474 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 134 => 0x904 },
	'lithostratigraphicterms' => { 115 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 271 => '32.1', 281 => '34.1' },
	'liveviewafareamode' => { 276 => '34.1' },
	'liveviewafmethod' => { 411 => 0x20 },
	'liveviewafmode' => { 276 => '34.2' },
	'liveviewafsetting' => { 395 => 0x36 },
	'liveviewbuttonoptions' => { 267 => '50.2', 269 => '48.2', 270 => '48.2', 279 => '48.2', 280 => '48.2' },
	'liveviewexposuresimulation' => { 81 => 0x810 },
	'liveviewfocusmode' => { 395 => [0x8b,0x28b] },
	'liveviewmetering' => { 395 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 267 => '21.2', 269 => '21.2', 270 => '21.2', 272 => '20.2', 273 => '20.2', 274 => '20.2', 276 => '20.2', 279 => '21.2', 280 => '21.2' },
	'liveviewshooting' => { 55 => 0x13 },
	'livingspecimen' => { 115 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 115 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 128 => 0x79 },
	'localizedcameramodel' => { 116 => 0xc615 },
	'locallocationname' => { 380 => 0x30 },
	'location' => { 218 => 0x9, 306 => 0x67, 455 => 'Location', 473 => 'Location', 477 => 'location', 478 => 'location' },
	'locationareacode' => { 461 => 'lac' },
	'locationbody' => { 360 => 'location.body' },
	'locationcreated' => { 474 => 'LocationCreated' },
	'locationcreatedcity' => { 474 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 474 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 474 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 474 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 474 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 474 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 474 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 474 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 474 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 474 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 474 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 474 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 360 => 'location.date' },
	'locationinfoversion' => { 218 => 0x0 },
	'locationname' => { 360 => 'location.name', 380 => 0x31 },
	'locationnote' => { 360 => 'location.note' },
	'locationrole' => { 360 => 'location.role' },
	'locationshown' => { 474 => 'LocationShown' },
	'locationshowncity' => { 474 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 474 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 474 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 474 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 474 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 474 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 474 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 474 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 474 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 474 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 474 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 474 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 81 => 0x709 },
	'logcomment' => { 488 => 'logComment' },
	'logscale' => { 134 => 0x902 },
	'longdescription' => { 358 => 'ldes' },
	'longexposurenoisereduction' => { 60 => 0x4, 81 => 0x201, 82 => 0x1, 83 => 0x2, 84 => 0x1, 85 => 0x1, 86 => 0x2, 87 => 0x1, 306 => 0x49, 393 => 0x2b, 394 => 0x25, 395 => 0x25, 406 => 0x2008, 411 => 0x11, 435 => 0x44 },
	'longexposurenoisereduction2' => { 55 => 0x8 },
	'longitude' => { 113 => 'Longitude' },
	'look' => { 462 => 'Look', 464 => 'Look' },
	'lookname' => { 462 => [\'Look','LookName'], 464 => [\'Look','LookName'] },
	'loop' => { 488 => 'loop' },
	'loopstyle' => { 366 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 115 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 462 => 'LuminanceAdjustmentAqua', 464 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 462 => 'LuminanceAdjustmentBlue', 464 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 462 => 'LuminanceAdjustmentGreen', 464 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 462 => 'LuminanceAdjustmentMagenta', 464 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 462 => 'LuminanceAdjustmentOrange', 464 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 462 => 'LuminanceAdjustmentPurple', 464 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 462 => 'LuminanceAdjustmentRed', 464 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 462 => 'LuminanceAdjustmentYellow', 464 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 105 => 0x150 },
	'luminancecurvepoints' => { 105 => 0x126 },
	'luminancenoisereduction' => { 100 => 0x20600, 106 => 0x5f, 383 => 0x1b },
	'luminancenoisereductioncontrast' => { 462 => 'LuminanceNoiseReductionContrast', 464 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 462 => 'LuminanceNoiseReductionDetail', 464 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 106 => 0x6d },
	'luminancesmoothing' => { 462 => 'LuminanceSmoothing', 464 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 81 => [0x40b,0x40c] },
	'lyrics' => { 358 => "\xa9lyr", 366 => "\xa9lyr", 488 => 'lyrics' },
	'lyricsuri' => { 366 => 'lrcu' },
	'm16cversion' => { 301 => 0x333 },
	'macatom' => { 463 => 'macAtom' },
	'macatomapplicationcode' => { 463 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 463 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 463 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 115 => 'MachineObservation' },
	'machineobservationday' => { 115 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 115 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 115 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 115 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 115 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 115 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 115 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 115 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 115 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 115 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 115 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 115 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 115 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 115 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 115 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 115 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 115 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 115 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 115 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 115 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 124 => 0x1020, 126 => 0x202, 147 => 0x2b, 288 => 0x202, 372 => 0x21, 382 => 0x202, 406 => 0xb040 },
	'macroled' => { 286 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 55 => 0x10 },
	'macromode' => { 34 => 0x1, 176 => 0xb, 283 => 0x300, 306 => 0x1c, 373 => 0x1009 },
	'magentahsl' => { 100 => 0x20917 },
	'magicfilter' => { 283 => 0x52c },
	'magnifiedview' => { 83 => 0x11, 85 => 0x9 },
	'mainboardversion' => { 134 => 0x438 },
	'maindialexposurecomp' => { 277 => '0.6' },
	'mainingredient' => { 480 => 'mainIngredient' },
	'majorversion' => { 453 => 'MajorVersion' },
	'make' => { 95 => 0x0, 112 => 0x1, 116 => 0x10f, 152 => 'Make', 296 => 'Make', 311 => 0x10f, 360 => 'make', 366 => "\xa9mak", 477 => 'make', 484 => 'Make' },
	'makernote' => { 468 => 'MakerNote' },
	'makernoteapple' => { 114 => 'MakN', 116 => 0x927c },
	'makernotecanon' => { 114 => 'MakN', 116 => 0x927c },
	'makernotecasio' => { 114 => 'MakN', 116 => 0x927c },
	'makernotecasio2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotedji' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteflir' => { 114 => 'MakN', 116 => 0x927c },
	'makernotefujifilm' => { 114 => 'MakN', 116 => 0x927c },
	'makernotege' => { 114 => 'MakN', 116 => 0x927c },
	'makernotege2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotehasselblad' => { 114 => 'MakN', 116 => 0x927c },
	'makernotehp' => { 114 => 'MakN', 116 => 0x927c },
	'makernotehp2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotehp4' => { 114 => 'MakN', 116 => 0x927c },
	'makernotehp6' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteisl' => { 114 => 'MakN', 116 => 0x927c },
	'makernotejvc' => { 114 => 'MakN', 116 => 0x927c },
	'makernotejvctext' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak10' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak11' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak12' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak1a' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak1b' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak3' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak4' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak5' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak6a' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak6b' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak7' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak8a' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak8b' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak8c' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodak9' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekodakunknown' => { 114 => 'MakN', 116 => 0x927c },
	'makernotekyocera' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica10' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica2' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica3' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica4' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica5' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica6' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica7' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica8' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteleica9' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteminolta' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteminolta2' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteminolta3' => { 114 => 'MakN', 116 => 0x927c },
	'makernotemotorola' => { 114 => 'MakN', 116 => 0x927c },
	'makernotenikon' => { 114 => 'MakN', 116 => 0x927c },
	'makernotenikon2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotenikon3' => { 114 => 'MakN', 116 => 0x927c },
	'makernotenintendo' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteoffset' => { 382 => 0xff },
	'makernoteolympus' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteolympus2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepanasonic' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepanasonic2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepanasonic3' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepentax' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepentax2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepentax3' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepentax4' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepentax5' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepentax6' => { 114 => 'MakN', 116 => 0x927c },
	'makernotepentaxunknown' => { 366 => 'PXMN' },
	'makernotephaseone' => { 114 => 'MakN', 116 => 0x927c },
	'makernotereconyx' => { 114 => 'MakN', 116 => 0x927c },
	'makernotereconyx2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotereconyx3' => { 114 => 'MakN', 116 => 0x927c },
	'makernotericoh' => { 114 => 'MakN', 116 => 0x927c },
	'makernotericoh2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotericohpentax' => { 114 => 'MakN', 116 => 0x927c },
	'makernotericohtext' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesafety' => { 116 => 0xc635 },
	'makernotesamsung1a' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesamsung1b' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesamsung2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesanyo' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesanyoc4' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesanyopatch' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesigma' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesony' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesony2' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesony3' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesony4' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesony5' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesonyericsson' => { 114 => 'MakN', 116 => 0x927c },
	'makernotesonysrf' => { 114 => 'MakN', 116 => 0x927c },
	'makernotetype' => { 373 => 0x1 },
	'makernoteunknown' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteunknownbinary' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteunknowntext' => { 114 => 'MakN', 116 => 0x927c },
	'makernoteversion' => { 181 => 0x0, 219 => 0x1, 288 => 0x0, 306 => 0x8000, 377 => 0x0, 380 => 0x1, 383 => [0x1d,0x1f], 396 => 0x2000 },
	'makerurl' => { 366 => "\xa9mal" },
	'managedfrom' => { 489 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 489 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 489 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 489 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 489 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 489 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 489 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 489 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 489 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 489 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 489 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 489 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 489 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 489 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 489 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 489 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 489 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 489 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 489 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 489 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 489 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 489 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 489 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 489 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 489 => 'Manager' },
	'managervariant' => { 489 => 'ManagerVariant' },
	'manageto' => { 489 => 'ManageTo' },
	'manageui' => { 489 => 'ManageUI' },
	'manifest' => { 489 => 'Manifest' },
	'manifestlinkform' => { 489 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 489 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 489 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 489 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 489 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 489 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 489 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 489 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 489 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 489 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 489 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 489 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 489 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 489 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 489 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 489 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 489 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 489 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 489 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 489 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 489 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 489 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 489 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 489 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 489 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 489 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 489 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 489 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 283 => 0x900, 306 => 0x86 },
	'manometerreading' => { 283 => 0x901 },
	'manualafpointselectpattern' => { 81 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 286 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 268 => '8.2', 271 => '22.2', 272 => '23.1', 273 => '23.2', 275 => '16.2', 276 => '23.2', 277 => '8.2', 278 => '23.2', 281 => '24.2', 373 => 0x100c },
	'manualflashstrength' => { 283 => 0x406 },
	'manualfocusdistance' => { 219 => 0x85, 288 => 0x100c, 382 => 0x223 },
	'manualtv' => { 80 => 0x5, 81 => 0x705 },
	'manufacturedate' => { 186 => 0x6705, 321 => 0x1 },
	'manufacturedate1' => { 375 => 0x4 },
	'manufacturedate2' => { 375 => 0x5 },
	'manufacturer' => { 447 => 'Manufacturer', 477 => 'manufacturer' },
	'mariahchromablursize' => { 134 => 0xf0d },
	'mariahmaphithreshold' => { 134 => 0xf0c },
	'mariahmaplothreshold' => { 134 => 0xf0b },
	'mariahsigmathreshold' => { 134 => 0xf0e },
	'mariahtexturethreshold' => { 134 => 0xf0a },
	'marked' => { 475 => 'Marked', 492 => 'Marked' },
	'markers' => { 488 => 'markers' },
	'markerscomment' => { 488 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 488 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 488 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 488 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 488 => [\'markers','markersCuePointType'] },
	'markersduration' => { 488 => [\'markers','markersDuration'] },
	'markerslocation' => { 488 => [\'markers','markersLocation'] },
	'markersname' => { 488 => [\'markers','markersName'] },
	'markersprobability' => { 488 => [\'markers','markersProbability'] },
	'markersspeaker' => { 488 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 488 => [\'markers','markersStartTime'] },
	'markerstarget' => { 488 => [\'markers','markersTarget'] },
	'markerstype' => { 488 => [\'markers','markersType'] },
	'maskedareas' => { 116 => 0xc68e },
	'masterdocumentid' => { 128 => 0xb9 },
	'mastergain' => { 227 => 0x50 },
	'materialsample' => { 115 => 'MaterialSample' },
	'materialsampleid' => { 115 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 267 => '50.1', 269 => '48.1', 270 => '48.1', 279 => '48.1', 280 => '48.1' },
	'matrixselectk' => { 134 => 0x91b },
	'matrixselectthreshold' => { 134 => 0x91a },
	'matrixselectthreshold1' => { 134 => 0x91e },
	'matrixselectthreshold2' => { 134 => 0x91f },
	'matrixstructure' => { 365 => 0xa },
	'maxaperture' => { 34 => 0x1a, 134 => 0x3f9, 140 => 0x6103, 159 => 'MaxAperture', 176 => 0x17, 182 => 0x49c5, 217 => 0x36, 284 => 0x20a, 332 => '14.1' },
	'maxapertureatmaxfocal' => { 124 => 0x1407, 159 => 'MaxApertureAtMaxFocal', 211 => 0xb, 212 => 0x10, 213 => 0x11, 217 => 0x12, 284 => 0x206 },
	'maxapertureatminfocal' => { 124 => 0x1406, 211 => 0xa, 212 => 0xf, 213 => 0x10, 217 => 0x11, 284 => 0x205 },
	'maxaperturevalue' => { 116 => 0x9205, 350 => 0x414, 468 => 'MaxApertureValue' },
	'maxavailheight' => { 474 => 'MaxAvailHeight' },
	'maxavailwidth' => { 474 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 266 => 0xb, 267 => 0xc, 269 => '12.1', 270 => '12.1', 275 => 0xc, 276 => 0xb, 279 => '12.1', 280 => '12.1' },
	'maxfaces' => { 287 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 124 => 0x1405, 159 => 'MaxFocalLength', 211 => 0x9, 212 => 0xe, 213 => 0xf, 217 => 0x10, 284 => 0x208, 418 => 0x127c, 419 => 0x1138, 420 => 0x330, 421 => 0x330, 422 => 0x30e },
	'maximumdensityrange' => { 130 => 0x8c },
	'maxpagesize' => { 493 => 'MaxPageSize' },
	'maxpagesizeh' => { 493 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 493 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 493 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 134 => 0xc7d },
	'maxsamplevalue' => { 116 => 0x119 },
	'maxstorage' => { 483 => 'maxstorage' },
	'mb-d10batteries' => { 266 => '12.6' },
	'mb-d10batterytype' => { 275 => '13.3' },
	'mb-d11batterytype' => { 276 => '2.3' },
	'mb-d12batterytype' => { 279 => '3.2' },
	'mb-d80batteries' => { 277 => '6.5' },
	'mb-d80batterytype' => { 281 => '3.2' },
	'mcuversion' => { 211 => 0xc, 212 => 0x11, 213 => 0x12, 217 => 0x13 },
	'md5digest' => { 160 => 'zmd5' },
	'mditemfindercomment' => { 169 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 169 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 169 => 'MDItemFSLabel' },
	'mditemusertags' => { 169 => 'MDItemUserTags' },
	'meal' => { 480 => 'meal' },
	'measuredev' => { 28 => 0x9, 74 => 0x3, 94 => 0x1814, 152 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 74 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 182 => 0x690, 301 => 0x312, 304 => 0x312, 305 => 0x312, 308 => 0x3407 },
	'measuredrggb' => { 62 => 0x1 },
	'measuredrggbdata' => { 42 => 0x287 },
	'measurementaccuracy' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 115 => 'MeasurementOrFact' },
	'measurementremarks' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 115 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 447 => 'MeasureType' },
	'mechanicalshuttercount' => { 219 => 0x37 },
	'mediaconstraints' => { 293 => 'MediaConstraints' },
	'mediacreatedate' => { 362 => 0x1 },
	'mediaeventiddate' => { 452 => 'MediaEventIdDate' },
	'mediamodifydate' => { 362 => 0x2 },
	'mediasummarycode' => { 293 => 'MediaSummaryCode' },
	'mediatype' => { 358 => 'stik' },
	'memoaudioquality' => { 81 => 0x812 },
	'memorycardconfiguration' => { 399 => 0x16 },
	'memorycardnumber' => { 202 => 0x2 },
	'menubuttondisplayposition' => { 79 => 0xb, 82 => 0xa, 83 => 0xb, 86 => 0xb },
	'menubuttonreturn' => { 87 => 0xb },
	'menumonitorofftime' => { 266 => '26.1', 267 => '22.1', 269 => '22.1', 270 => '22.1', 274 => '21.1', 275 => '8.2', 276 => '21.1', 279 => '22.1', 280 => '22.1', 281 => '22.1' },
	'metadatadate' => { 486 => 'MetadataDate' },
	'metadatamoddate' => { 488 => 'metadataModDate' },
	'metaversion' => { 413 => 0x34 },
	'meterinfo1row1' => { 407 => 0x0, 408 => 0x0 },
	'meterinfo1row2' => { 407 => 0x6c, 408 => 0x5a },
	'meterinfo1row3' => { 407 => 0xd8, 408 => 0xb4 },
	'meterinfo1row4' => { 407 => 0x144, 408 => 0x10e },
	'meterinfo1row5' => { 407 => 0x1b0, 408 => 0x168 },
	'meterinfo1row6' => { 407 => 0x21c, 408 => 0x1c2 },
	'meterinfo1row7' => { 407 => 0x288, 408 => 0x21c },
	'meterinfo2row1' => { 407 => 0x2f4, 408 => 0x276 },
	'meterinfo2row2' => { 407 => 0x378, 408 => 0x2e4 },
	'meterinfo2row3' => { 407 => 0x3fc, 408 => 0x352 },
	'meterinfo2row4' => { 407 => 0x480, 408 => 0x3c0 },
	'meterinfo2row5' => { 407 => 0x504, 408 => 0x42e },
	'meterinfo2row6' => { 407 => 0x588, 408 => 0x49c },
	'meterinfo2row7' => { 407 => 0x60c, 408 => 0x50a },
	'meterinfo2row8' => { 407 => 0x690, 408 => 0x578 },
	'meterinfo2row9' => { 407 => 0x714, 408 => 0x5e6 },
	'metering' => { 268 => '6.1' },
	'meteringmode' => { 34 => 0x11, 116 => 0x9207, 136 => 0x1c, 176 => 0x7, 177 => 0x25, 179 => 0x12, 283 => 0x202, 341 => 0x17, 383 => 0x9, 393 => 0x15, 394 => 0x13, 395 => 0x7, 411 => 0x3, 414 => 0x1174, 415 => 0x1178, 416 => 0x1154, 417 => 0x11d0, 418 => 0x11ac, 419 => 0x1064, 420 => 0x25c, 421 => 0x25c, 422 => 0x24b, 468 => 'MeteringMode' },
	'meteringmode2' => { 322 => '2.1', 406 => 0x202c },
	'meteringmode3' => { 322 => '16.1' },
	'meteringoffscaleindicator' => { 179 => 0x53 },
	'meteringtime' => { 266 => '22.2', 268 => '3.2', 271 => '17.1', 272 => '18.1', 275 => '7.3', 276 => '18.1', 277 => '3.2', 281 => '19.1' },
	'micro1version' => { 368 => 0x1f },
	'micro2version' => { 368 => 0x2d },
	'midrangesharpness' => { 223 => 0x3b },
	'mieversion' => { 160 => '0Vers' },
	'mime' => { 447 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 134 => 0x3f8, 159 => 'MinAperture', 332 => '0.2' },
	'minaperturevalue' => { 350 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 124 => 0x1404, 159 => 'MinFocalLength', 211 => 0x8, 212 => 0xd, 213 => 0xe, 217 => 0xf, 284 => 0x207, 418 => 0x127a, 419 => 0x1136, 420 => 0x32e, 421 => 0x32e, 422 => 0x30c },
	'minfocusdistance' => { 332 => 0x3 },
	'minintegrationrows' => { 134 => 0x1874 },
	'minoltadate' => { 176 => 0x15 },
	'minoltaimagesize' => { 176 => 0x4, 177 => 0xc, 178 => 0x2, 181 => 0x103 },
	'minoltamodelid' => { 176 => 0x25 },
	'minoltaquality' => { 176 => 0x5, 177 => 0xd, 178 => 0x3, 181 => [0x102,0x103] },
	'minoltatime' => { 176 => 0x16 },
	'minormodelagedisclosure' => { 293 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 453 => 'MinorVersion' },
	'minsamplevalue' => { 116 => 0x118 },
	'mirrorlockup' => { 79 => 0xc, 80 => 0xc, 81 => 0x60f, 82 => 0xb, 83 => 0xc, 84 => 0x6, 85 => 0x6, 86 => 0xc, 87 => 0x3 },
	'mobilecountrycode' => { 461 => 'mcc' },
	'mobilenetworkcode' => { 461 => 'mnc' },
	'moddate' => { 296 => 'modify-date', 475 => 'ModDate' },
	'modedialposition' => { 399 => 0x14 },
	'model' => { 95 => 0x6, 116 => 0x110, 152 => 'Model', 296 => 'Model', 311 => 0x110, 341 => 0x23f, 360 => 'model', 366 => ['CNMN','cmnm',"\xa9mdl","\xa9mod"], 383 => 0x84, 447 => 'Model', 477 => 'model', 484 => 'Model' },
	'modelage' => { 474 => 'ModelAge' },
	'modelid' => { 282 => 0x0 },
	'modelingflash' => { 266 => '21.4', 267 => '31.1', 269 => '31.1', 270 => '31.1', 275 => '26.4', 276 => '30.2', 277 => '7.4', 278 => '30.1', 279 => '31.1', 280 => '31.1', 281 => '31.3' },
	'modelreleaseid' => { 293 => 'ModelReleaseID' },
	'modelreleasestatus' => { 293 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 426 => 0x52, 427 => 0x46, 428 => 0x53 },
	'modeltiepoint' => { 116 => 0x8482 },
	'modeltransform' => { 116 => 0x85d8 },
	'modelyear' => { 477 => 'modelYear' },
	'modificationdate' => { 478 => 'modificationDate' },
	'modifiedcolortemp' => { 63 => 0x9 },
	'modifieddigitalgain' => { 63 => 0xb },
	'modifiedparamflag' => { 56 => 0x1 },
	'modifiedpicturestyle' => { 63 => 0xa },
	'modifiedsaturation' => { 283 => 0x504 },
	'modifiedsensorbluelevel' => { 63 => 0x5 },
	'modifiedsensorredlevel' => { 63 => 0x4 },
	'modifiedsharpness' => { 63 => 0x2 },
	'modifiedsharpnessfreq' => { 63 => 0x3 },
	'modifiedtonecurve' => { 63 => 0x1 },
	'modifiedwhitebalance' => { 63 => 0x8 },
	'modifiedwhitebalanceblue' => { 63 => 0x7 },
	'modifiedwhitebalancered' => { 63 => 0x6 },
	'modifydate' => { 116 => 0x132, 153 => 'ModifyDate', 292 => 'ModDate', 294 => 'tIME', 357 => 'ModDate', 363 => 0x2, 486 => 'ModifyDate' },
	'moirefilter' => { 116 => 0xfe58, 462 => 'MoireFilter', 464 => 'MoireFilter' },
	'monitordisplayoff' => { 179 => 0x4c },
	'monitormatrix' => { 134 => 0x8fc },
	'monitorofftime' => { 266 => '18.2', 268 => '3.1', 277 => '3.1' },
	'monochromecolor' => { 283 => 0x53b },
	'monochromecontrast' => { 106 => 0x3c },
	'monochromefiltereffect' => { 100 => 0x20307, 106 => 0x3a, 341 => 0x73 },
	'monochromelinear' => { 106 => 0x3d },
	'monochromeoutputhighlightpoint' => { 106 => 0x41 },
	'monochromeoutputshadowpoint' => { 106 => 0x42 },
	'monochromeprofilesettings' => { 283 => 0x537 },
	'monochromerawhighlight' => { 106 => 0x7a },
	'monochromerawhighlightpoint' => { 106 => 0x3f },
	'monochromerawshadow' => { 106 => 0x83 },
	'monochromerawshadowpoint' => { 106 => 0x40 },
	'monochromesharpness' => { 106 => 0x3e },
	'monochrometoning' => { 341 => 0x74 },
	'monochrometoningeffect' => { 100 => 0x20306, 106 => 0x3b },
	'monochromeunsharpmaskfineness' => { 106 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 106 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 106 => 0xb4 },
	'monochromevignetting' => { 283 => 0x53a },
	'monthdaycreated' => { 136 => 0x12, 145 => 0xe },
	'moonphase' => { 367 => 0x12, 368 => 0x43, 369 => 0x4c },
	'morepermissions' => { 460 => 'morePermissions' },
	'motionsensitivity' => { 367 => 0x29, 369 => 0x60 },
	'movieaelockbuttonassignment' => { 279 => '40.1' },
	'moviefunc1button' => { 269 => '41.1', 270 => '41.1', 280 => '41.1' },
	'moviefunctionbutton' => { 267 => '41.1', 279 => '41.1' },
	'moviefunctionbuttonplusdials' => { 267 => '52.1' },
	'moviepreviewbutton' => { 267 => '41.2', 269 => '41.2', 270 => '41.2', 279 => '41.2', 280 => '41.2' },
	'moviepreviewbuttonplusdials' => { 267 => '52.2' },
	'movieshutterbutton' => { 267 => '38.3', 269 => '38.3', 270 => '38.3', 279 => '38.3', 280 => '38.3' },
	'moviesubselectorassignment' => { 267 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 267 => '53.1' },
	'multiburstimageheight' => { 406 => 0x1002 },
	'multiburstimagewidth' => { 406 => 0x1001 },
	'multiburstmode' => { 406 => 0x1000 },
	'multicontrollerwhilemetering' => { 81 => 0x517 },
	'multiexposure' => { 65 => 0x1, 306 => 0xb4 },
	'multiexposureautogain' => { 220 => 0x3 },
	'multiexposurecontrol' => { 65 => 0x2 },
	'multiexposuremode' => { 220 => 0x1 },
	'multiexposureshots' => { 65 => 0x3, 220 => 0x2 },
	'multiframenoisereduction' => { 395 => 0x35, 406 => 0x200b, 411 => 0x15 },
	'multiframenreffect' => { 406 => 0x2023 },
	'multifunctionlock' => { 81 => 0x70f },
	'multipleexposuremode' => { 287 => 0x101c },
	'multipleexposureset' => { 322 => '10.1' },
	'multisample' => { 227 => 0x40 },
	'multiselector' => { 266 => '9.4', 267 => '10.3', 269 => '10.3', 270 => '10.3', 275 => '27.4', 279 => '10.3', 280 => '10.3' },
	'multiselectorliveview' => { 266 => '4.3', 269 => '37.1', 270 => '37.1', 279 => '37.1', 280 => '37.1' },
	'multiselectorliveviewmode' => { 237 => 0x18c2 },
	'multiselectorplaybackmode' => { 266 => ['13.5','9.2'], 267 => '10.2', 270 => '10.2', 275 => '27.2', 279 => '10.2', 280 => '10.2' },
	'multiselectorshootmode' => { 266 => '9.1', 267 => '10.1', 269 => '10.1', 270 => '10.1', 275 => '27.1', 279 => '10.1', 280 => '10.1' },
	'multishot' => { 311 => 0x121 },
	'mute' => { 360 => 'player.movie.audio.mute' },
	'mycolormode' => { 66 => 0x2 },
	'name' => { 366 => 'name' },
	'narrator' => { 358 => "\xa9nrt" },
	'nationalcatalognumber' => { 478 => 'nationalCatalogNumber' },
	'nativedigest' => { 468 => 'NativeDigest', 484 => 'NativeDigest' },
	'ndfilter' => { 74 => 0x1c, 283 => 0x204, 373 => 0x1019 },
	'near' => { 447 => 'Near' },
	'nefbitdepth' => { 219 => 0xe22 },
	'nefcompression' => { 219 => 0x93 },
	'neflinearizationtable' => { 219 => 0x96 },
	'negativecachelargepreviewsize' => { 462 => 'NegativeCacheLargePreviewSize', 464 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 462 => 'NegativeCacheMaximumSize', 464 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 462 => 'NegativeCachePath', 464 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 341 => 0x88 },
	'neutraloutputhighlightpoint' => { 106 => 0x2f },
	'neutraloutputshadowpoint' => { 106 => 0x30 },
	'neutralrawcolortone' => { 106 => 0x28 },
	'neutralrawcontrast' => { 106 => 0x2a },
	'neutralrawhighlight' => { 106 => 0x78 },
	'neutralrawhighlightpoint' => { 106 => 0x2d },
	'neutralrawlinear' => { 106 => 0x2b },
	'neutralrawsaturation' => { 106 => 0x29 },
	'neutralrawshadow' => { 106 => 0x81 },
	'neutralrawshadowpoint' => { 106 => 0x2e },
	'neutralrawsharpness' => { 106 => 0x2c },
	'neutralunsharpmaskfineness' => { 106 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 106 => 0xa8 },
	'neutraunsharpmaskstrength' => { 106 => 0xa4 },
	'newrawimagedigest' => { 116 => 0xc7a7 },
	'newsphotoversion' => { 130 => 0x0 },
	'nickname' => { 486 => 'Nickname' },
	'nikoncapturedata' => { 219 => 0xe01 },
	'nikoncaptureeditversions' => { 219 => 0xe13 },
	'nikoncaptureoffsets' => { 219 => 0xe0e },
	'nikoncaptureoutput' => { 219 => 0xe1e },
	'nikoncaptureversion' => { 219 => 0xe09 },
	'nikoniccprofile' => { 219 => 0xe1d },
	'nikonimagesize' => { 234 => '723.1', 235 => '732.1', 244 => 0x2c4 },
	'nikonmeteringmode' => { 238 => 0x2ea4, 246 => 0x175e },
	'noisefilter' => { 283 => 0x527 },
	'noiseprofile' => { 116 => 0xc761 },
	'noisereduction' => { 124 => [0x100b,0x100e], 177 => 0xb0, 178 => 0x60, 179 => 0x3f, 219 => 0x95, 259 => 0x753dcbc0, 260 => 0x17, 283 => 0x50a, 288 => 0x103a, 306 => 0x2d, 341 => 0x49, 373 => 0x100f, 375 => 0x2a },
	'noisereduction2' => { 287 => 0x1010 },
	'noisereductionapplied' => { 116 => 0xc6f7 },
	'noisereductionintensity' => { 260 => 0x9 },
	'noisereductionmethod' => { 260 => 0x11 },
	'noisereductionmode' => { 439 => 0x801e },
	'noisereductionparametersatcapture' => { 134 => 0xe73 },
	'noisereductionparameterscamera' => { 134 => 0xe72 },
	'noisereductionparametershost3mp' => { 134 => 0xe71 },
	'noisereductionparametershost6mp' => { 134 => 0xe70 },
	'noisereductionparametershostrgb' => { 134 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 134 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 134 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 134 => 0xe63 },
	'noisereductionparams' => { 311 => 0x1b },
	'noisereductionsharpness' => { 260 => 0xd },
	'noisereductionstrength' => { 306 => 0xd6 },
	'noisereductionvalue' => { 439 => 0x8027 },
	'nomemorycard' => { 266 => '22.1', 267 => '4.2', 268 => '0.3', 271 => '2.4', 272 => '3.2', 273 => '3.2', 275 => '33.7', 276 => '3.2', 277 => '0.3', 279 => '4.2', 281 => '4.5' },
	'nominalmaxaperture' => { 332 => 0xa },
	'nominalminaperture' => { 332 => '10.1' },
	'normallinetime' => { 134 => 0x186a },
	'normalwhitelevel' => { 43 => [0x2b8,0x2cf,0x2d3], 44 => 0x569, 45 => 0x1e3, 46 => [0x1fc,0x2dc], 47 => [0x230,0x30e], 48 => 0x31c },
	'notes' => { 440 => 'Notes', 457 => 'notes' },
	'npages' => { 493 => 'NPages' },
	'nullrecord' => { 94 => 0x0 },
	'numafpoints' => { 318 => 0x2 },
	'number' => { 478 => 'number' },
	'numberofbeats' => { 488 => 'numberOfBeats' },
	'numberoffocuspoints' => { 269 => '1.3', 270 => '1.3', 273 => '0.2', 274 => '0.3', 276 => '0.3' },
	'numfaceelements' => { 124 => 0x4200 },
	'numfacepositions' => { 298 => 0x0 },
	'numindexentries' => { 130 => 0x54 },
	'numwbentries' => { 312 => 0x0, 313 => 0x0 },
	'object' => { 478 => 'object' },
	'objectattributereference' => { 128 => 0x4 },
	'objectcycle' => { 128 => 0x4b, 457 => 'ObjectCycle' },
	'objectdescription' => { 477 => 'objectDescription' },
	'objectdistance' => { 109 => 0x6, 110 => 0x2022 },
	'objectname' => { 128 => 0x5 },
	'objectpreviewdata' => { 128 => 0xca },
	'objectpreviewfileformat' => { 128 => 0xc8 },
	'objectpreviewfileversion' => { 128 => 0xc9 },
	'objectsubtype' => { 477 => 'objectSubtype' },
	'objecttype' => { 477 => 'objectType' },
	'objecttypereference' => { 128 => 0x3 },
	'occurrence' => { 115 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 115 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 115 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 115 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 115 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 115 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 115 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 115 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 115 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 115 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 115 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 115 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 115 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 115 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 115 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 115 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 115 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 115 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 115 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 115 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 115 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 115 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 115 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 115 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 115 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 115 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 468 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 468 => [\'OECF','OECFNames'] },
	'oecfrows' => { 468 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 468 => [\'OECF','OECFValues'] },
	'offsaledate' => { 478 => 'offSaleDate' },
	'offsaledatea-platform' => { 478 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 478 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 134 => 0x190a },
	'offsetschema' => { 116 => 0xea1d },
	'offsettime' => { 116 => 0x9010 },
	'offsettimedigitized' => { 116 => 0x9012 },
	'offsettimeoriginal' => { 116 => 0x9011 },
	'okbutton' => { 276 => '15.1', 281 => '16.1' },
	'oldsubfiletype' => { 116 => 0xff },
	'olympusimageheight' => { 288 => 0x102f },
	'olympusimagewidth' => { 288 => 0x102e },
	'omenatcapturestrength' => { 134 => 0xa60 },
	'omenautostrength' => { 134 => 0xa5f },
	'omenearlystrength' => { 134 => 0xa5e },
	'omenfocallengthlimit' => { 134 => 0xa62 },
	'omeninitialipfstrength' => { 134 => 0xa5d },
	'omensurfaceindex' => { 134 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 288 => 0x302 },
	'onsaledate' => { 478 => 'onSaleDate' },
	'onsaledatea-platform' => { 478 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 478 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 478 => 'onSaleDay' },
	'onsaledaya-platform' => { 478 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 478 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 116 => 0xc740 },
	'opcodelist2' => { 116 => 0xc741 },
	'opcodelist3' => { 116 => 0xc74e },
	'opticalzoom' => { 138 => 0xfa3d, 140 => [0x6006,0xf006], 141 => 0x1000, 142 => 0xf, 145 => 0x1e, 147 => 0x20, 148 => 0x1c, 159 => 'OpticalZoom' },
	'opticalzoomcode' => { 74 => 0xa },
	'opticalzoommode' => { 306 => 0x34 },
	'opticalzoomon' => { 382 => 0x219 },
	'optionenddate' => { 481 => 'optionEndDate' },
	'opto-electricconvfactor' => { 468 => 'OECF' },
	'orangehsl' => { 100 => 0x20911 },
	'ordernumber' => { 124 => 0x8002 },
	'organisationinimagecode' => { 474 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 474 => 'OrganisationInImageName' },
	'organism' => { 115 => 'Organism' },
	'organismassociatedoccurrences' => { 115 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 115 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 115 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 115 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 115 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 115 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 115 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 478 => 'organization' },
	'orientation' => { 116 => 0x112, 311 => 0x112, 477 => 'orientation', 484 => 'Orientation' },
	'orientation2' => { 411 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 81 => 0x516 },
	'originalbestqualitysize' => { 116 => 0xc792 },
	'originalcreatedatetime' => { 452 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 111 => 'Canon::OriginalDecisionData' },
	'originaldecisiondataoffset' => { 61 => 0x83 },
	'originaldefaultcropsize' => { 116 => 0xc793 },
	'originaldefaultfinalsize' => { 116 => 0xc791 },
	'originaldirectory' => { 303 => 0x408 },
	'originaldocumentid' => { 489 => 'OriginalDocumentID' },
	'originalfilename' => { 94 => 0x816, 134 => 0x3e9, 146 => 0x20, 303 => 0x407, 452 => 'OriginalFilename' },
	'originalimageheight' => { 76 => 0xc, 120 => 0x1 },
	'originalimagewidth' => { 76 => 0xb, 120 => 0x0 },
	'originalrawfiledata' => { 116 => 0xc68c },
	'originalrawfiledigest' => { 116 => 0xc71d },
	'originalrawfilename' => { 116 => 0xc68b },
	'originaltransmissionreference' => { 128 => 0x67 },
	'originatingprogram' => { 128 => 0x41, 457 => 'OriginatingProgram' },
	'originplatform' => { 478 => 'originPlatform' },
	'os' => { 466 => 'os' },
	'otherconditions' => { 293 => 'OtherConditions' },
	'otherconstraints' => { 293 => 'OtherConstraints' },
	'otherimage' => { 111 => 'Exif::OtherImage' },
	'otherimageinfo' => { 293 => 'OtherImageInfo' },
	'otherimagelength' => { 116 => 0x202 },
	'otherimagestart' => { 116 => 0x201 },
	'otherlicensedocuments' => { 293 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 293 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 293 => 'OtherLicenseRequirements' },
	'outcue' => { 488 => 'outCue' },
	'outcuescale' => { 488 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 488 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 191 => 0x3 },
	'outputimagewidth' => { 191 => 0x2 },
	'outputlut' => { 306 => 0xa7 },
	'outputprofile' => { 134 => 0x138b },
	'outputresolution' => { 191 => 0x4 },
	'overclockcols' => { 134 => 0x189c },
	'overclockrows' => { 134 => 0x18c4 },
	'overridelookvignette' => { 462 => 'OverrideLookVignette', 464 => 'OverrideLookVignette' },
	'owner' => { 492 => 'Owner' },
	'ownerid' => { 128 => 0xbc },
	'ownername' => { 15 => 0x10f, 61 => 0x9, 94 => 0x810, 116 => [0xa430,0xfde8], 152 => 'OwnerName', 459 => 'OwnerName', 469 => 'CameraOwnerName' },
	'padding' => { 116 => 0xea1c },
	'pagecount' => { 478 => 'pageCount' },
	'pageimage' => { 486 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 486 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 486 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 486 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 486 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 486 => 'PageInfo' },
	'pagename' => { 116 => 0x11d },
	'pagenumber' => { 116 => 0x129 },
	'pageprogressiondirection' => { 478 => 'pageProgressionDirection' },
	'pagerange' => { 478 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 462 => 'PaintBasedCorrections', 464 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 462 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 464 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 309 => 0x0 },
	'panasonicexifversion' => { 306 => 0x26 },
	'panasonicimageheight' => { 306 => 0x4c },
	'panasonicimagewidth' => { 306 => 0x4b },
	'panasonicrawversion' => { 311 => 0x1 },
	'panasonictitle' => { 116 => 0xc6d2 },
	'panasonictitle2' => { 116 => 0xc6d3 },
	'panoramaangle' => { 124 => 0x1153 },
	'panoramacropbottom' => { 412 => 0x7 },
	'panoramacropleft' => { 412 => 0x4 },
	'panoramacropright' => { 412 => 0x6 },
	'panoramacroptop' => { 412 => 0x5 },
	'panoramadirection' => { 69 => 0x5, 124 => 0x1154, 412 => 0x3 },
	'panoramaframeheight' => { 412 => 0x9 },
	'panoramaframenumber' => { 69 => 0x2 },
	'panoramaframewidth' => { 412 => 0x8 },
	'panoramafullheight' => { 412 => 0x2 },
	'panoramafullwidth' => { 412 => 0x1 },
	'panoramamode' => { 136 => 0x3c, 283 => 0x601 },
	'panoramasize3d' => { 395 => 0x38 },
	'panoramasourceheight' => { 412 => 0xb },
	'panoramasourcewidth' => { 412 => 0xa },
	'panoramicstitchcameramotion' => { 172 => 'PanoramicStitchCameraMotion', 173 => 0x1 },
	'panoramicstitchmaptype' => { 172 => 'PanoramicStitchMapType', 173 => 0x2 },
	'panoramicstitchphi0' => { 172 => 'PanoramicStitchPhi0', 173 => 0x5 },
	'panoramicstitchphi1' => { 172 => 'PanoramicStitchPhi1', 173 => 0x6 },
	'panoramicstitchtheta0' => { 172 => 'PanoramicStitchTheta0', 173 => 0x3 },
	'panoramicstitchtheta1' => { 172 => 'PanoramicStitchTheta1', 173 => 0x4 },
	'panoramicstitchversion' => { 173 => 0x0 },
	'pantry' => { 489 => 'Pantry' },
	'pantryinstanceid' => { 489 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 124 => 0xb211, 282 => 0x28 },
	'parametricdarks' => { 462 => 'ParametricDarks', 464 => 'ParametricDarks' },
	'parametrichighlights' => { 462 => 'ParametricHighlights', 464 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 462 => 'ParametricHighlightSplit', 464 => 'ParametricHighlightSplit' },
	'parametriclights' => { 462 => 'ParametricLights', 464 => 'ParametricLights' },
	'parametricmidtonesplit' => { 462 => 'ParametricMidtoneSplit', 464 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 462 => 'ParametricShadows', 464 => 'ParametricShadows' },
	'parametricshadowsplit' => { 462 => 'ParametricShadowSplit', 464 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 452 => 'ParentMediaEventID' },
	'parentmeid' => { 452 => 'ParentMEID' },
	'parentproductid' => { 358 => '@ppi' },
	'parentreference1' => { 472 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 472 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 358 => '@PST' },
	'parenttitle' => { 358 => '@pti' },
	'partialactivecols1' => { 134 => 0x17e8 },
	'partialactivecols2' => { 134 => 0x17f2 },
	'partialactiverows1' => { 134 => 0x17fc },
	'partialactiverows2' => { 134 => 0x1806 },
	'partofcompilation' => { 488 => 'partOfCompilation' },
	'patientbirthdate' => { 441 => 'PatientDOB' },
	'patientid' => { 441 => 'PatientID' },
	'patientname' => { 441 => 'PatientName' },
	'patientsex' => { 441 => 'PatientSex' },
	'patternareaheight' => { 134 => 0x963 },
	'patternareawidth' => { 134 => 0x962 },
	'patterncorrectionfactorscale' => { 134 => 0x969 },
	'patterncropcols1' => { 134 => 0x96c },
	'patterncropcols2' => { 134 => 0x96d },
	'patterncroprows1' => { 134 => 0x96a },
	'patterncroprows2' => { 134 => 0x96b },
	'patternimagerheight' => { 134 => 0x961 },
	'patternimagerwidth' => { 134 => 0x960 },
	'patternx' => { 134 => 0x966 },
	'patterny' => { 134 => 0x967 },
	'pdfversion' => { 475 => 'PDFVersion' },
	'pentaximagesize' => { 341 => 0x9 },
	'pentaxmodelid' => { 321 => 0x0, 341 => 0x5 },
	'pentaxmodeltype' => { 341 => 0x1 },
	'pentaxversion' => { 341 => 0x0 },
	'people' => { 443 => 'People', 455 => 'People' },
	'perchannelblacklevel' => { 42 => 0xc4, 43 => [0x2b4,0x2cb,0x2cf], 44 => [0x108,0x14d], 45 => 0x1df, 46 => [0x1f8,0x2d8], 47 => [0x22c,0x30a], 48 => 0x149 },
	'performer' => { 358 => 'perf', 366 => 'perf' },
	'performerkeywords' => { 366 => "\xa9prk" },
	'performers' => { 366 => "\xa9prf" },
	'performerurl' => { 366 => "\xa9prl" },
	'peripheralillumcentralradius' => { 439 => 0x8030 },
	'peripheralillumcentralvalue' => { 439 => 0x8031 },
	'peripheralillumination' => { 100 => 0x20702, 106 => 0x68 },
	'peripheralilluminationcorr' => { 60 => 0x1, 331 => 0x2 },
	'peripheralilluminationon' => { 100 => '0x20702.0', 106 => 0x64 },
	'peripheralillumperiphvalue' => { 439 => 0x8032 },
	'peripherallighting' => { 76 => 0x2, 124 => 0x3804 },
	'peripherallightingsetting' => { 77 => 0x5 },
	'peripherallightingvalue' => { 76 => 0x6 },
	'permissions' => { 481 => 'permissions' },
	'permits' => { 460 => 'permits' },
	'person' => { 478 => 'person' },
	'personality' => { 452 => 'Personality' },
	'personheard' => { 474 => 'PersonHeard' },
	'personheardidentifier' => { 474 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 474 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 474 => 'PersonInImage' },
	'personinimagecharacteristic' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 474 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 474 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 462 => 'PerspectiveAspect', 464 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 462 => 'PerspectiveHorizontal', 464 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 462 => 'PerspectiveRotate', 464 => 'PerspectiveRotate' },
	'perspectivescale' => { 462 => 'PerspectiveScale', 464 => 'PerspectiveScale' },
	'perspectiveupright' => { 462 => 'PerspectiveUpright', 464 => 'PerspectiveUpright' },
	'perspectivevertical' => { 462 => 'PerspectiveVertical', 464 => 'PerspectiveVertical' },
	'perspectivex' => { 462 => 'PerspectiveX', 464 => 'PerspectiveX' },
	'perspectivey' => { 462 => 'PerspectiveY', 464 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 89 => 0x1 },
	'pf10retainprogramshift' => { 89 => 0xb },
	'pf13drivepriority' => { 89 => 0xe },
	'pf14disablefocussearch' => { 89 => 0xf },
	'pf15disableafassistbeam' => { 89 => 0x10 },
	'pf16autofocuspointshoot' => { 89 => 0x11 },
	'pf17disableafpointsel' => { 89 => 0x12 },
	'pf18enableautoafpointsel' => { 89 => 0x13 },
	'pf19continuousshootspeed' => { 89 => 0x14 },
	'pf19shootingspeedhigh' => { 88 => 0xa },
	'pf19shootingspeedlow' => { 88 => 0x9 },
	'pf1disableshootingmodes' => { 89 => 0x2 },
	'pf1value' => { 88 => 0x1 },
	'pf20limitcontinousshots' => { 89 => 0x15 },
	'pf20maxcontinousshots' => { 88 => 0xb },
	'pf21enablequietoperation' => { 89 => 0x16 },
	'pf23felocktime' => { 88 => 0xd },
	'pf23postreleasetime' => { 88 => 0xe },
	'pf23settimerlengths' => { 89 => 0x18 },
	'pf23shutterbuttontime' => { 88 => 0xc },
	'pf24lightlcdduringbulb' => { 89 => 0x19 },
	'pf25aemode' => { 88 => 0xf },
	'pf25afmode' => { 88 => 0x12 },
	'pf25afpointsel' => { 88 => 0x13 },
	'pf25colormatrix' => { 88 => 0x17 },
	'pf25defaultclearsettings' => { 89 => 0x1a },
	'pf25drivemode' => { 88 => 0x11 },
	'pf25imagesize' => { 88 => 0x14 },
	'pf25meteringmode' => { 88 => 0x10 },
	'pf25parameters' => { 88 => 0x16 },
	'pf25wbmode' => { 88 => 0x15 },
	'pf26shortenreleaselag' => { 89 => 0x1b },
	'pf27reversedialrotation' => { 89 => 0x1c },
	'pf27value' => { 88 => 0x18 },
	'pf28noquickdialexpcomp' => { 89 => 0x1d },
	'pf29quickdialswitchoff' => { 89 => 0x1e },
	'pf2disablemeteringmodes' => { 89 => 0x3 },
	'pf2value' => { 88 => 0x2 },
	'pf30enlargementmode' => { 89 => 0x1f },
	'pf31originaldecisiondata' => { 89 => 0x20 },
	'pf3manualexposuremetering' => { 89 => 0x4 },
	'pf3value' => { 88 => 0x3 },
	'pf4exposuretimelimits' => { 89 => 0x5 },
	'pf4exposuretimemax' => { 88 => 0x5 },
	'pf4exposuretimemin' => { 88 => 0x4 },
	'pf5aperturelimits' => { 89 => 0x6 },
	'pf5aperturemax' => { 88 => 0x7 },
	'pf5aperturemin' => { 88 => 0x6 },
	'pf6presetshootingmodes' => { 89 => 0x7 },
	'pf7bracketcontinuousshoot' => { 89 => 0x8 },
	'pf8bracketshots' => { 88 => 0x8 },
	'pf8setbracketshots' => { 89 => 0x9 },
	'pf9changebracketsequence' => { 89 => 0xa },
	'phasedetectaf' => { 188 => 0x6 },
	'phonenumber' => { 153 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 259 => 0xe9651831 },
	'photoeffects' => { 259 => 0xab5eca5e },
	'photoeffectsblue' => { 261 => 0x8 },
	'photoeffectsgreen' => { 261 => 0x6 },
	'photoeffectsred' => { 261 => 0x4 },
	'photoeffectstype' => { 261 => 0x0 },
	'photographicsensitivity' => { 469 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 266 => '17.6', 275 => '33.6' },
	'photometricinterpretation' => { 116 => 0x106, 484 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 238 => 0xe7d, 247 => 0xfbd },
	'photoshootingmenubankimagearea' => { 238 => '3716.1', 247 => 0x791 },
	'photoshopbgrthumbnail' => { 355 => 0x409 },
	'photoshopquality' => { 354 => 0x0 },
	'photoshopthumbnail' => { 355 => 0x40c },
	'photostyle' => { 306 => 0x89 },
	'picklabel' => { 467 => 'PickLabel' },
	'pictinfo' => { 382 => 0x208 },
	'picturecontrol' => { 259 => 0xe2173c47 },
	'picturecontrolactive' => { 262 => 0x0 },
	'picturecontroladjust' => { 221 => 0x30, 222 => 0x30, 223 => 0x36 },
	'picturecontrolbase' => { 221 => 0x18, 222 => 0x18, 223 => 0x1c },
	'picturecontroldata' => { 219 => [0xbd,0x23] },
	'picturecontrolmode' => { 262 => 0x13 },
	'picturecontrolname' => { 221 => 0x4, 222 => 0x4, 223 => 0x8 },
	'picturecontrolquickadjust' => { 221 => 0x31, 222 => 0x31, 223 => 0x37 },
	'pictureeffect' => { 406 => 0x200e },
	'pictureeffect2' => { 414 => 0x1163, 415 => 0x1167, 416 => 0x1143, 417 => 0x11bf, 418 => 0x119b, 419 => 0x1053, 420 => 0x24b, 421 => 0x24b, 422 => 0x23c, 435 => 0x46 },
	'picturefinish' => { 177 => 0x71 },
	'picturemode' => { 124 => 0x1031, 283 => 0x520, 341 => [0xb,0x33], 383 => 0x3d },
	'picturemode2' => { 322 => 0x0 },
	'picturemodebwfilter' => { 283 => 0x525 },
	'picturemodecontrast' => { 283 => 0x523 },
	'picturemodeeffect' => { 283 => 0x52d },
	'picturemodehue' => { 283 => 0x522 },
	'picturemodesaturation' => { 283 => 0x521 },
	'picturemodesharpness' => { 283 => 0x524 },
	'picturemodetone' => { 283 => 0x526 },
	'pictureprofile' => { 414 => [0x115e,0x115f], 415 => [0x1162,0x1163], 416 => [0x113e,0x113f], 417 => [0x11ba,0x11bb], 418 => [0x1196,0x1197], 419 => [0x104e,0x104f], 420 => [0x246,0x247], 421 => [0x246,0x247], 422 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 71 => 0xa, 100 => 0x20301, 106 => 0x2 },
	'picturestylepc' => { 61 => 0x4009 },
	'picturestyleuserdef' => { 61 => 0x4008 },
	'picturewizard' => { 380 => 0x21 },
	'picturewizardcolor' => { 379 => 0x1 },
	'picturewizardcontrast' => { 379 => 0x4 },
	'picturewizardmode' => { 379 => 0x0 },
	'picturewizardsaturation' => { 379 => 0x2 },
	'picturewizardsharpness' => { 379 => 0x3 },
	'pipelineversion' => { 172 => 'PipelineVersion' },
	'pitch' => { 112 => 0x6, 267 => '4.1', 279 => '4.1', 366 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 237 => 0x350f, 238 => 0x2c28, 246 => 0x36f8, 283 => 0x904, 306 => 0x91, 340 => 0x2, 378 => 0x1 },
	'pitchshift' => { 360 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 359 => 'pasp' },
	'pixelclockfrequency' => { 134 => 0x40b },
	'pixelcorrectionoffset' => { 134 => 0x972 },
	'pixelcorrectionscale' => { 134 => 0x971 },
	'pixelscale' => { 116 => 0x830e },
	'pixelshiftinfo' => { 406 => 0x202f },
	'pixelshiftresolution' => { 342 => 0x0 },
	'pixelsperunitx' => { 295 => 0x0 },
	'pixelsperunity' => { 295 => 0x4 },
	'pixelunits' => { 295 => 0x8 },
	'planarconfiguration' => { 116 => 0x11c, 484 => 'PlanarConfiguration' },
	'plane' => { 442 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 442 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 442 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 442 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 442 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 442 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 442 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 442 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 442 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 442 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 442 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 442 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 442 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 442 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 442 => 'Planes' },
	'planningref' => { 474 => 'PlanningRef' },
	'planningrefidentifier' => { 474 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 474 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 474 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 493 => 'PlateNames' },
	'platform' => { 478 => 'platform' },
	'playallframes' => { 366 => 'AllF' },
	'playbackmenustime' => { 271 => '20.1', 272 => '21.1', 273 => '21.1' },
	'playbackmonitorofftime' => { 266 => '25.2', 267 => '36.1', 269 => '36.1', 270 => '36.1', 274 => '35.1', 275 => '8.1', 276 => '35.1', 279 => '36.1', 280 => '36.1', 281 => '21.1' },
	'playbackzoom' => { 267 => '37.1' },
	'playdisplay' => { 179 => 0x4e },
	'playerversion' => { 360 => 'player.version' },
	'playgap' => { 358 => 'pgap' },
	'playlistid' => { 358 => 'plID' },
	'playmode' => { 366 => 'SDLN' },
	'playselection' => { 366 => 'SelO' },
	'plusversion' => { 293 => 'Version' },
	'pmversion' => { 353 => 'PMVersion' },
	'pngwarning' => { 296 => 'Warning' },
	'podcast' => { 358 => 'pcst' },
	'podcasturl' => { 358 => 'purl' },
	'poilevel' => { 218 => 0x8 },
	'portraitnote' => { 445 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 106 => 0x1d },
	'portraitoutputshadowpoint' => { 106 => 0x1e },
	'portraitrawcolortone' => { 106 => 0x16 },
	'portraitrawcontrast' => { 106 => 0x18 },
	'portraitrawhighlight' => { 106 => 0x76 },
	'portraitrawhighlightpoint' => { 106 => 0x1b },
	'portraitrawlinear' => { 106 => 0x19 },
	'portraitrawsaturation' => { 106 => 0x17 },
	'portraitrawshadow' => { 106 => 0x7f },
	'portraitrawshadowpoint' => { 106 => 0x1c },
	'portraitrawsharpness' => { 106 => 0x1a },
	'portraitrefiner' => { 110 => 0x302b },
	'portraitrequest' => { 445 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 106 => 0x9a },
	'portraitunsharpmaskstrength' => { 106 => 0x98 },
	'portraitunsharpmaskthreshold' => { 106 => 0x9c },
	'portraitversion' => { 445 => 'PortraitVersion' },
	'pose' => { 442 => 'Pose' },
	'poseheadingdegrees' => { 450 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 450 => 'PosePitchDegrees' },
	'posepositionx' => { 442 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 442 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 442 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 450 => 'PoseRollDegrees' },
	'poserotationw' => { 442 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 442 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 442 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 442 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 442 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 477 => 'positionDescriptor' },
	'postalcode' => { 157 => 'PostalCode' },
	'postcropvignetteamount' => { 462 => 'PostCropVignetteAmount', 464 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 462 => 'PostCropVignetteFeather', 464 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 462 => 'PostCropVignetteHighlightContrast', 464 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 462 => 'PostCropVignetteMidpoint', 464 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 462 => 'PostCropVignetteRoundness', 464 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 462 => 'PostCropVignetteStyle', 464 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 403 => 0xb },
	'potentialface2position' => { 403 => 0x15 },
	'potentialface3position' => { 403 => 0x1f },
	'potentialface4position' => { 403 => 0x29 },
	'potentialface5position' => { 403 => 0x33 },
	'potentialface6position' => { 403 => 0x3d },
	'potentialface7position' => { 403 => 0x47 },
	'potentialface8position' => { 403 => 0x51 },
	'powersource' => { 320 => '0.1' },
	'poweruptime' => { 219 => 0xb6 },
	'precaptureframes' => { 288 => 0x300 },
	'predictor' => { 116 => 0x13d },
	'preflashreturnstrength' => { 235 => 0x28a },
	'prefs' => { 128 => 0xdd, 353 => 'Prefs' },
	'prereadfastresetcount' => { 134 => 0x187e },
	'preservedfilename' => { 489 => 'PreservedFileName' },
	'preservedspecimen' => { 115 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 115 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 179 => 0x24, 439 => 0x8002 },
	'presetwhitebalanceadj' => { 439 => 0x8014 },
	'pressure' => { 116 => 0x9402, 469 => 'Pressure' },
	'previewapplicationname' => { 116 => 0xc716 },
	'previewapplicationversion' => { 116 => 0xc717 },
	'previewbutton' => { 266 => ['14.1','15.1'], 267 => '15.1', 269 => '15.1', 270 => '15.1', 275 => '29.1', 276 => '14.1', 279 => '15.1', 280 => '15.1' },
	'previewbuttonplusdials' => { 266 => ['14.2','15.2'], 267 => '15.2', 269 => '43.1', 270 => '43.1', 275 => '31.2', 279 => '43.1', 280 => '43.1' },
	'previewcolorspace' => { 116 => 0xc71a },
	'previewcropbottom' => { 352 => 0xef },
	'previewcropleft' => { 352 => 0xec },
	'previewcropright' => { 352 => 0xee },
	'previewcroptop' => { 352 => 0xed },
	'previewdate' => { 364 => 0x0 },
	'previewdatetime' => { 116 => 0xc71b },
	'previewimage' => { 110 => 0x2000, 111 => 'Exif::PreviewImage', 117 => 'PreviewImage', 119 => 0x4, 162 => 'data', 181 => 0x81, 288 => 0x280, 304 => 0x300, 406 => 0x2001 },
	'previewimageborders' => { 341 => 0x3e },
	'previewimageheight' => { 70 => 0x4, 138 => 0xfa58 },
	'previewimagelength' => { 70 => 0x2, 110 => 0x3, 116 => [0x117,0x202], 181 => 0x89, 224 => 0x202, 283 => 0x102, 288 => 0x1037, 341 => 0x3, 372 => 0x1e, 377 => 0x3, 383 => [0x1b,0x1d], 396 => 0x202 },
	'previewimagename' => { 162 => '1Name' },
	'previewimagesize' => { 110 => 0x2, 143 => 0x2, 162 => 'ImageSize', 341 => 0x2, 383 => [0x1c,0x1e], 406 => 0xb02c, 439 => 0x9012 },
	'previewimagestart' => { 70 => 0x5, 110 => 0x4, 116 => [0x111,0x201], 181 => 0x88, 224 => 0x201, 283 => 0x101, 288 => 0x1036, 341 => 0x4, 372 => 0x1c, 377 => 0x2, 383 => [0x1a,0x1c], 396 => 0x201 },
	'previewimagetype' => { 162 => '0Type' },
	'previewimagevalid' => { 283 => 0x100, 288 => 0x1035 },
	'previewimagewidth' => { 70 => 0x3, 138 => 0xfa57 },
	'previewquality' => { 70 => 0x1 },
	'previewsettingsdigest' => { 116 => 0xc719 },
	'previewsettingsname' => { 116 => 0xc718 },
	'primaryafpoint' => { 188 => [0x44,0x7] },
	'primarychromaticities' => { 116 => 0x13f, 484 => 'PrimaryChromaticities' },
	'primaryftp' => { 452 => 'PrimaryFTP' },
	'primaryslot' => { 238 => 0xe7f, 247 => 0xfbf },
	'printim' => { 116 => 0xc4a5 },
	'prioritysetinawb' => { 406 => 0x202b },
	'prioritysetupshutterrelease' => { 179 => 0x1d, 393 => 0x28 },
	'privatertkinfo' => { 454 => 'privateRTKInfo' },
	'processbordercolsleft' => { 134 => 0xc61 },
	'processbordercolsright' => { 134 => 0xc62 },
	'processborderrowsbottom' => { 134 => 0xc64 },
	'processborderrowstop' => { 134 => 0xc63 },
	'processingsoftware' => { 116 => 0xb },
	'processversion' => { 462 => 'ProcessVersion', 464 => 'ProcessVersion' },
	'producer' => { 292 => 'Producer', 360 => 'producer', 366 => "\xa9prd", 475 => 'Producer' },
	'producerkeywords' => { 366 => "\xa9pdk" },
	'productcode' => { 478 => 'productCode' },
	'productid' => { 129 => 0x32, 358 => 'prID', 477 => 'productID' },
	'productidtype' => { 477 => 'productIDType' },
	'productinimage' => { 474 => 'ProductInImage' },
	'productinimagedescription' => { 474 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 474 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 474 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 321 => 0x2 },
	'productorserviceconstraints' => { 293 => 'ProductOrServiceConstraints' },
	'productversion' => { 358 => 'VERS' },
	'profession' => { 478 => 'profession' },
	'profile' => { 442 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 116 => 0xc6f4 },
	'profilecameraindices' => { 442 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 116 => 0xc6fe },
	'profileembedpolicy' => { 116 => 0xc6fd },
	'profilehuesatmapdata1' => { 116 => 0xc6fa },
	'profilehuesatmapdata2' => { 116 => 0xc6fb },
	'profilehuesatmapdims' => { 116 => 0xc6f9 },
	'profilehuesatmapencoding' => { 116 => 0xc7a3 },
	'profilelooktabledata' => { 116 => 0xc726 },
	'profilelooktabledims' => { 116 => 0xc725 },
	'profilelooktableencoding' => { 116 => 0xc7a4 },
	'profilename' => { 116 => 0xc6f8 },
	'profiles' => { 442 => 'Profiles' },
	'profiletonecurve' => { 116 => 0xc6fc },
	'profiletype' => { 442 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 306 => 0x3c },
	'programline' => { 322 => '1.1' },
	'programmode' => { 184 => 0x5 },
	'programshift' => { 219 => 0xd },
	'programversion' => { 128 => 0x46 },
	'prohibits' => { 460 => 'prohibits' },
	'projectiontype' => { 450 => 'ProjectionType', 451 => 'ProjectionType' },
	'projectname' => { 488 => 'projectName' },
	'projectref' => { 488 => 'projectRef' },
	'projectrefpath' => { 488 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 488 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 293 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 293 => 'PropertyReleaseStatus' },
	'province-state' => { 128 => 0x5f },
	'publicationdate' => { 478 => 'publicationDate' },
	'publicationdatea-platform' => { 478 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 478 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 478 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 478 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 478 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 474 => 'PublicationEvent' },
	'publicationeventdate' => { 474 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 474 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 474 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 478 => 'publicationName' },
	'publisher' => { 358 => "\xa9pub", 360 => 'publisher', 465 => 'publisher' },
	'publishingfrequency' => { 478 => 'publishingFrequency' },
	'pulldown' => { 488 => 'pullDown' },
	'purchasedate' => { 358 => 'purd' },
	'purplehsl' => { 100 => 0x20916 },
	'pxshiftperiphedgenr' => { 439 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 439 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 109 => 0x2, 110 => 0x3002, 124 => 0x1000, 136 => 0x9, 219 => 0x4, 249 => 0x3, 288 => 0x201, 301 => 0x300, 341 => 0x8, 348 => 0x2, 383 => 0x16, 393 => 0x56, 394 => 0x56, 395 => 0xb, 406 => [0x102,0x202e] },
	'quality2' => { 414 => 0x1170, 415 => 0x1174, 416 => 0x1150, 418 => 0x11a8, 419 => 0x1060, 420 => 0x258, 421 => 0x258, 422 => 0x247, 426 => 0x29, 427 => 0x25, 428 => 0x2a },
	'qualitymode' => { 110 => 0x8 },
	'quantizationmethod' => { 130 => 0x78 },
	'quickadjust' => { 262 => 0x2a },
	'quickcontroldialinmeter' => { 81 => 0x703 },
	'quickfix' => { 259 => 0x416391c6 },
	'quickshot' => { 382 => 0x213 },
	'quiettime' => { 134 => 0x188a },
	'rads' => { 366 => 'rads' },
	'rangefinder' => { 271 => '4.1', 272 => '5.1', 273 => '5.1' },
	'rasterizedcaption' => { 128 => 0x7d },
	'rating' => { 116 => 0x4746, 124 => 0x1431, 352 => 0xdf, 358 => 'rtng', 406 => 0x2002, 457 => 'rating', 466 => 'rating', 474 => 'Rating', 478 => 'rating', 486 => 'Rating' },
	'ratingpercent' => { 116 => 0x4749, 174 => 'Rating', 358 => 'rate' },
	'ratingregion' => { 474 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 474 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 474 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 474 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 474 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 474 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 474 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 474 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 474 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 474 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 474 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 474 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 474 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 474 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 474 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 474 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 474 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 474 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 79 => 0x8, 181 => 0x109, 322 => 0xd },
	'rawbrightnessadj' => { 100 => 0x20001, 105 => 0x38 },
	'rawburstimagecount' => { 72 => 0x2 },
	'rawburstimagenum' => { 72 => 0x1 },
	'rawcoloradj' => { 105 => 0x2e },
	'rawcropbottom' => { 352 => 0xd4 },
	'rawcropleft' => { 352 => 0xd1 },
	'rawcropright' => { 352 => 0xd3 },
	'rawcroptop' => { 352 => 0xd2 },
	'rawcustomsaturation' => { 105 => 0x30 },
	'rawcustomtone' => { 105 => 0x34 },
	'rawdata' => { 380 => 0xa048 },
	'rawdatabyteorder' => { 380 => 0x40 },
	'rawdatacfapattern' => { 380 => 0x50 },
	'rawdatauniqueid' => { 116 => 0xc65d },
	'rawdepth' => { 183 => 0x10 },
	'rawdevartfilter' => { 290 => 0x121 },
	'rawdevautogradation' => { 290 => 0x119 },
	'rawdevcolorspace' => { 289 => 0x108, 290 => 0x109 },
	'rawdevcontrastvalue' => { 289 => 0x106, 290 => 0x105 },
	'rawdeveditstatus' => { 289 => 0x10b },
	'rawdevelopmentprocess' => { 341 => 0x62 },
	'rawdevengine' => { 289 => 0x109, 290 => 0x10b },
	'rawdevexposurebiasvalue' => { 289 => 0x100, 290 => 0x100 },
	'rawdevgradation' => { 290 => 0x112 },
	'rawdevgraypoint' => { 289 => 0x103, 290 => 0x104 },
	'rawdevmemorycoloremphasis' => { 289 => 0x105, 290 => 0x108 },
	'rawdevnoisereduction' => { 289 => 0x10a, 290 => 0x10a },
	'rawdevpicturemode' => { 290 => 0x10c },
	'rawdevpm_bwfilter' => { 290 => 0x110 },
	'rawdevpmcontrast' => { 290 => 0x10e },
	'rawdevpmnoisefilter' => { 290 => 0x120 },
	'rawdevpmpicturetone' => { 290 => 0x111 },
	'rawdevpmsaturation' => { 290 => 0x10d },
	'rawdevpmsharpness' => { 290 => 0x10f },
	'rawdevsaturation3' => { 290 => 0x113 },
	'rawdevsaturationemphasis' => { 289 => 0x104, 290 => 0x107 },
	'rawdevsettings' => { 289 => 0x10c },
	'rawdevsharpnessvalue' => { 289 => 0x107, 290 => 0x106 },
	'rawdevversion' => { 289 => 0x0, 290 => 0x0 },
	'rawdevwbfineadjustment' => { 289 => 0x102, 290 => 0x103 },
	'rawdevwhitebalance' => { 290 => 0x101 },
	'rawdevwhitebalancevalue' => { 289 => 0x101, 290 => 0x102 },
	'rawfile' => { 116 => 0xfe4c },
	'rawfilename' => { 462 => 'RawFileName', 464 => 'RawFileName' },
	'rawfiletype' => { 406 => 0x2029 },
	'rawformat' => { 311 => 0x2d, 350 => 0x10e },
	'rawimagecenter' => { 219 => 0x99 },
	'rawimagedigest' => { 116 => 0xc71c },
	'rawimagesize' => { 341 => 0x39 },
	'rawinfoversion' => { 291 => 0x0 },
	'rawjpgheight' => { 96 => 0x4 },
	'rawjpgquality' => { 55 => 0x6, 96 => 0x1 },
	'rawjpgsize' => { 55 => 0x7, 96 => 0x2 },
	'rawjpgwidth' => { 96 => 0x3 },
	'rawmeasuredrggb' => { 41 => 0x26a, 43 => 0x280, 45 => 0x194, 46 => [0x1ad,0x26b] },
	'rawrppused' => { 457 => 'rawrppused' },
	'rawtopreviewgain' => { 116 => 0xc7a8 },
	'readouttypeactual' => { 134 => 0x1903 },
	'readouttyperequested' => { 134 => 0x1902 },
	'reardisplay' => { 266 => '12.3', 267 => '6.2' },
	'recdevice' => { 474 => 'RecDevice' },
	'recdeviceattlensdescription' => { 474 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 474 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 474 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 474 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 474 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 480 => 'recipeEndingPage' },
	'recipepagerange' => { 480 => 'recipePageRange' },
	'recipesource' => { 480 => 'recipeSource' },
	'recipestartingpage' => { 480 => 'recipeStartingPage' },
	'recipetitle' => { 480 => 'recipeTitle' },
	'recognizedface1age' => { 299 => 0x20 },
	'recognizedface1name' => { 299 => 0x4 },
	'recognizedface1position' => { 299 => 0x18 },
	'recognizedface2age' => { 299 => 0x50 },
	'recognizedface2name' => { 299 => 0x34 },
	'recognizedface2position' => { 299 => 0x48 },
	'recognizedface3age' => { 299 => 0x80 },
	'recognizedface3name' => { 299 => 0x64 },
	'recognizedface3position' => { 299 => 0x78 },
	'recognizedfaceflags' => { 306 => 0x63 },
	'recommendedexposureindex' => { 116 => 0x8832, 469 => 'RecommendedExposureIndex' },
	'record' => { 115 => 'Record' },
	'recordbasisofrecord' => { 115 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 115 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 115 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 115 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 115 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 115 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 179 => 0x4d },
	'recorddynamicproperties' => { 115 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 94 => 0x1804 },
	'recordinformationwithheld' => { 115 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 366 => "\xa9phg" },
	'recordingformat' => { 373 => 0x1000 },
	'recordingmode' => { 109 => 0x1, 348 => 0x1 },
	'recordinstitutioncode' => { 115 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 115 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 366 => "\xa9lab" },
	'recordlabelurl' => { 366 => "\xa9lal" },
	'recordmode' => { 34 => 0x9, 110 => 0x3000 },
	'recordownerinstitutioncode' => { 115 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 382 => 0x217 },
	'redbalance' => { 288 => 0x1017, 311 => 0x11, 341 => 0x1c },
	'redcurvelimits' => { 105 => 0x18a },
	'redcurvepoints' => { 104 => 0x2d, 105 => 0x160 },
	'redeyecorrection' => { 263 => 0x0 },
	'redeyeinfo' => { 462 => 'RedEyeInfo', 464 => 'RedEyeInfo' },
	'redeyereduction' => { 179 => 0x41, 393 => 0x6a, 395 => 0x28 },
	'redeyeremoval' => { 306 => 0xb9 },
	'redhsl' => { 100 => 0x20910 },
	'redhue' => { 462 => 'RedHue', 464 => 'RedHue' },
	'redsaturation' => { 462 => 'RedSaturation', 464 => 'RedSaturation' },
	'reductionmatrix1' => { 116 => 0xc625 },
	'reductionmatrix2' => { 116 => 0xc626 },
	'reelname' => { 116 => 0xc789, 366 => 'reel' },
	'reference1' => { 472 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 472 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 116 => 0x214, 484 => 'ReferenceBlackWhite' },
	'referencedate' => { 128 => 0x2f },
	'referencenumber' => { 128 => 0x32 },
	'references' => { 153 => 'References' },
	'referenceservice' => { 128 => 0x2d },
	'regionappliedtodimensions' => { 168 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 168 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 168 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 168 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 168 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 168 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 168 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 168 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 168 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 168 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 168 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 168 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 293 => 'RegionConstraints' },
	'regiondescription' => { 168 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 168 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 168 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 168 => 'Regions' },
	'regioninfodateregionsvalid' => { 171 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 171 => 'RegionInfo' },
	'regioninforegions' => { 171 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 168 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 168 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 171 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 171 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 171 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 171 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 171 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 168 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 168 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 168 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 474 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 474 => 'RegistryId' },
	'registryitemid' => { 474 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 474 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 151 => 'data' },
	'relatedaudiofilename' => { 151 => '1Name' },
	'relatedaudiofiletype' => { 151 => '0Type' },
	'relatedimagefileformat' => { 116 => 0x1000 },
	'relatedimageheight' => { 116 => 0x1002 },
	'relatedimagewidth' => { 116 => 0x1001 },
	'relatedresourceid' => { 115 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 116 => 0xa004, 468 => 'RelatedSoundFile' },
	'relatedvideofile' => { 165 => 'data' },
	'relatedvideofilename' => { 165 => '1Name' },
	'relatedvideofiletype' => { 165 => '0Type' },
	'relation' => { 465 => 'relation' },
	'relationshipaccordingto' => { 115 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 115 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 115 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 115 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 113 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 488 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 488 => 'relativeTimestamp' },
	'relativetimestampscale' => { 488 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 488 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 266 => '17.8', 267 => '18.5', 269 => '18.4', 270 => '18.4', 275 => '33.8', 276 => '17.6', 279 => '18.5', 280 => '18.4' },
	'releasedate' => { 128 => 0x1e, 358 => 'rldt', 457 => 'ReleaseDate', 488 => 'releaseDate' },
	'releasemode' => { 110 => 0x3001, 237 => 0x184d, 406 => 0xb049 },
	'releasemode2' => { 414 => 0x112c, 415 => [0x112c,0x8], 416 => [0x1108,0x8], 417 => [0x1184,0x8], 418 => [0x1160,0x8], 419 => [0x4,0x1018], 420 => [0x4,0x210], 421 => [0x4,0x210], 422 => [0x4,0x208], 424 => [0x67,0x3f], 425 => [0x6b,0x6d,0x73,0x4b], 426 => 0x10, 427 => 0x10, 428 => 0x9, 435 => 0x34 },
	'releasemode3' => { 414 => 0x1128, 415 => 0x1128, 416 => 0x1104, 417 => 0x1180, 418 => 0x115c, 419 => 0x1014, 420 => 0x20c, 421 => 0x20c, 422 => 0x204 },
	'releaseready' => { 474 => 'ReleaseReady' },
	'releasesetting' => { 94 => 0x1016 },
	'releasetime' => { 128 => 0x23, 457 => 'ReleaseTime' },
	'remoteonduration' => { 268 => '3.4', 271 => '17.2', 272 => '18.2', 273 => '18.2', 274 => '18.2', 276 => '18.2', 277 => '4.3', 281 => '19.2' },
	'renditionclass' => { 489 => 'RenditionClass' },
	'renditionof' => { 489 => 'RenditionOf' },
	'renditionofalternatepaths' => { 489 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 489 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 489 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 489 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 489 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 489 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 489 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 489 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 489 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 489 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 489 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 489 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 489 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 489 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 489 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 489 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 489 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 489 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 489 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 489 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 489 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 489 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 489 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 489 => 'RenditionParams' },
	'repeatingflashcount' => { 203 => 0xd, 204 => 0xe, 205 => 0xe, 206 => 0xe, 207 => 0xe, 275 => '17.2', 276 => '24.2', 277 => '9.2', 278 => '24.2', 281 => '25.2' },
	'repeatingflashcountbuilt-in' => { 245 => 0x4db },
	'repeatingflashcountexternal' => { 245 => 0x4c3 },
	'repeatingflashoutput' => { 275 => '17.1', 276 => '24.1', 277 => '9.1', 278 => '24.1', 281 => '25.1' },
	'repeatingflashoutputexternal' => { 245 => 0x4c0 },
	'repeatingflashrate' => { 203 => 0xc, 204 => 0xd, 205 => 0xd, 206 => 0xd, 207 => 0xd, 275 => '18.1', 276 => '25.1', 277 => '10.1', 278 => '25.1', 281 => '26.1' },
	'repeatingflashratebuilt-in' => { 245 => 0x4da },
	'repeatingflashrateexternal' => { 245 => 0x4c2 },
	'requirements' => { 366 => "\xa9req" },
	'requires' => { 460 => 'requires' },
	'resampleparams' => { 488 => 'resampleParams' },
	'resampleparamsquality' => { 488 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 134 => 0xe50 },
	'resamplingkerneldenominators067' => { 134 => 0xe4f },
	'resamplingkerneldenominators100' => { 134 => 0xe51 },
	'resaved' => { 382 => 0x21e },
	'resetblacksegrows' => { 134 => 0x181a },
	'resolution' => { 158 => 'Resolution' },
	'resolutionmode' => { 383 => [0x87,0x4] },
	'resolutionunit' => { 116 => 0x128, 131 => 0x2, 484 => 'ResolutionUnit' },
	'resourceid' => { 115 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 115 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 115 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 81 => 0x612 },
	'restrictions' => { 481 => 'restrictions' },
	'retouchareafeather' => { 462 => [\'RetouchAreas','RetouchAreasFeather'], 464 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 462 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 464 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 462 => [\'RetouchAreas','RetouchAreasMasksAngle'], 464 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 462 => [\'RetouchAreas','RetouchAreasMasksBottom'], 464 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 462 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 464 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 462 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 464 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 462 => [\'RetouchAreas','RetouchAreasMasksDabs'], 464 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 462 => [\'RetouchAreas','RetouchAreasMasksFeather'], 464 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 462 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 464 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 462 => [\'RetouchAreas','RetouchAreasMasksFlow'], 464 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 462 => [\'RetouchAreas','RetouchAreasMasksFullX'], 464 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 462 => [\'RetouchAreas','RetouchAreasMasksFullY'], 464 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 462 => [\'RetouchAreas','RetouchAreasMasksLeft'], 464 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 462 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 464 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 462 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 464 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 462 => [\'RetouchAreas','RetouchAreasMasksRadius'], 464 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 462 => [\'RetouchAreas','RetouchAreasMasksRight'], 464 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 462 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 464 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 462 => [\'RetouchAreas','RetouchAreasMasks'], 464 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 462 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 464 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 462 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 464 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 462 => [\'RetouchAreas','RetouchAreasMasksTop'], 464 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 462 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 464 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 462 => [\'RetouchAreas','RetouchAreasMasksVersion'], 464 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 462 => [\'RetouchAreas','RetouchAreasMasksWhat'], 464 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 462 => [\'RetouchAreas','RetouchAreasMasksX'], 464 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 462 => [\'RetouchAreas','RetouchAreasMasksY'], 464 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 462 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 464 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 462 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 464 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 462 => [\'RetouchAreas','RetouchAreasMethod'], 464 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 462 => [\'RetouchAreas','RetouchAreasOffsetY'], 464 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 462 => [\'RetouchAreas','RetouchAreasOpacity'], 464 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 462 => 'RetouchAreas', 464 => 'RetouchAreas' },
	'retouchareaseed' => { 462 => [\'RetouchAreas','RetouchAreasSeed'], 464 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 462 => [\'RetouchAreas','RetouchAreasSourceState'], 464 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 462 => [\'RetouchAreas','RetouchAreasSourceX'], 464 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 462 => [\'RetouchAreas','RetouchAreasSpotType'], 464 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 219 => 0x9e },
	'retouchinfo' => { 462 => 'RetouchInfo', 464 => 'RetouchInfo' },
	'retouchnefprocessing' => { 226 => 0x5 },
	'retractlensonpoweroff' => { 81 => 0x814 },
	'reuse' => { 293 => 'Reuse' },
	'reuseallowed' => { 491 => 'ReuseAllowed' },
	'reuseprohibited' => { 481 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 273 => '5.2' },
	'reverseindicators' => { 266 => '12.1', 267 => '6.1', 269 => '6.1', 270 => '6.1', 271 => '4.3', 272 => '5.2', 273 => '5.4', 275 => '33.5', 276 => '5.1', 279 => '6.1', 280 => '6.1', 281 => '6.2' },
	'reverseshutterspeedaperture' => { 273 => '5.3' },
	'revision' => { 466 => 'revision' },
	'rflensmffocusringsensitivity' => { 81 => 0x714 },
	'rgbcurvelimits' => { 105 => 0x238 },
	'rgbcurvepoints' => { 104 => 0x7, 105 => 0x20e },
	'richtextcomment' => { 471 => 'RichTextComment' },
	'ricohdate' => { 372 => 0x6 },
	'ricohimageheight' => { 372 => 0x2 },
	'ricohimagewidth' => { 372 => 0x0 },
	'rightalbedo' => { 453 => 'RightAlbedo' },
	'rightascension' => { 161 => 'RightAscension' },
	'rights' => { 465 => 'rights' },
	'rightsagent' => { 481 => 'rightsAgent' },
	'rightsowner' => { 481 => 'rightsOwner' },
	'roll' => { 112 => 0x8, 366 => ['roll',"\xa9frl"] },
	'rollangle' => { 237 => 0x350b, 238 => 0x2c24, 246 => 0x36f4, 283 => 0x903, 306 => 0x90, 340 => 0x1, 378 => 0x2 },
	'romoperationmode' => { 94 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 93 => 0x3, 100 => 0x10002, 105 => 0x26e, 111 => 'QuickTime::Rotation', 120 => 0x4, 161 => 'Rotation', 177 => [0x65,0x50], 178 => 0x46, 179 => 0x5a, 182 => 0x10, 237 => 0x3693, 238 => 0xca, 244 => '590.1', 259 => 0x76a43207, 306 => 0x30, 322 => '17.2', 352 => 0xd8, 359 => 'irot', 393 => 0x3f, 394 => 0x3f, 404 => 0x10 },
	'routedto' => { 470 => 'RoutedTo' },
	'routing' => { 357 => 'Routing' },
	'routingdestinations' => { 452 => 'RoutingDestinations' },
	'routingexclusions' => { 452 => 'RoutingExclusions' },
	'routingnotes' => { 470 => 'RoutingNotes' },
	'rowsperstrip' => { 116 => 0x116 },
	'rpp' => { 457 => 'rpp' },
	'rtkflag' => { 113 => 'RtkFlag' },
	'rtkstdhgt' => { 113 => 'RtkStdHgt' },
	'rtkstdlat' => { 113 => 'RtkStdLat' },
	'rtkstdlon' => { 113 => 'RtkStdLon' },
	'safetyshift' => { 81 => 0x108 },
	'safetyshiftinavortv' => { 79 => 0x10, 80 => 0x10, 82 => 0xf, 83 => 0x10, 86 => 0x10 },
	'sameexposurefornewaperture' => { 81 => 0x112 },
	'samplebits' => { 151 => 'SampleBits' },
	'samplepagerange' => { 478 => 'samplePageRange' },
	'samplerate' => { 151 => 'SampleRate' },
	'samplesperpixel' => { 116 => 0x115, 311 => 0x8, 484 => 'SamplesPerPixel' },
	'samplestructure' => { 130 => 0x5a },
	'samsungmodelid' => { 380 => 0x3 },
	'sanyoquality' => { 382 => 0x201 },
	'sanyothumbnail' => { 382 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 49 => 0x1, 109 => 0xd, 110 => [0x3013,0x1f], 116 => [0xa409,0xfe55], 124 => 0x1003, 152 => 'Saturation', 176 => 0x1f, 177 => 0x32, 178 => 0x28, 179 => 0x1a, 184 => 0x1, 219 => 0xaa, 221 => 0x35, 222 => 0x3b, 223 => 0x43, 306 => 0x40, 308 => 0x300d, 341 => 0x1f, 348 => 0xd, 367 => 0x27, 369 => 0x58, 372 => 0x28, 373 => 0x1013, 383 => 0x10, 393 => 0x1e, 394 => 0x1b, 406 => 0x2005, 462 => 'Saturation', 464 => 'Saturation', 468 => 'Saturation' },
	'saturationadj' => { 100 => 0x20901, 105 => 0x116, 219 => 0x94, 258 => 0x1, 262 => 0x2e, 439 => 0x8016 },
	'saturationadjustmentaqua' => { 462 => 'SaturationAdjustmentAqua', 464 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 462 => 'SaturationAdjustmentBlue', 464 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 462 => 'SaturationAdjustmentGreen', 464 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 462 => 'SaturationAdjustmentMagenta', 464 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 462 => 'SaturationAdjustmentOrange', 464 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 462 => 'SaturationAdjustmentPurple', 464 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 462 => 'SaturationAdjustmentRed', 464 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 462 => 'SaturationAdjustmentYellow', 464 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 68 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 67 => 0x68, 68 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 67 => 0x38, 68 => 0x38 },
	'saturationmonochrome' => { 67 => 0x80, 68 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 67 => 0x50, 68 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 67 => 0x20, 68 => 0x20 },
	'saturationsetting' => { 291 => 0x1010, 395 => 0x11, 411 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 67 => 0x8, 68 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 67 => 0x98, 68 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 67 => 0xb0, 68 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 67 => 0xc8, 68 => 0xe0 },
	'saveid' => { 489 => 'SaveID' },
	'sbaanalysiscomplete' => { 134 => 0xc35 },
	'sbablack' => { 134 => 0xc25 },
	'sbagmoffset' => { 134 => 0xc4a },
	'sbagray' => { 134 => 0xc26 },
	'sbagreenmagentabal' => { 134 => 0xc33 },
	'sbahighgray' => { 134 => 0xc46 },
	'sbailloffset' => { 134 => 0xc49 },
	'sbailluminantbal' => { 134 => 0xc34 },
	'sbalowgray' => { 134 => 0xc47 },
	'sbaneutralbal' => { 134 => 0xc32 },
	'sbawhite' => { 134 => 0xc27 },
	'scaletype' => { 488 => 'scaleType' },
	'scanimageenhancer' => { 227 => 0x60 },
	'scanningdirection' => { 130 => 0x64 },
	'scene' => { 366 => 'scen', 473 => 'Scene', 488 => 'scene' },
	'scenearea' => { 286 => 0x211, 288 => 0x1031 },
	'sceneassist' => { 219 => 0x9c },
	'scenecapturetype' => { 116 => 0xa406, 468 => 'SceneCaptureType' },
	'scenedetect' => { 286 => 0x210, 288 => 0x1030 },
	'scenedetectdata' => { 286 => 0x212, 288 => 0x1033 },
	'scenemode' => { 138 => 0xfa02, 181 => 0x100, 219 => 0x8f, 283 => 0x509, 288 => 0x403, 306 => 0x8001, 315 => 0xf, 406 => 0xb023 },
	'scenemodeused' => { 140 => [0x6002,0xf002] },
	'scenerecognition' => { 124 => 0x1425 },
	'sceneselect' => { 382 => 0x21f },
	'scenetype' => { 116 => 0xa301, 468 => 'SceneType' },
	'screentips' => { 266 => '12.7', 267 => '5.3', 275 => '13.1', 276 => '4.4', 279 => '5.4', 281 => '5.1' },
	'scriptversion' => { 134 => 0x1770 },
	'season' => { 474 => 'Season', 477 => 'season' },
	'seasonidentifier' => { 474 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 474 => [\'Season','SeasonName'] },
	'seasonnumber' => { 474 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 452 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 237 => 0x1d0, 246 => 0x1d0 },
	'section' => { 478 => 'section' },
	'securityclassification' => { 116 => 0x9212 },
	'selectableafpoint' => { 81 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 81 => 0x512 },
	'selfdata' => { 113 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 306 => 0x2e, 382 => 0x214, 414 => 0x1134, 415 => 0x1134, 416 => 0x1110, 417 => 0x118c, 418 => 0x1168, 419 => 0x1020, 420 => 0x218, 421 => 0x218, 422 => 0x210 },
	'selftimer2' => { 74 => 0x1d },
	'selftimerinterval' => { 276 => '19.2' },
	'selftimermode' => { 116 => 0x882b },
	'selftimershotcount' => { 267 => '20.2', 269 => '20.3', 270 => '20.3', 271 => '18.2', 272 => '19.2', 273 => '19.2', 274 => '19.3', 276 => '19.3', 279 => '20.3', 280 => '20.3', 281 => '20.2' },
	'selftimershotinterval' => { 267 => '20.3', 269 => '20.2', 270 => '20.2', 274 => '19.2', 279 => '20.2', 280 => '20.2' },
	'selftimertime' => { 94 => 0x1806, 179 => 0x1f, 266 => '18.1', 267 => '20.1', 268 => '3.3', 269 => '20.1', 270 => '20.1', 271 => '18.1', 272 => '19.1', 273 => '19.1', 274 => '19.1', 275 => '7.2', 276 => '19.1', 277 => '3.3', 279 => '20.1', 280 => '20.1', 281 => '20.1' },
	'sellingagency' => { 478 => 'sellingAgency' },
	'seminfo' => { 116 => 0x8546 },
	'sensingmethod' => { 116 => 0xa217, 468 => 'SensingMethod' },
	'sensitivityadjust' => { 341 => 0x40 },
	'sensitivitysteps' => { 322 => ['14.3','17.4'], 324 => 0x1 },
	'sensitivitytype' => { 116 => 0x8830, 469 => 'SensitivityType' },
	'sensor' => { 186 => 0x665e },
	'sensorarea' => { 288 => 0x400 },
	'sensorareas' => { 380 => 0xa010 },
	'sensorbitdepth' => { 308 => 0x312d },
	'sensorbluelevel' => { 71 => 0x5 },
	'sensorcalibration' => { 287 => 0x805 },
	'sensorcleaning' => { 87 => 0xd },
	'sensorfullheight' => { 133 => 0xf904 },
	'sensorfullwidth' => { 133 => 0xf903 },
	'sensorheight' => { 133 => 0xf901, 138 => 0xfa21, 183 => 0x8, 308 => 0x312c, 350 => 0x109, 373 => 0x1602 },
	'sensorimageheight' => { 134 => 0x3ee },
	'sensorimagewidth' => { 134 => 0x3ed },
	'sensorleftborder' => { 134 => 0x3eb },
	'sensorleftmargin' => { 350 => 0x10a },
	'sensorpixelsize' => { 219 => 0x9a },
	'sensorredlevel' => { 71 => 0x4 },
	'sensorserialnumber' => { 134 => 0x9ce },
	'sensorsize' => { 152 => 'SensorSize', 341 => 0x35 },
	'sensortemperature' => { 286 => 0x1500, 288 => 0x1007, 346 => 0xc, 350 => 0x210, 383 => [0x39,0x55] },
	'sensortemperature2' => { 346 => 0xe, 350 => 0x211 },
	'sensortopborder' => { 134 => 0x3ec },
	'sensortopmargin' => { 350 => 0x10b },
	'sensorwidth' => { 133 => 0xf900, 138 => 0xfa20, 183 => 0xa, 308 => 0x312b, 350 => 0x108, 373 => 0x1601 },
	'sequence' => { 367 => 0x7, 368 => 0x35, 369 => 0x36 },
	'sequencefilenumber' => { 415 => 0x4, 416 => 0x4, 417 => 0x4, 418 => 0x4, 426 => 0xc, 427 => 0xc, 428 => 0x1a },
	'sequenceimagenumber' => { 415 => 0x0, 416 => 0x0, 417 => 0x0, 418 => 0x0, 426 => 0x8, 427 => 0x8, 428 => 0x12, 435 => 0x24 },
	'sequencelength' => { 426 => 0x22, 427 => 0x1e, 428 => [0x16,0x1e] },
	'sequencename' => { 477 => 'sequenceName' },
	'sequencenumber' => { 74 => 0x9, 110 => 0x301c, 124 => 0x1101, 136 => 0x1d, 245 => 0x51c, 306 => 0x2b, 395 => [0x10c,0x30c], 406 => 0xb04a, 477 => 'sequenceNumber' },
	'sequenceshotinterval' => { 382 => 0x224 },
	'sequencetotalnumber' => { 477 => 'sequenceTotalNumber' },
	'sequentialshot' => { 382 => 0x20e },
	'serialnumber' => { 61 => 0xc, 94 => 0x180b, 116 => [0xa431,0xfde9], 133 => 0xfa04, 135 => 0xfa00, 137 => 0xc354, 138 => 0xfa19, 149 => 0x0, 152 => 'SerialNumber', 186 => 0x5501, 219 => [0xa0,0x1d], 284 => 0x101, 288 => [0x404,0x101a], 301 => 0x303, 303 => 0x305, 308 => 0x3103, 341 => 0x229, 350 => 0x102, 351 => 0x407, 366 => ['SNum','slno'], 367 => 0x15, 368 => 0x4b, 369 => 0x7e, 373 => 0x5, 380 => 0xa002, 383 => 0x2, 406 => 0x2031, 459 => 'SerialNumber', 469 => 'BodySerialNumber' },
	'serialnumberformat' => { 61 => 0x15, 94 => 0x183b },
	'serialnumberhash' => { 366 => 'CAME' },
	'series' => { 474 => 'Series' },
	'seriesdatetime' => { 441 => 'SeriesDateTime' },
	'seriesdescription' => { 441 => 'SeriesDescription' },
	'seriesidentifier' => { 474 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 441 => 'SeriesModality' },
	'seriesname' => { 474 => [\'Series','SeriesName'] },
	'seriesnumber' => { 441 => 'SeriesNumber', 478 => 'seriesNumber' },
	'seriestitle' => { 478 => 'seriesTitle' },
	'serviceidentifier' => { 129 => 0x1e },
	'servingsize' => { 480 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 84 => 0x0, 85 => 0x0 },
	'setbuttonwhenshooting' => { 79 => 0x1, 81 => 0x704, 87 => 0xc },
	'setfunctionwhenshooting' => { 82 => 0x0, 83 => 0x1, 86 => 0x1 },
	'setting' => { 477 => 'setting' },
	'shadingcompensation' => { 283 => 0x50c, 306 => 0x8a },
	'shadingcompensation2' => { 287 => 0x1012 },
	'shadow' => { 383 => 0xe },
	'shadowadj' => { 100 => 0x2030b },
	'shadowcorrection' => { 341 => 0x79 },
	'shadowprotection' => { 258 => 0x0 },
	'shadows' => { 116 => 0xfe52, 456 => 'Shadows', 462 => 'Shadows', 464 => 'Shadows' },
	'shadows2012' => { 462 => 'Shadows2012', 464 => 'Shadows2012' },
	'shadowsadj' => { 439 => 0x901a },
	'shadowscale' => { 116 => 0xc633 },
	'shadowtint' => { 462 => 'ShadowTint', 464 => 'ShadowTint' },
	'shadowtone' => { 124 => 0x1040 },
	'shakereduction' => { 343 => 0x1, 344 => 0x1 },
	'sharpendetail' => { 462 => 'SharpenDetail', 464 => 'SharpenDetail' },
	'sharpenedgemasking' => { 462 => 'SharpenEdgeMasking', 464 => 'SharpenEdgeMasking' },
	'sharpening' => { 308 => 0x300b },
	'sharpeningadj' => { 262 => 0x2b },
	'sharpeningkernel' => { 134 => 0x92f },
	'sharpenradius' => { 462 => 'SharpenRadius', 464 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 71 => 0x2, 109 => 0xb, 110 => [0x3011,0x21], 116 => [0xa40a,0xfe56], 124 => 0x1001, 136 => 0x6b, 145 => 0x37, 152 => 'Sharpness', 176 => 0x21, 177 => 0x30, 178 => 0x26, 179 => 0x18, 184 => 0x3, 219 => 0x6, 221 => 0x32, 222 => 0x33, 223 => 0x39, 288 => 0x100f, 306 => 0x41, 341 => 0x21, 348 => 0xb, 367 => 0x26, 369 => 0x56, 372 => 0x22, 373 => [0x1003,0x1014], 383 => 0x11, 393 => 0x1c, 394 => 0x19, 406 => 0x2006, 435 => 0x52, 462 => 'Sharpness', 464 => 'Sharpness', 468 => 'Sharpness' },
	'sharpnessadj' => { 100 => 0x20310, 105 => 0x25a, 439 => 0x801a },
	'sharpnessadjon' => { 100 => '0x20310.0' },
	'sharpnessauto' => { 68 => 0x94 },
	'sharpnessfactor' => { 288 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 67 => 0x64, 68 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 71 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 67 => 0x34, 68 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 67 => 0x7c, 68 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 67 => 0x4c, 68 => 0x4c },
	'sharpnessovershoot' => { 439 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 67 => 0x1c, 68 => 0x1c },
	'sharpnesssetting' => { 283 => 0x506, 291 => 0x1013, 395 => 0x12, 411 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 67 => 0x4, 68 => 0x4 },
	'sharpnessstrength' => { 100 => 0x20311 },
	'sharpnessthreshold' => { 439 => 0x801d },
	'sharpnessundershoot' => { 439 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 67 => 0x94, 68 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 67 => 0xac, 68 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 67 => 0xc4, 68 => 0xdc },
	'shiftcols' => { 134 => 0xc70 },
	'shootid' => { 477 => 'shootID' },
	'shootingdistance' => { 100 => 0x20701 },
	'shootinginfodisplay' => { 266 => '13.2', 267 => '5.1', 275 => '10.2', 276 => '4.1', 279 => '5.1', 281 => '5.3' },
	'shootinginfomonitorofftime' => { 266 => '26.2', 267 => '22.2', 269 => '22.2', 270 => '22.2', 274 => '21.2', 275 => '9.1', 276 => '21.2', 279 => '22.2', 280 => '22.2', 281 => '22.2' },
	'shootingmode' => { 152 => 'ShootingMode', 219 => 0x89, 306 => 0x1f },
	'shootingmodesetting' => { 268 => '5.1' },
	'shortdescription' => { 466 => 'shortdescription' },
	'shortdocumentid' => { 128 => 0xba },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 81 => 0x80d },
	'shorttitle' => { 358 => '@sti' },
	'shotdate' => { 488 => 'shotDate' },
	'shotday' => { 488 => 'shotDay' },
	'shotlocation' => { 488 => 'shotLocation' },
	'shotname' => { 366 => 'shot', 488 => 'shotName' },
	'shotnumber' => { 488 => 'shotNumber' },
	'shotnumbersincepowerup' => { 410 => 0x44e, 426 => 0x1a, 427 => 0x16, 428 => 0xa },
	'shotnumbersincepowerup2' => { 395 => 0x200 },
	'shotsize' => { 488 => 'shotSize' },
	'shownevent' => { 474 => 'EventExt' },
	'showneventidentifier' => { 474 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 474 => [\'EventExt','EventExtName'] },
	'shutter' => { 424 => 0x20, 425 => 0x26 },
	'shutter-aelock' => { 79 => 0x4, 81 => 0x701, 82 => 0x3, 83 => 0x4, 84 => 0x3, 85 => 0x3, 86 => 0x4, 87 => 0x2 },
	'shutteraelbutton' => { 80 => 0x4 },
	'shutterbuttonafonbutton' => { 81 => 0x701 },
	'shuttercount' => { 11 => 0x176, 55 => 0x1, 219 => 0xa7, 228 => [0x6a,0x157,0x24d], 229 => 0x286, 230 => 0x279, 231 => 0x284, 232 => 0x242, 233 => 0x280, 234 => 0x276, 235 => [0x27d,0x27f], 236 => 0x246, 239 => 0x2d6, 240 => 0x321, 241 => 0xbd8, 242 => 0x287, 243 => 0x320, 244 => 0x24a, 245 => 0x5fb, 248 => 0x2d5, 341 => 0x5d, 404 => 0x846, 409 => [0x125,0x14a], 424 => 0x32, 425 => 0x3a },
	'shuttercount2' => { 424 => 0x4c, 425 => [0x50,0x52,0x58] },
	'shuttercount3' => { 424 => [0x1a0,0x1aa,0x1bd], 425 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 79 => 0xf, 80 => 0xf, 81 => 0x305, 82 => 0xe, 83 => 0xf, 84 => 0x8, 85 => 0x8, 86 => 0xf, 87 => 0x8 },
	'shuttermode' => { 136 => 0x1b, 219 => 0x34 },
	'shutterreleasebuttonae-l' => { 266 => '17.7', 267 => '18.4', 269 => '78.4', 270 => '78.4', 271 => '16.1', 272 => '17.1', 273 => '17.1', 274 => '17.1', 275 => '7.1', 276 => '17.5', 279 => '18.4', 280 => '78.4', 281 => '18.2' },
	'shutterreleasemethod' => { 94 => 0x1010 },
	'shutterreleasenocfcard' => { 79 => 0x2, 80 => 0x2, 87 => 0xf },
	'shutterreleasetiming' => { 94 => 0x1011 },
	'shutterreleasewithoutlens' => { 81 => 0x711 },
	'shutterspeedlock' => { 267 => '38.1', 269 => '38.1', 270 => '38.1', 279 => '38.1', 280 => '38.1' },
	'shutterspeedrange' => { 81 => 0x10c },
	'shutterspeedsetting' => { 179 => 0x6, 393 => 0x2f, 394 => 0x28, 395 => 0x0 },
	'shutterspeedvalue' => { 90 => 0x1, 116 => 0x9201, 288 => 0x1000, 350 => 0x400, 468 => 'ShutterSpeedValue' },
	'shuttertype' => { 124 => 0x1050, 306 => 0x9f },
	'sidecarforextension' => { 476 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 134 => 0xe0d },
	'sigmascalingfactorcamera' => { 134 => 0xe0c },
	'sigmascalingfactorlowres' => { 134 => 0xe0b },
	'sigmasizetable' => { 134 => 0xe0f },
	'similarityindex' => { 128 => 0xe4 },
	'singleframebracketing' => { 179 => 0x21 },
	'skilllevel' => { 480 => 'skillLevel' },
	'skintonecorrection' => { 341 => 0x95 },
	'skiplinetime' => { 134 => 0x184e },
	'slaveflashmeteringsegments' => { 341 => 0x20b },
	'slideshowname' => { 477 => 'slideshowName' },
	'slideshownumber' => { 477 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 477 => 'slideshowTotalNumber' },
	'slowshutter' => { 74 => 0x8 },
	'slowsync' => { 124 => 0x1030 },
	'smartalbumcolor' => { 380 => 0x20 },
	'smartrange' => { 380 => 0xa012 },
	'smileshutter' => { 395 => 0x31 },
	'smileshuttermode' => { 395 => 0x27 },
	'smoothness' => { 116 => 0xfe57, 462 => 'Smoothness', 464 => 'Smoothness' },
	'snapshot' => { 474 => 'SnapshotLink' },
	'snapshotformat' => { 474 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 474 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 474 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 474 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 474 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 457 => 'Snapshots' },
	'snapshotusedvideoframe' => { 474 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 474 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 474 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 474 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 474 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 406 => 0x200f },
	'software' => { 116 => 0x131, 153 => 'Software', 296 => 'Software', 350 => 0x203, 360 => 'software', 383 => 0x18, 447 => 'Software', 484 => 'Software' },
	'softwareversion' => { 366 => "\xa9swr", 382 => 0x207 },
	'songwriter' => { 366 => "\xa9swf" },
	'songwriterkeywords' => { 366 => "\xa9swk" },
	'sonycropsize' => { 116 => 0x74c8 },
	'sonycroptopleft' => { 116 => 0x74c7 },
	'sonydatetime' => { 413 => 0x6, 415 => 0x1b6, 416 => 0x210, 417 => 0x1fe, 418 => 0x22c },
	'sonydatetime2' => { 424 => 0x51 },
	'sonyexposuretime' => { 424 => 0x3a, 425 => 0x46 },
	'sonyexposuretime2' => { 435 => 0xe },
	'sonyfnumber' => { 424 => 0x3c, 425 => 0x48, 435 => 0x14 },
	'sonyimageheight' => { 413 => 0x1a, 426 => 0x44, 427 => 0x3f, 428 => 0x47 },
	'sonyimageheightmax' => { 435 => 0x40 },
	'sonyimagesize' => { 179 => 0x3b, 393 => 0x54, 394 => 0x54, 395 => 0x9 },
	'sonyimagewidth' => { 413 => 0x1c },
	'sonyimagewidthmax' => { 435 => 0x3e },
	'sonyiso' => { 415 => 0x1218, 416 => 0x11f4, 417 => 0x1270, 418 => [0x1254,0x1258,0x1280], 419 => 0x113c, 420 => 0x344, 421 => 0x346, 422 => 0x320, 435 => 0x4 },
	'sonymaxaperture' => { 424 => 0x0, 425 => 0x0 },
	'sonymaxaperturevalue' => { 435 => 0x16 },
	'sonyminaperture' => { 424 => 0x1, 425 => 0x1 },
	'sonymodelid' => { 406 => 0xb001 },
	'sonyquality' => { 179 => 0x3c },
	'sonytimeminsec' => { 425 => 0x61 },
	'sortalbum' => { 358 => 'soal' },
	'sortalbumartist' => { 358 => 'soaa' },
	'sortartist' => { 358 => 'soar' },
	'sortcomposer' => { 358 => 'soco' },
	'sortname' => { 358 => 'sonm' },
	'sortshow' => { 358 => 'sosn' },
	'source' => { 128 => 0x73, 296 => 'Source', 465 => 'source', 466 => 'source', 476 => 'Source' },
	'sourcecount' => { 451 => 'SourceCount' },
	'sourcecredits' => { 366 => "\xa9src" },
	'sourcedirectoryindex' => { 328 => 0x0 },
	'sourcefileindex' => { 328 => 0x2 },
	'sourcephotoscount' => { 450 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 134 => 0x1390 },
	'spatialfrequencyresponse' => { 468 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 468 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 468 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 468 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 468 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 488 => 'speakerPlacement' },
	'specialeffectlevel' => { 110 => 0x3030 },
	'specialeffectmode' => { 110 => 0x2076 },
	'specialeffectsetting' => { 110 => 0x3031 },
	'specialinstructions' => { 128 => 0x28 },
	'specialmode' => { 288 => 0x200, 382 => 0x200 },
	'specialoccasion' => { 480 => 'specialOccasion' },
	'specialtypeid' => { 445 => 'SpecialTypeID' },
	'spectralsensitivity' => { 116 => 0x8824, 468 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => [0x2b9,0x2d0,0x2d4], 44 => 0x56a, 45 => 0x1e4, 46 => [0x1fd,0x2dd], 47 => [0x231,0x30f], 48 => 0x31d },
	'speedx' => { 112 => 0x3, 366 => "\xa9xsp" },
	'speedy' => { 112 => 0x4, 366 => "\xa9ysp" },
	'speedz' => { 112 => 0x5, 366 => "\xa9zsp" },
	'spherical' => { 451 => 'Spherical' },
	'splitcolumn' => { 350 => 0x222 },
	'splittoningbalance' => { 462 => 'SplitToningBalance', 464 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 462 => 'SplitToningHighlightHue', 464 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 462 => 'SplitToningHighlightSaturation', 464 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 462 => 'SplitToningShadowHue', 464 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 462 => 'SplitToningShadowSaturation', 464 => 'SplitToningShadowSaturation' },
	'sport' => { 478 => 'sport' },
	'spotfocuspointx' => { 176 => 0x2d },
	'spotfocuspointy' => { 176 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 81 => 0x107 },
	'sractive' => { 322 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 343 => 0x3 },
	'srhalfpresstime' => { 343 => 0x2 },
	'srresult' => { 343 => 0x0, 344 => 0x0 },
	'stackedimage' => { 283 => 0x804 },
	'standardmatrixcustom' => { 134 => 0x7d4 },
	'standardmatrixdaylight' => { 134 => 0x7d0 },
	'standardmatrixflash' => { 134 => 0x7d3 },
	'standardmatrixfluorescent' => { 134 => 0x7d2 },
	'standardmatrixtungsten' => { 134 => 0x7d1 },
	'standardoutputhighlightpoint' => { 106 => 0x14 },
	'standardoutputsensitivity' => { 116 => 0x8831, 469 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 106 => 0x15 },
	'standardrawcolortone' => { 106 => 0xd },
	'standardrawcontrast' => { 106 => 0xf },
	'standardrawhighlight' => { 106 => 0x75 },
	'standardrawhighlightpoint' => { 106 => 0x12 },
	'standardrawlinear' => { 106 => 0x10 },
	'standardrawsaturation' => { 106 => 0xe },
	'standardrawshadow' => { 106 => 0x7e },
	'standardrawshadowpoint' => { 106 => 0x13 },
	'standardrawsharpness' => { 106 => 0x11 },
	'standardunsharpmaskfineness' => { 106 => 0x94 },
	'standardunsharpmaskstrength' => { 106 => 0x92 },
	'standardunsharpmaskthreshold' => { 106 => 0x96 },
	'standardwhitecustom' => { 134 => 0x838 },
	'standardwhitedaylight' => { 134 => 0x834 },
	'standardwhiteflash' => { 134 => 0x837 },
	'standardwhitefluorescent' => { 134 => 0x836 },
	'standardwhitetungsten' => { 134 => 0x835 },
	'standbytimer' => { 267 => '19.1', 269 => '19.1', 270 => '19.1', 273 => '18.1', 274 => '18.1', 279 => '19.1', 280 => '19.1' },
	'startingpage' => { 478 => 'startingPage' },
	'startmovieshooting' => { 81 => 0x70d },
	'starttimecode' => { 366 => "\xa9TIM", 488 => 'startTimecode' },
	'starttimecodetimeformat' => { 488 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 488 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 488 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 366 => "\xa9TSZ", 488 => 'startTimeSampleSize' },
	'starttimescale' => { 366 => "\xa9TSC", 488 => 'startTimeScale' },
	'state' => { 157 => 'State', 306 => 0x6b, 476 => 'State' },
	'status' => { 443 => 'Status', 455 => 'Status' },
	'stereomode' => { 451 => 'StereoMode' },
	'stitched' => { 451 => 'Stitched' },
	'stitchingsoftware' => { 450 => 'StitchingSoftware', 451 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 414 => 0x113e, 415 => 0x113e, 416 => 0x111a, 417 => 0x1196, 418 => 0x1172, 419 => 0x102a, 420 => 0x222, 421 => 0x222, 422 => 0x217, 435 => 0xa },
	'storagemethod' => { 183 => 0x12 },
	'storebyorientation' => { 267 => '46.3', 269 => '47.3', 270 => '47.3', 279 => '47.3', 280 => '47.3' },
	'storylineidentifier' => { 474 => 'StorylineIdentifier' },
	'straightenangle' => { 259 => 0x2fc08431 },
	'streamready' => { 474 => 'StreamReady' },
	'streamtype' => { 172 => 'StreamType' },
	'stretchmode' => { 488 => 'stretchMode' },
	'studydatetime' => { 441 => 'StudyDateTime' },
	'studydescription' => { 441 => 'StudyDescription' },
	'studyid' => { 441 => 'StudyID' },
	'studyphysician' => { 441 => 'StudyPhysician' },
	'styleperiod' => { 474 => 'StylePeriod' },
	'sub-location' => { 128 => 0x5c },
	'subfiledata' => { 160 => 'data' },
	'subfiledirectory' => { 160 => '1Directory' },
	'subfilemimetype' => { 160 => '2MIME' },
	'subfilename' => { 160 => '1Name' },
	'subfileresource' => { 160 => 'rsrc' },
	'subfiletype' => { 116 => 0xfe, 160 => '0Type' },
	'subject' => { 292 => 'Subject', 357 => 'Subject', 465 => 'subject', 475 => 'Subject', 489 => 'subject' },
	'subjectarea' => { 116 => 0x9214, 468 => 'SubjectArea' },
	'subjectcode' => { 473 => 'SubjectCode' },
	'subjectdistance' => { 116 => 0x9206, 136 => 0x3e, 468 => 'SubjectDistance' },
	'subjectdistancerange' => { 116 => 0xa40c, 468 => 'SubjectDistanceRange' },
	'subjectlocation' => { 116 => 0xa214, 468 => 'SubjectLocation' },
	'subjectmotion' => { 269 => '78.2', 270 => '78.2', 280 => '78.2' },
	'subjectprogram' => { 176 => 0x22 },
	'subjectreference' => { 128 => 0xc },
	'sublabels1' => { 472 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 472 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 111 => 'Exif::SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 111 => 'Exif::SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 111 => 'Exif::SubSecModifyDate' },
	'subsectime' => { 116 => 0x9290 },
	'subsectimedigitized' => { 116 => 0x9292 },
	'subsectimeoriginal' => { 116 => 0x9291 },
	'subsection1' => { 478 => 'subsection1' },
	'subsection2' => { 478 => 'subsection2' },
	'subsection3' => { 478 => 'subsection3' },
	'subsection4' => { 478 => 'subsection4' },
	'subselector' => { 267 => '49.1', 269 => '71.1', 270 => '71.1', 280 => '71.1' },
	'subselectorassignment' => { 267 => '48.1' },
	'subselectorcenter' => { 269 => '72.1', 270 => '72.1', 280 => '72.1' },
	'subselectorplusdials' => { 267 => '49.2', 269 => '73.1', 270 => '73.1', 280 => '73.1' },
	'subtitle' => { 366 => "\xa9snm", 478 => 'subtitle' },
	'subtitlekeywords' => { 366 => "\xa9snk" },
	'subversionfilename' => { 472 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 472 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 472 => 'SubVersions' },
	'superimposeddisplay' => { 79 => 0xa, 81 => 0x510, 82 => 0x9, 83 => 0xa, 86 => 0xa, 87 => 0xe },
	'supermacro' => { 61 => 0x1a },
	'supplementalcategories' => { 128 => 0x14, 476 => 'SupplementalCategories' },
	'supplementaltype' => { 130 => 0x37 },
	'supplementdisplayid' => { 478 => 'supplementDisplayID' },
	'supplementstartingpage' => { 478 => 'supplementStartingPage' },
	'supplementtitle' => { 478 => 'supplementTitle' },
	'supplychainsource' => { 474 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 474 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 474 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 322 => 0x14 },
	'swatchcoloranta' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 493 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 493 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 493 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 493 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 493 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 306 => 0x93, 395 => 0x33 },
	'sweeppanoramafieldofview' => { 306 => 0x94 },
	'sweeppanoramasize' => { 395 => 0x32 },
	'switchtoregisteredafpoint' => { 80 => 0x12, 81 => 0x50a },
	'symlink' => { 117 => 'SymLink' },
	'syncreleasemode' => { 269 => '77.1', 270 => '77.1', 280 => '77.1' },
	'system' => { 350 => 0x204 },
	'tagged' => { 352 => 0xdd, 353 => 'Tagged', 457 => 'tagged' },
	'tagslist' => { 467 => 'TagsList' },
	'tagstructure' => { 472 => 'TagStructure' },
	'takenumber' => { 488 => 'takeNumber' },
	'tapename' => { 488 => 'tapeName' },
	'targetaperture' => { 74 => 0x4 },
	'targetcompressionratio' => { 92 => 0x1 },
	'targetdistancesetting' => { 94 => 0x1807 },
	'targetexposuretime' => { 74 => 0x5 },
	'targetimagetype' => { 94 => 0x100a },
	'targetprinter' => { 116 => 0x151 },
	'taxon' => { 115 => 'Taxon' },
	'taxonacceptednameusage' => { 115 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 115 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 115 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 115 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 115 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 115 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 115 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 115 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 115 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 115 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 115 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 115 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 115 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 115 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 115 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 115 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 115 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 115 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 115 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 115 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 115 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 115 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 115 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 115 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 115 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 115 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 115 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 115 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 115 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 115 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 115 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 115 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 115 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 134 => 0x196f },
	'tda1edgepolarity' => { 134 => 0x1971 },
	'tda1gain' => { 134 => 0x1970 },
	'tda1offset' => { 134 => 0x196e },
	'tda2bandwidth' => { 134 => 0x1979 },
	'tda2edgepolarity' => { 134 => 0x197b },
	'tda2gain' => { 134 => 0x197a },
	'tda2offset' => { 134 => 0x1978 },
	'tda3bandwidth' => { 134 => 0x1983 },
	'tda3edgepolarity' => { 134 => 0x1985 },
	'tda3gain' => { 134 => 0x1984 },
	'tda3offset' => { 134 => 0x1982 },
	'tda4bandwidth' => { 134 => 0x198d },
	'tda4edgepolarity' => { 134 => 0x198f },
	'tda4gain' => { 134 => 0x198e },
	'tda4offset' => { 134 => 0x198c },
	'teaser' => { 478 => 'teaser' },
	'teleconverter' => { 181 => 0x105, 406 => 0x105 },
	'tempampgainx100' => { 134 => 0x1914 },
	'tempo' => { 488 => 'tempo' },
	'temporalcoverage' => { 474 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 474 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 474 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 293 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 293 => 'TermsAndConditionsURL' },
	'testname' => { 117 => 'TestName' },
	'textencoding' => { 218 => 0x4 },
	'textlayername' => { 476 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 476 => 'TextLayers' },
	'textlayertext' => { 476 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 306 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 462 => 'Texture', 464 => 'Texture' },
	'three-dtrackingfacedetection' => { 269 => '1.4', 270 => '1.4', 280 => '1.4' },
	'three-dtrackingwatcharea' => { 269 => '78.1', 270 => '78.1', 280 => '78.1' },
	'thresholding' => { 116 => 0x107 },
	'thumbnailfilename' => { 94 => 0x817 },
	'thumbnailformat' => { 486 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 138 => 0xfa55, 486 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 94 => 0x2008, 111 => 'Exif::ThumbnailImage', 119 => 0x3, 163 => 'data', 288 => 0x100, 366 => 'thmb', 486 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 163 => '1Name' },
	'thumbnailimagesize' => { 163 => 'ImageSize' },
	'thumbnailimagetype' => { 163 => '0Type' },
	'thumbnailimagevalidarea' => { 61 => 0x13 },
	'thumbnaillength' => { 116 => 0x202 },
	'thumbnailoffset' => { 116 => 0x201 },
	'thumbnailpng' => { 366 => 'thmb' },
	'thumbnails' => { 486 => 'Thumbnails' },
	'thumbnailwidth' => { 138 => 0xfa54, 486 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 478 => 'ticker' },
	'tiffhandling' => { 462 => 'TIFFHandling', 464 => 'TIFFHandling' },
	'tiffmeteringimage' => { 182 => 0x104c, 404 => 0x1110 },
	'tilelength' => { 116 => 0x143 },
	'tilewidth' => { 116 => 0x142 },
	'time' => { 134 => 0x401, 341 => 0x7 },
	'timecodes' => { 116 => 0xc763 },
	'timecreated' => { 128 => 0x3c, 136 => 0x14, 145 => 0x10, 353 => 'TimeCreated' },
	'timelapseshotnumber' => { 309 => 0x10 },
	'timeperiod' => { 478 => 'timePeriod' },
	'timerfunctionbutton' => { 268 => '5.2', 271 => '12.1', 272 => '13.1' },
	'timerlength' => { 81 => 0x80c },
	'timerrecording' => { 306 => 0x96 },
	'timescaleparams' => { 488 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 488 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 488 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 488 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 129 => 0x50 },
	'timeshot' => { 452 => 'TimeShot' },
	'timesignature' => { 488 => 'timeSignature' },
	'timesincepoweron' => { 306 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 282 => 0x8, 296 => 'TimeStamp', 306 => 0xaf, 451 => 'Timestamp', 458 => 'Timestamp', 472 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 75 => 0x1, 251 => 0x0, 376 => 0xa },
	'timezonecity' => { 75 => 0x2 },
	'timezonecode' => { 97 => 0x1 },
	'timezoneinfo' => { 97 => 0x2 },
	'timezoneoffset' => { 116 => 0x882a },
	'tint' => { 360 => 'player.movie.visual.tint', 462 => 'Tint', 464 => 'Tint' },
	'title' => { 153 => 'Title', 292 => 'Title', 296 => 'Title', 306 => 0x65, 357 => 'Title', 358 => ['titl',"\xa9nam"], 360 => 'title', 366 => ['titl',"\xa9nam"], 465 => 'title', 475 => 'Title', 486 => 'Title' },
	'tonecomp' => { 219 => 0x81 },
	'tonecurve' => { 71 => 0x1, 341 => 0x402, 462 => 'ToneCurve', 464 => 'ToneCurve' },
	'tonecurveactive' => { 105 => 0x110 },
	'tonecurveadobergb' => { 380 => 0xa043 },
	'tonecurveadobergbdefault' => { 380 => 0xa041 },
	'tonecurveblue' => { 462 => 'ToneCurveBlue', 464 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 439 => 0x9003 },
	'tonecurvebluey' => { 439 => 0x9007 },
	'tonecurvebrightness' => { 100 => 0x20410 },
	'tonecurvebrightnessx' => { 439 => 0x9000 },
	'tonecurvebrightnessy' => { 439 => 0x9004 },
	'tonecurvecolorspace' => { 104 => 0x0 },
	'tonecurvecontrast' => { 100 => 0x20411 },
	'tonecurvegreen' => { 462 => 'ToneCurveGreen', 464 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 439 => 0x9002 },
	'tonecurvegreeny' => { 439 => 0x9006 },
	'tonecurveinputrange' => { 104 => 0x3 },
	'tonecurveinterpolation' => { 105 => 0x159 },
	'tonecurvemode' => { 105 => 0x113 },
	'tonecurvename' => { 462 => 'ToneCurveName', 464 => 'ToneCurveName' },
	'tonecurvename2012' => { 462 => 'ToneCurveName2012', 464 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 100 => '0x20400.1' },
	'tonecurveoutputrange' => { 104 => 0x5 },
	'tonecurveprofilename' => { 134 => 0x1391 },
	'tonecurveproperty' => { 105 => 0x3c },
	'tonecurvepv2012' => { 462 => 'ToneCurvePV2012', 464 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 462 => 'ToneCurvePV2012Blue', 464 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 462 => 'ToneCurvePV2012Green', 464 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 462 => 'ToneCurvePV2012Red', 464 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 462 => 'ToneCurveRed', 464 => 'ToneCurveRed' },
	'tonecurveredx' => { 439 => 0x9001 },
	'tonecurveredy' => { 439 => 0x9005 },
	'tonecurves' => { 341 => 0x403 },
	'tonecurveshape' => { 104 => 0x1 },
	'tonecurvesrgb' => { 380 => 0xa042 },
	'tonecurvesrgbdefault' => { 380 => 0xa040 },
	'tonecurvex' => { 104 => 0xa },
	'tonecurvey' => { 104 => 0xb },
	'tonelevel' => { 283 => 0x52e },
	'tonemapstrength' => { 462 => 'ToneMapStrength', 464 => 'ToneMapStrength' },
	'toningeffect' => { 55 => 0xf, 219 => 0xb3, 221 => 0x38, 222 => 0x40, 223 => 0x48, 373 => 0x1015 },
	'toningeffectauto' => { 68 => 0xa4 },
	'toningeffectfaithful' => { 67 => 0x74, 68 => 0x74 },
	'toningeffectlandscape' => { 67 => 0x44, 68 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 67 => 0x8c, 68 => 0x8c },
	'toningeffectneutral' => { 67 => 0x5c, 68 => 0x5c },
	'toningeffectportrait' => { 67 => 0x2c, 68 => 0x2c },
	'toningeffectstandard' => { 67 => 0x14, 68 => 0x14 },
	'toningeffectuserdef1' => { 67 => 0xa4, 68 => 0xbc },
	'toningeffectuserdef2' => { 67 => 0xbc, 68 => 0xd4 },
	'toningeffectuserdef3' => { 67 => 0xd4, 68 => 0xec },
	'toningsaturation' => { 221 => 0x39, 222 => 0x41, 223 => 0x49 },
	'totalzoom' => { 136 => 0x62 },
	'touchae' => { 306 => 0xab },
	'track' => { 358 => "\xa9trk", 366 => "\xa9trk" },
	'trackcreatedate' => { 365 => 0x1 },
	'trackmodifydate' => { 365 => 0x2 },
	'tracknumber' => { 358 => 'trkn', 488 => 'trackNumber' },
	'tracks' => { 488 => 'Tracks' },
	'tracksframerate' => { 488 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 488 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 488 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 488 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 488 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 488 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 488 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 488 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 488 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 488 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 488 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 488 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 488 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 488 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 488 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 488 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 488 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 366 => 'kgtt' },
	'trailer' => { 117 => 'Trailer' },
	'trailersignature' => { 160 => 'zmie' },
	'transcript' => { 474 => 'Transcript' },
	'transcriptlink' => { 474 => 'TranscriptLink' },
	'transcriptlinklink' => { 474 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 474 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 116 => 0x12d, 484 => 'TransferFunction' },
	'transfertimenormal' => { 134 => 0x1888 },
	'transfertimetest' => { 134 => 0x1889 },
	'transform' => { 306 => [0x8012,0x59] },
	'transmissionreference' => { 476 => 'TransmissionReference' },
	'trapped' => { 292 => 'Trapped', 475 => 'Trapped' },
	'trashbuttonfunction' => { 81 => 0x710 },
	'travelday' => { 306 => 0x36 },
	'trebel' => { 360 => 'player.movie.audio.treble' },
	'triggermode' => { 367 => 0x6, 368 => 0x34, 369 => 0x34 },
	'tstop' => { 116 => 0xc772 },
	'ttl_da_adown' => { 329 => 0x5 },
	'ttl_da_aup' => { 329 => 0x4 },
	'ttl_da_bdown' => { 329 => 0x7 },
	'ttl_da_bup' => { 329 => 0x6 },
	'tungstenawb' => { 319 => 0x1 },
	'tvepisode' => { 358 => 'tves' },
	'tvepisodeid' => { 358 => 'tven' },
	'tvexposuretimesetting' => { 322 => 0x12 },
	'tvnetworkname' => { 358 => 'tvnn' },
	'tvseason' => { 358 => 'tvsn' },
	'tvshow' => { 358 => 'tvsh' },
	'type' => { 465 => 'type', 483 => 'type' },
	'typestatus' => { 115 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 116 => 0xc614 },
	'uniquedocumentid' => { 128 => 0xbb },
	'uniquematrixauto' => { 134 => 0x7e9 },
	'uniquematrixcustom' => { 134 => 0x7e8 },
	'uniquematrixdaylight' => { 134 => 0x7e4 },
	'uniquematrixflash' => { 134 => 0x7e7 },
	'uniquematrixfluorescent' => { 134 => 0x7e6 },
	'uniquematrixtungsten' => { 134 => 0x7e5 },
	'uniqueobjectname' => { 129 => 0x64 },
	'units' => { 447 => 'Units' },
	'unknown_aacr' => { 358 => 'AACR' },
	'unknown_cdek' => { 358 => 'CDEK' },
	'unknown_cdet' => { 358 => 'CDET' },
	'unknownblock' => { 341 => 0x405 },
	'unknownblock1' => { 287 => 0x635 },
	'unknownblock2' => { 287 => 0x636 },
	'unknownblock3' => { 287 => 0x1103 },
	'unknownblock4' => { 287 => 0x1104 },
	'unknowncontrast' => { 106 => 0x45 },
	'unknowndate' => { 350 => 0x212 },
	'unknownev' => { 134 => 0x1 },
	'unknownlinear' => { 106 => 0x46 },
	'unknownnumber' => { 94 => 0x180b },
	'unknownoutputhighlightpoint' => { 106 => 0x4a },
	'unknownoutputshadowpoint' => { 106 => 0x4b },
	'unknownrawhighlight' => { 106 => 0x7b },
	'unknownrawhighlightpoint' => { 106 => 0x48 },
	'unknownrawshadow' => { 106 => 0x84 },
	'unknownrawshadowpoint' => { 106 => 0x49 },
	'unknownsharpness' => { 106 => 0x47 },
	'unknowntags' => { 366 => 'TAGS' },
	'unknowntemperature' => { 118 => 0x4 },
	'unknownthumbnail' => { 366 => 'thmb' },
	'unsharp1color' => { 264 => 0x13 },
	'unsharp1halowidth' => { 264 => 0x19 },
	'unsharp1intensity' => { 264 => 0x17 },
	'unsharp1threshold' => { 264 => 0x1b },
	'unsharp2color' => { 264 => 0x2e },
	'unsharp2halowidth' => { 264 => 0x34 },
	'unsharp2intensity' => { 264 => 0x32 },
	'unsharp2threshold' => { 264 => 0x36 },
	'unsharp3color' => { 264 => 0x49 },
	'unsharp3halowidth' => { 264 => 0x4f },
	'unsharp3intensity' => { 264 => 0x4d },
	'unsharp3threshold' => { 264 => 0x51 },
	'unsharp4color' => { 264 => 0x64 },
	'unsharp4halowidth' => { 264 => 0x6a },
	'unsharp4intensity' => { 264 => 0x68 },
	'unsharp4threshold' => { 264 => 0x6c },
	'unsharpcount' => { 264 => 0x0 },
	'unsharpmask' => { 106 => 0x90, 259 => 0x76a43200 },
	'unsharpmaskfineness' => { 100 => 0x20309 },
	'unsharpmaskstrength' => { 100 => 0x20308 },
	'unsharpmaskthreshold' => { 100 => 0x2030a },
	'uprightcentermode' => { 462 => 'UprightCenterMode', 464 => 'UprightCenterMode' },
	'uprightcenternormx' => { 462 => 'UprightCenterNormX', 464 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 462 => 'UprightCenterNormY', 464 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 462 => 'UprightDependentDigest', 464 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 462 => 'UprightFocalLength35mm', 464 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 462 => 'UprightFocalMode', 464 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 462 => 'UprightFourSegmentsCount', 464 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 462 => 'UprightPreview', 464 => 'UprightPreview' },
	'uprighttransform_0' => { 462 => 'UprightTransform_0', 464 => 'UprightTransform_0' },
	'uprighttransform_1' => { 462 => 'UprightTransform_1', 464 => 'UprightTransform_1' },
	'uprighttransform_2' => { 462 => 'UprightTransform_2', 464 => 'UprightTransform_2' },
	'uprighttransform_3' => { 462 => 'UprightTransform_3', 464 => 'UprightTransform_3' },
	'uprighttransform_4' => { 462 => 'UprightTransform_4', 464 => 'UprightTransform_4' },
	'uprighttransform_5' => { 462 => 'UprightTransform_5', 464 => 'UprightTransform_5' },
	'uprighttransformcount' => { 462 => 'UprightTransformCount', 464 => 'UprightTransformCount' },
	'uprightversion' => { 462 => 'UprightVersion', 464 => 'UprightVersion' },
	'urgency' => { 128 => 0xa, 476 => 'Urgency' },
	'url' => { 153 => 'URL', 296 => 'URL', 355 => 0x40b, 478 => 'url' },
	'url_list' => { 355 => 0x41e },
	'urla-platform' => { 478 => [\'url','urlA-platform'] },
	'urlurl' => { 478 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 81 => 0x10a },
	'usableshootingmodes' => { 81 => 0x109 },
	'usage' => { 479 => 'usage' },
	'usageterms' => { 492 => 'UsageTerms' },
	'useguidelines' => { 460 => 'useGuidelines' },
	'usepanoramaviewer' => { 450 => 'UsePanoramaViewer' },
	'usercollection' => { 360 => 'collection.user' },
	'usercomment' => { 94 => 0x805, 116 => 0x9286, 468 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 67 => 0xd8, 68 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 67 => 0xda, 68 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 67 => 0xdc, 68 => 0xf4 },
	'userfields' => { 455 => 'UserFields' },
	'userlabel' => { 367 => 0x2b, 368 => 0x5a, 369 => 0x68 },
	'userprofile' => { 301 => 0x302, 308 => 0x3038 },
	'userrating' => { 360 => 'rating.user' },
	'usmlenselectronicmf' => { 2 => 0x7, 80 => 0x7, 81 => 0x501 },
	'uspsnumber' => { 478 => 'uspsNumber' },
	'utmeasting' => { 164 => 'Easting' },
	'utmmapdatum' => { 164 => 'Datum' },
	'utmnorthing' => { 164 => 'Northing' },
	'utmzone' => { 164 => 'Zone' },
	'uv-irfiltercorrection' => { 301 => 0x325 },
	'validbits' => { 287 => 0x611, 288 => 0x102c },
	'validpixeldepth' => { 291 => 0x611 },
	'variablelowpassfilter' => { 406 => 0x2028 },
	'variousmodes' => { 136 => 0x26 },
	'variousmodes2' => { 136 => 0x3a },
	'variprogram' => { 219 => 0xab },
	'varraydacnominalvalues' => { 134 => 0x191e },
	'vendor' => { 366 => 'vndr' },
	'vendorinfo' => { 442 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 442 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 442 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 442 => [\'VendorInfo','VendorInfoNotes'] },
	'version' => { 124 => 0x0, 357 => 'Version', 360 => 'version', 462 => 'Version', 464 => 'Version' },
	'versioncreatedate' => { 439 => 0xd100 },
	'versionid' => { 489 => 'VersionID' },
	'versionidentifier' => { 478 => 'versionIdentifier' },
	'versionmodifydate' => { 439 => 0xd101 },
	'versions' => { 489 => 'Versions' },
	'versionscomments' => { 489 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 489 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 489 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 489 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 489 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 489 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 489 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 489 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 489 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 489 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 489 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 266 => '3.2', 267 => '47.2', 269 => '79.1' },
	'verticalclockoverlaps' => { 134 => 0x412 },
	'verticalfuncbutton' => { 267 => '42.2', 269 => '67.1' },
	'verticalfuncbuttonplusdials' => { 267 => '43.1' },
	'verticalfuncplusdials' => { 269 => '68.1' },
	'verticalmultiselector' => { 267 => '42.1', 269 => '66.1', 270 => '66.1', 280 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 81 => [0x510,0x51d] },
	'vibrance' => { 456 => 'Vibrance', 462 => 'Vibrance', 464 => 'Vibrance' },
	'vibrationreduction' => { 228 => [0x75,0x82,0x1ae], 236 => '586.1', 244 => '590.2', 250 => 0x4 },
	'videoalphamode' => { 488 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 488 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 488 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 488 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 474 => 'videoBitRate' },
	'videobitratemode' => { 474 => 'videoBitRateMode' },
	'videoburstmode' => { 306 => 0xbb },
	'videocodec' => { 64 => 0x74 },
	'videocolorspace' => { 488 => 'videoColorSpace' },
	'videocompression' => { 124 => 0x3806 },
	'videocompressor' => { 488 => 'videoCompressor' },
	'videodisplayaspectratio' => { 474 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 474 => 'videoEncodingProfile' },
	'videofieldorder' => { 488 => 'videoFieldOrder' },
	'videoframerate' => { 488 => 'videoFrameRate' },
	'videoframesize' => { 488 => 'videoFrameSize' },
	'videoframesizeh' => { 488 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 488 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 488 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 488 => 'videoModDate' },
	'videopixelaspectratio' => { 488 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 488 => 'videoPixelDepth' },
	'videoquality' => { 110 => 0x4003 },
	'videorecordingmode' => { 124 => 0x3803 },
	'videoshottype' => { 474 => 'VideoShotType' },
	'videoshottypeidentifier' => { 474 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 474 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 474 => 'videoStreamsCount' },
	'viewfinder' => { 350 => 0x455 },
	'viewfinderdisplay' => { 266 => '12.4', 267 => '6.3' },
	'viewfinderwarning' => { 266 => '13.4', 276 => '3.5', 277 => '6.2', 281 => '4.4' },
	'viewfinderwarnings' => { 81 => 0x40a },
	'viewinfoduringexposure' => { 81 => 0x407 },
	'viewingmode' => { 395 => 0x2f, 411 => 0x18 },
	'viewingmode2' => { 395 => [0x85,0x285] },
	'viewpoint' => { 477 => 'viewpoint' },
	'vignetteamount' => { 462 => 'VignetteAmount', 464 => 'VignetteAmount' },
	'vignettecontrol' => { 219 => 0x2a, 259 => 0x76a43205 },
	'vignettecontrolintensity' => { 259 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 459 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 462 => 'VignetteMidpoint', 464 => 'VignetteMidpoint' },
	'vignetting' => { 373 => 0x1011, 380 => 0xa052 },
	'vignettingcorrection' => { 116 => 0x7031, 380 => 0xa053, 406 => 0x2011 },
	'vignettingcorrparams' => { 116 => 0x7032, 434 => 0x64a, 435 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 380 => 0xa054 },
	'visualcolor' => { 474 => 'VisualColour' },
	'visualtechnique' => { 477 => 'visualTechnique' },
	'voicememo' => { 382 => 0x216 },
	'volume' => { 478 => 'volume' },
	'vr_0x66' => { 228 => 0x66 },
	'vrdoffset' => { 61 => 0xd0 },
	'vrmode' => { 250 => 0x6 },
	'waterdepth' => { 116 => 0x9403, 469 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 182 => 0x19a },
	'wb_bluelevel6500k' => { 182 => 0x18a },
	'wb_bluelevelcustom' => { 182 => 0x18e },
	'wb_bluelevelscloudy' => { 182 => 0x106 },
	'wb_bluelevelsdaylight' => { 182 => 0xea },
	'wb_bluelevelsflash' => { 182 => 0x122 },
	'wb_bluelevelsfluorescent' => { 182 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 182 => 0x254 },
	'wb_bluelevelsshade' => { 182 => 0x176 },
	'wb_bluelevelstungsten' => { 182 => 0xce },
	'wb_gbrglevels' => { 182 => 0xae, 185 => 0x4 },
	'wb_glevel' => { 287 => 0x11f },
	'wb_glevel3000k' => { 287 => 0x113 },
	'wb_glevel3300k' => { 287 => 0x114 },
	'wb_glevel3600k' => { 287 => 0x115 },
	'wb_glevel3900k' => { 287 => 0x116 },
	'wb_glevel4000k' => { 287 => 0x117 },
	'wb_glevel4300k' => { 287 => 0x118 },
	'wb_glevel4500k' => { 287 => 0x119 },
	'wb_glevel4800k' => { 287 => 0x11a },
	'wb_glevel5300k' => { 287 => 0x11b },
	'wb_glevel6000k' => { 287 => 0x11c },
	'wb_glevel6600k' => { 287 => 0x11d },
	'wb_glevel7500k' => { 287 => 0x11e },
	'wb_grbglevels' => { 195 => 0x0 },
	'wb_grgblevelsauto' => { 78 => 0x2 },
	'wb_grgblevelscloudy' => { 78 => 0x12 },
	'wb_grgblevelscustom1' => { 78 => 0x42 },
	'wb_grgblevelscustom2' => { 78 => 0x4a },
	'wb_grgblevelsdaylight' => { 78 => 0xa },
	'wb_grgblevelsflash' => { 78 => 0x32 },
	'wb_grgblevelsfluorescent' => { 78 => 0x22 },
	'wb_grgblevelsfluorhigh' => { 78 => 0x2a },
	'wb_grgblevelstungsten' => { 78 => 0x1a },
	'wb_grgblevelsunderwater' => { 78 => 0x3a },
	'wb_rbgglevels' => { 192 => 0x0 },
	'wb_rblevels' => { 196 => 0x270, 219 => 0xc, 287 => 0x100 },
	'wb_rblevels1' => { 312 => 0x2 },
	'wb_rblevels2' => { 312 => 0x5 },
	'wb_rblevels3' => { 312 => 0x8 },
	'wb_rblevels3000k' => { 287 => 0x102 },
	'wb_rblevels3300k' => { 287 => 0x103 },
	'wb_rblevels3500k' => { 182 => 0x430 },
	'wb_rblevels3600k' => { 287 => 0x104 },
	'wb_rblevels3900k' => { 287 => 0x105 },
	'wb_rblevels4' => { 312 => 0xb },
	'wb_rblevels4000k' => { 287 => 0x106 },
	'wb_rblevels4300k' => { 287 => 0x107 },
	'wb_rblevels4500k' => { 287 => 0x108 },
	'wb_rblevels4800k' => { 287 => 0x109 },
	'wb_rblevels5' => { 312 => 0xe },
	'wb_rblevels5300k' => { 287 => 0x10a },
	'wb_rblevels6' => { 312 => 0x11 },
	'wb_rblevels6000k' => { 287 => 0x10b },
	'wb_rblevels6500k' => { 182 => 0x420 },
	'wb_rblevels6600k' => { 287 => 0x10c },
	'wb_rblevels7' => { 312 => 0x14 },
	'wb_rblevels7500k' => { 287 => 0x10d },
	'wb_rblevelsauto' => { 196 => 0x272, 291 => 0x110 },
	'wb_rblevelscloudy' => { 182 => 0x3f0, 184 => 0x10, 196 => 0x296, 291 => 0x121 },
	'wb_rblevelscoolwhitef' => { 182 => 0x308, 184 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 291 => 0x132 },
	'wb_rblevelscustom' => { 182 => 0x424 },
	'wb_rblevelscwb1' => { 287 => 0x10e },
	'wb_rblevelscwb2' => { 287 => 0x10f },
	'wb_rblevelscwb3' => { 287 => 0x110 },
	'wb_rblevelscwb4' => { 287 => 0x111 },
	'wb_rblevelsdaylight' => { 182 => [0x3ec,0x528], 184 => 0xc, 196 => 0x274 },
	'wb_rblevelsdaylightf' => { 184 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 291 => 0x130 },
	'wb_rblevelsdaywhitef' => { 184 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 291 => 0x131 },
	'wb_rblevelseveningsunlight' => { 291 => 0x124 },
	'wb_rblevelsfineweather' => { 291 => 0x122 },
	'wb_rblevelsflash' => { 182 => [0x3f4,0x304], 184 => 0x18, 196 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 196 => 0x290 },
	'wb_rblevelsincandescent' => { 196 => 0x282 },
	'wb_rblevelsshade' => { 182 => 0x418, 184 => 0x20, 196 => 0x2b2, 291 => 0x120 },
	'wb_rblevelstungsten' => { 182 => 0x3e8, 184 => 0x8, 291 => 0x123 },
	'wb_rblevelsunknown' => { 184 => 0x1c },
	'wb_rblevelsused' => { 291 => 0x100 },
	'wb_rblevelswhitef' => { 184 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 291 => 0x133 },
	'wb_redlevel3500k' => { 182 => 0x198 },
	'wb_redlevel6500k' => { 182 => 0x188 },
	'wb_redlevelcustom' => { 182 => 0x18c },
	'wb_redlevelscloudy' => { 182 => 0xf8 },
	'wb_redlevelsdaylight' => { 182 => 0xdc },
	'wb_redlevelsflash' => { 182 => 0x114 },
	'wb_redlevelsfluorescent' => { 182 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 182 => 0x1be },
	'wb_redlevelsshade' => { 182 => 0x168 },
	'wb_redlevelstungsten' => { 182 => 0xc0 },
	'wb_rgbglevels' => { 194 => 0x0 },
	'wb_rgblevels' => { 182 => [0x546,0x96], 302 => 0xd, 303 => 0x413, 308 => 0x3036, 350 => 0x107, 414 => 0x117c, 415 => 0x1180, 416 => 0x115c, 417 => 0x11d8, 418 => 0x11b4, 419 => 0x106c, 420 => 0x264, 421 => 0x264, 422 => 0x252 },
	'wb_rgblevels1' => { 313 => 0x2 },
	'wb_rgblevels2' => { 313 => 0x6 },
	'wb_rgblevels3' => { 313 => 0xa },
	'wb_rgblevels4' => { 313 => 0xe },
	'wb_rgblevels5' => { 313 => 0x12 },
	'wb_rgblevels6' => { 313 => 0x16 },
	'wb_rgblevels7' => { 313 => 0x1a },
	'wb_rgblevelsauto' => { 384 => 0x0 },
	'wb_rgblevelscustom1' => { 384 => 0x15 },
	'wb_rgblevelscustom2' => { 384 => 0x18 },
	'wb_rgblevelscustom3' => { 384 => 0x1b },
	'wb_rgblevelsdaylight' => { 384 => 0x3 },
	'wb_rgblevelsflash' => { 384 => 0x12 },
	'wb_rgblevelsfluorescent' => { 384 => 0xf },
	'wb_rgblevelsincandescent' => { 384 => 0xc },
	'wb_rgblevelsovercast' => { 384 => 0x9 },
	'wb_rgblevelsshade' => { 384 => 0x6 },
	'wb_rgblevelsunknown0' => { 385 => 0x0 },
	'wb_rgblevelsunknown1' => { 385 => 0x3 },
	'wb_rgblevelsunknown2' => { 385 => 0x6 },
	'wb_rgblevelsunknown3' => { 385 => 0x9 },
	'wb_rgblevelsunknown4' => { 385 => 0xc },
	'wb_rgblevelsunknown5' => { 385 => 0xf },
	'wb_rgblevelsunknown6' => { 385 => 0x12 },
	'wb_rgblevelsunknown7' => { 385 => 0x15 },
	'wb_rgblevelsunknown8' => { 385 => 0x18 },
	'wb_rgblevelsunknown9' => { 385 => 0x1b },
	'wb_rgbmuldaylight' => { 134 => 0x852 },
	'wb_rgbmulflash' => { 134 => 0x855 },
	'wb_rgbmulfluorescent' => { 134 => 0x854 },
	'wb_rgbmultungsten' => { 134 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 185 => 0x4, 193 => 0x0, 197 => 0x13e8, 198 => 0x38 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x22, 42 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x3f, 48 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x18, 42 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x44, 48 => 0x4c, 197 => 0x1478, 198 => 0x114, 380 => 0xa022 },
	'wb_rggblevelsblack' => { 380 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0x31, 42 => 0x58, 45 => 0x71, 46 => 0x8a, 47 => 0x8f, 48 => 0x92, 197 => 0x1408, 198 => 0x60, 341 => 0x20f, 349 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 42 => 0x80, 197 => 0x1468, 198 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x27, 42 => 0x4e, 45 => 0x67, 46 => 0x80, 47 => 0x85, 48 => 0x88, 197 => 0x13f8, 198 => 0x4c, 341 => 0x20d, 349 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0x45, 42 => 0x6c, 45 => 0x85, 46 => 0x9e, 47 => 0xa3, 48 => 0xa6, 197 => 0x1448, 341 => 0x214, 349 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0x3b, 42 => 0x62, 45 => 0x7b, 46 => 0x94, 47 => 0x99, 48 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 198 => 0xc4, 341 => 0x211, 349 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 349 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 198 => 0xb0, 341 => 0x212, 349 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 197 => 0x1438, 198 => 0x9c, 341 => 0x213, 349 => 0x38 },
	'wb_rggblevelshtmercury' => { 198 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 380 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 380 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0x40, 42 => 0x67, 45 => 0x80, 46 => 0x99, 47 => 0x9e, 48 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 42 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x49, 48 => 0x51 },
	'wb_rggblevelspc1' => { 41 => 0x90, 42 => 0x71 },
	'wb_rggblevelspc2' => { 41 => 0x95, 42 => 0x76 },
	'wb_rggblevelspc3' => { 41 => 0x9a, 42 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x2c, 42 => 0x53, 45 => 0x6c, 46 => 0x85, 47 => 0x8a, 48 => 0x8d, 198 => 0x74, 341 => 0x20e, 349 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0x36, 42 => 0x5d, 45 => 0x76, 46 => 0x8f, 47 => 0x94, 48 => 0x97, 197 => 0x1428, 198 => 0x88, 341 => 0x210, 349 => 0x1d },
	'wb_rggblevelsuncorrected' => { 380 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x1d, 45 => 0x4e, 46 => 0x4e, 47 => 0x4e, 48 => 0x56, 349 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x72, 45 => 0x9e, 46 => 0x7b, 47 => 0x7b, 48 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0x77, 45 => 0xa3, 46 => 0xa3, 47 => 0x80, 48 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0x7c, 45 => 0xa8, 46 => 0xa8, 47 => 0xa8, 48 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0x81, 45 => 0xad, 46 => 0xad, 47 => 0xad, 48 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0x86, 45 => 0xb2, 46 => 0xb2, 47 => 0xb2, 48 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0x8b, 45 => 0xb7, 46 => 0xb7, 47 => 0xb7, 48 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0x9f, 46 => 0xbc, 47 => 0xbc, 48 => 0xc4 },
	'wb_rggblevelsunknown17' => { 46 => 0xc1, 47 => 0xc1, 48 => 0xc9 },
	'wb_rggblevelsunknown18' => { 46 => 0xc6, 47 => 0xc6, 48 => 0xce },
	'wb_rggblevelsunknown19' => { 46 => 0xcb, 47 => 0xcb, 48 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x4a, 45 => 0x53, 46 => 0x53, 47 => 0x53, 48 => 0x5b },
	'wb_rggblevelsunknown20' => { 46 => 0xd0, 47 => 0xd0, 48 => 0xd8 },
	'wb_rggblevelsunknown21' => { 47 => 0xd5, 48 => 0xdd },
	'wb_rggblevelsunknown22' => { 47 => 0xda, 48 => 0xe2 },
	'wb_rggblevelsunknown23' => { 47 => 0xdf, 48 => 0xe7 },
	'wb_rggblevelsunknown24' => { 47 => 0xe4, 48 => 0xec },
	'wb_rggblevelsunknown25' => { 47 => 0xe9, 48 => 0xf1 },
	'wb_rggblevelsunknown26' => { 47 => 0xee, 48 => 0xf6 },
	'wb_rggblevelsunknown27' => { 47 => 0xf3, 48 => 0xfb },
	'wb_rggblevelsunknown28' => { 47 => 0xf8, 48 => 0x100 },
	'wb_rggblevelsunknown29' => { 47 => 0xfd, 48 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x4f, 45 => 0x58, 46 => 0x58, 47 => 0x58, 48 => 0x60 },
	'wb_rggblevelsunknown30' => { 47 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x54, 45 => 0x5d, 46 => 0x5d, 47 => 0x5d, 48 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x59, 45 => 0x62, 46 => 0x62, 47 => 0x62, 48 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x5e, 45 => 0x8a, 46 => 0x67, 47 => 0x67, 48 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x63, 45 => 0x8f, 46 => 0x6c, 47 => 0x6c, 48 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x68, 45 => 0x94, 46 => 0x71, 47 => 0x71, 48 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x6d, 45 => 0x99, 46 => 0x76, 47 => 0x76, 48 => 0x7e },
	'wb_rggblevelsuserselected' => { 349 => 0x5c },
	'wbadjblueamber' => { 100 => 0x20106 },
	'wbadjbluebalance' => { 265 => 0x8 },
	'wbadjcolortemp' => { 100 => 0x20102, 105 => 0x1a },
	'wbadjlighting' => { 265 => 0x14 },
	'wbadjmagentagreen' => { 100 => 0x20105 },
	'wbadjmode' => { 265 => 0x10 },
	'wbadjredbalance' => { 265 => 0x0 },
	'wbadjrggblevels' => { 100 => 0x20125, 105 => 0x6 },
	'wbadjtemperature' => { 265 => 0x18 },
	'wbadjtint' => { 265 => 0x25 },
	'wbbluelevel' => { 301 => 0x324, 306 => 0x8006, 311 => 0x26 },
	'wbbracketingsteps' => { 237 => 0x174d, 238 => 0x87c, 246 => 0x1757 },
	'wbbracketmode' => { 55 => 0x9 },
	'wbbracketshotnumber' => { 182 => 0x2b, 373 => 0x101a },
	'wbbracketvalueab' => { 55 => 0xc },
	'wbbracketvaluegm' => { 55 => 0xd },
	'wbfinetuneactive' => { 105 => 0x24 },
	'wbfinetunesaturation' => { 105 => 0x28 },
	'wbfinetunetone' => { 105 => 0x2c },
	'wbgreenlevel' => { 301 => 0x323, 306 => 0x8005, 311 => 0x25 },
	'wbmediaimagesizesetting' => { 81 => 0x708 },
	'wbmode' => { 184 => 0x4, 288 => 0x1015 },
	'wbredlevel' => { 301 => 0x322, 306 => 0x8004, 311 => 0x24 },
	'wbscale' => { 185 => 0x0 },
	'wbshiftab' => { 71 => 0xc, 306 => 0x46, 323 => 0x10 },
	'wbshiftab_gm' => { 406 => 0x2014 },
	'wbshiftab_gm_precise' => { 406 => 0x2026 },
	'wbshiftcreativecontrol' => { 306 => 0x92 },
	'wbshiftgm' => { 71 => 0xd, 306 => 0x47, 323 => 0x11 },
	'wbshiftintelligentauto' => { 306 => 0x8b },
	'wbtype1' => { 312 => 0x1, 313 => 0x1 },
	'wbtype2' => { 312 => 0x4, 313 => 0x5 },
	'wbtype3' => { 312 => 0x7, 313 => 0x9 },
	'wbtype4' => { 312 => 0xa, 313 => 0xd },
	'wbtype5' => { 312 => 0xd, 313 => 0x11 },
	'wbtype6' => { 312 => 0x10, 313 => 0x15 },
	'wbtype7' => { 312 => 0x13, 313 => 0x19 },
	'webstatement' => { 492 => 'WebStatement' },
	'what' => { 462 => 'What', 464 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 71 => 0x8, 74 => 0x7, 109 => 0x7, 110 => [0x19,0x2012], 116 => [0xa403,0xfe4e], 124 => 0x1002, 134 => 0x3fc, 135 => 0xfa0d, 136 => 0x40, 147 => 0x1a, 176 => 0x3, 177 => 0xe, 178 => 0x4, 179 => 0xb, 181 => 0x115, 219 => 0x5, 249 => 0x7, 301 => 0x304, 306 => 0x3, 308 => 0x3033, 341 => 0x19, 348 => 0x7, 372 => 0x26, 373 => 0x1003, 383 => [0x88,0x3c,0x7,0x58], 393 => 0xf, 394 => 0xe, 406 => [0x115,0xb054], 462 => 'WhiteBalance', 464 => 'WhiteBalance', 468 => 'WhiteBalance' },
	'whitebalance0' => { 172 => 'WhiteBalance0' },
	'whitebalance1' => { 172 => 'WhiteBalance1' },
	'whitebalance2' => { 172 => 'WhiteBalance2', 283 => 0x500 },
	'whitebalanceadj' => { 100 => 0x20101, 105 => 0x18, 259 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 319 => 0x0 },
	'whitebalancebias' => { 110 => 0x2011, 288 => 0x304, 306 => 0x23 },
	'whitebalanceblue' => { 71 => 0x7 },
	'whitebalancebracket' => { 283 => 0x502, 288 => 0x303 },
	'whitebalancebracketing' => { 179 => 0x22, 182 => 0x2c, 404 => 0x2c },
	'whitebalancecomp' => { 291 => 0x1001 },
	'whitebalancedetected' => { 134 => 0x3fb },
	'whitebalancefinetune' => { 124 => 0x100a, 179 => 0x38, 181 => 0x112, 219 => 0xb, 373 => 0x1004, 393 => 0x6, 394 => 0x5, 406 => 0x112 },
	'whitebalancemode' => { 134 => 0x3fa, 341 => 0x1a },
	'whitebalancered' => { 71 => 0x6 },
	'whitebalanceset' => { 322 => 0xa },
	'whitebalancesetting' => { 179 => 0x23, 393 => 0x5, 394 => 0x4, 395 => 0x16, 411 => 0xd },
	'whitebalancesetup' => { 380 => 0x41 },
	'whitebalancetemperature' => { 283 => 0x501 },
	'whiteboard' => { 288 => 0x301 },
	'whitelevel' => { 116 => 0xc61d, 341 => 0x7e },
	'whitepoint' => { 116 => 0x13e, 341 => 0x201, 484 => 'WhitePoint' },
	'whites2012' => { 462 => 'Whites2012', 464 => 'Whites2012' },
	'whitesadj' => { 439 => 0x9017 },
	'wideadapter' => { 373 => 0x1017 },
	'widefocuszone' => { 176 => 0x2f },
	'widerange' => { 382 => 0x20f },
	'windmode' => { 134 => 0x3f4 },
	'windowlocation' => { 366 => 'WLOC' },
	'windowsatom' => { 463 => 'windowsAtom' },
	'windowsatomextension' => { 463 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 463 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 463 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 478 => 'wordCount' },
	'workcolorspace' => { 100 => 0x10200, 105 => 0x270 },
	'workflowtag' => { 474 => 'WorkflowTag' },
	'workflowtagcvid' => { 474 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 474 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 474 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 474 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 470 => 'WorkToDo' },
	'worldtimelocation' => { 306 => 0x3a, 341 => 0x22, 347 => '0.1' },
	'writer-editor' => { 128 => 0x7a },
	'x3filllight' => { 383 => 0x12 },
	'xattrquarantine' => { 170 => 'com.apple.quarantine' },
	'xilinxversion' => { 134 => 0x414 },
	'xml' => { 132 => 'xml ' },
	'xmp' => { 103 => 0xffff00f6, 117 => 'XMP' },
	'xmptoolkit' => { 485 => 'xmptk' },
	'xpauthor' => { 116 => 0x9c9d },
	'xpcomment' => { 116 => 0x9c9c },
	'xpkeywords' => { 116 => 0x9c9e },
	'xposition' => { 116 => 0x11e },
	'xpsubject' => { 116 => 0x9c9f },
	'xptitle' => { 116 => 0x9c9b },
	'xresolution' => { 116 => 0x11a, 131 => 0x3, 356 => 0x0, 484 => 'XResolution' },
	'xyresolution' => { 120 => 0x3 },
	'yaw' => { 112 => 0x7, 366 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 237 => 0x3513, 238 => 0x2c2c, 246 => 0x36fc, 378 => 0x0 },
	'ycbcrcoefficients' => { 116 => 0x211, 484 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 116 => 0x213, 484 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 116 => 0x212, 484 => 'YCbCrSubSampling' },
	'year' => { 358 => 'yrrc', 360 => 'year' },
	'yearcreated' => { 136 => 0x10, 145 => 0xc },
	'yellowhsl' => { 100 => 0x20912 },
	'yield' => { 480 => 'yield' },
	'yposition' => { 116 => 0x11f },
	'yresolution' => { 116 => 0x11b, 131 => 0x5, 356 => 0x4, 484 => 'YResolution' },
	'zonematching' => { 181 => 0x10a, 184 => [0x3a,0x4a], 406 => 0xb024 },
	'zonematchingmode' => { 179 => 0x14 },
	'zonematchingon' => { 178 => 0x75 },
	'zonematchingvalue' => { 393 => 0x1f },
	'zoomedpreviewlength' => { 288 => 0xf05 },
	'zoomedpreviewsize' => { 288 => 0xf06 },
	'zoomedpreviewstart' => { 288 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 286 => 0x300, 288 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'acceldata' => 1,
	'accelerometerdata' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airspeed' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kinds' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'lenstypemake' => 1,
	'lenstypemodel' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playcounter' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2020, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
