package org.jboss.cache.loader;

import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

/**
 * Tests {@link org.jboss.cache.loader.jdbm.JdbmCacheLoader}.
 *
 * @author Elias Ross
 * @version $Id: JdbmCacheLoaderTest.java 5906 2008-05-29 07:24:18Z mircea.markus $
 */
@Test (groups = {"functional"})
public class JdbmCacheLoaderTest extends CacheLoaderTestsBase
{
   protected void configureCache() throws Exception
   {      
      String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
      String tmpCLLoc = tmpDir + "/JBossCache-JdbmCacheLoaderTest";
      cache.getConfiguration().setCacheLoaderConfig(getSingleCacheLoaderConfig("", "org.jboss.cache.loader.jdbm.JdbmCacheLoader", "location=" + tmpCLLoc, false, true, false));
      TestingUtil.recursiveFileRemove(tmpCLLoc);
   }
}
