/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.GraphicsState;
import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.MutableCommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Command;
import de.erichseifert.vectorgraphics2d.intermediate.commands.CreateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DisposeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawImageCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawStringCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.RotateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.ScaleCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetBackgroundCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetClipCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetColorCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetCompositeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetFontCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetHintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetPaintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetStrokeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetXORModeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.ShearCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.TransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.TranslateCommand;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class VectorGraphics2D
extends Graphics2D
implements Cloneable {
    private final MutableCommandSequence commands = new MutableCommandSequence();
    private final GraphicsConfiguration deviceConfig;
    private final FontRenderContext fontRenderContext;
    private boolean disposed;
    private GraphicsState state;

    public VectorGraphics2D() {
        this.emit(new CreateCommand(this));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = null;
        if (!graphicsEnvironment.isHeadlessInstance()) {
            graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            this.deviceConfig = graphicsDevice.getDefaultConfiguration();
        } else {
            this.deviceConfig = null;
        }
        this.fontRenderContext = new FontRenderContext(null, false, true);
        this.state = new GraphicsState();
        this.setColor(Color.BLACK);
        this.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, null, 0.0f));
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            VectorGraphics2D vectorGraphics2D = (VectorGraphics2D)super.clone();
            vectorGraphics2D.state = (GraphicsState)this.state.clone();
            return vectorGraphics2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        if (this.isDisposed()) {
            return;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.setRenderingHint((RenderingHints.Key)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clip(Shape shape) {
        Shape shape2 = this.getClip();
        if (shape2 != null && shape != null) {
            shape = VectorGraphics2D.intersectShapes(shape2, shape);
        }
        this.setClip(shape);
    }

    private static Shape intersectShapes(Shape shape, Shape shape2) {
        if (shape instanceof Rectangle2D && shape2 instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            Rectangle2D rectangle2D2 = (Rectangle2D)shape2;
            double d = Math.max(rectangle2D.getMinX(), rectangle2D2.getMinX());
            double d2 = Math.max(rectangle2D.getMinY(), rectangle2D2.getMinY());
            double d3 = Math.min(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
            double d4 = Math.min(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            if (d3 < d || d4 < d2) {
                double_.setFrameFromDiagonal(0.0, 0.0, 0.0, 0.0);
            } else {
                double_.setFrameFromDiagonal(d, d2, d3, d4);
            }
            return double_;
        }
        Area area = new Area(shape);
        area.intersect(new Area(shape2));
        return area;
    }

    @Override
    public void draw(Shape shape) {
        if (this.isDisposed() || shape == null) {
            return;
        }
        this.emit(new DrawShapeCommand(shape));
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        Shape shape = glyphVector.getOutline(f, f2);
        this.draw(shape);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        BufferedImage bufferedImage = this.getTransformedImage(image, affineTransform);
        return this.drawImage(bufferedImage, bufferedImage.getMinX(), bufferedImage.getMinY(), bufferedImage.getWidth(), bufferedImage.getHeight(), null, null);
    }

    private BufferedImage getTransformedImage(Image image, AffineTransform affineTransform) {
        Integer n = (Integer)this.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        n = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(n) ? Integer.valueOf(1) : (RenderingHints.VALUE_INTERPOLATION_BILINEAR.equals(n) ? Integer.valueOf(2) : Integer.valueOf(3));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, n);
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        return affineTransformOp.filter(bufferedImage, null);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        this.drawImage(bufferedImage, n, n2, bufferedImage.getWidth(), bufferedImage.getHeight(), null, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(renderedImage);
        this.drawImage(bufferedImage, affineTransform, null);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        if (this.isDisposed() || string == null || string.trim().length() == 0) {
            return;
        }
        boolean bl = false;
        if (bl) {
            TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
            this.fill(shape);
        } else {
            this.emit(new DrawStringCommand(string, f, f2));
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuilder.append(c);
            c = attributedCharacterIterator.next();
        }
        this.drawString(stringBuilder.toString(), f, f2);
    }

    @Override
    public void fill(Shape shape) {
        if (this.isDisposed() || shape == null) {
            return;
        }
        this.emit(new FillShapeCommand(shape));
    }

    @Override
    public Color getBackground() {
        return this.state.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.state.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.deviceConfig;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    @Override
    public Paint getPaint() {
        return this.state.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        if (RenderingHints.KEY_ANTIALIASING.equals(key)) {
            return RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_TEXT_ANTIALIASING.equals(key)) {
            return RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        }
        if (RenderingHints.KEY_FRACTIONALMETRICS.equals(key)) {
            return RenderingHints.VALUE_FRACTIONALMETRICS_ON;
        }
        return this.state.getHints().get(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.state.getHints().clone();
    }

    @Override
    public Stroke getStroke() {
        return this.state.getStroke();
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        Shape shape2 = shape;
        if (bl) {
            shape2 = this.getStroke().createStrokedShape(shape2);
        }
        shape2 = this.state.transformShape(shape2);
        boolean bl2 = shape2.intersects(rectangle);
        return bl2;
    }

    @Override
    public void setBackground(Color color) {
        if (this.isDisposed() || color == null || this.getColor().equals(color)) {
            return;
        }
        this.emit(new SetBackgroundCommand(color));
        this.state.setBackground(color);
    }

    @Override
    public void setComposite(Composite composite) {
        if (this.isDisposed()) {
            return;
        }
        if (composite == null) {
            throw new IllegalArgumentException("Cannot set a null composite.");
        }
        this.emit(new SetCompositeCommand(composite));
        this.state.setComposite(composite);
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.isDisposed() || paint == null) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (this.getPaint().equals(paint)) {
            return;
        }
        this.emit(new SetPaintCommand(paint));
        this.state.setPaint(paint);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.isDisposed()) {
            return;
        }
        this.state.getHints().put(key, object);
        this.emit(new SetHintCommand(key, object));
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        if (this.isDisposed()) {
            return;
        }
        this.state.getHints().clear();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.setRenderingHint((RenderingHints.Key)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (this.isDisposed()) {
            return;
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Cannot set a null stroke.");
        }
        this.emit(new SetStrokeCommand(stroke));
        this.state.setStroke(stroke);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.state.getTransform());
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        if (this.isDisposed() || affineTransform == null || this.state.getTransform().equals(affineTransform)) {
            return;
        }
        this.emit(new SetTransformCommand(affineTransform));
        this.state.setTransform(affineTransform);
    }

    @Override
    public void shear(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        affineTransform.shear(d, d2);
        this.emit(new ShearCommand(d, d2));
        this.state.setTransform(affineTransform);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return;
        }
        AffineTransform affineTransform2 = this.getTransform();
        affineTransform2.concatenate(affineTransform);
        this.emit(new TransformCommand(affineTransform));
        this.state.setTransform(affineTransform2);
    }

    @Override
    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    @Override
    public void translate(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(d, d2);
        this.emit(new TranslateCommand(d, d2));
        this.state.setTransform(affineTransform);
    }

    @Override
    public void rotate(double d) {
        this.rotate(d, 0.0, 0.0);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        if (d == 0.0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        if (d2 == 0.0 && d3 == 0.0) {
            affineTransform.rotate(d);
        } else {
            affineTransform.rotate(d, d2, d3);
        }
        this.emit(new RotateCommand(d, d2, d3));
        this.state.setTransform(affineTransform);
    }

    @Override
    public void scale(double d, double d2) {
        if (d == 1.0 && d2 == 1.0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        affineTransform.scale(d, d2);
        this.emit(new ScaleCommand(d, d2));
        this.state.setTransform(affineTransform);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        Color color = this.getColor();
        this.setColor(this.getBackground());
        this.fillRect(n, n2, n3, n4);
        this.setColor(color);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Graphics create() {
        if (this.isDisposed()) {
            return null;
        }
        VectorGraphics2D vectorGraphics2D = null;
        try {
            vectorGraphics2D = (VectorGraphics2D)this.clone();
            this.emit(new CreateCommand(vectorGraphics2D));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return vectorGraphics2D;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.emit(new DisposeCommand(this));
        this.disposed = true;
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (this.isDisposed() || image == null) {
            return true;
        }
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (color != null) {
            Color color2 = this.getColor();
            this.setColor(color);
            this.fill(rectangle);
            this.setColor(color2);
        }
        this.emit(new DrawImageCommand(image, n5, n6, n, n2, n3, n4));
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        int n9 = Math.min(n5, n7);
        int n10 = Math.min(n6, n8);
        int n11 = Math.abs(n7 - n5);
        int n12 = Math.abs(n8 - n6);
        int n13 = Math.min(n, n3);
        int n14 = Math.min(n2, n4);
        int n15 = Math.abs(n3 - n);
        int n16 = Math.abs(n4 - n2);
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(n9, n10, n11, n12);
        return this.drawImage(bufferedImage2, n13, n14, n15, n16, color, imageObserver);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Double(n, n2, n3, n4));
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Double(n, n2, n3, n4));
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Path2D.Float float_ = new Path2D.Float();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Path2D)float_).lineTo(nArray[i], nArray2[i]);
                continue;
            }
            ((Path2D)float_).moveTo(nArray[i], nArray2[i]);
        }
        this.draw(float_);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2));
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Double(n, n2, n3, n4));
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public Shape getClip() {
        return this.state.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.getClip() == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Color getColor() {
        return this.state.getColor();
    }

    @Override
    public Font getFont() {
        return this.state.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 3);
        Graphics graphics = bufferedImage.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        graphics.dispose();
        return fontMetrics;
    }

    @Override
    public void setClip(Shape shape) {
        if (this.isDisposed()) {
            return;
        }
        this.emit(new SetClipCommand(shape));
        this.state.setClip(shape);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setColor(Color color) {
        if (this.isDisposed() || color == null || this.getColor().equals(color)) {
            return;
        }
        this.emit(new SetColorCommand(color));
        this.state.setColor(color);
        this.state.setPaint(color);
    }

    @Override
    public void setFont(Font font) {
        if (this.isDisposed() || font != null && this.getFont().equals(font)) {
            return;
        }
        this.emit(new SetFontCommand(font));
        this.state.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    public Color getXORMode() {
        return this.state.getXorMode();
    }

    @Override
    public void setXORMode(Color color) {
        if (this.isDisposed() || color == null) {
            return;
        }
        this.emit(new SetXORModeCommand(color));
        this.state.setXorMode(color);
    }

    private void emit(Command<?> command) {
        this.commands.add(command);
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    public CommandSequence getCommands() {
        return this.commands;
    }
}

