/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me;

import com.sun.cdc.i18n.Helper;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public abstract class UniversalInputStream
extends InputStream
implements DataInput {
    private Reader reader;
    private int lastch = -2;

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = (int)this.skip(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public String readUTF() throws IOException {
        return UniversalInputStream.readUTF(this);
    }

    public static String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        byte[] byArray = new byte[n];
        int n2 = 0;
        dataInput.readFully(byArray, 0, n);
        block5: while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(stringBuffer);
    }

    public float readFloat() throws IOException {
        throw new RuntimeException("Function not supported");
    }

    public double readDouble() throws IOException {
        throw new RuntimeException("Function not supported");
    }

    public String readLine() throws IOException {
        throw new RuntimeException("Function not supported");
    }

    public byte[] readByteArray() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray, 0, n);
        return byArray;
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        this.reader = Helper.getStreamReader(this, string);
        this.lastch = -1;
    }

    public int scanChar() throws IOException {
        if (this.lastch == -1) {
            return this.reader.read();
        }
        if (this.lastch == -2) {
            this.reader = Helper.getStreamReader(this);
            this.lastch = -1;
            return this.reader.read();
        }
        int n = this.lastch;
        this.lastch = -1;
        return n;
    }

    public int scanInt() throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = this.scanChar();
        if (n2 == 45) {
            bl = true;
            n2 = this.scanChar();
        }
        if (n2 == 43) {
            n2 = this.scanChar();
        }
        if (n2 == -1) {
            throw new EOFException();
        }
        while (true) {
            if (n2 < 48 || n2 > 57) break;
            n = n * 10 + (n2 - 48);
            n2 = this.scanChar();
        }
        this.lastch = n2;
        return bl ? 0 - n : n;
    }

    public String scanText() throws IOException {
        int n = this.scanChar();
        if (n == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (n <= 32) break;
            stringBuffer.append((char)n);
            n = this.scanChar();
        }
        this.lastch = n;
        return stringBuffer.toString();
    }

    public String scanLine() throws IOException {
        int n = this.scanChar();
        if (n == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (n == 13) continue;
            if (n == 10) break;
            stringBuffer.append((char)n);
        } while ((n = this.scanChar()) != -1);
        return stringBuffer.toString();
    }

    public void seek(long l) throws IOException, IllegalAccessException {
        throw new IllegalAccessException();
    }

    public void setTimeout(int n) throws IOException {
    }
}

