/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    private Runtime() {
    }

    public void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        if (!Runtime.safeExit(n)) {
            Shutdown.exit(n);
        }
    }

    private static native boolean safeExit(int var0);

    public void addShutdownHook(Thread thread) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        Shutdown.add(thread);
    }

    public boolean removeShutdownHook(Thread thread) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        return Shutdown.remove(thread);
    }

    public void halt(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        Shutdown.halt(n);
    }

    private native Process execInternal(String[] var1, String[] var2, String var3) throws IOException;

    public Process exec(String string) throws IOException {
        return this.exec(string, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        int n = 0;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        stringTokenizer = new StringTokenizer(string);
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n++] = stringTokenizer.nextToken();
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        SecurityManager securityManager;
        int n;
        stringArray = (String[])stringArray.clone();
        String[] stringArray3 = stringArray2 = stringArray2 != null ? (String[])stringArray2.clone() : null;
        if (stringArray.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            throw new NullPointerException();
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n] != null) continue;
                throw new NullPointerException();
            }
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkExec(stringArray[0]);
        }
        String string = file == null ? null : file.getPath();
        return this.execInternal(stringArray, stringArray2, string);
    }

    public int availableProcessors() {
        return 1;
    }

    public native long freeMemory();

    public native long totalMemory();

    public native long maxMemory();

    public native void gc();

    private static native void runFinalization0();

    public void runFinalization() {
        Runtime.runFinalization0();
    }

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    public void load(String string) {
        this.load0(System.getCallerClass(), string);
    }

    synchronized void load0(Class clazz, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (!new File(string).isAbsolute()) {
            throw new UnsatisfiedLinkError("Expecting an absolute path of the library: " + string);
        }
        ClassLoader.loadLibrary(clazz, string, true);
    }

    public void loadLibrary(String string) {
        this.loadLibrary0(System.getCallerClass(), string);
    }

    synchronized void loadLibrary0(Class clazz, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        if (string.indexOf(File.separatorChar) != -1) {
            throw new UnsatisfiedLinkError("Directory separator should not appear in library name: " + string);
        }
        ClassLoader.loadLibrary(clazz, string, false);
    }
}

