/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * RevertPanel.java
 *
 * Created on May 11, 2011, 3:48:55 PM
 */
package org.netbeans.modules.localhistory.ui.actions;

import java.awt.Dialog;
import java.awt.EventQueue;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author tomas
 */
public class RevertPanel extends javax.swing.JPanel {

    /** Creates new form RevertPanel */
    public RevertPanel() {
        initComponents();
        listScrollPane.setVisible(false);
        titleLabel.setVisible(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        listScrollPane = new javax.swing.JScrollPane();
        titleLabel = new javax.swing.JLabel();
        messageLabel = new javax.swing.JLabel();

        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        listScrollPane.setViewportView(tree);

        titleLabel.setText(org.openide.util.NbBundle.getMessage(RevertPanel.class, "RevertPanel.titleLabel.text")); // NOI18N

        initPanel.setBackground(javax.swing.UIManager.getDefaults().getColor("List.background"));
        initPanel.setMinimumSize(new java.awt.Dimension(380, 195));
        initPanel.setRequestFocusEnabled(false);
        initPanel.setLayout(new java.awt.GridBagLayout());

        messageLabel.setText(org.openide.util.NbBundle.getMessage(RevertPanel.class, "RevertPanel.messageLabel.text")); // NOI18N
        messageLabel.setEnabled(false);
        initPanel.add(messageLabel, new java.awt.GridBagConstraints());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(listScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)
                    .addComponent(titleLabel)
                    .addComponent(initPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(titleLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(listScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 105, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(initPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 195, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JPanel initPanel = new javax.swing.JPanel();
    private javax.swing.JScrollPane listScrollPane;
    private javax.swing.JLabel messageLabel;
    private javax.swing.JLabel titleLabel;
    final javax.swing.JTree tree = new javax.swing.JTree();
    // End of variables declaration//GEN-END:variables


    void setRootNode(final TreeNode root) {
        if(root != null) {
            EventQueue.invokeLater(new Runnable() {
                @Override
                public void run() {
                    tree.setModel(new DefaultTreeModel(root));
                    for (int i = 0; i < tree.getRowCount(); i++) {
                        tree.expandRow(i);
                    }
                    listScrollPane.setVisible(true);
                    titleLabel.setVisible(true);
                    initPanel.setVisible(false);
                }
            });
        } else {
            messageLabel.setText(NbBundle.getMessage(RevertDeletedAction.class, "MSG_NO_FILES")); // NOI18N
        }
    }
    
    TreeNode getRootNode() {
        return (TreeNode) tree.getModel().getRoot();
    }

    boolean open() {
        final DialogDescriptor dd = 
            new DialogDescriptor (
                this, 
                NbBundle.getMessage(RevertDeletedAction.class, "LBL_SELECT_FILES"), // NOI18N
                true, 
                DialogDescriptor.OK_CANCEL_OPTION, 
                DialogDescriptor.OK_OPTION, 
                null); 
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        return dd.getValue() == DialogDescriptor.OK_OPTION;
    }
    
}
