/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.subversion.options;

import org.netbeans.modules.versioning.util.FilePathCellRenderer;

/**
 *
 * @author  Tomas Stupka
 */
public class AnnotationSettingsPanel extends javax.swing.JPanel {
    
    /** Creates new form AnnotationSettingsPanel */
    public AnnotationSettingsPanel() {
        initComponents();
        initModel();
        expresionsTable.setDefaultRenderer(String.class, new FilePathCellRenderer());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        org.openide.awt.Mnemonics.setLocalizedText(resetButton, org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.resetButton.text")); // NOI18N

        tableLabel.setLabelFor(expresionsTable);
        tableLabel.setText(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.tableLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(upButton, org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.upButton.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(downButton, org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.downButton.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(newButton, org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.newButton.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(removeButton, org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.removeButton.text")); // NOI18N

        expressionsPane.setViewportView(expresionsTable);
        expresionsTable.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSN_LablesTable")); // NOI18N
        expresionsTable.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSD_LablesTable")); // NOI18N

        warningLabel.setForeground(new java.awt.Color(255, 0, 0));
        warningLabel.setText(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.warningLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(wizardButton, org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.wizardButton.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(editButton, org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.editButton.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tableLabel)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(resetButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(warningLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 225, Short.MAX_VALUE))
                    .addComponent(expressionsPane, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE))
                .addGap(4, 4, 4)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(removeButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(editButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(newButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(wizardButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(upButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 141, Short.MAX_VALUE)
                    .addComponent(downButton, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(tableLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(newButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(wizardButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(editButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(removeButton)
                        .addGap(18, 18, 18)
                        .addComponent(upButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(downButton))
                    .addComponent(expressionsPane, javax.swing.GroupLayout.DEFAULT_SIZE, 219, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(resetButton)
                    .addComponent(warningLabel))
                .addContainerGap())
        );

        resetButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSN_Reset")); // NOI18N
        resetButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSD_Reset")); // NOI18N
        newButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSN_Add")); // NOI18N
        newButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSD_Add")); // NOI18N
        wizardButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSN_AddWizard")); // NOI18N
        wizardButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "ACSD_AddWizard")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    private void initModel() {
        expresionsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"", ""}
            },
            new String [] {
                org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.expresionsTable.column1.name"),
                org.openide.util.NbBundle.getMessage(AnnotationSettingsPanel.class, "AnnotationSettingsPanel.expresionsTable.column2.name")
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });        
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JButton downButton = new javax.swing.JButton();
    final javax.swing.JButton editButton = new javax.swing.JButton();
    final javax.swing.JTable expresionsTable = new javax.swing.JTable();
    final javax.swing.JScrollPane expressionsPane = new javax.swing.JScrollPane();
    final javax.swing.JButton newButton = new javax.swing.JButton();
    final javax.swing.JButton removeButton = new javax.swing.JButton();
    final javax.swing.JButton resetButton = new javax.swing.JButton();
    final javax.swing.JLabel tableLabel = new javax.swing.JLabel();
    final javax.swing.JButton upButton = new javax.swing.JButton();
    final javax.swing.JLabel warningLabel = new javax.swing.JLabel();
    final javax.swing.JButton wizardButton = new javax.swing.JButton();
    // End of variables declaration//GEN-END:variables
    
}
