#
# @file    TestGetMultipleObjects.py
# @brief   GetMultipleObjects unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestGetMultipleObjects.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestGetMultipleObjects(unittest.TestCase):


  def test_GetMultipleObjects_allElements(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    list = d.getListOfAllElements()
    self.assertTrue( list.getSize() == 37 )
    d = None
    pass  

  def test_GetMultipleObjects_getId(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    obj = d.getElementBySId("no_id")
    self.assertTrue( obj == None )
    obj = d.getElementBySId("")
    self.assertTrue( obj == None )
    obj = d.getElementBySId("find_id")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_MODEL )
    obj = d.getElementBySId("func1")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    obj = d.getElementBySId("comp")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_COMPARTMENT )
    obj = d.getElementBySId("b")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_SPECIES )
    obj = d.getElementBySId("x")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_PARAMETER )
    obj = d.getElementBySId("J0")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_REACTION )
    obj = d.getElementBySId("E0")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_EVENT )
    d = None
    pass  

  def test_GetMultipleObjects_getMetaId(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    obj = d.getElementByMetaId("no_id")
    self.assertTrue( obj == None )
    obj = d.getElementByMetaId("")
    self.assertTrue( obj == None )
    obj = d.getElementByMetaId("meta1")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_DOCUMENT )
    obj = d.getElementByMetaId("meta2")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_MODEL )
    obj = d.getElementByMetaId("meta3")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_COMPARTMENT )
    obj = d.getElementByMetaId("meta4")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_COMPARTMENT )
    obj = d.getElementByMetaId("meta5")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_SPECIES )
    obj = d.getElementByMetaId("meta6")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_SPECIES )
    obj = d.getElementByMetaId("meta7")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_REACTION )
    obj = d.getElementByMetaId("meta8")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_REACTION )
    obj = d.getElementByMetaId("meta9")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta10")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta11")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_KINETIC_LAW )
    obj = d.getElementByMetaId("meta12")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_EVENT )
    obj = d.getElementByMetaId("meta13")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_EVENT )
    obj = d.getElementByMetaId("meta14")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_TRIGGER )
    obj = d.getElementByMetaId("meta15")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_EVENT_ASSIGNMENT )
    obj = d.getElementByMetaId("meta16")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_EVENT_ASSIGNMENT )
    obj = d.getElementByMetaId("meta17")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_DELAY )
    obj = d.getElementByMetaId("meta18")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_PARAMETER )
    obj = d.getElementByMetaId("meta19")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_PRIORITY )
    obj = d.getElementByMetaId("meta20")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    obj = d.getElementByMetaId("meta21")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    obj = d.getElementByMetaId("meta22")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementByMetaId("meta23")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementByMetaId("meta24")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_RULE )
    obj = d.getElementByMetaId("meta25")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_RATE_RULE )
    obj = d.getElementByMetaId("meta26")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_ASSIGNMENT_RULE )
    obj = d.getElementByMetaId("meta27")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_LOCAL_PARAMETER )
    obj = d.getElementByMetaId("meta28")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LOCAL_PARAMETER )
    obj = d.getElementByMetaId("meta29")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_UNIT_DEFINITION )
    obj = d.getElementByMetaId("meta30")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_UNIT_DEFINITION )
    obj = d.getElementByMetaId("meta31")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_UNIT )
    obj = d.getElementByMetaId("meta32")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_UNIT )
    obj = d.getElementByMetaId("meta33")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_PARAMETER )
    obj = d.getElementByMetaId("meta34")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assertTrue( obj.getItemTypeCode() == libsbml.SBML_MODIFIER_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta35")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_MODIFIER_SPECIES_REFERENCE )
    d = None
    pass  

  def test_GetMultipleObjects_noAssignments(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "assignments-invalid.xml"
    d = reader.readSBML(filename)
    if (d.getModel() == None):
      pass    
    obj = d.getElementBySId("ia")
    self.assertTrue( obj == None )
    obj = d.getElementByMetaId("ia_meta")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementBySId("ar")
    self.assertTrue( obj == None )
    obj = d.getElementByMetaId("ar_meta")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_ASSIGNMENT_RULE )
    obj = d.getElementBySId("rr")
    self.assertTrue( obj == None )
    obj = d.getElementByMetaId("rr_meta")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_RATE_RULE )
    obj = d.getElementBySId("ea")
    self.assertTrue( obj == None )
    obj = d.getElementByMetaId("ea_meta")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_EVENT_ASSIGNMENT )
    d = None
    pass  

  def test_GetMultipleObjects_noLocalParameters(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    rxn = d.getElementBySId("J0")
    self.assertTrue( rxn != None )
    obj = rxn.getElementBySId("x")
    self.assertTrue( obj == None )
    obj = rxn.getElementByMetaId("meta28")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_LOCAL_PARAMETER )
    d = None
    pass  

  def test_GetMultipleObjects_noUnits(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    obj = d.getElementBySId("volume")
    self.assertTrue( obj == None )
    obj = d.getElementByMetaId("meta30")
    self.assertTrue( obj != None )
    self.assertTrue( obj.getTypeCode() == libsbml.SBML_UNIT_DEFINITION )
    d = None
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestGetMultipleObjects))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
