/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking;

/** Constants used by the DockingDesktop to position Dockables.
 * <p>
 * API Users will use these constants to interact with the DockingDesktop.
 * <p>
 * These constants are defined as enumerations of Hide and Split classes, in order
 * to avoid runtime errors.
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 */
public class  DockingConstants {

  public static final int INT_SPLIT_TOP = 0;
  public static final int INT_SPLIT_LEFT = 1;
  public static final int INT_SPLIT_BOTTOM = 2;
  public static final int INT_SPLIT_RIGHT = 3;

  /** A constant describing a VERTICAL splitting operation where the new component
   * goes on the TOP part */
  public static final Split SPLIT_TOP = new Split(INT_SPLIT_TOP);

  /** A constant describing an HORIZONTAL splitting operation where the new component
   * goes on the LEFT part */
  public static final Split SPLIT_LEFT = new Split(INT_SPLIT_LEFT);

  /** A constant describing a VERTICAL splitting operation where the new component
   * goes on the BOTTOM part */
  public static final Split SPLIT_BOTTOM = new Split(INT_SPLIT_BOTTOM);

  /** A constant describing an HORIZONTAL splitting operation where the new component
   * goes on the RIGHT part */
  public static final Split SPLIT_RIGHT = new Split(INT_SPLIT_RIGHT);

  public static final int INT_HIDE_TOP = 0;
  public static final int INT_HIDE_LEFT = 1;
  public static final int INT_HIDE_BOTTOM = 2;
  public static final int INT_HIDE_RIGHT = 3;

  /** A constant describing an auto-hide operation where the component
   * goes on the TOP border */
  public static final Hide HIDE_TOP = new Hide(INT_HIDE_TOP);

  /** A constant describing an auto-hide operation where the component
   * goes on the LEFT border */
  public static final Hide HIDE_LEFT = new Hide(INT_HIDE_LEFT);
  /** A constant describing an auto-hide operation where the component
   * goes on the BOTTOM border */
  public static final Hide HIDE_BOTTOM = new Hide(INT_HIDE_BOTTOM);
  /** A constant describing an auto-hide operation where the component
   * goes on the RIGHT border */
  public static final Hide HIDE_RIGHT = new Hide(INT_HIDE_RIGHT);


  /** Typesafe enumeration describing a split operation on the DockingDesktop.*/
 public static class Split {
   private int value;
   private Split(int value){
     this.value = value;
   }
   public int value(){
     return value;
   }
 }

 /** Typesafe enumeration describing an auto-hide  operation on the DockingDesktop.*/
 public static class Hide {
   private int value;
   private Hide(int value){
     this.value = value;
   }
   public int value(){
     return value;
   }
 }


}
