/*******************************************************************************
* Copyright 2019-2020 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "cpu/x64/jit_generator.hpp"

#include "cpu/x64/gemm/f32/common_f32.hpp"

namespace dnnl {
namespace impl {
namespace cpu {
namespace x64 {

jit_avx512_core_f32_copy_an_kern::jit_avx512_core_f32_copy_an_kern()
    : jit_generator(nullptr, F32_COPY_KERNEL_CODE_SIZE) {}

void jit_avx512_core_f32_copy_an_kern::generate() {

#ifndef _WIN32
#define M rdi
#define N rsi
#define A rdx
#define LDA rcx
#define ALPHA r8
#define B r9

#define I rax
#define A1 r10
#define A2 r8
#define LDA3 r11

#else
#define M rcx
#define N rdx
#define A r8
#define LDA r9
#define ALPHA rsi
#define B rdi
#define I rax
#define A1 rsi
#define A2 r10
#define LDA3 r11

#define ARG_ALPHA 40 + stacksize + rsp
#define ARG_B 48 + stacksize + rsp

#endif

    inLocalLabel();
    {

        Xbyak::Label l115c;
        Xbyak::Label l121c;
        Xbyak::Label l1284;
        Xbyak::Label l12bc;
        Xbyak::Label l12c0;
        Xbyak::Label l12e4;
        Xbyak::Label l13a4;
        Xbyak::Label l140c;
        Xbyak::Label l1448;
        Xbyak::Label l146c;
        Xbyak::Label l1470;
        Xbyak::Label l1494;
        Xbyak::Label l1534;
        Xbyak::Label l1588;
        Xbyak::Label l15bc;
        Xbyak::Label l15dc;
        Xbyak::Label l15e0;
        Xbyak::Label l1604;
        Xbyak::Label l16a0;
        Xbyak::Label l16f4;
        Xbyak::Label l1728;
        Xbyak::Label l1748;
        Xbyak::Label l174c;
        Xbyak::Label l1770;
        Xbyak::Label l180c;
        Xbyak::Label l1860;
        Xbyak::Label l1894;
        Xbyak::Label l18b4;
        Xbyak::Label l18b8;
        Xbyak::Label l18dc;
        Xbyak::Label l1978;
        Xbyak::Label l19cc;
        Xbyak::Label l1a00;
        Xbyak::Label l1a20;
        Xbyak::Label l1a24;
        Xbyak::Label l1a2c;
        Xbyak::Label l1a38;
        Xbyak::Label l1a54;
        Xbyak::Label l1c58;
        Xbyak::Label l1d64;
        Xbyak::Label l1df4;
        Xbyak::Label l1e40;
        Xbyak::Label l1e50;
        Xbyak::Label l1e78;
        Xbyak::Label l1e8;
        Xbyak::Label l1fdc;
        Xbyak::Label l209c;
        Xbyak::Label l2104;
        Xbyak::Label l213c;
        Xbyak::Label l2140;
        Xbyak::Label l2164;
        Xbyak::Label l2224;
        Xbyak::Label l228c;
        Xbyak::Label l22c8;
        Xbyak::Label l22ec;
        Xbyak::Label l22f0;
        Xbyak::Label l2314;
        Xbyak::Label l23b4;
        Xbyak::Label l2408;
        Xbyak::Label l243c;
        Xbyak::Label l245c;
        Xbyak::Label l2460;
        Xbyak::Label l2484;
        Xbyak::Label l2520;
        Xbyak::Label l2574;
        Xbyak::Label l25a8;
        Xbyak::Label l25c8;
        Xbyak::Label l25cc;
        Xbyak::Label l25f0;
        Xbyak::Label l268c;
        Xbyak::Label l26e0;
        Xbyak::Label l2714;
        Xbyak::Label l2734;
        Xbyak::Label l2738;
        Xbyak::Label l275c;
        Xbyak::Label l27f8;
        Xbyak::Label l284c;
        Xbyak::Label l2880;
        Xbyak::Label l28a0;
        Xbyak::Label l28a4;
        Xbyak::Label l2ac;
        Xbyak::Label l314;
        Xbyak::Label l34c;
        Xbyak::Label l35c;
        Xbyak::Label l384;
        Xbyak::Label l488;
        Xbyak::Label l518;
        Xbyak::Label l568;
        Xbyak::Label l58;
        Xbyak::Label l594;
        Xbyak::Label l598;
        Xbyak::Label l5bc;
        Xbyak::Label l64c;
        Xbyak::Label l69c;
        Xbyak::Label l6cc;
        Xbyak::Label l6e8;
        Xbyak::Label l6ec;
        Xbyak::Label l70c;
        Xbyak::Label l74;
        Xbyak::Label l788;
        Xbyak::Label l7cc;
        Xbyak::Label l7f8;
        Xbyak::Label l814;
        Xbyak::Label l818;
        Xbyak::Label l838;
        Xbyak::Label l8b0;
        Xbyak::Label l8f4;
        Xbyak::Label l920;
        Xbyak::Label l93c;
        Xbyak::Label l940;
        Xbyak::Label l960;
        Xbyak::Label l9d8;
        Xbyak::Label la1c;
        Xbyak::Label la48;
        Xbyak::Label la64;
        Xbyak::Label la68;
        Xbyak::Label la88;
        Xbyak::Label lb00;
        Xbyak::Label lb44;
        Xbyak::Label lb70;
        Xbyak::Label lb8c;
        Xbyak::Label lb90;
        Xbyak::Label lb98;
        Xbyak::Label lbb8;
        Xbyak::Label lbd4;
        Xbyak::Label ldd8;
        Xbyak::Label lee4;
        Xbyak::Label lf74;
        Xbyak::Label lfc0;
        Xbyak::Label lfd0;
        Xbyak::Label lff8;

        preamble();
#ifdef _WIN32
        auto stacksize = get_size_of_abi_save_regs();
        mov(ALPHA, ptr[ARG_ALPHA]);
        mov(B, ptr[ARG_B]);
#endif

        mov(M, qword[M]);
        mov(N, qword[N]);
        mov(LDA, qword[LDA]);
        sub(A, -128);
        sub(B, -128);
        shl(LDA, 0x2);
        lea(LDA3, ptr[LDA + LDA * 2]);
        vbroadcastss(zmm6, dword[ALPHA]);
        vpcmpeqb(xmm3, xmm3, xmm3);
        vpsrld(xmm3, xmm3, 0x17);
        vpslld(xmm3, xmm3, 0x19);
        vpsrld(xmm3, xmm3, 0x2);
        vpcmpeqb(xmm4, xmm4, xmm4);
        vpslld(xmm4, xmm4, 0x1f);
        vbroadcastss(zmm4, xmm4);
        vucomiss(xmm6, xmm3);
        jne(lb98, T_NEAR);
        cmp(N, 0x30);
        jl(l35c, T_NEAR);
        align(4);

        L(l58);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0xc0);
        mov(I, M);
        sar(I, 0x3);
        jle(l1e8, T_NEAR);
        align(4);

        L(l74);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2]);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1]);
        vmovups(zword[B + 0x240], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vmovups(zword[B + 0x280], zmm0);
        vmovups(zmm0, zword[A2 - 0x40]);
        vmovups(zword[B + 0x2c0], zmm0);
        vmovups(zmm0, zword[A2]);
        vmovups(zword[B + 0x300], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vmovups(zword[B + 0x340], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x380], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1]);
        vmovups(zword[B + 0x3c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vmovups(zword[B + 0x400], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x40]);
        vmovups(zword[B + 0x440], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2]);
        vmovups(zword[B + 0x480], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x4c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x40]);
        vmovups(zword[B + 0x500], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1]);
        vmovups(zword[B + 0x540], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -1536);
        dec(I);
        jg(l74, T_NEAR);
        align(4);

        L(l1e8);
        test(M, 0x4);
        jle(l2ac, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2]);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1]);
        vmovups(zword[B + 0x240], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -768);
        align(4);

        L(l2ac);
        test(M, 0x2);
        jle(l314, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vmovups(zword[B + 0xc0], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -384);
        align(4);

        L(l314);
        test(M, 0x1);
        jle(l34c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmovups(zword[B], zmm0);
        sub(B, -192);
        align(4);

        L(l34c);
        sub(N, 0x30);
        cmp(N, 0x30);
        jge(l58, T_NEAR);
        align(4);

        L(l35c);
        cmp(N, 0x20);
        jl(l598, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x80);
        mov(I, M);
        sar(I, 0x3);
        jle(l488, T_NEAR);
        align(4);

        L(l384);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A2 - 0x40]);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x240], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vmovups(zword[B + 0x280], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x40]);
        vmovups(zword[B + 0x2c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x300], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x40]);
        vmovups(zword[B + 0x340], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -1024);
        dec(I);
        jg(l384, T_NEAR);
        align(4);

        L(l488);
        test(M, 0x4);
        jle(l518, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmovups(zword[B + 0x140], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -512);
        align(4);

        L(l518);
        test(M, 0x2);
        jle(l568, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmovups(zword[B + 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -256);
        align(4);

        L(l568);
        test(M, 0x1);
        jle(l594, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmovups(zword[B - 0x40], zmm0);
        sub(B, -128);
        align(4);

        L(l594);
        sub(N, 0x20);
        align(4);

        L(l598);
        cmp(N, 0x10);
        jl(l6ec, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x40);
        mov(I, M);
        sar(I, 0x3);
        jle(l64c, T_NEAR);
        align(4);

        L(l5bc);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x140], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -512);
        dec(I);
        jg(l5bc, T_NEAR);
        align(4);

        L(l64c);
        test(M, 0x4);
        jle(l69c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmovups(zword[B + 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -256);
        align(4);

        L(l69c);
        test(M, 0x2);
        jle(l6cc, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmovups(zword[B - 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -128);
        align(4);

        L(l6cc);
        test(M, 0x1);
        jle(l6e8, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmovups(zword[B - 0x80], zmm0);
        sub(B, -64);
        align(4);

        L(l6e8);
        sub(N, 0x10);
        align(4);

        L(l6ec);
        cmp(N, 0x8);
        jl(l818, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x20);
        mov(I, M);
        sar(I, 0x3);
        jle(l788, T_NEAR);
        align(4);

        L(l70c);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vmovups(yword[B - 0x60], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 2 - 0x80]);
        vmovups(yword[B - 0x40], ymm0);
        vmovups(ymm0, yword[A1 + LDA3 * 1 - 0x80]);
        vmovups(yword[B - 0x20], ymm0);
        vmovups(ymm0, yword[A2 - 0x80]);
        vmovups(yword[B], ymm0);
        vmovups(ymm0, yword[A2 + LDA * 1 - 0x80]);
        vmovups(yword[B + 0x20], ymm0);
        vmovups(ymm0, yword[A2 + LDA * 2 - 0x80]);
        vmovups(yword[B + 0x40], ymm0);
        vmovups(ymm0, yword[A2 + LDA3 * 1 - 0x80]);
        vmovups(yword[B + 0x60], ymm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -256);
        dec(I);
        jg(l70c, T_NEAR);
        align(4);

        L(l788);
        test(M, 0x4);
        jle(l7cc, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vmovups(yword[B - 0x60], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 2 - 0x80]);
        vmovups(yword[B - 0x40], ymm0);
        vmovups(ymm0, yword[A1 + LDA3 * 1 - 0x80]);
        vmovups(yword[B - 0x20], ymm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -128);
        align(4);

        L(l7cc);
        test(M, 0x2);
        jle(l7f8, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vmovups(yword[B - 0x60], ymm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -64);
        align(4);

        L(l7f8);
        test(M, 0x1);
        jle(l814, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmovups(yword[B - 0x80], ymm0);
        sub(B, -32);
        align(4);

        L(l814);
        sub(N, 0x8);
        align(4);

        L(l818);
        cmp(N, 0x4);
        jl(l940, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x10);
        mov(I, M);
        sar(I, 0x3);
        jle(l8b0, T_NEAR);
        align(4);

        L(l838);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vmovups(xword[B - 0x70], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 2 - 0x80]);
        vmovups(xword[B - 0x60], xmm0);
        vmovups(xmm0, xword[A1 + LDA3 * 1 - 0x80]);
        vmovups(xword[B - 0x50], xmm0);
        vmovups(xmm0, xword[A2 - 0x80]);
        vmovups(xword[B - 0x40], xmm0);
        vmovups(xmm0, xword[A2 + LDA * 1 - 0x80]);
        vmovups(xword[B - 0x30], xmm0);
        vmovups(xmm0, xword[A2 + LDA * 2 - 0x80]);
        vmovups(xword[B - 0x20], xmm0);
        vmovups(xmm0, xword[A2 + LDA3 * 1 - 0x80]);
        vmovups(xword[B - 0x10], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -128);
        dec(I);
        jg(l838, T_NEAR);
        align(4);

        L(l8b0);
        test(M, 0x4);
        jle(l8f4, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vmovups(xword[B - 0x70], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 2 - 0x80]);
        vmovups(xword[B - 0x60], xmm0);
        vmovups(xmm0, xword[A1 + LDA3 * 1 - 0x80]);
        vmovups(xword[B - 0x50], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -64);
        align(4);

        L(l8f4);
        test(M, 0x2);
        jle(l920, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vmovups(xword[B - 0x70], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -32);
        align(4);

        L(l920);
        test(M, 0x1);
        jle(l93c, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmovups(xword[B - 0x80], xmm0);
        sub(B, -16);
        align(4);

        L(l93c);
        sub(N, 0x4);
        align(4);

        L(l940);
        cmp(N, 0x2);
        jl(la68, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x8);
        mov(I, M);
        sar(I, 0x3);
        jle(l9d8, T_NEAR);
        align(4);

        L(l960);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vmovlps(qword[B - 0x78], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 2 - 0x80]);
        vmovlps(qword[B - 0x70], xmm0);
        vmovsd(xmm0, qword[A1 + LDA3 * 1 - 0x80]);
        vmovlps(qword[B - 0x68], xmm0);
        vmovsd(xmm0, qword[A2 - 0x80]);
        vmovlps(qword[B - 0x60], xmm0);
        vmovsd(xmm0, qword[A2 + LDA * 1 - 0x80]);
        vmovlps(qword[B - 0x58], xmm0);
        vmovsd(xmm0, qword[A2 + LDA * 2 - 0x80]);
        vmovlps(qword[B - 0x50], xmm0);
        vmovsd(xmm0, qword[A2 + LDA3 * 1 - 0x80]);
        vmovlps(qword[B - 0x48], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -64);
        dec(I);
        jg(l960, T_NEAR);
        align(4);

        L(l9d8);
        test(M, 0x4);
        jle(la1c, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vmovlps(qword[B - 0x78], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 2 - 0x80]);
        vmovlps(qword[B - 0x70], xmm0);
        vmovsd(xmm0, qword[A1 + LDA3 * 1 - 0x80]);
        vmovlps(qword[B - 0x68], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -32);
        align(4);

        L(la1c);
        test(M, 0x2);
        jle(la48, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vmovlps(qword[B - 0x78], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -16);
        align(4);

        L(la48);
        test(M, 0x1);
        jle(la64, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmovlps(qword[B - 0x80], xmm0);
        sub(B, -8);
        align(4);

        L(la64);
        sub(N, 0x2);
        align(4);

        L(la68);
        cmp(N, 0x1);
        jl(lb90, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x4);
        mov(I, M);
        sar(I, 0x3);
        jle(lb00, T_NEAR);
        align(4);

        L(la88);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vmovss(dword[B - 0x7c], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 2 - 0x80]);
        vmovss(dword[B - 0x78], xmm0);
        vmovss(xmm0, dword[A1 + LDA3 * 1 - 0x80]);
        vmovss(dword[B - 0x74], xmm0);
        vmovss(xmm0, dword[A2 - 0x80]);
        vmovss(dword[B - 0x70], xmm0);
        vmovss(xmm0, dword[A2 + LDA * 1 - 0x80]);
        vmovss(dword[B - 0x6c], xmm0);
        vmovss(xmm0, dword[A2 + LDA * 2 - 0x80]);
        vmovss(dword[B - 0x68], xmm0);
        vmovss(xmm0, dword[A2 + LDA3 * 1 - 0x80]);
        vmovss(dword[B - 0x64], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -32);
        dec(I);
        jg(la88, T_NEAR);
        align(4);

        L(lb00);
        test(M, 0x4);
        jle(lb44, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vmovss(dword[B - 0x7c], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 2 - 0x80]);
        vmovss(dword[B - 0x78], xmm0);
        vmovss(xmm0, dword[A1 + LDA3 * 1 - 0x80]);
        vmovss(dword[B - 0x74], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -16);
        align(4);

        L(lb44);
        test(M, 0x2);
        jle(lb70, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vmovss(dword[B - 0x7c], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -8);
        align(4);

        L(lb70);
        test(M, 0x1);
        jle(lb8c, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmovss(dword[B - 0x80], xmm0);
        sub(B, -4);
        align(4);

        L(lb8c);
        sub(N, 0x1);
        align(4);

        L(lb90);
        jmp(l28a4, T_NEAR);
        align(4);

        L(lb98);
        vxorps(xmm3, xmm3, xmm4);
        vucomiss(xmm6, xmm3);
        jne(l1a2c, T_NEAR);
        vmovaps(zmm6, zmm4);
        cmp(N, 0x30);
        jl(lfd0, T_NEAR);
        align(4);

        L(lbb8);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0xc0);
        mov(I, M);
        sar(I, 0x3);
        jle(ldd8, T_NEAR);
        align(4);

        L(lbd4);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x240], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x280], zmm0);
        vmovups(zmm0, zword[A2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x2c0], zmm0);
        vmovups(zmm0, zword[A2]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x300], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x340], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x380], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x3c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x400], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x440], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x480], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x4c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x500], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x540], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -1536);
        dec(I);
        jg(lbd4, T_NEAR);
        align(4);

        L(ldd8);
        test(M, 0x4);
        jle(lee4, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x240], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -768);
        align(4);

        L(lee4);
        test(M, 0x2);
        jle(lf74, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -384);
        align(4);

        L(lf74);
        test(M, 0x1);
        jle(lfc0, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        sub(B, -192);
        align(4);

        L(lfc0);
        sub(N, 0x30);
        cmp(N, 0x30);
        jge(lbb8, T_NEAR);
        align(4);

        L(lfd0);
        cmp(N, 0x20);
        jl(l12c0, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x80);
        mov(I, M);
        sar(I, 0x3);
        jle(l115c, T_NEAR);
        align(4);

        L(lff8);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x240], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x280], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x2c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x300], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x340], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -1024);
        dec(I);
        jg(lff8, T_NEAR);
        align(4);

        L(l115c);
        test(M, 0x4);
        jle(l121c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -512);
        align(4);

        L(l121c);
        test(M, 0x2);
        jle(l1284, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -256);
        align(4);

        L(l1284);
        test(M, 0x1);
        jle(l12bc, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        sub(B, -128);
        align(4);

        L(l12bc);
        sub(N, 0x20);
        align(4);

        L(l12c0);
        cmp(N, 0x10);
        jl(l1470, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x40);
        mov(I, M);
        sar(I, 0x3);
        jle(l13a4, T_NEAR);
        align(4);

        L(l12e4);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -512);
        dec(I);
        jg(l12e4, T_NEAR);
        align(4);

        L(l13a4);
        test(M, 0x4);
        jle(l140c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -256);
        align(4);

        L(l140c);
        test(M, 0x2);
        jle(l1448, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -128);
        align(4);

        L(l1448);
        test(M, 0x1);
        jle(l146c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vpxorq(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        sub(B, -64);
        align(4);

        L(l146c);
        sub(N, 0x10);
        align(4);

        L(l1470);
        cmp(N, 0x8);
        jl(l15e0, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x20);
        mov(I, M);
        sar(I, 0x3);
        jle(l1534, T_NEAR);
        align(4);

        L(l1494);
        vmovups(ymm0, yword[A1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x60], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 2 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x40], ymm0);
        vmovups(ymm0, yword[A1 + LDA3 * 1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x20], ymm0);
        vmovups(ymm0, yword[A2 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B], ymm0);
        vmovups(ymm0, yword[A2 + LDA * 1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B + 0x20], ymm0);
        vmovups(ymm0, yword[A2 + LDA * 2 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B + 0x40], ymm0);
        vmovups(ymm0, yword[A2 + LDA3 * 1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B + 0x60], ymm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -256);
        dec(I);
        jg(l1494, T_NEAR);
        align(4);

        L(l1534);
        test(M, 0x4);
        jle(l1588, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x60], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 2 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x40], ymm0);
        vmovups(ymm0, yword[A1 + LDA3 * 1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x20], ymm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -128);
        align(4);

        L(l1588);
        test(M, 0x2);
        jle(l15bc, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x60], ymm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -64);
        align(4);

        L(l15bc);
        test(M, 0x1);
        jle(l15dc, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vxorps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        sub(B, -32);
        align(4);

        L(l15dc);
        sub(N, 0x8);
        align(4);

        L(l15e0);
        cmp(N, 0x4);
        jl(l174c, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x10);
        mov(I, M);
        sar(I, 0x3);
        jle(l16a0, T_NEAR);
        align(4);

        L(l1604);
        vmovups(xmm0, xword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x70], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x60], xmm0);
        vmovups(xmm0, xword[A1 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x50], xmm0);
        vmovups(xmm0, xword[A2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x40], xmm0);
        vmovups(xmm0, xword[A2 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x30], xmm0);
        vmovups(xmm0, xword[A2 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x20], xmm0);
        vmovups(xmm0, xword[A2 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x10], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -128);
        dec(I);
        jg(l1604, T_NEAR);
        align(4);

        L(l16a0);
        test(M, 0x4);
        jle(l16f4, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x70], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x60], xmm0);
        vmovups(xmm0, xword[A1 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x50], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -64);
        align(4);

        L(l16f4);
        test(M, 0x2);
        jle(l1728, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x70], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -32);
        align(4);

        L(l1728);
        test(M, 0x1);
        jle(l1748, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        sub(B, -16);
        align(4);

        L(l1748);
        sub(N, 0x4);
        align(4);

        L(l174c);
        cmp(N, 0x2);
        jl(l18b8, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x8);
        mov(I, M);
        sar(I, 0x3);
        jle(l180c, T_NEAR);
        align(4);

        L(l1770);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x78], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x70], xmm0);
        vmovsd(xmm0, qword[A1 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x68], xmm0);
        vmovsd(xmm0, qword[A2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x60], xmm0);
        vmovsd(xmm0, qword[A2 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x58], xmm0);
        vmovsd(xmm0, qword[A2 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x50], xmm0);
        vmovsd(xmm0, qword[A2 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x48], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -64);
        dec(I);
        jg(l1770, T_NEAR);
        align(4);

        L(l180c);
        test(M, 0x4);
        jle(l1860, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x78], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x70], xmm0);
        vmovsd(xmm0, qword[A1 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x68], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -32);
        align(4);

        L(l1860);
        test(M, 0x2);
        jle(l1894, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x78], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -16);
        align(4);

        L(l1894);
        test(M, 0x1);
        jle(l18b4, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        sub(B, -8);
        align(4);

        L(l18b4);
        sub(N, 0x2);
        align(4);

        L(l18b8);
        cmp(N, 0x1);
        jl(l1a24, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x4);
        mov(I, M);
        sar(I, 0x3);
        jle(l1978, T_NEAR);
        align(4);

        L(l18dc);
        vmovss(xmm0, dword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x7c], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x78], xmm0);
        vmovss(xmm0, dword[A1 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x74], xmm0);
        vmovss(xmm0, dword[A2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x70], xmm0);
        vmovss(xmm0, dword[A2 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x6c], xmm0);
        vmovss(xmm0, dword[A2 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x68], xmm0);
        vmovss(xmm0, dword[A2 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x64], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -32);
        dec(I);
        jg(l18dc, T_NEAR);
        align(4);

        L(l1978);
        test(M, 0x4);
        jle(l19cc, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x7c], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 2 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x78], xmm0);
        vmovss(xmm0, dword[A1 + LDA3 * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x74], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -16);
        align(4);

        L(l19cc);
        test(M, 0x2);
        jle(l1a00, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x7c], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -8);
        align(4);

        L(l1a00);
        test(M, 0x1);
        jle(l1a20, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vxorps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        sub(B, -4);
        align(4);

        L(l1a20);
        sub(N, 0x1);
        align(4);

        L(l1a24);
        jmp(l28a4, T_NEAR);
        align(4);

        L(l1a2c);
        cmp(N, 0x30);
        jl(l1e50, T_NEAR);
        align(4);

        L(l1a38);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0xc0);
        mov(I, M);
        sar(I, 0x3);
        jle(l1c58, T_NEAR);
        align(4);

        L(l1a54);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x240], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x280], zmm0);
        vmovups(zmm0, zword[A2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x2c0], zmm0);
        vmovups(zmm0, zword[A2]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x300], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x340], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x380], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x3c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x400], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x440], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x480], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x4c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x500], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x540], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -1536);
        dec(I);
        jg(l1a54, T_NEAR);
        align(4);

        L(l1c58);
        test(M, 0x4);
        jle(l1d64, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x240], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -768);
        align(4);

        L(l1d64);
        test(M, 0x2);
        jle(l1df4, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -384);
        align(4);

        L(l1df4);
        test(M, 0x1);
        jle(l1e40, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        sub(B, -192);
        align(4);

        L(l1e40);
        sub(N, 0x30);
        cmp(N, 0x30);
        jge(l1a38, T_NEAR);
        align(4);

        L(l1e50);
        cmp(N, 0x20);
        jl(l2140, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x80);
        mov(I, M);
        sar(I, 0x3);
        jle(l1fdc, T_NEAR);
        align(4);

        L(l1e78);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x180], zmm0);
        vmovups(zmm0, zword[A2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x1c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x200], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x240], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x280], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x2c0], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x300], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x340], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -1024);
        dec(I);
        jg(l1e78, T_NEAR);
        align(4);

        L(l1fdc);
        test(M, 0x4);
        jle(l209c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -512);
        align(4);

        L(l209c);
        test(M, 0x2);
        jle(l2104, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -256);
        align(4);

        L(l2104);
        test(M, 0x1);
        jle(l213c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 - 0x40]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        sub(B, -128);
        align(4);

        L(l213c);
        sub(N, 0x20);
        align(4);

        L(l2140);
        cmp(N, 0x10);
        jl(l22f0, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x40);
        mov(I, M);
        sar(I, 0x3);
        jle(l2224, T_NEAR);
        align(4);

        L(l2164);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        vmovups(zmm0, zword[A2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x80], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0xc0], zmm0);
        vmovups(zmm0, zword[A2 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x100], zmm0);
        vmovups(zmm0, zword[A2 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x140], zmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -512);
        dec(I);
        jg(l2164, T_NEAR);
        align(4);

        L(l2224);
        test(M, 0x4);
        jle(l228c, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 2 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B], zmm0);
        vmovups(zmm0, zword[A1 + LDA3 * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B + 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -256);
        align(4);

        L(l228c);
        test(M, 0x2);
        jle(l22c8, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        vmovups(zmm0, zword[A1 + LDA * 1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x40], zmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -128);
        align(4);

        L(l22c8);
        test(M, 0x1);
        jle(l22ec, T_NEAR);
        vmovups(zmm0, zword[A1 - 0x80]);
        vmulps(zmm0, zmm6, zmm0);
        vmovups(zword[B - 0x80], zmm0);
        sub(B, -64);
        align(4);

        L(l22ec);
        sub(N, 0x10);
        align(4);

        L(l22f0);
        cmp(N, 0x8);
        jl(l2460, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x20);
        mov(I, M);
        sar(I, 0x3);
        jle(l23b4, T_NEAR);
        align(4);

        L(l2314);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x60], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 2 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x40], ymm0);
        vmovups(ymm0, yword[A1 + LDA3 * 1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x20], ymm0);
        vmovups(ymm0, yword[A2 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B], ymm0);
        vmovups(ymm0, yword[A2 + LDA * 1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B + 0x20], ymm0);
        vmovups(ymm0, yword[A2 + LDA * 2 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B + 0x40], ymm0);
        vmovups(ymm0, yword[A2 + LDA3 * 1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B + 0x60], ymm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -256);
        dec(I);
        jg(l2314, T_NEAR);
        align(4);

        L(l23b4);
        test(M, 0x4);
        jle(l2408, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x60], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 2 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x40], ymm0);
        vmovups(ymm0, yword[A1 + LDA3 * 1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x20], ymm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -128);
        align(4);

        L(l2408);
        test(M, 0x2);
        jle(l243c, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        vmovups(ymm0, yword[A1 + LDA * 1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x60], ymm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -64);
        align(4);

        L(l243c);
        test(M, 0x1);
        jle(l245c, T_NEAR);
        vmovups(ymm0, yword[A1 - 0x80]);
        vmulps(ymm0, ymm6, ymm0);
        vmovups(yword[B - 0x80], ymm0);
        sub(B, -32);
        align(4);

        L(l245c);
        sub(N, 0x8);
        align(4);

        L(l2460);
        cmp(N, 0x4);
        jl(l25cc, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x10);
        mov(I, M);
        sar(I, 0x3);
        jle(l2520, T_NEAR);
        align(4);

        L(l2484);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x70], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x60], xmm0);
        vmovups(xmm0, xword[A1 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x50], xmm0);
        vmovups(xmm0, xword[A2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x40], xmm0);
        vmovups(xmm0, xword[A2 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x30], xmm0);
        vmovups(xmm0, xword[A2 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x20], xmm0);
        vmovups(xmm0, xword[A2 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x10], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -128);
        dec(I);
        jg(l2484, T_NEAR);
        align(4);

        L(l2520);
        test(M, 0x4);
        jle(l2574, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x70], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x60], xmm0);
        vmovups(xmm0, xword[A1 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x50], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -64);
        align(4);

        L(l2574);
        test(M, 0x2);
        jle(l25a8, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        vmovups(xmm0, xword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x70], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -32);
        align(4);

        L(l25a8);
        test(M, 0x1);
        jle(l25c8, T_NEAR);
        vmovups(xmm0, xword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovups(xword[B - 0x80], xmm0);
        sub(B, -16);
        align(4);

        L(l25c8);
        sub(N, 0x4);
        align(4);

        L(l25cc);
        cmp(N, 0x2);
        jl(l2738, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x8);
        mov(I, M);
        sar(I, 0x3);
        jle(l268c, T_NEAR);
        align(4);

        L(l25f0);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x78], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x70], xmm0);
        vmovsd(xmm0, qword[A1 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x68], xmm0);
        vmovsd(xmm0, qword[A2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x60], xmm0);
        vmovsd(xmm0, qword[A2 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x58], xmm0);
        vmovsd(xmm0, qword[A2 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x50], xmm0);
        vmovsd(xmm0, qword[A2 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x48], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -64);
        dec(I);
        jg(l25f0, T_NEAR);
        align(4);

        L(l268c);
        test(M, 0x4);
        jle(l26e0, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x78], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x70], xmm0);
        vmovsd(xmm0, qword[A1 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x68], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -32);
        align(4);

        L(l26e0);
        test(M, 0x2);
        jle(l2714, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        vmovsd(xmm0, qword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x78], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -16);
        align(4);

        L(l2714);
        test(M, 0x1);
        jle(l2734, T_NEAR);
        vmovsd(xmm0, qword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovlps(qword[B - 0x80], xmm0);
        sub(B, -8);
        align(4);

        L(l2734);
        sub(N, 0x2);
        align(4);

        L(l2738);
        cmp(N, 0x1);
        jl(l28a4, T_NEAR);
        mov(A1, A);
        lea(A2, ptr[A1 + LDA * 4]);
        add(A, 0x4);
        mov(I, M);
        sar(I, 0x3);
        jle(l27f8, T_NEAR);
        align(4);

        L(l275c);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x7c], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x78], xmm0);
        vmovss(xmm0, dword[A1 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x74], xmm0);
        vmovss(xmm0, dword[A2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x70], xmm0);
        vmovss(xmm0, dword[A2 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x6c], xmm0);
        vmovss(xmm0, dword[A2 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x68], xmm0);
        vmovss(xmm0, dword[A2 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x64], xmm0);
        lea(A1, ptr[A1 + LDA * 8]);
        lea(A2, ptr[A2 + LDA * 8]);
        sub(B, -32);
        dec(I);
        jg(l275c, T_NEAR);
        align(4);

        L(l27f8);
        test(M, 0x4);
        jle(l284c, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x7c], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 2 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x78], xmm0);
        vmovss(xmm0, dword[A1 + LDA3 * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x74], xmm0);
        lea(A1, ptr[A1 + LDA * 4]);
        sub(B, -16);
        align(4);

        L(l284c);
        test(M, 0x2);
        jle(l2880, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        vmovss(xmm0, dword[A1 + LDA * 1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x7c], xmm0);
        lea(A1, ptr[A1 + LDA * 2]);
        sub(B, -8);
        align(4);

        L(l2880);
        test(M, 0x1);
        jle(l28a0, T_NEAR);
        vmovss(xmm0, dword[A1 - 0x80]);
        vmulps(xmm0, xmm6, xmm0);
        vmovss(dword[B - 0x80], xmm0);
        sub(B, -4);
        align(4);

        L(l28a0);
        sub(N, 0x1);
        align(4);

        L(l28a4);

        postamble();
    }
    outLocalLabel();

#undef M
#undef N
#undef A
#undef LDA
#undef ALPHA
#undef B
#undef I
#undef A1
#undef A2
#undef LDA3
#ifdef _WIN32
#undef ARG_ALPHA
#undef ARG_B
#endif
}

} // namespace x64
} // namespace cpu
} // namespace impl
} // namespace dnnl
