/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "PowerSupply_Common.h"

int SMBIOS_getPowerSupplyInformation(vector<system_power_supply>& power,vector< vector<string> >& dmi_strings,string& errorMessage)
{
	vector<void*> _power;
	void *start_ptr;
	char *tableAddress;
	_smbios_entry_point *anchor;
	
	if((start_ptr=SMBIOS_getRawData(_SMBIOS_ANCHOR_SEARCH_OFFSET,_SMBIOS_ANCHOR_SEARCH_RANGE,errorMessage))==NULL)
		return FAILED;
	
	anchor = SMBIOS_getEntryPoint(start_ptr);
	
	if((tableAddress=(char*)SMBIOS_getRawData(anchor->structure_table_address,anchor->structure_table_length,errorMessage))==NULL)
	{
		free(start_ptr);
		return FAILED;
	}
	
	SMBIOS_getStructure(_power,tableAddress,anchor-> number_of_smbios_structure,39); // System Power Supply - type 39
	
	for(unsigned int i=0;i<_power.size();i++)
	{
		vector<string> _dmi_strings;
		vector<int> indexes;
		int index_max;
		
		power.push_back(*(system_power_supply*)_power[i]);
		
		indexes.push_back((int)power[i].location);
		indexes.push_back((int)power[i].device_name);
		indexes.push_back((int)power[i].manufacturer);
		indexes.push_back((int)power[i].serial_number);
		indexes.push_back((int)power[i].asset_tag_number);
		indexes.push_back((int)power[i].model_part_number);
		indexes.push_back((int)power[i].revision_level);
		
		index_max=*max_element(indexes.begin(), indexes.end());
		
		for(unsigned int j=0;j<=index_max;j++)
			_dmi_strings.push_back(SMBIOS_getDmiString((_smbios_structure_header*)_power[i],j));
		
		dmi_strings.push_back(_dmi_strings);
	}
	
	free(tableAddress);
	free(start_ptr);
	
	return OK;
}

