/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_GROUPONSYSTEMACCESS_H_
#define OPENDRIM_GROUPONSYSTEMACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_GroupOnSystem.h"
#include "assocOpenDRIM_GroupOnSystem.h"

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_GroupOnSystem>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_GroupOnSystem& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupOnSystem& newInstance, const OpenDRIM_GroupOnSystem& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupOnSystem& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupOnSystem& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_associatorOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const char** properties, vector<Instance>& OwningElement_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_associatorOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const char** properties, vector<Instance>& OwnedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_referenceOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const vector<Instance>& OwningElement_instances, vector<OpenDRIM_GroupOnSystem>& OpenDRIM_GroupOnSystem_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_referenceOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const vector<Instance>& OwnedElement_instances, vector<OpenDRIM_GroupOnSystem>& OpenDRIM_GroupOnSystem_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_populate(OpenDRIM_GroupOnSystem& instance, string& errorMessage);

#endif /*OPENDRIM_GROUPONSYSTEMACCESS_H_*/
