/*
 *  Copyright (c) 2007 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_FUNCTION_H_
#define _OPENCTL_FUNCTION_H_

#include <vector>
#include <GTLCore/String.h>

namespace GTLCore {
  class Type;
  class Value;
  class Parameter;
  class ScopedName;
  /**
   * This class contains the information about a function, it also allow to
   * execute the function.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT Function {
      GTL_NO_COPY(Function);
    public:
      class Data;
      /**
       * @internal
       * Create a function.
       * @param _name name of the function
       * @param _returnType the return type of the function
       * @param _data private data of the function
       */
      Function(const GTLCore::ScopedName& _name, const GTLCore::Type* _returnType, Data* _data);
      ~Function();
      /**
       * @return the name of the function
       */
      GTLCore::ScopedName name() const;
      /**
       * Call this function with the given parameters.
       */
      GTLCore::Value call( const std::vector< GTLCore::Value>& _parameters) const;
      /**
       * @return the list of parameter that this function take
       */
      const std::vector< Parameter >& parameters() const;
      /**
       * @return the type of the function
       */
      const GTLCore::Type* returnType() const;
    public:
      struct Private;
      Private* const d;
  };
}

#endif
