// --------------------------------------------------------------------------
//                   OpenMS -- Open-Source Mass Spectrometry
// --------------------------------------------------------------------------
// Copyright The OpenMS Team -- Eberhard Karls University Tuebingen,
// ETH Zurich, and Freie Universitaet Berlin 2002-2013.
//
// This software is released under a three-clause BSD license:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of any author or any participating institution
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
// For a full list of authors, refer to the file AUTHORS.
// --------------------------------------------------------------------------
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING
// INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// --------------------------------------------------------------------------
// $Maintainer: Clemens Groepl $
// $Authors: $
// --------------------------------------------------------------------------

#ifndef OPENMS_TRANSFORMATIONS_FEATUREFINDER_FEATUREFINDERALGORITHM_IMPL_H
#define OPENMS_TRANSFORMATIONS_FEATUREFINDER_FEATUREFINDERALGORITHM_IMPL_H


#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/FeatureFinderAlgorithm.h>

#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/FeatureFinderAlgorithmSimplest.h>
#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/FeatureFinderAlgorithmSimple.h>
#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/FeatureFinderAlgorithmPicked.h>
#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/FeatureFinderAlgorithmIsotopeWavelet.h>
#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/FeatureFinderAlgorithmMRM.h>
#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/FeatureFinderAlgorithmSH.h>

namespace OpenMS
{

  template <class PeakType, class FeatureType>
  void FeatureFinderAlgorithm<PeakType, FeatureType>::registerChildren()
  {
    // deprecated:
    // Factory<FeatureFinderAlgorithm<PeakType,FeatureType> >::registerProduct
    //  (
    //   FeatureFinderAlgorithmSimplest<PeakType,FeatureType>::getProductName(),
    //   &FeatureFinderAlgorithmSimplest<PeakType,FeatureType>::create
    //  );
    // Factory<FeatureFinderAlgorithm<PeakType,FeatureType> >::registerProduct
    //  (
    //   FeatureFinderAlgorithmSimple<PeakType,FeatureType>::getProductName(),
    //   &FeatureFinderAlgorithmSimple<PeakType,FeatureType>::create
    //  );
    Factory<FeatureFinderAlgorithm<PeakType, FeatureType> >::registerProduct
    (
      FeatureFinderAlgorithmPicked<PeakType, FeatureType>::getProductName(),
      &FeatureFinderAlgorithmPicked<PeakType, FeatureType>::create
    );
    Factory<FeatureFinderAlgorithm<PeakType, FeatureType> >::registerProduct
    (
      FeatureFinderAlgorithmIsotopeWavelet<PeakType, FeatureType>::getProductName(),
      &FeatureFinderAlgorithmIsotopeWavelet<PeakType, FeatureType>::create
    );
    Factory<FeatureFinderAlgorithm<PeakType, FeatureType> >::registerProduct
    (
      FeatureFinderAlgorithmMRM<PeakType, FeatureType>::getProductName(),
      &FeatureFinderAlgorithmMRM<PeakType, FeatureType>::create
    );
    Factory<FeatureFinderAlgorithm<PeakType, FeatureType> >::registerProduct
    (
      FeatureFinderAlgorithmSH<PeakType, FeatureType>::getProductName(),
      &FeatureFinderAlgorithmSH<PeakType, FeatureType>::create
    );

  }

} // namespace OpenMS

#endif // OPENMS_TRANSFORMATIONS_FEATUREFINDER_FEATUREFINDERALGORITHM_IMPL_H
