###############################################################################
# OpenVAS Vulnerability Test
# $Id: bugzilla_35916.nasl 7197 2010-04-01 09:20:01Z chandra $
#
# Bugzilla 'show_bug.cgi' Information Disclosure Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100263);
 script_bugtraq_id(35916);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Low");

 script_name("Bugzilla 'show_bug.cgi' Information Disclosure Vulnerability");

desc = "Overview:
Bugzilla is prone to an information-disclosure vulnerability.

Successful exploits will allow authenticated attackers to obtain
potentially sensitive information that may aid in further attacks.

The following are vulnerable:

Bugzilla 3.3.4, 3.4rc1, and 3.4.


Solution:
Updates are available. Please see the references for details.


References:
http://www.securityfocus.com/bid/35916
http://www.bugzilla.org
http://www.bugzilla.org/security/3.4/


Risk factor : Low";

 script_description(desc);
 script_summary("Determine if Bugzilla version is <=3.3.4 and/or <3.4.1");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("bugzilla_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(Ver = get_kb_item(string("www/", port, "/bugzilla/version"))) {
  if(version_in_range(version:Ver, test_version:"3.3", test_version2:"3.3.4") ||
     version_in_range(version:Ver, test_version:"3.4", test_version2:"3.4.0")){
     security_warning(port:port);
  }
}
