###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for proftpd FEDORA-2007-2613
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861120);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.1");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-2613");
  script_cve_id("CVE-2007-2165");
  script_name( "Fedora Update for proftpd FEDORA-2007-2613");
  desc = "

  Vulnerability Insight:
  ProFTPD is an enhanced FTP server with a focus toward simplicity, security,
  and ease of configuration. It features a very Apache-like configuration
  syntax, and a highly customizable server infrastructure, including support for
  multiple 'virtual' FTP servers, anonymous FTP, and permission-based directory
  visibility.
  
  This package defaults to the standalone behaviour of ProFTPD, but all the
  needed scripts to have it run by xinetd instead are included.


  Affected Software/OS:
  proftpd on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00065.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of proftpd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"proftpd", rpm:"proftpd~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-debuginfo", rpm:"proftpd-debuginfo~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-ldap", rpm:"proftpd-ldap~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-postgresql", rpm:"proftpd-postgresql~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd", rpm:"proftpd~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-mysql", rpm:"proftpd-mysql~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd", rpm:"proftpd~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-debuginfo", rpm:"proftpd-debuginfo~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-ldap", rpm:"proftpd-ldap~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-mysql", rpm:"proftpd-mysql~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"proftpd-postgresql", rpm:"proftpd-postgresql~1.3.1~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}