###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for xine-lib FEDORA-2008-3353
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860833);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-3353");
  script_cve_id("CVE-2008-1878");
  script_name( "Fedora Update for xine-lib FEDORA-2008-3353");
  desc = "

  Vulnerability Insight:
  This package contains the Xine library. Xine is a free multimedia player.
  It can play back various media. It also decodes multimedia files from local
  disk drives, and displays multimedia streamed over the Internet. It
  interprets many of the most common multimedia formats available - and some
  of the most uncommon formats, too.  --with/--without rpmbuild options
  (some default values depend on target distribution): aalib, caca, directfb,
  imagemagick, freetype, antialiasing (with freetype), pulseaudio, xcb.


  Affected Software/OS:
  xine-lib on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00571.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of xine-lib");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"xine-lib", rpm:"xine-lib~1.1.12~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}