###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_li_element_dos_vuln_sep09.nasl 4415 2009-08-31 17:09:24Z aug $
#
# Microsoft Internet Explorer 'li' Element DoS Vulnerability - Sep09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800872);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3019");
  script_bugtraq_id(36070);
  script_name("Microsoft Internet Explorer 'li' Element DoS Vulnerability - Sep09");
  desc = "
  Overview: This host has Internet Explorer installed and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  Error exists when application fails to handle a crafted JavaScript code, that
  calls 'createElement' to create an instance of the 'li' element, and then
  calls 'setAttribute' to set the value attribute.

  Impact:
  Successful exploitation could allow remote attackers can cause the application
  to crash.

  Impact Level: Application

  Affected Software/OS:
  Microsoft, Internet Explorer version 6.x on Windows XP SP2/SP3

  Fix: Upgrade to Internet Explorer version 8 or 8 beta 2
  http://www.microsoft.com/windows/internet-explorer/default.aspx

  References:
  http://www.milw0rm.com/exploits/9455
  http://downloads.securityfocus.com/vulnerabilities/exploits/36070-1.html
  http://downloads.securityfocus.com/vulnerabilities/exploits/36070-3.txt
  https://connect.microsoft.com/IE/feedback/ViewFeedback.aspx?FeedbackID=338599

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

# Check for XP SP3
SP = get_kb_item("SMB/WinXP/ServicePack");
if(("Service Pack 3" >< SP) || ("Service Pack 2" >< SP))
{
  # Get for Internet Explorer Version
  ieVer = get_kb_item("MS/IE/Version");
  # Check for IE 6
  if(ieVer =~ "^6\..*"){
    security_warning(0);
  }
}
