# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1973-1 (glibc, eglibc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66770);
 script_cve_id("CVE-2010-0015");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1973-1 (glibc, eglibc)");

 desc = "The remote host is missing an update to glibc, eglibc
announced via advisory DSA 1973-1.

Christoph Pleger has discovered that the GNU C Library (aka glibc) and
its derivatives add information from the passwd.adjunct.byname map to
entries in the passwd map, which allows local users to obtain the
encrypted passwords of NIS accounts by calling the getpwnam function.


For the oldstable distribution (etch), this problem has been fixed in
version 2.3.6.ds1-13etch10 of the glibc package.

For the stable distribution (lenny), this problem has been fixed in
version 2.7-18lenny2 of the glibc package.

For the unstable distribution (sid) this problem has been fixed in
version 2.10.2-4 of the eglibc package.


We recommend that you upgrade your glibc or eglibc package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201973-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1973-1 (glibc, eglibc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"glibc-doc", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"locales", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nscd", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"locales-all", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-prof", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-pic", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dbg", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dev", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-prof", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dbg", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-i386", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-pic", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-i386", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-xen", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-i686", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-amd64", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-amd64", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-ppc64", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-ppc64", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-s390x", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-s390x", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-sparcv9b", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-sparc64", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-sparcv9", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-sparc64", ver:"2.3.6.ds1-13etch10", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"locales", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"glibc-doc", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"glibc-source", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dbg", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-pic", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-prof", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dev", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nscd", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-alphaev67", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"locales-all", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-i386", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-prof", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dbg", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-pic", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-i386", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-i686", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-amd64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-xen", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-amd64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-mips64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-mips64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-mipsn32", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-mipsn32", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-ppc64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-ppc64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-s390x", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-s390x", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-sparc64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-sparcv9b", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev-sparc64", ver:"2.7-18lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
