# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2417 (bugzilla)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63602);
 script_cve_id("CVE-2008-4437", "CVE-2008-6098", "CVE-2009-0481", "CVE-2009-0483", "CVE-2009-0484", "CVE-2009-0485", "CVE-2009-0486", "CVE-2009-0482");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-2417 (bugzilla)";
 script_name(name);

 desc = "The remote host is missing an update to bugzilla
announced via advisory FEDORA-2009-2417.

ChangeLog:

* Thu Mar  5 2009 Itamar Reis Peixoto  3.2.2-2
- fix from BZ #474250 Comment #16, from Chris Eveleigh -->
- add python BR for contrib subpackage
- fix description
- change Requires perl-SOAP-Lite to perl(SOAP::Lite) according guidelines
* Sun Mar  1 2009 Itamar Reis Peixoto  3.2.2-1
- thanks to Chris Eveleigh 
- for contributing with patches :-)
- Upgrade to upstream 3.2.2 to fix multiple security vulns
- Removed old perl_requires exclusions, added new ones for RADIUS, Oracle and sanitycheck.cgi
- Added Oracle to supported DBs in description (and moved line breaks)
- Include a patch to fix max_allowed_packet warnin when using with mysql
* Sat Feb 28 2009 Itamar Reis Peixoto  3.0.8-1
- Upgrade to 3.0.8, fix #466077 #438080
- fix macro in changelog rpmlint warning
- fix files-attr-not-set rpmlint warning for doc and contrib sub-packages
* Mon Feb 23 2009 Fedora Release Engineering  - 3.0.4-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

References:

[ 1 ] Bug #465956 - CVE-2008-4437 bugzilla directory traversal flaw
https://bugzilla.redhat.com/show_bug.cgi?id=465956
[ 2 ] Bug #484755 - CVE-2008-6098 bugzilla: quip moderation bypass for authenticated users
https://bugzilla.redhat.com/show_bug.cgi?id=484755
[ 3 ] Bug #484805 - CVE-2009-0481 bugzilla: XSS vulnerability via HTML and JavaScript attachments
https://bugzilla.redhat.com/show_bug.cgi?id=484805
[ 4 ] Bug #484807 - CVE-2009-0483 bugzilla: CSRF vuln via editkeywords.cgi and userprefs.cgi
https://bugzilla.redhat.com/show_bug.cgi?id=484807
[ 5 ] Bug #484811 - CVE-2009-0484 bugzilla: CSRF vuln via buglist.cgi
https://bugzilla.redhat.com/show_bug.cgi?id=484811
[ 6 ] Bug #484812 - CVE-2009-0485 bugzilla: CSRF vuln via editflagtypes.cgi
https://bugzilla.redhat.com/show_bug.cgi?id=484812
[ 7 ] Bug #484813 - CVE-2009-0486 bugzilla: CSRF protection bypass when running under mod_perl
https://bugzilla.redhat.com/show_bug.cgi?id=484813
[ 8 ] Bug #484806 - CVE-2009-0482 bugzilla: CSRF vuln via process_bug.cgi
https://bugzilla.redhat.com/show_bug.cgi?id=484806

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bugzilla' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2417

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2417 (bugzilla)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bugzilla", rpm:"bugzilla~3.2.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-contrib", rpm:"bugzilla-contrib~3.2.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-doc", rpm:"bugzilla-doc~3.2.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
