////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_VIEWPORT_MODE_ACTION_H
#define __OVITO_VIEWPORT_MODE_ACTION_H

#include <core/Core.h>
#include <core/viewport/input/ViewportInputManager.h>
#include "Action.h"

namespace Core {

/******************************************************************************
* An action that actives a ViewportInputHandler.
******************************************************************************/
class CORE_DLLEXPORT ViewportModeAction : public Action
{
	Q_OBJECT

private:

	/// \brief Default constructor. Should not be used.
	ViewportModeAction() : Action() { OVITO_ASSERT(false); }

public:

	/// \brief Initializes the action object.
	/// \param id The unique identifier string of this action object.
	ViewportModeAction(const QString& id, const ViewportInputHandler::SmartPtr& inputHandler, const QColor& highlightColor = QColor());

protected:

	/// This is called by the system after the action object has been bound to its ActionProxy.
	virtual void initializeAction(ActionProxy* proxy);

	/// This function is called whenever the action is added to a container widget that supports custom widgets.
	virtual QWidget* createWidget(QWidget* parent);

protected Q_SLOTS:

	/// Is called when the active viewport input handler has changed.
	void onInputModeChanged(ViewportInputHandler* oldMode, ViewportInputHandler* newMode);

	/// Is called when the user has triggered the action's state.
	void onActionTriggered(bool checked);

private:

	/// The viewport input handler activated by this action.
	ViewportInputHandler::SmartPtr _inputHandler;

	/// The highlight color for the button controls.
	QColor _highlightColor;

private:

	DECLARE_PLUGIN_CLASS(ViewportModeAction)
};

};

#endif // __OVITO_VIEWPORT_MODE_ACTION_H
