#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-06-23 10:07:30  
# _check-samba.sh

### P A R A M S

if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi

### I N C L U D E

. ./_include.sh

### C H E C K E D   F I L E S

nsswinbindlib=${LIBDIR}/libnss_winbind.so
pamwinbindlib=${LIBDIR}/security/pam_winbind.so
winbinddaemon=${USRSBINDIR}/winbindd
sambapkg=${SAMBAPKG}
sambapkgs=${SAMBAPKGS}

### S T A R T

# S A M B A   P A C K A G E S
echo "+SAMBA PACKAGE"
if ! ${PACKAGETEST} ${sambapkg} > /dev/null; then
	echo "${sambapkg} package FAIL (does not exist)" >&2
	exit 1
fi
echo "package=${sambapkg}"
sambaversion=`${PACKAGEVERSION} ${sambapkg}`
echo "version=${sambaversion}"
sambamajorversion=`echo "${sambaversion}" | sed 's/^[0-9:]*\([0-9]\).*$/\1/g'`
echo "majorversion=${sambamajorversion}"
if (( $((sambamajorversion)) < 3 )); then
	echo "current version is ${sambamajorversion} [FAIL] (samba 3 is needed)" >&2
	exit 1
fi
[ -z "${MYVERBOSE}" ] || echo "version is ${sambamajorversion} OK"
if ! ${PACKAGETEST} ${sambapkgs} 2> /dev/null >/dev/null; then
	echo "[FAIL] packages ${sambapkgs} are not installed" >&2
	[ -z "${MYVERBOSE}" ] || echo "details:" >&2
	[ -z "${MYVERBOSE}" ] || echo "{" >&2
	[ -z "${MYVERBOSE}" ] || ${PACKAGETEST} ${sambapkgs} >&2
	[ -z "${MYVERBOSE}" ] || echo "}" >&2
	exit 1
fi

# N S S _ W I N B I N D  L I B R A R Y
echo "+NSS_WINBIND"
if [ ! -L ${nsswinbindlib}.${LIBC_VERSMAJ} -a  ! -f ${nsswinbindlib}.${LIBC_VERSMAJ} ];then
	echo "[FAIL] ${nsswinbindlib}.${LIBC_VERSMAJ} missing" >&2
else
	[ -z "${MYVERBOSE}" ] || echo "${nsswinbindlib}.${LIBC_VERSMAJ} OK (exists)"
fi

# N S S _ W I N B I N D   D E P E N D E N T   L I B R A R I E S
if [ -f /usr/bin/objdump ]; then 
	echo "+NSS_WINBIND DEPENDENT LIBRARIES"
	deps=$(objdump -p ${nsswinbindlib}.${LIBC_VERSMAJ} | grep NEEDED | sed s/"NEEDED "//g)
	for dl in ${deps}; do
		dl=$(whereis -b ${dl} | sed s/.*://)
		for d in ${dl}; do
			if [ -f ${d} ]; then
				[ -z "${MYVERBOSE}" ] || echo "${d} OK (exists)"
			else
				echo "[FAIL] ${d} missing"
			fi
		done
	done
fi

# W I N B I N D  L I B R A R Y
echo "+WINBIND DAEMON"
if [ ! -f ${winbinddaemon} ];then
	echo "[FAIL] ${winbinddaemon} does not exist" >&2
	exit 1
else
	[ -z "${MYVERBOSE}" ] || echo "${winbinddaemon} OK (exists)"
fi

# W I N B I N D   D E P E N D E N T   L I B R A R I E S
if [ -f /usr/bin/objdump ]; then 
	echo "+WINBIND DAEMON DEPENDENT LIBRARIES"
	deps=$(objdump -p ${winbinddaemon} | grep NEEDED | sed s/"NEEDED "//g)
	for dl in ${deps}; do
		dl=$(whereis -b ${dl} | sed s/.*://)
		for d in ${dl}; do
			if [ -f ${d} ]; then
				[ -z "${MYVERBOSE}" ] || echo "${d} OK (exists)"
			else
				echo "[FAIL] ${d} missing" >&2
			fi
		done
	done
fi

# P A M _ W I N B I N D  L I B R A R Y
echo "+PAM_WINBIND DEPENDENT LIBRARY"
if [ ! -f ${pamwinbindlib} ];then
	echo "${pamwinbindlib} FAIL (does not exist)" >&2
	exit 1
else
	[ -z "${MYVERBOSE}" ] || echo "${pamwinbindlib} OK (exists)"
fi

# P A M _ W I N B I N D   D E P E N D E N T   L I B R A R I E S
if [ -f /usr/bin/objdump ]; then 
	echo "+PAM_WINBIND DEPENDENT LIBRARIES"
	deps=$(objdump -p ${pamwinbindlib} | grep NEEDED | sed s/"NEEDED "//g)
	for dl in ${deps}; do
		dl=$(whereis -b ${dl} | sed s/.*://)
		for d in ${dl}; do
			if [ -f ${d} ]; then
				[ -z "${MYVERBOSE}" ] || echo "${d} OK (exists)"
			else
				echo "[FAIL] ${d} missing" >&2
			fi
		done
	done
fi
