/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.cast;

import adql.db.DBType;
import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.UnknownType;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.cast.CustomTargetType;
import adql.query.operand.function.cast.StandardTargetType;
import adql.query.operand.function.cast.TargetType;
import adql.translator.FunctionTranslator;

public class CastFunction
extends ADQLFunction
implements UnknownType {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adql-type", "CAST", true, "Convert the given value into the specified datatype.");
    protected final String FCT_NAME = "CAST";
    protected ADQLOperand value;
    protected TargetType targetType;
    protected FunctionTranslator customTranslation = null;
    private char expectedType = (char)63;

    public CastFunction(ADQLOperand value, TargetType type) {
        this.value = value;
        this.targetType = type;
    }

    public CastFunction(CastFunction toCopy) throws Exception {
        this.value = toCopy.value == null ? null : (ADQLOperand)toCopy.value.getCopy();
        this.targetType = toCopy.targetType.getCopy();
        this.setPosition(toCopy.getPosition() == null ? null : new TextPosition(toCopy.getPosition()));
    }

    @Override
    public boolean isNumeric() {
        return this.targetType.isNumeric();
    }

    @Override
    public boolean isString() {
        return this.targetType.isString();
    }

    @Override
    public boolean isGeometry() {
        return this.targetType.isGeometry();
    }

    @Override
    public char getExpectedType() {
        return this.expectedType;
    }

    @Override
    public void setExpectedType(char c) {
        this.expectedType = c;
    }

    @Override
    public String getName() {
        return "CAST";
    }

    public ADQLOperand getValue() {
        return this.value;
    }

    public DBType getReturnType() {
        return this.targetType.getReturnType();
    }

    public final TargetType getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(TargetType type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("Missing target type! It is required in a CAST function.");
        }
        this.targetType = type;
    }

    public final FunctionTranslator getFunctionTranslator() {
        return this.customTranslation;
    }

    public final void setFunctionTranslator(FunctionTranslator customTranslation) {
        this.customTranslation = customTranslation;
    }

    @Override
    public LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new CastFunction(this);
    }

    @Override
    public int getNbParameters() {
        return 2 + this.targetType.getNbParameters();
    }

    @Override
    public ADQLOperand[] getParameters() {
        ADQLOperand[] params = new ADQLOperand[this.getNbParameters()];
        params[0] = this.value;
        params[1] = new StringConstant(this.targetType.getName());
        for (int i = 0; i < this.targetType.getNbParameters(); ++i) {
            params[i + 2] = this.targetType.getParameter(i);
        }
        return params;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"CAST\" (nb required params = " + this.getNbParameters() + ")!");
        }
        if (index == 0) {
            return this.value;
        }
        if (index == 1) {
            return new StringConstant(this.targetType.getName());
        }
        return this.targetType.getParameter(index - 2);
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"CAST\" (nb required params = " + this.getNbParameters() + ")!");
        }
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove any parameter from the \"CAST\" function ! All parameters are required!");
        }
        ADQLOperand replaced = null;
        switch (index) {
            case 0: {
                replaced = this.value;
                this.value = replacer;
                this.setPosition(null);
                break;
            }
            case 1: {
                if (replacer instanceof StringConstant) {
                    replaced = this.getParameter(1);
                    try {
                        this.targetType = new StandardTargetType(((StringConstant)replacer).getValue());
                    }
                    catch (Exception ex) {
                        this.targetType = new CustomTargetType(((StringConstant)replacer).getValue(), this.targetType.getParameters());
                    }
                    this.setPosition(null);
                    break;
                }
                throw new Exception("Impossible to replace a datatype's name by a " + replacer.getClass().getName() + "! A StringConstant with the datatype name was expected.");
            }
            default: {
                this.targetType.setParameter(index - 2, replacer);
                this.setPosition(null);
            }
        }
        return replaced;
    }

    @Override
    public String toADQL() {
        StringBuilder adql = new StringBuilder("CAST");
        adql.append('(').append(this.value == null ? "NULL" : this.value.toADQL());
        adql.append(" AS ").append(this.targetType.toADQL());
        adql.append(')');
        return adql.toString();
    }
}

