/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _COMMANDSTARTEDFINISHED_TEST_H
#define _COMMANDSTARTEDFINISHED_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
class ConfigManager;
class WcViewModel;
class Bookmark;
class ScModel;

// qt
#include <QtCore/QObject>


class CommandStartedFinishedTest : public QObject, public CppUnit::TestCase 
{
  Q_OBJECT;

  CPPUNIT_TEST_SUITE( CommandStartedFinishedTest );
  CPPUNIT_TEST( run );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void run();

public slots:
  void started( Bookmark* );
  void finished( Bookmark* );

private:
  WcViewModel* _viewModel;

  int          _started;
  int          _finished;

  // dependencies
  Bookmark*      _bm;
  ScModel*       _sc;
  ConfigManager* _cm;

  class TestBookmark;
  class TestScModel;
};

#endif // _COMMANDSTARTEDFINISHED_TEST_H
