/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BOOKMARK_DRAGOBJECT_H
#define _SC_BOOKMARK_DRAGOBJECT_H

// sc
#include "util/Id.h"

// qt
#include <Qt3Support/Q3DragObject>

/**
 * Bookmark drag & drop. Used to transfer the Bookmark Id.
 */
class BookmarkDragObject : public Q3StoredDrag
{
public:
  BookmarkDragObject( const char* mimeType, QWidget* dragSource, ID bmId, ID bmParentId )
    : Q3StoredDrag( mimeType, dragSource )
  {
    QString data;
    data += QString("%1:%2").arg(bmId).arg(bmParentId);

    QByteArray* dataArr = new QByteArray;
    //dataArr->assign( data, data.length() );
    dataArr->append(data);
    setEncodedData(*dataArr);
  }

  /**
   * try to decode the mime source.
   */
  static bool decode( const QMimeSource* e, ID& bmId, ID& bmParentId )
  {
    QByteArray dataArr = e->encodedData(e->format());
    QString data(dataArr);

    QString id  = data.section( ":", 0, 0 );
    QString pid = data.section( ":", 1, 1 );

    bool successId, successPid; 
    bmId       = id.toULong(&successId);
    bmParentId = pid.toULong(&successPid);

    return successId && successPid;
  }
};


#endif // _SC_PROJECTITEM_DRAGOBJECT_H
