/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ListCmd.h"
#include "ListParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/DirEntry.h"
#include "util/Error.h"


ListCmd::ListCmd( ListParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

ListCmd::~ListCmd()
{
  delete _cb;
}

void ListCmd::run()
{
  sc::Error* err;

  _prgscb->started( _param, getCancel() );

  err = _client->ls( _param->getPathOrUrl(), *_param->getRevision(), _param->getRecurse(),
    _param->getEntries() );

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
