/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFF_SUMMARIZE_EVENT_H
#define _SC_DIFF_SUMMARIZE_EVENT_H

// sc
#include "CustomEvents.h"
#include "svn/DiffSummarizeTypes.h"

// qt
#include <QtCore/QEvent>


class DiffSummarizeEvent : public QCustomEvent
{
public:
  DiffSummarizeEvent( svn::DiffSummarizePtr summarize )
    : QCustomEvent(ScDiffSummarizeEvent), _summarize(summarize)
  {
  }

  svn::DiffSummarizePtr getDiffSummarize() const
  {
    return _summarize;
  }

private:
  svn::DiffSummarizePtr _summarize;
};

#endif // _SC_DIFF_SUMMARIZE_EVENT_H
