/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_TOOLSSETTINGSWIDGET_H
#define _SC_TOOLSSETTINGSWIDGET_H

// sc
#include "sublib/settings/SettingsWidget.h"
class ExternProvider;

// qt
class QLineEdit;


class ToolsSettingsWidget : public SettingsWidget
{
  typedef SettingsWidget super;
  Q_OBJECT;

public:
  ToolsSettingsWidget( ExternProvider* p, QWidget *parent = 0 );
  ~ToolsSettingsWidget();

  void setInitialized();

  void setDiffCmd( const QString& );
  void setMergeCmd( const QString& );
  void setBuiltinDiffCmd( const QString& );
  void setBuiltinMergeCmd( const QString& );
  QString getDiffCmd();
  QString getMergeCmd();

public slots:
  void selectDiff();
  void selectMerge();
  void resetDiff();
  void resetMerge();
  void textChanged(const QString&);

private:
  ExternProvider* _p;

  QString    _diffBi;
  QString    _mergeBi;

  QLineEdit* _diffEdit;
  QLineEdit* _mergeEdit;

  bool       _initialized;
};


#endif // _SC_TOOLSSETTINGSWIDGET_H
