; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple arm64-none-eabi -o - %s | FileCheck %s --check-prefixes=CHECK,SDISEL
; RUN: llc -mtriple arm64-none-eabi -global-isel -o - %s | FileCheck %s --check-prefixes=CHECK,GISEL

@out = internal global i32 0, align 4

; Ensure that we transform select(C0, x, select(C1, x, y)) towards
; select(C0 | C1, x, y) so we can use CMP;CCMP for the implementation.
define i32 @test0(i32 %v0, i32 %v1, i32 %v2) {
; SDISEL-LABEL: test0:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    cmp w0, #7
; SDISEL-NEXT:    ccmp w1, #0, #0, ne
; SDISEL-NEXT:    csel w0, w1, w2, gt
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: test0:
; GISEL:       // %bb.0:
; GISEL-NEXT:    cmp w0, #7
; GISEL-NEXT:    csel w8, w1, w2, eq
; GISEL-NEXT:    cmp w1, #0
; GISEL-NEXT:    csel w0, w1, w8, gt
; GISEL-NEXT:    ret
  %cmp1 = icmp eq i32 %v0, 7
  %cmp2 = icmp sgt i32 %v1, 0
  %sel0 = select i1 %cmp1, i32 %v1, i32 %v2
  %sel1 = select i1 %cmp2, i32 %v1, i32 %sel0
  ret i32 %sel1
}

; Usually we keep select(C0 | C1, x, y) as is on aarch64 to create CMP;CCMP
; sequences. This case should be transformed to select(C0, select(C1, x, y), y)
; anyway to get CSE effects.
define void @test1(i32 %bitset, i32 %val0, i32 %val1) {
; SDISEL-LABEL: test1:
; SDISEL:       // %bb.0:
; SDISEL-NEXT:    cmp w0, #7
; SDISEL-NEXT:    adrp x8, out
; SDISEL-NEXT:    csel w9, w1, w2, eq
; SDISEL-NEXT:    cmp w9, #13
; SDISEL-NEXT:    csel w9, w1, w2, lo
; SDISEL-NEXT:    cmp w0, #42
; SDISEL-NEXT:    csel w10, w1, w9, eq
; SDISEL-NEXT:    str w9, [x8, :lo12:out]
; SDISEL-NEXT:    str w10, [x8, :lo12:out]
; SDISEL-NEXT:    ret
;
; GISEL-LABEL: test1:
; GISEL:       // %bb.0:
; GISEL-NEXT:    cmp w0, #7
; GISEL-NEXT:    csel w8, w1, w2, eq
; GISEL-NEXT:    cmp w8, #13
; GISEL-NEXT:    cset w8, lo
; GISEL-NEXT:    tst w8, #0x1
; GISEL-NEXT:    csel w9, w1, w2, ne
; GISEL-NEXT:    cmp w0, #42
; GISEL-NEXT:    cset w10, eq
; GISEL-NEXT:    orr w8, w10, w8
; GISEL-NEXT:    tst w8, #0x1
; GISEL-NEXT:    adrp x8, out
; GISEL-NEXT:    csel w10, w1, w2, ne
; GISEL-NEXT:    str w9, [x8, :lo12:out]
; GISEL-NEXT:    str w10, [x8, :lo12:out]
; GISEL-NEXT:    ret
  %cmp1 = icmp eq i32 %bitset, 7
  %cond = select i1 %cmp1, i32 %val0, i32 %val1
  %cmp5 = icmp ult i32 %cond, 13
  %cond11 = select i1 %cmp5, i32 %val0, i32 %val1
  %cmp3 = icmp eq i32 %bitset, 42
  %or.cond = or i1 %cmp3, %cmp5
  %cond17 = select i1 %or.cond, i32 %val0, i32 %val1
  store volatile i32 %cond11, i32* @out, align 4
  store volatile i32 %cond17, i32* @out, align 4
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
